ROUTINE(zpowrz,		decompose rr=alpha*10.**kpower)
subroutine zpowrz(rr,alpha,kpower)
real rr,alpha; integer kpower
# rr: real value
# alpha: returned mantissa in range + or -[1.,10.)
# kpower: rr= alpha * 10.**kpower

real r,rlog,tbl(10)

data tbl/1.e0,1.e1,1.e2,1.e3,1.e4,1.e5,1.e6,1.e7,1.e8,1.e9/
#table of small powers avoids (possibly erroroneous) **
r=abs(rr)
if(r==0.) {
	kpower=0
	alpha=0.0
	}
else {
	rlog=alog10(r); kpower=ifix(rlog)
	if(rlog<0.)kpower=kpower-1
	if(iabs(kpower)<10) #use table
		if(kpower>=0)alpha=r/tbl(kpower+1)
		else alpha=r*tbl(-kpower+1)
	else alpha=r/10.**kpower
	while(alpha>=10.){alpha=alpha/10.;kpower=kpower+1}
	while(alpha<1.){alpha=alpha*10.;kpower=kpower-1}
	alpha=sign(alpha,rr)
	}
return
end
