#include <stdio.h>
#include <ctype.h>
#include <signal.h>
#include "S.h"
#include "device.h"
#ifdef ATT_UNIX
#include <sys/ioctl.h>
#include <termio.h>
#endif
#ifdef Research
#include <sys/ttyio.h>
#endif
#ifdef Berkeley
#include <sgtty.h>
#endif

#define NLOCAL	6

#define ask	((long *)(cur_device->local_params))[0]
#define oldltype ((float *)(cur_device->local_params))[1]
#define oldsize ((float *)(cur_device->local_params))[2]
#define oldrot	((float *)(cur_device->local_params))[3]
#define oldcolor ((float *)(cur_device->local_params))[4]
#define devtype ((long *)(cur_device->local_params))[5]

#define am(i)	(F77_COM(bgrp)[i-1])
#define Ltype	((int)am(8))
#define Color	((int)am(10))
#define Cex	((int)am(18))
#define notNew	(am(121))

extern float F77_COM(bgrp)[];
vector *hp2623();
vector *F77_SUB(bpntsz)(), *F77_SUB(blinsz)();
vector *F77_SUB(btextz)(), *F77_SUB(bsegsz)(), *F77_SUB(brdpnz)();

static int rtangl();
static vector *wrap(), *flush(), *signalled(),
	*clear(), *polyg(), *seek(), *point(), *line(), *getxy();
static vector *polyg_2623(), *polyg_2627(), *polyg_2628();
static vector *getxy_2623(), *getxy_150();
static vector *poly_rectangle();
static void poly_bw_pattern(), poly_polygon();

static device d_hp2623 = {
	FALSE,			/* active */
	0,			/* which index in list of devices */
	(float *) NULL,		/* params */
	NLOCAL,			/* nlocal */
	(char *) NULL,		/* local_params */
    {					/* <R> required <O> optional */
	hp2623,	/* DEV_initial,	initialize <R> */
	wrap,			/* wrap up <R> */
	flush,			/* flush <R> */
	signalled,		/* caught signal <R> */
	F77_SUB(bpntsz),	/* points <R> (bpntsz) */
	F77_SUB(blinsz),	/* lines <R> (blinsz) */
	polyg,			/* polygon <R> */
	F77_SUB(btextz),	/* text <R> (btextz) */
	F77_SUB(bsegsz),	/* segments <R> (bsegsz) */
	clear,			/* clear <R> */
	F77_SUB(brdpnz),	/* graphic input <R> (brdpnz) */
	NULL,			/* menu <O> */
	NULL,			/* hook <O> */
	seek,			/* seek <O> (low level) */
	point,	/* DEV_ptchar,	point <O> (low level) */
	line,			/* line <O> (low level) */
	NULL,			/* length of string <O> */
	getxy,			/* input <O> (low level) */
    }
};

FILE	*outfile;
static double max(), min();

vector *hp2623(a_ask, a_file, a_devtype)
long *a_ask;
char **a_file;
long *a_devtype;
{
	device *d, *new_device();
	int i;
	char buf[128];
	d = new_device (&d_hp2623, 0L);	/* initialize device structure */
	set_device(d->which);

	for (i = 1; i <= 39; i++)
		am(i) = 0;
	am(1) = 2;		/* allow char size change */
	am(20) = 7;		/* char width in rasters */
	am(21) = 11;		/* char heighth in rasters */
	am(22) = 0;		/* min x raster */
	am(24) = 0;		/* min y raster */
	am(26) = 0;		/* char addressing offset */
	am(27) = 0;
	am(31) = 1; 		/* device can rotate characters */

	am(23) = 511;	   	/* max x raster */
	am(25) = 389;	   	/* max y raster */
	am(28) = 8.5/(am(23)-am(22)+1);	/* raster width in inches */
	am(29) = 6.5/(am(25)-am(24)+1);	/* raster heighth in inches */

	switch((int)*a_devtype)
	{
	case 150:
		am(30) = devtype = HP150;
		break;
	case 2623:
		am(30) = devtype = HP2623;
		break;
	case 2648:
		am(30) = devtype = HP2648;
		am(23) = 719;	   	/* max x raster */
		am(25) = 359;	   	/* max y raster */
		am(28) = 10./(am(23)-am(22)+1);	/* raster width in inches */
		am(29) = 5.0/(am(25)-am(24)+1);	/* raster heighth in inches */
		break;
	case 2627:
		am(30) = devtype = HP2627;
		break;
	case 2628:
		am(30) = devtype = HP2628;
		break;
	default:
		PROBLEM "HP26xx %d is an invalid device type", *a_devtype RECOVER(S_void);
	}

	ask = *a_ask;
	oldltype = -1;
	oldsize = -1;
	oldcolor = -9999;
	oldrot = 0;

	if (**a_file) {			/* no interaction allowed */
		outfile = fopen(*a_file, "a"); Perm_open(outfile);
		if (outfile == NULL) PROBLEM "Cannot open file" RECOVER(S_void);
		ask = 0;
		}
	else
		outfile = stdout;
	fprintf(outfile,"\033*m1N");	/* select no character rotation */
	fprintf(outfile,"\033*m1M");	/* select cex = 1 */
	fprintf(outfile,"\033*mR");	/* set graphics default
					   also toggles graphics screen on */
	flush();
	F77_SUB(defltz)();
	notNew = 1;			/* force erase on first real plotting */
	return(S_void);
}

static vector *wrap()
{
	flush();
	if(outfile != stdout){ Perm_close(outfile); fclose(outfile);}
	return(S_void);
}

static vector *signalled()
{
	return(S_void);
}

static vector *line(x, y)
long   *x, *y;
{
	fprintf(outfile,"\033*p%d,%dZ", *x, *y);
	return(S_void);
}

static vector *point(ich, crot)
F_CHARTYPE   ich;
float  *crot;
{
	char *p = F_CHARP(ich);

	if (*crot != oldrot) {
		fprintf(outfile,"\033*m%dN", ((int)(*crot/90))%4 + 1);
		oldrot = *crot;
		}
	if (Cex != oldsize) {
		int isz = (1> Cex+.5)? 1: Cex+.5;
		if (isz > 8) isz = 8;	/* disallow anything > 8 */
		fprintf(outfile,"\033*m%dM", isz);
		oldsize = Cex;
		}
	if(Color != oldcolor && devtype == HP2627) {
		fprintf(outfile,"\033*m%dX", (808-(int)Color)%8);
		oldcolor = Color;
	}

	/* don't center justify (\033*m5Q), seek went to low left corner;
	   replace zero by oh (avoid possible slash through it?) */
	fprintf(outfile,"\033*m1Q\033*l%c\n", *p=='0'?'O':*p);
	return (S_void);
}

static vector *seek(x, y)
long *x, *y;
{
	int	 j;

	if (oldltype != Ltype) {	/* 8 types: 1,4-10 */
		oldltype = Ltype;
		if ((j = (int)(Ltype-1)%8 + 1) > 1)
			j += 2;		/* skip 2 user defined ltys */
		fprintf(outfile,"\033*m%dB", j);
		}
	if(Color != oldcolor && devtype == HP2627) {
		fprintf(outfile,"\033*m%dX", (808-(int)Color)%8);
		oldcolor = Color;
	}
	fprintf(outfile,"\033*pa%d,%dZ", *x, *y);
	return(S_void);
}

static vector *clear()
{
	if (ask) {
		fprintf(stderr, "GO? ");
		fflush (stderr);
		while (getc (stdin) != '\n');	/* ignore reply */
		}
	fprintf(outfile,"\033*daZ");	/* clear graphics screen */
	return(S_void);
}

static vector *flush()
{
	fflush(outfile);
	return(S_void);
}

static vector *getxy (x, y, flag)
long *x, *y, *flag;
{
	switch((int)devtype) {
	case HP150:
		return getxy_150(x, y, flag);
	default:
		return getxy_2623(x, y, flag);
	}
}

static vector *
getxy_2623(x, y, flag)
	long *x, *y, *flag;
{
	int typed;
	char buf[30], *fgets();
	fprintf(stderr,"\007\033*s4^\021");	/* ring bell, turn on cursor */
	fflush(stderr);				/* BSD buffers stderr */
	fgets(buf,30,stdin);
	*flag = -1L;
	if( sscanf(buf,"%6ld,%6ld,%3d",x,y,&typed) == 3  &&
		( typed != '\r' ) && ( typed != '\n' ) )
		*flag = 1L;		/* return 1 if char typed not cr or lf */
	return(S_void);
}
static vector *
getxy_150(xa, ya, indic)
	long *xa, *ya, *indic;
{

	int x,y,t,nx=0,ny=0,i,ox,oy;

	int (*istat)();
#ifdef ATT_UNIX
	struct termio iostr;
#else
	struct sgttyb iostr;
#endif
	int oflags;

	istat = signal(SIGINT,SIG_IGN);	/* ignore break */

#ifdef ATT_UNIX
	ioctl(0, TCGETA, &iostr);
	oflags = iostr.c_lflag;
	iostr.c_lflag &= ~ECHO;
	ioctl(0,TCSETAF, &iostr);
#else
	ioctl(0, TIOCGETP, &iostr);
	oflags = iostr.sg_flags;
	iostr.sg_flags &= ~ECHO;
	ioctl(0, TIOCSETP, &iostr);
#endif

	fprintf(stderr,"\033*dK");	/* graph cursor on */
	fprintf(stderr,"\033-zd1n3M");	/* touch screen report touch, release */
	fflush(stderr);		/* stupid Berkeley */
	ox = oy = INTEGER_MAX;
	for(i=0;;i++){
		t=0;
		scanf("\033-z%dx%dy%dQ\n",&x,&y,&t);
		switch(t){
		case 0:
			goto out;
		case 3:
			if(abs(x-ox)+2*abs(y-oy)<10) {
				nx += (x-ox)*3;
				ny += (oy-y)*3;
			} else {
				nx = x*6+25;
				ny = (25-y)*15+25;
			}
			fprintf(stderr,"\033*d%3d,%3dO",nx,ny);
			fflush(stderr);
			break;
		case 4:
			nx = 0; ny=0;
			goto out;
		}
		ox = x; oy = y;
	}

out:
	*xa = nx; *ya=ny; *indic = t>0?1:-1;

	fprintf(stderr,"\033-z0N\033*dL");	/* cursor and touch screen off */
	fflush(stderr);
	while( getchar()!='\n' );	/* skip extra new line */
#ifdef ATT_UNIX
	iostr.c_lflag = oflags;
	ioctl(0, TCSETA, &iostr);
#else
	iostr.sg_flags = oflags;
	ioctl(0, TIOCSETP, &iostr);
#endif
	(void)signal(SIGINT,istat);
	return(S_void);
}

static vector
*polyg(x,y,n)
	float	*x, *y;
	long	*n;
{
	switch((int)devtype) {
	case HP2627:
		return polyg_2627(x,y,n);
	case HP2628:
	case HP150:
		return polyg_2628(x,y,n);
	default:
		return polyg_2623(x,y,n);
	}
}

static int pat_table[7][8] = {
	{ 170,  85, 170,  85, 170,  85, 170,  85 },	/* sm checkerbd */
	{  51,  51, 204, 204,  51,  51, 204, 204 },	/* lg checkerbd */
	{   0,  85,   0,  85,   0,  85,   0,  85 },	/* 1/4 filled */
	{  15,  15,  15,  15, 240, 240, 240, 240 },	/* v lg checkerbd */
	{ 255, 128, 190, 162, 170, 186, 130, 254 },	/* spiral */
	{  24,  36,  66, 129, 129,  66,  36,  24 },	/* diamond */
	{  60,  66, 129, 129, 129, 129,  66,  60 }	/* circle */
	};

/*	fill a polygon (only rectangle) */
static vector *
polyg_2623(x,y,n)
float	*x, *y;
long	*n;
{
	long	one = 1;
	double	xmin, xmax, ymin, ymax;

	if (*n < 3) {
		flush();
		fprintf(stderr, "polyg: Polygon needs at least 3 points\n");
		return S_void;
	}

	if (rtangl(x, y, n, &xmin, &xmax, &ymin, &ymax)) {
		poly_rectangle(xmin, xmax, ymin, ymax);
	} else {
		/* could be done line by line */
		F77_SUB(blinsz)(x,y,n);
		F77_SUB(bsegsz)(x+(*n)-1,y+(*n)-1,x,y,&one);
	}
	return S_void;
}

static vector *
polyg_2628(x,y,n)
	float *x, *y;
	long *n;
{
	double xmin, xmax, ymin, ymax;

	if( *n < 3 || *n > 148 ) {
		flush();
		PROBLEM "polyg: Polygon needs at least 3 points and at most 105" RECOVER(NULL_ENTRY);
	}

	if (rtangl(x, y, n, &xmin, &xmax, &ymin, &ymax)) {
		poly_rectangle(xmin, xmax, ymin, ymax);
	} else {
		poly_bw_pattern();	/* set fill pattern */
		poly_polygon(x, y, n);	/* and do it */
	}
	return S_void;
}

/*	Fill a rectangle.
 *	It is not known if this will work for 2648 terminals, although
 *	it was in the old S driver.
 */

static void
poly_bw_pattern()
{
	/* 8 colors mapped to solid & area patterns:
	   Color=1 should map to solid, others to patterns */

	int	which_pat, i;
	which_pat = (Color-1)%8;
	which_pat *= (which_pat<0)? -1: 1;	/* make positive */
	fprintf(outfile, "\033*m");
	if (which_pat == 0)
		which_pat = 1;			/* solid lty no. */
	else	{
		for (i=0; i<8; ++i)
			fprintf(outfile, "%d ", pat_table[which_pat-1][i]);
		fprintf(outfile, "d");		/* pattern define */
		which_pat = 2;
		}
	fprintf(outfile, "%dG", which_pat);	/* pattern select */
}

static vector *
poly_rectangle(xmin, xmax, ymin, ymax)
	double xmin, xmax, ymin, ymax;
{
	int	ix, iy;

	poly_bw_pattern();

	ix = max(xmin*am(37)+am(36), am(32)) + .5;
	iy = max(ymin*am(39)+am(38), am(34)) + .5;
	fprintf(outfile, "\033*m%d,%d", ix, iy);
	ix = min(xmax*am(37)+am(36), am(33)) + .5;
	iy = min(ymax*am(39)+am(38), am(35)) + .5;
	fprintf(outfile, " %d,%dE", ix, iy);	/* rectangle fill */
	flush();
	return S_void;
}

/*	determine if polygon is rectangle */
static int rtangl(x,y,n,xmin,xmax,ymin,ymax)
long	*n;
float	*x, *y;
double	*xmin, *xmax, *ymin, *ymax;
{
	int	isrect;
	if (*n != 4)
		return 0;
	/* would be better to use x and y rasters ccords,
	   but seems for standard grz applications */
	isrect = ((x[1]-x[0] == x[2]-x[3])
		&& (y[1]-y[0] == y[2]-y[3])
		&& (x[2]-x[1] == x[3]-x[0])
		&& (y[2]-y[1] == y[3]-y[0])
		&& (x[1]==x[0] || x[1]==x[2])
		&& (y[1]==y[0] || y[1]==y[2]));
	if (isrect) {
		*xmin = min(min(x[0],x[1]),x[2]);
		*ymin = min(min(y[0],y[1]),y[2]);
		*xmax = max(max(x[0],x[1]),x[2]);
		*ymax = max(max(y[0],y[1]),y[2]);
		}
	return isrect;
}

/*	fill a polygon in color */
static vector
*polyg_2627(x,y,n)
	float	*x, *y;
	long	*n;
{
	int icol;

	if( *n < 3 || *n > 148 ) {
		flush();
		PROBLEM "Need at least 3 points and at most 148 for polygon" RECOVER(S_void);

	}
	/* negative colors use pattern; positive use solid+dithered */
	icol = Color;
	if( icol > 7 ) {
		/* Dithered */
		fprintf(outfile, "\033*m0g%dw", 2+(icol-8)%18);
	} else
	if( icol >= 0 ) {
		/* Solid */
		fprintf(outfile,"\033*m1g");
		if( icol != oldcolor ) {
			oldcolor = icol;
			fprintf(outfile, "\033*m%dx", (808-icol)%8);
		}
	} else {
		/* Patterned */
		fprintf(outfile, "\033*m%dG", 9-(icol/10)%7);
		icol = icol%10;
		if(icol != oldcolor) {
			oldcolor = icol;
			fprintf(outfile, "\033*m%dX", (16-icol)%8);
		}
	}

	poly_polygon(x,y,n);
	return S_void;
}

static void
poly_polygon(x, y, n)
	float	*x, *y;
	long	*n;
{
	float rx[2], ry[2], rrx[2], rry[2], xclip = 0, yclip = 0;
	int i;
	int clipped, begin;
	int jint;
	int irx, iry;

	clipped = FALSE;
	begin = TRUE;

	fprintf(outfile,"\033*psa");
	rx[1] = x[0] * am(37) + am(36);
	ry[1] = y[0] * am(39) + am(38);
	for(i=1; i<*n; i++) {
		rx[0] = rx[1];
		ry[0] = ry[1];
		rx[1] = x[i] * am(37) + am(36);
		ry[1] = y[i] * am(39) + am(38);
		F77_SUB(lclipz)(rx, ry, &am(32), &am(34), rrx, rry, &jint);
		if(begin && jint == 0) {
			irx = rrx[0] + 0.5;
			iry = rry[0] + 0.5;
			fprintf(outfile," %d,%d", irx, iry);
			begin = FALSE;
		}
		if( jint != 0 ) {
			clipped = TRUE;
			xclip = x[i];
			yclip = y[i];
			if( jint < 0)
	/**/			continue;	/* skip if entirely out */
			irx = rrx[0] + 0.5;
			iry = rry[0] + 0.5;
			fprintf(outfile," %d,%d", irx, iry);
			begin = FALSE;
		}
		irx = rrx[1] + 0.5;
		iry = rry[1] + 0.5;
		fprintf(outfile," %d,%d", irx, iry);
		
	}
	fprintf(outfile, "T");
	flush();
	if( clipped ) {
		fprintf(stderr,"Polygon out of bounds at X=%g Y=%g\n",
			xclip, yclip);
	}
}

static double
max(a,b)
double a, b;
{
	return(a > b ? a : b);
}

static double
min(a,b)
double a, b;
{
	return(a < b ? a : b);
}
