/* Caution - various fprintf statements include
   percent characters that are supposed to be output, not be patterns
   These are done using fprintf(...,"%s","...%...") constructs that
   might naively be written as fprintf(...,"...%...")
   but this causes the percent characters to be lost
*/
#include <stdio.h>
#include <ctype.h>
#include <math.h>
#include "S.h"
#include "device.h"

#define NLOCAL	5
#define ask ((long *)(cur_device->local_params))[0]
#define oldltype ((long *)(cur_device->local_params))[1]
#define oldsize ((float *)(cur_device->local_params))[2]
#define oldcol ((float *)(cur_device->local_params))[3]
#define oldrot ((float *)(cur_device->local_params))[4]
#define am(i)	(F77_COM(bgrp)[i-1])
#define Color	((int)am(10))
#define Ltype	((int)am(8))
#define Csize	(am(18))
#define notNew	(am(121))

extern float F77_COM(bgrp)[];
vector *tek4105();
static void makeascii(), optout(), xyout(), tekszrt(), teklty();
vector *F77_SUB(bpntsz)(), *F77_SUB(blinsz)();
vector *F77_SUB(btextz)(), *F77_SUB(bsegsz)(), *F77_SUB(brdpnz)();

static vector *wrap(), *flush(), *signalled(), *polygon(),
	*clear(), *seek(), *point(), *line(), *getxy();

static device d_tek4105 = {
	FALSE,
	0,
	(float *) NULL,
	NLOCAL,
	(char *) NULL,
	{			/* <R> required <O> optional */
	tek4105,			/* initialize <R> */
	wrap,			/* wrap up <R> */
	flush,			/* flush <R> */
	signalled,		/* caught signal <R> */
	F77_SUB(bpntsz),	/* points <R> (bpntsz) */
	F77_SUB(blinsz),	/* lines <R> (blinsz) */
	polygon,		/* polygon <R> (bpolyz) */
	F77_SUB(btextz),	/* text <R> (btextz) */
	F77_SUB(bsegsz),	/* segments <R> (bsegsz) */
	clear,			/* clear <R> */
	F77_SUB(brdpnz),	/* graphic input <R> (brdpnz) */
	NULL,			/* menu <O> */
	NULL,			/* hook <O> */
	seek,			/* seek <O> (low level) */
	point,			/* point <O> (low level) */
	line,			/* line <O> (low level) */
	NULL,			/* length of string <O> */
	getxy,			/* input <O> (low level) */
	}
};

FILE	*outfile;

vector *tek4105(a_ask,a_file)
long *a_ask;
char **a_file;
{
	device *d, *new_device();
	int i;
	d = new_device(&d_tek4105, 0L);	/* initialize device structure */
	set_device(d->which);
	for (i = 1; i <= 39; i++) am(i) = 0.0;
	am(20) = 56.;		/* char size in rasters */
	am(21) = 84.;		/* actual wid = 40, space = 16, ht = 56 */
	am(22) = 0.0;
	am(23) = 4095.;
	am(24) = 0.0;
	am(25) = 3132.;
	am(26) = 1./6.;		/* char addressing offset */
	am(27) = 7./36.;
	am(28) = 11.5/(am(23)-am(22));	/* raster size in inches */
	am(29) = am(28);
	am(30) = TEK4105;
	am(31) = 1;		/* allow char rotation */
	am(1) = 2.;		/* allow char size change */
	ask = *a_ask;
	oldltype = 1;	/* defaults */
	oldsize = 1;
	oldcol = 999;
	oldrot = 0;
	if (**a_file) {		/* no interaction allowed */
		outfile = fopen (*a_file, "a");
		if (outfile == NULL)
			PROBLEM "Cannot open file" RECOVER(S_void);
		ask = 0;
	}
	else outfile = stdout;
	fprintf(outfile,"%s","\033%!0\033MR00\033MCB8C8A0\033MV0\033ML1\033MT1");
	F77_SUB(defltz)();
	notNew = 1;	/* force erase on first real plotting */
	return(S_void);
}

static vector *wrap()
{
	if(ask) clear();
/* put 4105 into ansi, absolute address, replace mode */
	fprintf(outfile,"%s","\033%!1\033[?6l\033[4l");
	fflush(outfile);
	return(S_void);
}

static vector *signalled()
{
	flush();
	return(S_void);
}

static vector *line(x, y)
long *x, *y;
{
	makeascii((int)*x,(int)*y);
	optout();	/* send out optimized binary */
	return(S_void);
}

static vector *point(ich, crot)
F_CHARTYPE ich;
float *crot;
{
	tekszrt((double)*crot);
	fprintf(outfile,"\033LT1%c",*F_CHARP(ich));
	return (S_void);
}

static vector *seek(x, y)
long *x, *y;
{
	teklty();
	makeascii((int)*x,(int)*y);
	xyout(1);	/* send out binary coords, incl gs character */
	return(S_void);
}

static vector *clear()
{
	if(ask>0) {
		fprintf(outfile, "GO? ");
		fflush(outfile);
		while(getc(stdin) != '\n');	/* ignore reply */
	}
	/* delete segment 1, redraw page, open segment 1 */
	fprintf(outfile,"%s","\033%!0\033SK1\033\014\033SO1");
	fflush(outfile);
	return(S_void);
}

static vector *flush()
{
	fprintf(outfile,"\037");
	if(outfile==stdout){	/* only if output to terminal */
		fprintf(outfile,"%s","\033%!1");
		oldsize = -1; oldltype = -1;
		}
	fflush(outfile);
	return(S_void);
}

static char out[6], old[5];

static void makeascii(x,y)
int x,y;
{
	out[0] = ((y>>7) & 037) + 040;	/* upper 5 bits of y */
	out[1] = (((y & 03) <<2) | (x & 03)) + 0140;	/* lower 2 of x and y */
	out[2] = ((y & 0177) >> 2) + 0140;	/* mid 5 of y */
	out[3] = ((x>>7) & 037) + 040;	/* upper 5 bits of x */
	out[4] = ((x & 0177) >> 2) + 0100;	/* mid 5 of x */
}

static void optout()
{
	if(old[0] != out[0]) fputc(out[0],outfile);
	if(old[1] != out[1]) fputc(out[1],outfile);
	if(old[1] != out[1] || old[2] != out[2] || old[3] != out[3])
		fputc(out[2],outfile);
	if(old[3] != out[3]) fputc(out[3],outfile);
	fputc(out[4],outfile);
	strncpy(old,out,5);
}

static void xyout(i)
int i;
{
	out[6] = 0;
	if(i) fputc('\035',outfile);
	fputs(out,outfile);
	strncpy(old,out,5);
}

static vector *getxy(x, y, flag)
long *x, *y, *flag;
{
	int i, (*istat)();
#ifdef Research
#include <sys/ttyio.h>
#include <signal.h>
	struct sgttyb iostr;
#endif
#ifdef Berkeley
#include <signal.h>
#include <sgtty.h>
	struct sgttyb iostr;
#endif
#ifdef ATT_UNIX
#include <sys/signal.h>
#include <sys/termio.h>
	struct termio iostr; char lflag, ovmin;
#endif
	int oflags;
	char buf[10], *fgets();
	if(outfile!=stdout){	/* no input if non-interactive */
		*flag = -1;
		return(S_void);
	}
	fprintf(stderr,"%s","\033%!0\007\033\032");	/* bell, esc, sub - turn on cursor */
	istat=signal(SIGINT,SIG_IGN);
	fflush(stderr);
#ifdef ATT_UNIX
	ioctl(0, TCGETA, &iostr);
	lflag = iostr.c_lflag; ovmin = iostr.c_cc[VMIN];
	iostr.c_lflag &= ~(ECHO |ICANON);
	iostr.c_cc[VMIN] = 1;  /* 1 char at a time */
	ioctl(0,TCSETAF, &iostr);
#else
	ioctl(0, TIOCGETP, &iostr);
	oflags = iostr.sg_flags;
	iostr.sg_flags &= ~ECHO;
	iostr.sg_flags |= CBREAK;
	ioctl(0, TIOCSETP, &iostr);
#endif
	fgets(buf,10,stdin);
#ifdef ATT_UNIX
	iostr.c_lflag = lflag; iostr.c_cc[VMIN] = ovmin;
	ioctl(0, TCSETA, &iostr);
#else
	iostr.sg_flags = oflags;
	ioctl(0, TIOCSETP, &iostr);
#endif
	for(i=0; i<10; i++) if(buf[i]=='\n' || buf[i]=='\0') break;
	if(i != 5){
		*flag = -1;
		if(i==0) fgets(buf,10,stdin); /* one extraneous line generated when user gives CR */
		}
	else {
		*flag = (unsigned) buf[0];
		*x = (((buf[1] & 037)<<5 | (buf[2] & 037)) & 01777) << 2;
		*y = (((buf[3] & 037)<<5 | (buf[4] & 037)) & 01777) << 2;
		}
	fputc("\012",stderr);
	signal(SIGINT,istat);
	return(S_void);
}


static tekint(in)
int in;
{
	unsigned i;
	i = abs(in);
	if(i >> 10) fputc((i>>10)+'@',outfile);
	i &= 01777;
	if(i >> 4) fputc((i>>4)+'@',outfile);
	i &= 017;
	fputc(i+(in>=0 ? '0' : ' '),outfile);
}

static void tekszrt(crot)	/* set char size and rotation */
double crot;
{
	int i;
	if(oldsize != Csize){
		oldsize = Csize;
		fprintf(outfile,"\033MC");
		tekint((int)(oldsize*40));
		tekint((int)(oldsize*56));
		tekint((int)(oldsize*16));
	}
	if(oldrot != crot){
		oldrot = crot;
		while(crot>=360) crot -= 360.;
		while(crot<0) crot += 360.;
		i = crot/90.;
		fprintf(outfile,"\033MR");
		tekint(i*90);
		tekint(0);
	}
}

static void teklty()		/* set line type, color */
{
	int j, ncol;
	fprintf(outfile,"%s","\033%!0");	/* into tek mode */
	if (oldltype != Ltype) {
		oldltype = Ltype;
		j = ((int) oldltype-1) % 8;
		fprintf(outfile,"\033MV");
		tekint(j);
	}
	if(oldcol != Color) {	/* line and text color */
		oldcol = Color;
		ncol = Color;
		ncol = abs(ncol);
		if(ncol>7) ncol = 7;
		fprintf(outfile,"\033ML");
		tekint(ncol);
		fprintf(outfile,"\033MT");
		tekint(ncol);
	}

}

static vector* polygon(x,y,n)
float *x, *y; long *n;
{
	int ncol, i; long m;
	if(*n<3) PROBLEM "polygon needs at least 3 points" RECOVER(S_void);
	fprintf(outfile,"%s","\033%!0\033ML");
	ncol = Color; ncol = abs(ncol); if(ncol>7) ncol = 7;
	tekint(ncol);	/* color for line index */
	fprintf(outfile,"\033MP");
	/* legit fill patterns are from -7 to 16 or 50 to 174 */
	ncol = Color;
	if(ncol < -7) ncol = -7;
	if(ncol > 16 && ncol < 50) ncol = 16;
	if(ncol > 174) ncol = 174;
	tekint(ncol);	/* color for fill pattern */
	fprintf(outfile,"\033MS010\035\033LP");	/* start panel */
	emit_point(x[0],y[0],0);
	fprintf(outfile,"0");	/* don't draw panel boundary */
	for(i=1; i < *n; i++)
		emit_point(x[i], y[i], i);
	fprintf(outfile,"\033LE");	/* end panel */
	flush();
	return(S_void);
}

static emit_point(x,y,i)
float x,y; int i;
{
	makeascii((int) (x * am(37) + am(36)),
		  (int) (y * am(39) + am(38)) );
	if(i) optout(); else xyout(0);
}
