#include <stdio.h>
#include <setjmp.h>
#include <signal.h>
#include <errno.h>
#include "S.h"
#include "eval.h"
#include "y.tab.h"
#include "sys_codes.h"
#include "options.h"

vector *Trace, *Frames, *blt_in_empty, *On_stop, **C_specials;
vector *C_on_stop, *Program = NULL_ENTRY;
int Eval_Profile, eval_open = 0;
int Restart = 0; /* the frame for restarting: set by S_init or eval */
long Nframe, *parent_frame;
jmp_buf S_error_jmp;

static vector *Eval(), *cons_value(), *pop_frame(), *check_trace();
static vector *do_eval(), *do_object(), *replace_expr(), *expd_replace();
static vector *do_replace(), *expand_dots(), *append_dir(), *substitute();
static vector *fix_mode(), *do_bind(), *bind_call(), *simplify(), *miss_dot();
static vector *get_intern_method(), *generic_fun(), *do_intern_method(),*get_arg1();
static vector *quick_call(), *append_dir(), *sub_call(), *find_fun();
static vector *make_frame_attrs(), *get_perm();
static void set_program(), boot_program(), set_frame(), repl_calls(), set_C_assign();
static void xpd_frames(), xpand(), init_dots(), eval_init(), eval_close(), quick_close();
static void eval_clear(), replace_dots(), del_local(), new_frame(), do_trace(), fix_dotnum();
static long e_logical_value(), which_trace();
static int el_fun(), expd_ok();

static vector *quick_save =NULL, *quick_fun, *internal_call;
static char *quick_name = NULL_STRING; static long quick_frame;
static int Trace_all = FALSE, **frame_jmp;
static vector *C_assign, *call_stack, *cur_attrs, *frame_fun, *frame_attrs;
static long *trace_Nframe, eval_count, *breaks, *nexts, Nexpr;
static vector *Unknown = NULL_ENTRY, *ret_stack, **ret_vals, *Parent;
static vector *N_call_args, *break_stack, *next_stack;
static vector *trace_call = NULL_ENTRY, *trace_expr;
static vector *C__; static long I__; /* reserved for preprocessor f'ns */
#define RETURNED(n) (ret_vals[n]!=S_void)
static int booted = FALSE; /* see boot_program() */
#define RETRIES 20
static long ntry = RETRIES;
/* names for the replacement functions: used in looking for methods             */
/* the order of these names must follow the symbolic codes for SUBSET_FUN, etc. */
/* as set up in eval.h and used by el_fun() here and by S_extract & S_replace   */
static char *Replace_names[MAX_SUB_FUN] = {
	"[<-", "[<-", "[[<-", "attr<-", "mode<-", "length<-",
	"$<-", "names<-", "[<-", "dim<-", "dimnames<-", "tsp<-",
	"levels<-", "attributes<-", "storage.mode<-"
};

void 
do_S()
{
	extern int cur_interact, Initialized;
	int error, Started, Last = 0; long mem;
	vector *value;
	char *enci1();
	S_init(); /* objects from directories, search list, etc. */
	Started = Restart; /* TRUE if .Restart was read in */
	while(TRUE){
		if((error=setjmp(S_error_jmp))==0) {
			eval_init();
			if(!Started) {
				value = do_object(".First");
				Started = TRUE;
			}
			else {
				if(!Program) { /* establish the program */
					Program = get_data(".Program",ANY);
					if(VOID(Program)) /* setting up system 1st time */
						boot_program();
					set_program();
					Initialized = TRUE;
				}
				value = do_eval(Program);
				pop_brk(); /* a no-op unless the special malloc is used*/
				check_frame0();
			}
			if(data_mode(value)==QUIT) {
				Last = TRUE; /* wrapping up */
				do_object(".Last");
				if(audit_file) 
					fprintf(audit_file,"#~End session: Time: %ld; Process: %ld\n",
					time((long *)0), mainpid);
				if(runit_pid)kill(runit_pid,SIGKILL);
				exit(last_signal);
			}
			ntry = RETRIES; /* eval succeeded, reset ntry */
		}
		else if(ntry-- <0)S_terminate("Too many errors in a row");
		else if(Last) S_terminate("Error in wrapup expression");
		eval_close(error);
		if(cur_interact) { /* check for a restart */
			mem_size(&mem);
			if(2*mem > max_memory) {
				fprintf(stderr,"Getting too big; will reload\n");
				eval_init(); /* set up S_data, etc. */
				save_restart(); /* won't return */
			}
		}
	}
}

static vector *
do_eval(arg)
vector *arg; /* the primitive evaluator for .Program */
{
	long n; vector **args;
	if(Nframe!=1)set_frame(1L);
	if(arg->mode!=PARSE)return(Eval(arg,Nframe));
	n = arg->length; args = arg->value.tree;
	while(n--)
		arg=Eval(*args++,Nframe);
	return(arg);
}

static vector *
do_object(name)
char *name;
{
	vector *object, *value;
	object = get_data(name,ANY);
	if(!object)return(S_void);
	if(object->mode==FUN_DEF) {
		value = alcvec(FUN_CALL,1L);
		value->value.tree[0] = object;
		object = value;
	}
	return(do_eval(object));
}

static void 
set_program()
	/* clean up the .Program so it will run right.  Typically it is */
	/* of the form expression(.....); if so, evaluate that to get a */
	/* Program of mode PARSE */
{
	long prev;
	if(VOID(Program)) S_terminate("Failed to find \".Program\"");
	if(Program->mode == FUN_CALL && Program->length>1) {
		vector *arg;
		arg = Program->value.tree[0];
		if(arg->mode == NAME || name_eq(arg->value.name,"expression"))
			Program = Program->value.tree[1];
	}
	if(Program->length<1 ||
	  !(Program->mode==PARSE || LANGUAGE_TYPE(Program->mode))) {
		fputs("\".Program\" should be a language object: found ",stderr);
		deparse(Program,stderr);
		S_terminate(NULL_STRING);
	}
	prev=set_alloc(PERM_FRAME);
	Program = copy_data(Program,cons_frame);
	set_alloc(prev);
}

static void 
boot_program()
	/* The program that  runs when all else fails: typically when
	/* the system is first being  booted & no functions are defined.
	/* Its purpose is to parse the boot source & do the function
	/* and .Program assignments therein */
{
	char *file, *name;
	int error;
	vector **args;
	if(booted) S_terminate("Boot failed");
	booted = TRUE; /* prevent repeated attempts to boot */
	file = encs1("%s/data/boot",shome);
	if(!push_source(file,FALSE))/* open boot file for parsing */
		S_terminate("Can't open boot file");
	while(!(error = do_parse()) && S_ptree->mode!=END_OF_FILE)
		if(S_ptree->mode == LARROW) {
			 /* assignment, which it better always be */
			args = S_ptree->value.tree;
			if(args[0]->mode!=NAME)
				S_terminate("Invalid assignment in boot");
			name = args[0]->value.name;
			frame0_assign(name,args[1]);
		}
		else S_terminate("Invalid expression in boot: must be assignment");
	flush_data(0);
	Program = get_data(".Program",ANY); /* get the version from frame 0 */
	C_specials[0]->length = 0; /* clear out the .Program marker */
	pop_source();
	if(error)S_terminate("Error in parsing boot source");
}

vector *
S_debug(ent,arglist)
vector *ent, *arglist;
{
	vector **pp, *value;
	extern int sys_index; int which = sys_index; long i, n;
	switch(which) {
	case 0: /* sys.status() */
		value = alcvec(LIST,4L); pp = value->value.tree;
		set_precious(value,S_data);
		Frames->name="frames";
		call_stack->name="calls";
		Parent->name="parent.frame";
		N_call_args->name="no.of.arguments";
		*pp++ = Frames;
		*pp++ = call_stack;
		*pp++ = Parent;
		*pp = N_call_args;
		break;
	case 1: /* sys.frames() */
		value = New_vector(); *value = *frame_attrs;
		value->length--; /* exclude this frame */
		set_precious(value,S_data);
		break;
	case 2: /* sys.on.exit() */
		if(!On_stop)return(alcvec(LIST,0L));
		value = New_vector(); *value = *On_stop;
		(value->length)--; /* exclude this frame */
		set_precious(value,S_data);
		break;
	case 6: /* sys.calls() */
		value = New_vector(); *value = *call_stack;
		(value->length)--; /* exclude this frame */
		set_precious(value,S_data);
		break;
	case 8: /* sys.parent(generations) */
		if(Nargs(ent)<1)return(Parent); /* the whole vector */
		which =long_value(arglist->value.tree[0],ent);
		if(which<0)Recover("Specified negative number of generations in",ent);
		value = alcvec(INT,1L);
		n = parent_frame[Nframe];
		while(which-- &&  n>1)n = parent_frame[n];
		*(value->value.Long) = n;
		break;
	case 9: /* sys.nframe() */
		value = alcvec(INT,1L);
		*(value->value.Long) = parent_frame[Nframe];
		break;
	case 10: /* sys.frame() */
		which = parent_frame[Nframe];
		value = *(frame_attrs->value.tree+which-1);
		set_precious(value,S_data);
		break;
	case 11: /* sys.function() */
		if(Nargs(ent)<1)which = parent_frame[Nframe];
		else which = long_value(arglist->value.tree[0],ent);
		if(which<1 || which > Frames->length) {
			PROBLEM "Illegal frame number (%ld), should be between 1 and %ld",
				which, Frames->length RECOVER(NULL_ENTRY);
		}
		value = frame_fun->value.tree[which-1];
		if(VOID(value)) value = blt_in_NULL;
		break;
	default:
		MEANINGFUL(value);
		Recover("Invalid internal code for system status",ent);
	}
	if(PRECIOUS(value))value = copy_data(value,NULL_ENTRY);
	return(value);
}

#define CURRENT_CALL (*(call_stack->value.tree+Nframe-1))
#define CURRENT_NARGS (*(N_call_args->value.Long+Nframe-1))

static void 
del_local(name)
char *name; /* delete the first occurrence of name from the local data list */
	/* used by Eval() for FOR */
{
	extern vector *S_data, *assign_data, *Local_data;
	vector **children; int found;
	long n;
	children = Local_data->value.tree; found = FALSE;
	n = Local_data->length;
	while(n--){
		if(!found) found = name_eq((*children)->name,name);
		else *(children-1) = *children;
		children++;
	}
	if(found)Local_data->length--;
}

static void 
new_frame(frame,call)
vector *frame, *call;
{
	long n,old; vector **from, **to;
	old = Nframe;
	n = Frames->length+1;if(n>Frames->nalloc) xpd_frames();
	Frames->length = call_stack->length = ret_stack->length =
	  break_stack->length = next_stack->length = 
	  Parent->length = N_call_args->length = 
	  C_on_stop->length = C_assign->length = On_stop->length = frame_fun->length = frame_attrs->length = n;
	call_stack->value.tree[n-1]=call; ret_stack->value.tree[n-1] =
		C_on_stop->value.tree[n-1] = C_assign->value.tree[n-1] = 
		On_stop->value.tree[n-1] = frame_fun->value.tree[n-1] = frame_attrs->value.tree[n-1] = S_void;
	*(N_call_args->value.Long+n-1) = frame->length;
	parent_frame[n] = old; breaks[n] = nexts[n] = FALSE; frame_jmp[n] = NULL;
	Nframe = n; set_alloc(Nframe);
	Frames->value.tree[n-1] = Local_data = alcvec(LIST,frame->length);
	set_precious(Local_data,Local_data);
	for(n=frame->length, to=Local_data->value.tree, from = frame->value.tree;
	  n>0; n--, to++, from++) *to = *from;
}

static vector *
pop_frame(val)
vector *val;
{
	long ii, old = Nframe, new;
	new = parent_frame[Nframe];
if(check){
	if(new==old)Warning(enci1("Pop_frame from %ld to itself",old),NULL_ENTRY);
	if(old<Frames->length)Warning(enci2("Extra frames popped going from %ld to %ld",Frames->length,old),NULL_ENTRY);
	if(new>old)Recover("Invalid return to later frame",NULL_ENTRY);
}
	if(Restart && old <= Restart)Restart=0;
	for(ii=Frames->length; ii>old;ii--){ /* unusual: from explicit frame given to eval()?*/
		eval_clear(ii);
		clear_alloc(ii);
	}
	eval_clear(old);
	set_frame(new);
	val = copy_data(val,NULL_ENTRY);
	clear_alloc(old);
	C_specials[old-1]->length = 0;
	Frames->length = call_stack->length = ret_stack->length =
	  break_stack->length = next_stack->length = 
	  Parent->length = N_call_args->length = old-1;
	if(cur_attrs && cur_attrs->length >= old)cur_attrs->value.tree[old=1] = NULL_ENTRY;
	return(val);
}

static void 
set_frame(new)
long new;
{
	long old = Nframe;
if(check) {
	if(new<1 || new>Frames->length)
		Recover("Invalid frame number in set_frame",NULL_ENTRY);
}
	if(old==new)return;
	Nframe = new; Local_data = *(Frames->value.tree+new-1);
	set_alloc(new);
	if(C_specials[old-1]->length && !C_specials[new-1]->length)
		set_C_assign(C_specials[old-1],new);
	else if(C_specials[new-1]->length) set_C_assign(C_specials[new-1],new);
}

vector *
eval(ent)
vector *ent;
{
	return(Eval(ent,Nframe));
}

/* where expr. is likely to be constant, use this def. to save recursion */
#define EVAL(p,f) (m__ = (p)->mode, LANGUAGE_TYPE(m__)?Eval(p,f):(p))
static long m__;

static vector *
Eval(ent, frame)
vector *ent; long frame;
{
	char *name; int mode;
	long n, i, prev_frame; vfun_ptr f;
	vector **children, *Temp, *val, *child, *attrs;
if(check) {
	sanity(ent,"vector arg to Eval");
}
	if(!eval_open)return(S_void); /* called outside the evaluator ?? */
	if(frame != (prev_frame = Nframe))
		set_frame(frame); /* start off the frame */
	else if(cur_frame!=Nframe)set_alloc(Nframe);
	if(!frame_jmp[Nframe]) { /* first evaluation in frame */
		frame_jmp[Nframe] = (int *)S_alloc(1L,sizeof(jmp_buf));
		n=setjmp(frame_jmp[Nframe]); /* will return here for restart() */
		if(n) set_frame(frame);
	}
		Local_data = *(Frames->value.tree+Nframe-1);
if(check) {
		if(Nframe>Frames->length)
			S_terminate(enci2("Internal frame count, %ld, greater than frames length, %ld",Nframe,Frames->length));
		if(Local_data->mode!=LIST)
			S_terminate(enci1("Frame %ld's data list is not a list",Nframe));
	if(S_void->mode!=MISSING)
		S_terminate("Object \"S_void\" overwritten: ");
	if(Unknown->mode!=UNKNOWN)
		S_terminate("Object \"Unknown\" overwritten ");
	sanity(ret_vals[Nframe],"Return stack element in eval");
#ifdef MALLOC
	check_alloc();
#endif
}
	if(Trace_all) { /* can only be set by setting S_TRACE in shell */
		fprintf(stderr,"-----Frame %ld:\n",Nframe);
		deparse(ent,stderr);
		fflush(stderr);
		}
	if(Nexpr++ > expr_depth) {
		PROBLEM "Expressions nested beyond limit (options(expressions=%ld))", expr_depth
		RECOVER(NULL_ENTRY);
	}
	mode = ent->mode;
	switch(mode) {
	case LARROW:
	case DBLEARROW:
		Temp = replace_expr(ent);
		i = mode==DBLEARROW; /* permanent */
		/* the rhs, which will be the value of the assign.  This implementation
		/* relies on S_replace, user replacement & exp'ded replacement all
		/* preserving (i.e., not free'ing) the rhs */
		switch(Temp->mode) {
		case FUN_CALL:
			child = Temp->value.tree[1]; /* object's name */
			Eval(child,Nframe); /* maybe an argument */
if(check) {
	if(child->mode !=NAME) Recover("Invalid replacement expression",Temp);
}
			name = child->value.name;
			if(i) child = get_perm(name);
			else if(val = xact_comp(Local_data,name)) child =val;
			else {
				i |= Nframe == 1;
				child = get_data(name,ANY);
			}
			Temp = do_replace(ent,child,Temp,(int)i, &val);
			assign_obj(name,Temp,child,(int)i);
			break;
		case LBRACE: /* complicated, done by {..} */
			val = Eval(Temp,Nframe); break;
		default: /* simple */
			child = NULL; i |= Nframe == 1;
			name = (ent->value.tree[0])->value.name;
			val = EVAL(ent->value.tree[1],Nframe);
			/* set_data may free the rhs, so we need to return the lhs */
			val = assign_obj(name,val,child,(int)i);
		}
		break;
	case NAME: name = ent->value.name; val = NULL_ENTRY;
		if(*name <= 'Z' && (val = cons_value(ent))) break;
		for(n = 0,children = Local_data->value.tree;
		  n < Local_data->length; n++, children++)
			if(name_eq((*children)->name,name))
			  {val = *children; break;} /*found locally */
		if(val && val->mode == UNKNOWN && val->x.frame==cons_frame) {
			long nn;
			for(nn = Local_data->length-1, children = Local_data->value.tree;
			 nn>=0; nn--) if(name_eq((children[n])->name,name))break;
			if(Local_data->length-nn <= CURRENT_NARGS)
			  Recover(encs1("Recursive occurrence of default argument \"%s\"",name),NULL_ENTRY);
		}
		if(val){ /* is it an argument ? */
			n = val->mode == ARGUMENT &&
			  (Local_data->length-n <= CURRENT_NARGS);
		} else  {
			n = FALSE;
			if((val = get_data(name,ANY))==NULL_ENTRY)
				Recover(encs1("Object \"%s\" not found",name),NULL_ENTRY);
		}
		if(n) {
			if(*name == '.' && name_eq(name,"..."))
				Recover("Invalid use of \"...\" outside of function call",NULL_ENTRY);
			val=Eval(val,Nframe); /* an unevaluated argument */
		}
		break;
	case END_OF_FILE:
		val =S_void; break;/* end of source'd input*/
	case QUIT:
		val = ent; break; /* do_eval will handle quit actions */
	case ARGUMENT:
		 /*set up: put a dummy version into local data
		/*to ensure that the symbolic ARG stays on
		/* frame & to catch recursive defaults */
		val = New_vector(); *val = *Unknown;
		val->name = ent->name;
		append_dir(Local_data,0,val);
		val = *(ent->value.tree);
		if(val->mode==MISSING) {/*default*/
			val = *(ent->value.tree+1);
			if(val->mode==MISSING){
				Recover(encs1("Argument \"%s\" is missing, with no default",
				val->name),CURRENT_CALL);
			}
			val = EVAL(val,Nframe);
		}
		else {/* actual, do in caller's frame */
			n = parent_frame[Nframe];
			val = EVAL(val,n);
			if(RETURNED(n)) ret_vals[Nframe] = blt_in_NULL;
		}
		val=set_data(Local_data,val,ent->name);
		break;
	case COMPILED:
		val = Eval(ent->value.tree[0],Nframe); break;
	case FLEX_CALL:
		val = *(ent->value.tree);/* the call */
		val = Eval(expand_dots(val),Nframe);
		break;
	case INTERNAL: {
		long which; int eval_args; vector **from, **to; long len;
		children = ent->value.tree; n = ent->length;
		if(n<2)Recover("Invalid .Internal(): needs at least 3 arguments",ent);
		f = internal_symbol(children[1])->value.sys;
		if(!f)Recover("Attempt to use internal code not loaded with S",NULL_ENTRY);
		which = (n > 3) ? long_value(EVAL(children[3],Nframe),ent) : 0;
		eval_args = (n > 2) ?
		  logical_value(EVAL(children[2],Nframe),ent) : TRUE;
		val = children[0]; /* the image of the call */
		if(val->mode == FLEX_CALL)val = expand_dots(val->value.tree[0]);
		internal_call = val; /* record the call for use by quick_args*/
		Temp = alcvec(LIST,val->length-1); /* the arglist */
		len = Temp->length;
		for(i=0, from= val->value.tree+1, to = Temp->value.tree;
		  i<len && !RETURNED(Nframe); i++, from++, to++) {
			child = *from;
			if(eval_args && !(child=cons_value(child)))
				child = Eval(*from,Nframe);
			if(eval_args && PRECIOUS(child)){
					*to = New_vector();
					**to = *child;
			}
			else *to = child;
			(*to)->name = (*from)->name;
		}
		if(RETURNED(Nframe))break;
		to = Temp->value.tree;	child = val;
	/* use a method, if appropriate */
		if(val=do_intern_method(child,Temp,f,NULL_ENTRY,NULL_STRING)) break;
	/* invoke the C code for the .Internal*/
		sys_index = which;
		val = (*f) (child, Temp);
	if(check){
		if((name=sanity(val,NULL_STRING))!=NULL_STRING)
		 Recover(encs1("Bad value returned by internal code: %s",name),ent);
	}
		break;
	}
	case S_DATA:
		val = S_to_QPE(*(ent->value.Long),0L);
		val->status = ent->status; /* maybe NOPRINT */
		break;
	case S_FUN_CALL: {
		vector **from, **to, *t;
		children = ent->value.tree;
		val = children[0]; /* the image of the call */
		if(val->mode == FLEX_CALL)val = expand_dots(val->value.tree[0]);
		Temp = alcvec(LIST,val->length-1); /* the arglist */
		for(i=0, from= val->value.tree+1, to = Temp->value.tree;
		  i<Temp->length; i++, from++, to++) {
			t = EVAL(*from,Nframe);
			if(PRECIOUS(t))t = copy_data(t,NULL_ENTRY);
			t->name = (*from)->name;
			*to = t;
		}
		if(RETURNED(Nframe))break;
		val = Sfun(children[0],children[1],Temp);
		if(val->mode==S_DATA)val = S_to_QPE(*(val->value.Long),0L);
		break;
	}
	case FUN_CALL: /* an un-bound function call */
		 /* find the function */
		Temp = *(ent->value.tree); name = NULL;
		if(Temp->mode == NAME)  /* a function, or an argument */
			val = find_fun(name=Temp->value.name);
		else {
			val = EVAL(Temp,Nframe);
			if(!PRECIOUS(val))set_precious(val,Local_data);
		}
		if(!val)
			Recover(encs1("couldn't find function \"%s\"",string_value(Temp)),NULL_ENTRY);
		attrs =  val;
		if(val->mode != FUN_DEF) {
			val = coevec(val,ANY,TRUE,TRUE);
			if(val->mode!=FUN_DEF) Recover(
			  encs1("\"%s\" is not a function",string_value(Temp)),NULL_ENTRY);
		}
		if((Temp=val->value.tree[val->length-1])->mode==INTERNAL
			&& (Temp=quick_call(ent,val,Temp,name))) {
			val = Temp; break;
		}
		Temp = fun_args(val,ent,NULL_ENTRY); /* the matched args */
		if(Eval_Profile && Trace->length &&
		  (child= check_trace(ent,Temp,val))) /* may be traced */
			{ val = Eval(child,Nframe); break;}
		new_frame(Temp,ent);
		frame_fun->value.tree[Nframe-1] = val; /* the function def'n */
		frame_attrs->value.tree[Nframe-1] = make_frame_attrs(attrs);
		val= *(val->value.tree+val->length -1);/* the body */
		val = EVAL(val,Nframe); Temp=ret_vals[Nframe];
		if(Temp!=S_void){ val = Temp; ret_vals[Nframe]=S_void;}
		val = pop_frame(val); break;
	case FRAME: /* a pre-bound function call, usually */
		if( (n=ent->length)<3)Recover("Invalid frame expression",ent);
		children = ent->value.tree;
		Temp = coevec(children[1],ANY,FALSE,FALSE);
		if(Temp->mode != LIST)
			Recover("The frame for evaluation must be a list",Temp);
		child = children[2]; /* the call */
		new_frame(Temp,child);
		frame_attrs->value.tree[Nframe-1] = make_frame_attrs(children[1]);
		val = children[0]; /* the body */
		if(n>3 && val->mode == INTERNAL && child->mode == FUN_CALL
			&& (child = quick_call(child,children[3],val,NULL_STRING)))
			{val = pop_frame(child); break;}
		val = EVAL(children[0],Nframe); Temp=ret_vals[Nframe];
		if(Temp!=S_void){ val = Temp; ret_vals[Nframe]=S_void;}
		val = pop_frame(val); break;
	case FOR:
		{ vector *loop_value, *body_value;
		char *store_ptr[2];
		store_ptr[0]=NULL_STRING;
		alloc_ptr(store_ptr,NULL_ENTRYP,NULL_ENTRYP);
		children = ent->value.tree;
		name = (*children)->name; 
		Temp = coevec(EVAL(*(children+1),Nframe),ANY,FALSE,FALSE);
		set_precious(Temp,Local_data); /* not to change from assignments */
		loop_value = S_void;
		for(n=0;n<Temp->length;n++) {
			if(n==0) { /* initialize counter */
				val  = alcvec(Temp->mode,1L); val->name = name;
				val->x.frame = Local_data;
				append_dir(Local_data,0,val);
			}
			else {val = get_local(name,1L); 
if(check)sanity(val,"index in for loop");
			}
			if(!val)
				Recover("Index object in for loop deleted",ent);
			switch(Temp->mode) {
				case LGL: case INT: val->value.Long = Temp->value.Long+n; break;
				case REAL: val->value.Float = Temp->value.Float+n; break;
				case DOUBLE: val->value.Double = Temp->value.Double+n; break;
				case COMPLEX: val->value.Complex = Temp->value.Complex+n; break;
				case CHAR: val->value.Char = Temp->value.Char+n; break;
				default:
					*val = *(Temp->value.tree[n]);
					val->name = name;
					set_precious(val,Local_data);
			}
			body_value = Eval(*(children+2),Nframe);
			if(RETURNED(Nframe) || breaks[Nframe])break;
			if(nexts[Nframe])nexts[Nframe]=FALSE;
			else {
				try_to_free(loop_value,TRUE);
				loop_value = PRECIOUS(body_value) ? 
				  copy_data(body_value,NULL_ENTRY) : body_value;
			}
			alloc_ptr(store_ptr,&loop_value,&Temp);
		}
		del_local(name);
		val = loop_value; breaks[Nframe]=FALSE; break;
	}
	case WHILE: {
		vector *body_value;
		char *store_ptr[2];
		val = S_void;
		store_ptr[0]=NULL_STRING; alloc_ptr(store_ptr,NULL_ENTRYP,NULL_ENTRYP);
		while(logical_value(Eval(*(ent->value.tree),Nframe),ent)){
			if(RETURNED(Nframe))break;
			body_value = Eval(*(ent->value.tree+1),Nframe);
			if(RETURNED(Nframe) || breaks[Nframe])break;
			if(nexts[Nframe])nexts[Nframe]=FALSE;
			else {
				try_to_free(val,TRUE);
				val = PRECIOUS(body_value) ? 
				  copy_data(body_value,NULL_ENTRY) : body_value;
			}
			alloc_ptr(store_ptr,&val,NULL_ENTRYP);
		}
		breaks[Nframe]=FALSE; break;
	}
	case REPEAT: {
		vector *body_value;
		char *store_ptr[2];
		vector *compact_keep();
		val = S_void;
		store_ptr[0]=NULL_STRING; alloc_ptr(store_ptr,NULL_ENTRYP,NULL_ENTRYP);
		while(TRUE){
			body_value = Eval(*(ent->value.tree),Nframe);
			if(RETURNED(Nframe) || breaks[Nframe])break;
			if(nexts[Nframe])nexts[Nframe]=FALSE;
			else {
				try_to_free(val,TRUE);
				val = PRECIOUS(body_value) ? 
				  copy_data(body_value,NULL_ENTRY) : body_value;
			}
			alloc_ptr(store_ptr,&val,NULL_ENTRYP);
		}
		breaks[Nframe]=FALSE; break;
	}
	case RETURN: {
		vector **from, **to;
		if(Nframe<2)Recover("Meaningless to return when at top level",NULL_ENTRY);
		switch((int)ent->length) {
		case 0: val = blt_in_NULL; break;
		case 1: val = Eval(ent->value.tree[0],Nframe); break;
		default:
			Temp = alcvec(FUN_CALL,ent->length+1);
			Temp->value.tree[0] = alc_name("list");
			from = ent->value.tree; to = Temp->value.tree+1;
			n = ent->length; while(n--) *to++ = *from++;
			val = Eval(Temp,Nframe);
		}
		if(!PRECIOUS(val))set_precious(val,Local_data);
		ret_vals[Nframe] = val;
		break;
	}
	case LBRACE:
		val = S_void;
		for(n = ent->length, children = ent->value.tree; n>0; n--, children++) {
			Temp = Eval(*children,Nframe);
			if(RETURNED(Nframe) || breaks[Nframe])break;
			if(nexts[Nframe])break;
			else val = Temp;
		}
		break;
	case IF:
		children = ent->value.tree;
		val = Eval(*children,Nframe);
		if(!RETURNED(Nframe) &&  logical_value(val,ent))
			val = Eval(*(children+1),Nframe);
		else if(!RETURNED(Nframe) && ent->length>2 )
			val = Eval(*(children+2),Nframe);
		else val = blt_in_NULL;
		break;
	case COMMENT_EXPR:
		val = Eval(comment_out(ent),Nframe);
		break;
	case COMMENT:
		val = S_void; break;
	case BREAK:
		breaks[Nframe] = TRUE; val = ent; break;
	case NEXT:
		nexts[Nframe] = TRUE; val = ent; break;
	case PARSE:
		/* LANGUGE_TYPE, but its value itself */
		val = ent; break;
	default:
		if(LANGUAGE_TYPE(mode))
			val = Eval(fix_mode(ent),Nframe);
		else val = ent;
		break;
	}
	if(prev_frame != Nframe)set_frame(prev_frame);
	Nexpr--;
	return(val);
}

vector *
S_dummy(ent,arglist)
vector *ent, *arglist;
{
	vector *Temp, *val, **children, *child; char *name;
	long e_logical(); int which; long n, i, l1, l2;
	long nargs = arglist->length; vector **args = arglist->value.tree;
	which = sys_index; if(which<0)which = -which;
	/* The functions in the first switch are the only internals
	/* that do not get their arguments evaluated ahead of time
	/* the codes are defined in sys_codes.h */
	/* NB:  The internals that use their arguments without evaluating
	/* them must NOT be expanded in binding code:  These are expression(),
	/* rm(), substitute(), on.exit() and missing()
	/* (missing()'s can and should be removed in any expansion of code) */
	switch(which) {
	case S_EXPRESSION: 
	{
		vector **to;
		children = CURRENT_CALL->value.tree+1; n = CURRENT_CALL->length-1;
		Temp = alcvec(PARSE,n); to = Temp->value.tree;
		while(n--) *to++ = *children++;
		return(Temp);
	}
	case S_SWITCH:
	{
		vector *deflt;
		int by_name,found;
		Temp = coevec(Eval(Arg1(ent),Nframe),ANY,TRUE,CHECK_IT);
		if(Temp->length>1)Warning(enci1("switch value has %ld elements: only the first used",Temp->length),NULL_ENTRY);
		else if(Temp->length<1)Recover("Length of switch value is 0",NULL_ENTRY);
		MEANINGFUL(name);
		switch(Temp->mode) {
		case DOUBLE: case INT: case REAL: case LGL: case COMPLEX:
			n = long_value(Temp,ent); by_name = FALSE; break;
		default:
			MEANINGFUL(n);
			name = string_value(Temp); by_name = TRUE;
		}
		if(by_name)
			if(name==NULL_STRING || *name == '\0')return(S_void);
			else {
				n=ent->length-2; children=ent->value.tree+2;
				found=FALSE; deflt = NULL_ENTRY;
		/* if the name is matched, evaluate the first non-missing argument
		 * that follows: switch(a=,b=,c=foo(...),)
		 * if no match by name, the first unnamed argument, if any, is used
		 */
				while(n--){
					Temp = *children++;
					if(!found) {
						if( deflt==NULL_ENTRY &&
						  IS_NULL_STRING(Temp->name))
							deflt = Temp;
						found=name_eq(Temp->name,name);
					}
					if(found && Temp->mode!=MISSING){
						deflt = Temp; break;
					}
				}
				if(deflt==NULL_ENTRY)return(blt_in_NULL);
				else
					return(Eval(deflt,Nframe));
			}
		else if(n<0 || n>ent->length-2)return(blt_in_NULL);
		else if(n==0) {
			val = ent->value.tree[ent->length -1];
			if(val->name && *val->name == 'd') 
				return(Eval(val,Nframe));
			else return(blt_in_NULL);
		}
		else
			return(Eval((*(ent->value.tree+n+1)),Nframe));
	}
	case S_SUBSTITUTE:
		val = get_local("expr",1L);
		Temp = get_local("frame",2L);
		if(val->mode==ARGUMENT)val = val->value.tree[0];
		if(Temp->mode == ARGUMENT && VOID(Temp->value.tree[0]))
			Temp = Frames->value.tree[parent_frame[Nframe]-1];
		else {
			Temp = EVAL(Temp,Nframe);
			if(Temp->mode != LIST) {
				n = long_value(Temp,NULL_ENTRY);
				if(n==0)Temp = blt_in_empty;
				else if (n<0 || n>Frames->length)
				   Recover("Invalid frame number", Temp);
				else Temp = Frames->value.tree[n-1];
			}
		}
		val = substitute(val,Temp,(char **)NULL,S_void);
		return(val);
	case S_EVAL: {
		long frame, prev, parent, mode; vector *attrs;
		val = args[0]; frame = Nframe;
		attrs = Temp = args[1]; /*local */
		Temp = coevec(Temp,ANY,FALSE,FALSE);
		switch(data_mode(Temp)) {
		case LGL:
			i = Temp->value.Long[0] ? parent_frame[Nframe] : 1;
			break;
		case LIST: i = -1; break; /* an explicit frame*/
		default: i = long_value(Temp,NULL_ENTRY); /* a frame number */
		}
		val = coevec(val,ANY,FALSE,PRECIOUS(val));
		mode = val->mode; /* can't be STRUCTURE */
		if(mode==PARSE) {
			n = val->length;
			if(n == 1) val = val->value.tree[0];
			else if(n>1) {
				child = New_vector();
				*child = *val; child->mode = LBRACE;
				val = child;
			}
			else return(val);
		}
		else if(!LANGUAGE_TYPE(mode)) return(val);
		if(i==0)i=1;
		if(i>0) {
			if(i>Frames->length)
				 Recover("Invalid \"local\" argument to eval()",Temp);
			MEANINGFUL(prev);
			if(i<frame) { /* ensure expression will stay */
			/* this, along with case ARGUMENT in Eval,
			/* and set_data, could
			/* be more sophisticated in recognizing objects
			/* coming originally from an early frame */
				prev = set_alloc(i);
				val = copy_data(val,Frames->value.tree[i-1]);
			}
			val = Eval(val,i);
			if(i<frame)set_alloc(prev);
		}
		else {
			vector *ttt = args[2];
			if(ttt->mode == LIST) {
				new_frame(ttt,S_void);
				parent =Nframe;
			}
			else if(ttt->length)parent = long_value(ttt,ent);
			else parent = parent_frame[frame];
			if(parent<1 || parent>Frames->length)
				Recover("Invalid parent frame number",NULL_ENTRY);
			new_frame(Temp,S_void);
			frame_fun->value.tree[Nframe-1] = S_void; /* the function def'n */
			frame_attrs->value.tree[Nframe-1] = make_frame_attrs(attrs);
			parent_frame[Nframe] = parent;
			val = Eval(val,Nframe);
			val = pop_frame(val);
		}
		return(val);
	}
	case S_RM:
		val = alcvec(FUN_CALL,ent->length);
		children = val->value.tree;
		*children++ = ent->value.tree[0];
		for(n = 0;n<nargs; n++, args++, children++) {
			child = *args;
			if(child->mode==NAME)child =get_local(child->value.name,1L);
			if(child->mode==ARGUMENT)child = child->value.tree[0];
			if(child->mode!=NAME)
			 Recover("Argument to rm() is not an object name",child);
			*children = child;
			}
		do_rm(val);
		return(S_void);
	case S_AND:
		children = ent->value.tree;
		Temp = Eval(children[1],Nframe);
		l1 = e_logical_value(Temp,ent);
		if(!l1)return(blt_in_FALSE);
		l2 = e_logical_value(Eval(children[2],Nframe),ent);
		return( !l2 ? blt_in_FALSE :
		 ((is_na(&l2) || is_na(&l1)) ? blt_in_NA : blt_in_TRUE));
	case S_OR:
		children = ent->value.tree;
		Temp = Eval(children[1],Nframe);
		l1 = e_logical_value(Temp,ent);
		if(l1==TRUE)return(blt_in_TRUE);
		l2 = e_logical_value(Eval(children[2],Nframe),ent);
		return( l2==TRUE ? blt_in_TRUE :
		 ((is_na(&l2) || is_na(&l1)) ? blt_in_NA : blt_in_FALSE));
	case S_MISSING:
		Temp = get_local("name",1L);
		if(!Temp || Temp->mode!=ARGUMENT)Recover("Invalid use of missing()",ent);
		Temp = Temp->value.tree[0]; /* the actual */
		MEANINGFUL(name);
		if(Temp->mode == NAME) name=Temp->value.name;
		else Recover("The argument to missing() should be a name",NULL_ENTRY);
		set_frame(parent_frame[Nframe]);
		n = Local_data->length-CURRENT_NARGS; children = Local_data->value.tree+n;
		MEANINGFUL(val);
		while(n++ < Local_data->length){
			val = *children++;
			if(!name_eq(name,val->name))continue;
			val =  (val->mode == MISSING ||(val->mode==ARGUMENT &&
			  (val->value.tree[0])->mode==MISSING))? blt_in_TRUE
			  :blt_in_FALSE;
			n = 0; break;
		}
		if(!n)return(val);
		else if(val=miss_dot(name,Local_data))return(val);
		else Recover(encs1("Object %s should have been an argument",name),NULL_ENTRY);
	case S_ON_STOP:
		n = parent_frame[Nframe];
		if(Nargs(ent)==0)/* delete the on_stop*/
			On_stop->value.tree[n-1] = S_void;
		else {
			long prev; /* On_stop is allocated in the first frame, but
				its elements can point to expressions in later frames,
				according to the discipline that the actions
				are dropped on exit from their function */
			Temp = get_local("expression",1L);
if(check) {
	if(Temp->mode!=ARGUMENT)Recover("Invalid code in on.exit()",ent);
}
			Temp = Temp->value.tree[0]; /* the actual argument */
			prev = set_alloc(1L);
			val = copy_data(Temp,NULL_ENTRY);
			On_stop->value.tree[n-1] = val;
			set_alloc(prev);
		}
		return(S_void);
	}
/* other functions included here, mostly because they interface to */
/* one of the evaluation utilities in this file. */
	switch(which) {
	case S_TRACE:
		if(nargs>0)
			Eval_Profile = long_value(args[0],NULL_ENTRY);
		else Eval_Profile = Eval_Profile?0:1;
		val = S_void; break;
	case S_STOP:
		Temp = args[0];
		if(Temp->length<1) do_stop(SIGSERROR); /*  silent */
		else Recover(string_value(args[0]),NULL_ENTRY);
#ifdef lint
		val = 0; break;
#endif
	case S_ASSIGN:
		val = expd_replace(args[0],long_value(args[1],ent));
		break;
	case S_IS_ARG: {
		vector *frame; long nargs;
		Temp = coevec(args[0],CHAR,TRUE,CHECK_IT);
		name = Temp->value.Char[0];
		n = parent_frame[Nframe]-1;
		frame = Frames->value.tree[n];
		nargs = N_call_args->value.Long[n]; val = NULL_ENTRY;
		for(n = frame->length-nargs,args = frame->value.tree+n;
		  n < frame->length; n++, args++)
			if(name_eq((*args)->name,name))
			  {val = *args; break;} /*found locally */
		val = val ? blt_in_TRUE : blt_in_FALSE;
		}
		break;
	case S_WARN:
		Temp = args[0];
		Warning(Temp->length?string_value(args[0]):"",NULL_ENTRY);
		val = S_void; break;
	case S_NARGS:
		n = parent_frame[Nframe]-1;
		if(n<0)Recover("nargs() not in a function call",ent);
	 	val = alcvec(INT,1L);
		*(val->value.Long)=Nargs(*(call_stack->value.tree+n));
		break;
	case S_NCHAR:
		{
		char **ptr; long *slens; vector *lens;
		Temp = args[0];
		val = coeves(Temp,CHAR,FALSE,PRECIOUS(Temp),&Temp);
		if(VOID(Temp)){val = S_void; break;}
		n = Temp->length;
		lens = alcvec(INT,n);
		ptr = Temp->value.Char;
		slens = lens->value.Long;
		while(n--) *slens++ = strlen(*ptr++);
		if(val->mode == STRUCTURE) {
			n = which_comp(".Data",val);
			val->value.tree[n-1] = lens;
			lens->name = ".Data";
		}
		else val = lens;
		break;
		}
	case S_RESTART:
		n = logical_value(args[0],ent);
		if(n && db_level) {
			fputs("restart() ignored in wrapup\n",stderr);
			fflush(stderr);
			n = 0;
		}
		Restart = n ? parent_frame[Nframe] : 0;
		val = alcvec(INT,1L);
		val->value.Long[0] = Restart;
		break;	
	case S_ATTR: /* this and next two implement attributes of frames */
		i = Nframe; set_frame(parent_frame[Nframe]);
		append_el(arglist,0L,frame_attrs->value.tree[Nframe-1]);
		sys_index = ATTR_FUN;
		set_frame(i);
		val = S_extract(ent,arglist);
		break;
	case S_SET_ATTR:
		i = Nframe; set_frame(parent_frame[Nframe]);
		arglist = copy_data(arglist,NULL_ENTRY);
		val = frame_attrs->value.tree[Nframe-1];
		if(val->x.frame!= Local_data) 
			val = frame_attrs->value.tree[Nframe-1] = copy_data(val,Local_data);
		append_dir(arglist,0L,val);
		sys_index = ATTR_FUN;
		val = S_replace(ent,arglist);
		set_frame(i);
		break;
	case S_ALL_ATTRS:
		i = Nframe; set_frame(parent_frame[Nframe]);
		append_el(arglist,0L,frame_attrs->value.tree[Nframe-1]);
		sys_index = ALL_ATTR_FUN;
		set_frame(i);
		val = S_extract(ent,arglist);
		break;
	default:
		Recover(enci1("index (%ld) for S_dummy unknown",(long)which),ent);
#ifdef lint
		val = 0;
#endif
	}
	return(val);
}

static vector *
replace_expr(ent)
vector *ent;
{
	vector *child, *Temp, *copy; long n;
	Temp = ent->value.tree[0]; /* left-side of assignment */
	if(Temp->mode==NAME)return(ent);
	if(Temp->mode != FUN_CALL)
		Recover(encs1("Left side of assignment can't be of mode %s",
		  token_name(Temp->mode)), NULL_ENTRY);
	if(Temp->length<2)
		Recover("Function with no argument on left of assignment", ent);
	child = Arg1(Temp);
	switch(child->mode) {
	case NAME:
	case CHAR:
		n = Temp->length;
		copy = alcvec(FUN_CALL,n+1);
		MEMCPY(copy->value.tree, Temp->value.tree, n);
		return(copy);
	default:
		if(NOT_RECURSIVE(child->mode)) Recover("Invalid assignment: no object name",ent);
		return(expd_replace(ent,Nframe));
	}
}

static vector **o_names = NULL;
static long max_o_names = 0;

static vector *
expd_replace(ent,nfr)
vector *ent; long nfr;
{
	vector *call, **calls, *val, **exprs, *a, *rhs, *a_name, *b, *nframe;
	long i, k;
	i = ent->mode;
	if(i!=LARROW && i!=DBLEARROW)Recover("Invalid expression",ent);
	k=0; call = ent->value.tree[0];
	while(!NOT_RECURSIVE(call->mode)){
		if(call->length<2)Recover("Invalid expression on left of assignment",call);
		k++; call = call->value.tree[1];
	}
	switch(call->mode) {
		case NAME:
		case CHAR:
			break;
		default:
			Recover("Invalid left-side of assignment: no object name",ent);
	}
	if(k<2)return(ent);
	if(k>=max_o_names){
		long kk,prev = set_alloc(PERM_FRAME);
		kk = (k<10) ? 11 : k+1;
		o_names = (vector **)S_alloc(k+1,sizeof(vector *));
		for(i = 0; i<=k; i++)
			o_names[i] = alc_name(enci1("..%ld",i));
		max_o_names = kk;
		set_alloc(prev);
	}
	val = alcvec(LBRACE,2*k+1); exprs= val->value.tree;
	
	calls = (vector **)S_alloc(k+1,sizeof(vector *));
	a_name = alc_name(".Assign");
	nframe = alcvec(INT,1L); nframe->value.Long[0] = nfr;
	repl_calls(ent->value.tree[0],o_names,calls,k-1);
	calls[k] = ent->value.tree[1];
	for(i=k; i>0; i--){
		a = alcvec(FUN_CALL,4L);
		a->value.tree[0] = a_name;
		b = alcvec(CHAR,1L); b->value.Char[0] = (o_names[i-1])->value.name;
		a->value.tree[1] = b;
		a->value.tree[2] = calls[i];
		a->value.tree[3] = nframe;
		*exprs++ = a;
	}
	rhs = o_names[k-1];
	for(i=0; i<k; i++){
		a = alcvec(LARROW,2L);
		a->value.tree[0] = calls[i];
		a->value.tree[1] = rhs;
		rhs = o_names[i]; *exprs++ = a;
	}
	*exprs = o_names[k-1];
	return(val);
}

static void 
repl_calls(ent,onames,calls,level)
vector *ent, **onames, **calls; long level;
{
	long n; vector *call;
	if(level>0) {
		n = ent->length;
		call = alcvec(FUN_CALL,n);
		MEMCPY(call->value.tree, ent->value.tree, n);
		call->value.tree[1] = *onames;
		*calls = call;
		repl_calls(ent->value.tree[1],onames+1,calls+1,level-1);
	}
	else *calls = ent;
}

/* carry out the replacement of part of an object.  This routine is only called     */
/* from the evaluator, immediately followed by a call to assign_obj().   Because    */
/* assign_obj checks the new object for being identical to the old, the code in     */
/* do_replace can handle both in-place situations (via S_replace) and versions that */
/* construct a new object (user-defined replacements and replacement methods)       */
static vector *
do_replace(ent, object, Temp, perm, rhsp)
vector *ent, *object, *Temp, **rhsp;
int perm;
{
	vector **args = Temp->value.tree, *fun = args[0], *frame = object->x.frame;
	char *name = fun->value.name;
	long n = Temp->length, which = el_fun(name), i, prev;
	int non_local = (Nframe > 1) && perm;
	vector *rhs;
if(check) {
	if(fun->mode != NAME) Recover("Invalid left side of assignment",Temp);
	check_frame(cur_frame,encs1("before replacement (\"%s\")",name));
}
	args[n-1] = ent->value.tree[1]; rhs = Eval(args[n-1],Nframe);
	*rhsp = rhs;
	/* user-defined replacement */
	if(which == 0) {
		vector *def, *frame, *temp;
		args[0] = alc_name(name=encs1("%s<-", name));
		def = find_fun(name);
		if(!def)
			Recover(encs1("couldn't find assignment function \"%s\"",name),NULL_ENTRY);
		frame = fun_args(def,Temp,NULL_ENTRY); /* the matched args */
		if(PRECIOUS(rhs)) {
			temp = New_vector();
			*temp = *rhs; 
			rhs = temp;
		}
		rhs->name = (def->value.tree[def->length-2])->name;
		append_el(frame,0L,rhs); /* append the evaluated rhs to prevent re-eval'n*/
		temp = alcvec(FRAME,3L); /* create a bound & partly evaluated frame */
		args = temp->value.tree; args[0] = def->value.tree[def->length-1];
		args[1] = frame; args[2] = Temp;
		return(Eval(temp, Nframe));
	}
	/*
	 * otherwise, done by a call to S_replace: a speeded-up version
	 * of calling a function containing the .Internal
	 */
	if(Nframe > 1 && !perm && frame != Local_data) {
		object = copy_data(object, Local_data);
		frame = Local_data;
	}
	Temp->value.tree = ++args;
	Temp->length = --n;
	*args++ = object;
	for(i = 1; i < n-1; i++, args++)
		*args = EVAL(*args, Nframe);
	*args = rhs;
	/*
	 * Because S_replace will do things in place in object, must
	 * make sure the inserted data is in the right frame.
	 * NOT needed for user replacement since there Temp!=object, ever
	 */
	MEANINGFUL(prev);
	if(non_local) {
		prev = set_alloc(perm ? 1L : Nframe);
		args = Temp->value.tree + 1;
		for(i = 1; i < n; i++, args++)
			*args = copy_data(*args, frame);
	}
/* if there might be a replacement method for this object, use it     */
/* this code shortcuts do_intern_method() to save lookup of S_replace */
	if(object->mode == STRUCTURE && xact_comp(object,"class")) {
		quick_save = ent; quick_fun = find_fun(Replace_names[which-1]);
	  	fun = class_fun("Replace",Replace_names[which-1],ent,Temp);
		if(fun) return(Eval(fun,Nframe));
	}
	sys_index = which;
	Temp = S_replace(ent, Temp);
if(check){
	check_frame(cur_frame,encs1("after replacement (\"%s\")",name));
}
	if(non_local)
		set_alloc(prev);
	return(Temp);
}

vector * 
assign_obj(name, object, old, perm)
char *name; vector *object, *old; int perm;
{
	vector *frame;
	if(object == NULL_ENTRY)return(object); /* done by a {...} expansion earlier */
	if(perm) {
		frame = S_data; perm_assign(name,object);
		if(xact_comp(frame0,name) || (h_S_data && xact_comp(h_S_data,name)))
			Warning(encs1("\"%s\" assigned on the working data but hidden by a version on frame 0",
				name),NULL_ENTRY);
	}
	else if(Nframe>1) frame = Local_data;
	else { /* Possibilities: frame 1, frame 0, working data (S_data)
		/* or another directory (cons_frame) (goes to working data) */
		frame = old ? old->x.frame : S_data;
		if(frame == S_data || frame == cons_frame)
			perm_assign(name,object);
		else if(frame == frame0 || frame == h_S_data)/* old or new frame 0*/
			frame0_assign(name,object);
	}
	if(object!=old || (frame==S_data && object != find_comp(S_data,name)))
		object = set_data(frame,object,name);
	return(object);
}

static void 
xpd_frames()
{
	long prev = set_alloc(PERM_FRAME);
	long old = Frames->length, new = old < 32 ? 32 : 2*old;
	call_stack->length = Parent->length = N_call_args->length = old;
	xpand(Frames, new);
	new = Frames->nalloc;  /* normally does nothing, unless new is small */
	Local_data = Frames->value.tree[Nframe-1];
	xpand(call_stack,new);
	xpand(ret_stack,new);
	ret_vals = ret_stack->value.tree-1;
	xpand(Parent,new);
	parent_frame = Parent->value.Long-1;
	xpand(N_call_args,new);
	xpand(On_stop,new);
	xpand(C_on_stop,new);
	xpand(frame_fun,new);
	xpand(frame_attrs,new);
	xpand(C_assign,new); C_specials = C_assign->value.tree;
	xpand(break_stack,new); breaks = break_stack->value.Long-1;
	xpand(next_stack,new); nexts = next_stack->value.Long-1;
	frame_jmp = (int **)Perm_realloc((char *)frame_jmp,(new+1)*sizeof(int *));
	Frames->length = call_stack->length = ret_stack->length = 
		break_stack->length = next_stack->length = 
		Parent->length = N_call_args->length = old; /* restore lengths */
	set_alloc(prev);
}

static void 
xpand(what,new)
vector *what; long new;
{
	vector *val, **from, **to; long old = what->length, i, *f, *t;
	val = alcvec(what->mode,new);
	switch(what->mode) {
	case LIST:
		for(i=0, from = what->value.tree, to = val->value.tree;
			i<old; i++) *to++ = *from++;
		break;
	case LGL: case INT:
		for(i=0, f = what->value.Long, t = val->value.Long;
			i<old; i++) *t++ = *f++;
		break;
	default:
		S_terminate(encs1("Internal eval error: expand undefined for mode %s",token_name(what->mode)));
	}
	*what = *val;
}

static long 
e_logical_value(ent,from)
vector *ent/* T, F, or NA */, *from;
{
	vector *value; long mode,n;
if(check) {
	sanity(ent,"vector arg to logical_value");
}
	mode=ent->mode;
	if(!(n=ent->length))Recover("No data to interpret as logical value",from);
	if(mode==LGL && n==1) /* the fast exit */
		return(is_na(ent->value.Long) ? NA_PATTERN : (int) *(ent->value.Long) );
	value = coevec(Eval(ent,Nframe),LGL,TRUE,CHECK_IT);
	if(VOID(value))
		Recover("Can't evaluate as a logical",from);
	if(value->length>1)
		Warning(enci1("Condition has %ld elements: only the first used",value->length),from);
	return(is_na(value->value.Long) ? NA_PATTERN : (int) *(value->value.Long) );
}

int 
logical_value(ent,from)
vector *ent, *from;
{
	vector *value; long mode,n;
if(check) {
	sanity(ent,"vector arg to logical_value");
}
	mode=ent->mode;
	if(!(n=ent->length))Recover("No data to interpret as logical value",from);
	if(mode==LGL && n==1 && !is_na(ent->value.Long))
		return((int) *(ent->value.Long) ); /* the fast exit */
	value = coevec(ent,LGL,TRUE,PRECIOUS(ent));
	if(VOID(value))
		Recover("Can't evaluate as a logical",from);
	if(is_na(value->value.Long))
		Recover("Missing value where logical needed",from);
	if(value->length>1)
		Warning(enci1("Condition has %ld elements: only the first used",value->length),from);
	return((int) *(value->value.Long) );
}

float 
real_value(ent)
vector *ent;
{
	vector *value; long mode;
if(check) {
	sanity(ent,"vector arg to real_value");
}
	mode=ent->mode;
	if(ent->length<1)Recover("No data to interpret as a number",ent);
	if(mode==REAL)return(*(ent->value.Float)); /* the fast exit */
	if(mode==DOUBLE)return((float)(*(ent->value.Double)));
	value = coevec(ent,REAL,TRUE,PRECIOUS(ent));
	if(VOID(value))
		Recover("Can't evaluate as a number",ent);
	if(is_na(value->value.Float))
		Recover("Missing value where number needed",ent);
	if(value->length>1)
		Warning(enci1("Object has %ld elements: only the first used for numerical value",value->length),NULL_ENTRY);
	return( *(value->value.Float) );
}

double 
double_value(ent)
vector *ent;
{
	vector *value; long mode;
if(check) {
	sanity(ent,"vector arg to real_value");
}
	mode=ent->mode;
	if(ent->length<1)Recover("No data to interpret as a number",ent);
	if(mode==DOUBLE) /* the fast exit */
		if(is_na(ent->value.Double))
			Recover("Missing value where number needed",ent);
		else
			return(*(ent->value.Double));
	value = coevec(ent,DOUBLE,TRUE,PRECIOUS(ent));
	if(VOID(value))
		Recover("Can't evaluate as a number",ent);
	if(is_na(value->value.Double))
		Recover("Missing value where number needed",ent);
	if(value->length>1)
		Warning(enci1("Object has %ld elements: only the first used for numerical value",value->length),NULL_ENTRY);
	return( *(value->value.Double) );
}

long 
long_value(ent, from)
vector *ent, *from;
{
	vector *value; long mode;
if(check) {
	sanity(ent,"vector arg to long_value");
}
	mode=ent->mode;
	if(!ent->length)Recover("No data to interpret as a number",from);
	if(mode==INT)return(*(ent->value.Long)); /* the fast exit */
	if(mode==DOUBLE)return((long)(*(ent->value.Double)));
	value = coevec(ent,INT,TRUE,PRECIOUS(ent));
	if(VOID(value))
		Recover("Can't evaluate as a number",from);
	if(is_na(value->value.Long))
		Recover("Missing value where number needed",from);
	if(value->length>1)
		Warning(enci1("Object has %ld elements: only the first used for numerical value",value->length),from);
	return( *(value->value.Long) );
}

char *
string_value(ent)
vector *ent;
{
	vector *value; long mode;
if(check) {
	sanity(ent,"vector arg to string_value");
}
	mode=ent->mode;
	if(!ent->length)Recover("No data to interpret as a character string",ent);
	if(mode==CHAR && ent->length==1)return(*(ent->value.Char));
	if(mode==NAME)return(ent->value.name);
	value = coevec(ent,CHAR,TRUE,PRECIOUS(ent));
	if(VOID(value) )
		Recover("Can't evaluate as a character string",ent);
	if(value->length>1)
		Warning(enci1("Object has %ld elements: only the first used for string value",value->length),NULL_ENTRY);
	return( *(value->value.Char) );
}

vector *
fun_args(f,call,deflts)
vector *f, *call, *deflts;
{
	long *Match_to, *Matched, nmatch, nf, nc, i, done, pmatch, ic, *mf,
		 *mc, *l, idots, n, *m;
	vector **ff, **cc, **ff0, **cc0, **position, *frame, *arg, **aa, *dots, *actual;
	char *name, *q, *p, message[80];
	int c;
	ff0 = f->value.tree; cc0 = call->value.tree+1;
	nf = f->length-1; nc = call->length -1; nmatch =0;
	position = ff0 + nf; /* look for ... as a formal */
	Match_to = CALLOC(nf+nc, long); Matched = Match_to + nf;
	for(n = nf, ff = ff0; n>0; n--, ff++) {
		name = (*ff)->name;
		if(name && (*name == '.') && name_eq(name,"...")){
			position = ff; Match_to[position - ff0] = -1;
			break;
		}
	}
	for(ic=1, cc = cc0, mc = Matched; ic<=nc; ic++, cc++,mc++) {
	/* exact match by name */
		name = (*cc)->name;
		done = 0;
		if(name && *name) {
			for(ff = ff0, i = 1,mf = Match_to;i <= nf && !done;
			  ff++, i++, mf++) {
				if(*mf)continue; /* already matched */
				p = name; q = (*ff)->name;
				while( (c = *p++) == *q++ )
					if(!c) {done = i; break;}
			}
		}
		if(done) { /* mark the actual and the formal as matched */
			Match_to[done - 1] = ic; Matched[ic - 1] = done;
			nmatch++;
		}
	}
	for(ic=1, cc = cc0, mc = Matched; ic<=nc; ic++, cc++,mc++) {
	/* partial match by name */
		if(*mc)continue;
		name = (*cc)->name;
		done = 0;
		if(name && *name) {
			pmatch = 0;
			for(ff = ff0, i = 1,mf = Match_to;i <= nf;
			  ff++, i++, mf++) {
				if(*mf)continue; /* already matched */
				p = name; q = (*ff)->name;
				while( (c = *p++) == *q++ ){}
				if(!c && ff < position) /* maybe p-match */
					if(pmatch)pmatch = -1;
					else pmatch = i;
			}
			if(pmatch > 0) done = pmatch; /* 1 p-match */
		}
		if(done) { /* mark the actual and the formal as matched */
			Match_to[done - 1] = ic; Matched[ic - 1] = done;
			nmatch++;
		}
	}
	for(ic=1, cc = cc0, mc = Matched; ic<=nc; ic++, cc++,mc++) {
	/* match by position */
		if(*mc)continue;
		name = (*cc)->name;
		done = 0;
		if(!name || !(*name)) {
			for(ff = ff0, i = 1,mf = Match_to;i <= nf;
			  ff++, i++, mf++)
				if(!(*mf) && ff<position) {
					done = i; break;
				}
		}
		if(done) { /* mark the actual and the formal as matched */
			Match_to[done - 1] = ic; Matched[ic - 1] = done;
			nmatch++;
		}
	}
	MEANINGFUL(dots);
	if( (idots = position - ff0 + 1) <=nf) { /* collect leftovers */
		long ndots; vector **j;
		ndots = nc - nmatch;
		dots = alcvec(LPAR,ndots+1); /* could change to PARSE if
			we allowed ... only in calls */
		j = dots->value.tree; *j++ = S_void;
		if(ndots) for( cc = cc0, i = 0; i < nc; i++, cc++ )
			if(!Matched[i]){
				Matched[i] = idots;
				*j++ = *cc; /* any need to copy?? */
			}
		Match_to[idots-1] = nc+1; /* just not zero */
	}
	/* done matching; make the frame*/
	frame = alcvec(LIST,nf); aa = frame->value.tree;
	MEANINGFUL(m);
	if(deflts)m = deflts->value.Long;
	for(l = Match_to, n = nf, ff = ff0; n>0; l++, n--, ff++, aa++, m++) {
		actual = (ff==position) ? dots :( (*l)? cc0[*l - 1] : S_void);
		if(actual->mode == MISSING) *l = FALSE;
		if(*l && ff!=position && (arg=cons_value(actual))) /* just the data */
			arg = copy_data(arg,Local_data);
		else {
			arg = alcvec(ARGUMENT,2L);
			arg->value.tree[0] = actual;
			arg->value.tree[1] = *ff;
			set_precious(arg, Local_data);

		}
		*aa = arg; arg->name = (*ff)->name;
		if(deflts) *m = !*l;
	}
	done = FALSE;
	for(l = Matched, i = 1, cc = cc0; i <= nc; l++, i++, cc++)
		if(!(*l)) { /* look for unmatched arguments */
			name = (*cc)->name;
			if(name && *name) sprintf(message,"Argument %s not matched",name);
			else sprintf(message,"Argument number %ld in call not matched",i);
			done = TRUE;
		}
	free((char *)Match_to);
	if(done)Recover(message,call);
	return(frame);
}


/* this routine allows arbitrary lists of arguments to be passed down through
 * a function whose formal arguments include "..."  The semantics require that
 * invocation of this function with, say, k arguments matching ... is equivalent
 * to implicit arguments ..1, ..2, ..., ..k  Invocation of other functions with
 * "..." as an actual is equivalent to supplying the k implicit arguments.  Some
 * significant overhead is generated, because the implicit arguments must be
 * evaluated in the correct frame, but must also match in name to the actuals
 */
#define DOT_NAME(j) (j<16 ? dot_names[j] : enci1("..%ld",j+1))
#define DOT_NAME_OBJ(j) (j<16 ? dot_ptrs[j] : alc_name(enci1("..%ld",j+1)))
static char *dot_names[] = { "..1", "..2","..3","..4","..5",
	"..6","..7","..8","..9","..10","..11","..12",
	"..13","..14","..15","..16"};
static vector **dot_ptrs = NULL;

static vector *
expand_dots(ent)
vector *ent;
/* expand a function call containing "..."  */
{
	vector **args, *dots, **c1, **c2, **c3, *arg, *value, *actual;
	long n, nn, dlength, i; vector **dvalue = &S_void;
	int isarg, first = TRUE, named;
	dots = get_local("...",1L);
	if(VOID(dots))
		Recover("\"...\" used in a context where it doesn't exist",ent);	
	if(isarg = (dots->mode==ARGUMENT)) {
		args = dots->value.tree;
		dots = args[0];
		if(VOID(dots))dots=args[1];
	}
	if(VOID(dots))dlength=0;
	else if(NOT_RECURSIVE(dots->mode)){dlength=1; dvalue = &dots;}
	else if(isarg) { /* the LPAR data set up in the parse */
		dvalue = dots->value.tree+1;
		dlength = dots->length-1;
	}
	else {dlength = dots->length; dvalue = dots->value.tree;}
	args = ent->value.tree+1; n = ent->length-1;
	while(n--) if( (arg = *args++)->mode == NAME &&name_eq("...",arg->value.name)) {
		value = alcvec(ent->mode,dlength+ent->length-1);
		c2 = value->value.tree;
		c1=ent->value.tree; nn=ent->length-n-1;
		while (nn--) *c2++ = *c1++;
		nn = dlength; c3 = dvalue;
		value->length = ent->length + nn-1;
		/* replacing ... in the arglist */
		for(i = 0;i<dlength;i++,c2++,c3++) {
			actual = *c3;
			if(!(isarg && LANGUAGE_TYPE(actual->mode))) {
				*c2 = actual;
				continue;
			}
			/* create special indiv. arg's: ONCE only */
			if(first) {
				arg = alcvec(ARGUMENT,2L);
				*(arg->value.tree) = actual;
				arg->name = DOT_NAME(i);
				append_dir(Local_data,NOARG,arg);
				CURRENT_NARGS++;
				if(!dot_ptrs)init_dots();
			}
			named = (*c3)->name && *(actual->name);
			if(named) {
				arg = alc_name(DOT_NAME(i));
				arg->name = actual->name;
			}
			else arg = DOT_NAME_OBJ(i);
			*c2 = arg;
		}
		nn = n; c1++;
		while(nn--) *c2++ = *c1++;
		ent = value; first = FALSE;
	}
	return(ent);
}

static void 
init_dots()
{
	long i, prev; vector *p;
	prev = set_alloc(PERM_FRAME);
	dot_ptrs = (vector **)S_alloc(16L,sizeof(vector *));
	for(i=0; i<16; i++) {
		p = alc_name(dot_names[i]); p->x.frame = cons_frame;
		dot_ptrs[i] = p;
	}
	set_alloc(prev);
}

/* initialize evaluation of a statement */
static void 
eval_init()
{
	if(eval_open){
		if(Initialized)
			fputs("Warning: eval initialized twice\n", stderr);
		return;
	}
if(check) {
	sanity(Unknown,"Unknown marker");
}
	eval_open = 1; On_stop->length = C_on_stop->length = C_assign->length = Restart = frame_fun->length = frame_attrs->length = 0;
	Nexpr = 0;
	Warn_list = cur_attrs = NULL_ENTRY;
	data_init(); Eval_Profile = Trace && Trace->length>0;
	eval_count=0; db_level = 0; C_wrapup = NULL;
	last_signal = 0;
	Frames->length = 0; Nframe = 1;
	set_alloc(1L);
	new_frame(blt_in_empty,S_void);
}

/* one-time at begining of run */
void 
frames_init()
{
	long prev=set_alloc(PERM_FRAME); char *tr;
	Unknown = New_vector(); Unknown->mode = UNKNOWN;
	Unknown->x.frame = cons_frame;
	blt_in_empty = alcvec(LIST,0L);
	blt_in_empty->x.frame = cons_frame;
	Frames = alcvec(LIST,0L);
	call_stack = alcvec(LIST,0L);
	ret_stack = alcvec(LIST,0L);
	ret_vals = ret_stack->value.tree-1;
	On_stop = alcvec(LIST,0L);
	frame_fun  = alcvec(LIST,0L);
	frame_attrs  = alcvec(LIST,0L);
	C_on_stop = alcvec(LIST,0L);
	C_assign = alcvec(LIST,0L); C_specials = C_assign->value.tree;
	Parent = alcvec(INT,0L);
	frame_jmp = PERMALLOC(Parent->nalloc+1, int*);
	break_stack = alcvec(INT,0L); breaks = break_stack->value.Long-1;
	next_stack = alcvec(INT,0L); nexts = next_stack->value.Long-1;
	parent_frame = Parent->value.Long-1;
	N_call_args = alcvec(INT,0L);
	set_alloc(prev);
	Nframe = 1;
	if((tr=getenv("S_TRACE")) && *tr!='n' && *tr!='N')
		Trace_all = TRUE;

}

static void 
eval_close(error)
int error;
{
	if((eval_open++)!=1){
		if(!error)Recover("Loop in closing the evaluator",NULL_ENTRY);
		eval_open = 0;
		return;
	}
	if(!error) flush_data(0);
	if(!error && Warn_list && Warn_list->length > 0)
		warn_message();
	set_frame(1L);
	eval_clear(1L); /* add_exit in quick_call, set_search, etc. */
	quick_close(); /* clear up any quick_calls in progress */
	clear_alloc(PERM_FRAME); /* make sure all frames cleared */
	Frames->length = 0;
	eval_open = 0;
}

void 
warn_message()
{
	extern int cur_interact; extern vector *Warn_list; long n;
	vector **pp, *p;
	n = Warn_list ? Warn_list->length : 0;
	if(cur_interact && n>5) {
		vector *w = Warn_list;
		Warn_list = 0; /* avoid recursive warnings! */
		fprintf(stderr,"There were %ld warnings (use warnings() to see them)\n",n);
		put_data("last.warning",*(Search_list->value.Char),w);
	} else {
		fputs("Warning messages:\n",stderr);
		n=Warn_list->length; pp = Warn_list->value.tree;
		while(n--){
			p = *pp++;
			fputs("  ",stderr);
			if(p->name) fputs(p->name,stderr);
			if(!VOID(p)){
				fputs(" in: ",stderr);
				deparse(p,stderr);
			}
			else
				fputc('\n',stderr);
		}
	}
}

static vector *
append_dir( current, which, new)
/*special version of append_el (simpler and doesn't create new vectors) */
vector *current, *new; int which;
{
	vector **i, *j,*jj, *coevec(), *copy_data();
	long n;
if(check) {
	sanity(current,"current structure in append_dir");
	if(atomic_type(current->mode))Recover("only use append_dir on lists",
		current);
}
	if(which==NOARG)which=current->length;
	n = (which>current->length ? which: current->length)+1;
	if(current->nalloc < n+1 ) {
		long oldlen = current->nalloc,nn;
		current->nalloc = n>oldlen?(n+oldlen+16):(oldlen*2);
		current->value.tree = ( vector **) S_realloc( (char *)current->value.tree,current->nalloc,oldlen,sizeof(vector *));
		nn = current->nalloc-1;
		while(nn>=current->length)
			*(current->value.tree + nn--) = S_void;
		}
	i = current->value.tree+which;
	if(!PRECIOUS(new) && PRECIOUS(current))
		set_precious(new,current->x.frame);
	j=new;
	while(which++ < n) { jj= (*i); *(i++)=j; j=jj;  } 
	current->length = n;
	return(current);
}

static void 
eval_clear(frame)
long frame;
{
	vector **exprs, *expr;
	expr = *(exprs = On_stop->value.tree+frame-1);
	if(expr && expr->length){
		*exprs = blt_in_NULL;
		Eval(expr,frame);
	}
	do_C_stop(frame); C_on_stop->value.tree[frame-1] = S_void;
}

static void
set_C_assign(name_v,new)
vector *name_v; long new;
{
	char **names, *name; long nnames, nframe = new, prev; vector *value;
	if(name_v->mode != CHAR) Recover("Internal error: invalid vector of C specials",NULL_ENTRY);
	names = name_v->value.Char; nnames = name_v->length;
	for(; nnames>0; nnames--, names++ ) {
		name = *names; value = NULL_ENTRY;
		while(nframe>0){ /* find a setting in the family tree */
			if(C_specials[nframe-1] &&
			  (value = xact_comp(Frames->value.tree[nframe-1],name))!=NULL_ENTRY)
			  break;
			if(nframe == 1)break;
			nframe = parent_frame[nframe];
		}
		if(!value)value = find_data(name,ANY,TRUE,NULL_ENTRY);
		if(!value)Recover(encs1("Can't find a value for \"%s\"",name),NULL_ENTRY);
		prev = set_alloc(nframe);
		check_assign(nframe,name,value);
		set_alloc(prev);
	}
}

/* error or break */
void 
do_stop(error)
int error;
{
	long n;
	fflush(stderr); /* put out any error message before wrapup */
	if(eval_open && db_level<2) { /* the usual case */
		flush_data(error); /*kill assignments */
		gr_signalled();	/* tell graphic devices */
		if(!VOID(error_code) && logical_value(error_code,NULL_ENTRY)) { /*options("error")*/
			vector *wrap; long nframe = Nframe;
			wrap = find_data(".Error",ANY,TRUE,Local_data);
			if(!wrap)Recover("error option turned on, but couldn't find the error expression (\".Error\")",NULL_ENTRY);
			if(wrap->mode == PARSE) wrap = wrap->value.tree[0];
 			if(quick_frame == nframe && quick_save)
 			  /* add the quick-called function to sys_frames */
 				new_frame(blt_in_empty,quick_save);
			Eval(wrap,Nframe);
 			if(quick_frame == nframe && quick_save)
 				pop_frame(S_void);
		}
		do_C_wrap();
		for(n=Frames->length; n>1;n--) {
			set_frame(n);
			if(n==Restart) {
				Frames->length = n;
				db_level=0; Restart = 0;
				longjmp(frame_jmp[n],error);
			}
			eval_clear(n); /* do S and C actions for this frame */
			clear_alloc(n);
			Frames->length = n-1;
		}
		flush_data(0); /* allow assignments in wrapup */
		eval_close(error);
	}
	else { /*  error in wrapup */
		if(db_level)fputs("Error during wrapup\n",stderr);
		else fputs("Error outside evaluator\n",stderr);
		if(db_level>2) S_terminate("Can't reset evaluation");
		if(eval_open==1) eval_close(error);
		else { /* eval_close would have done this */
			flush_data(error);
			clear_alloc(PERM_FRAME);
		}
	}
	On_stop->length = C_on_stop->length = C_assign->length = Restart = 0;
	fflush(stderr);
	errno = 0; /* clear UNIX error number */
	Frames->length = 0; Nframe = 1;
	db_level = 0;
	longjmp(S_error_jmp,error);
}

static vector *
sub_call(expr,arglist,badnames,parent)
vector *arglist, *expr, *parent; char **badnames;
{
	vector *val, **args, *arg, *sub, *copy_data() ;
	long which; int changed;
	val = copy_data(expr->mode == FLEX_CALL ? *(expr->value.tree) : expr,NULL_ENTRY);
	changed = FALSE;
	for(which=0; which < val->length; which++) {
		args = val->value.tree; arg = args[which];
		if(arg->mode == NAME && name_eq(arg->value.name,"...")) {
			changed = TRUE;
			replace_dots(val,&which,arglist);
		}
		else if((sub = substitute(arg,arglist,badnames,parent)) != arg){
			sub->name = args[which]->name;
			args[which] = sub; changed = TRUE;
		}
	}
	return( changed ? val : expr);
}

static vector *
substitute(expr,arglist,badnames,parent)
vector *arglist, *expr, *parent; char **badnames;
{
	vector *val, **args, *arg, *sub, *append_data(), *sub_call();
	long n, nargs; int changed, mode; char **bad_ptr,*bad_name;
	char *name;
	mode = expr->mode;n = expr->length;
	if(n<1)return(expr);
	switch(mode) {
	case FLEX_CALL:
	case FUN_CALL: return(sub_call(expr,arglist,badnames,parent));
	case NAME:
		name = expr->value.name;
		if(badnames){ /* check for loops */
			bad_ptr = badnames;
			while((bad_name = *bad_ptr++))
				if(name_eq(name,bad_name))
					Recover(encs1("Argument \"%s\" appeared recursively in default expr.",
					  name),expr);
		}
		nargs = arglist->length; args = arglist->value.tree+nargs-1;
		/* search in the list: from the back, so that arguments, even
		/* if evalutated, are encountered symbolically */
		while(nargs--){
			arg = *args--;
			if(name_eq(arg->name,name)) {
				if(arg->mode == ARGUMENT) {
					args = arg->value.tree;
					if(VOID(args[0]))
					  arg = substitute(args[1],arglist,badnames,parent);
					else arg = args[0];
				}
				sub = copy_data(arg,NULL_ENTRY);
				sub->name = expr->name; /* keep name= form */
				return(sub);
			}
		}
		return(expr); /* name not in arglist, no substitution */
	}
	if(NOT_RECURSIVE(mode) || !(LANGUAGE_TYPE(mode) || mode==FUN_DEF))return(expr);
/* for anything else, recursively substitute in the elements of the vector */
	val = copy_data(expr,NULL_ENTRY);
	args = val->value.tree; changed = FALSE;
	while(n--) {
		arg = *args;
		sub = substitute(arg,arglist,badnames,parent);
		if(sub!=arg){
			*args = sub; changed = TRUE;
		}
		args++;
	}
	return( changed ? val : expr);
}

static void 
replace_dots(call,which,arglist)
vector *call, *arglist; long *which;
{
	vector **children, **args, *dots; long i,n;
	dots = find_comp(arglist,"...");
	if(dots && dots->mode == ARGUMENT)
		dots = dots->value.tree[0];
	if(VOID(dots) || dots->mode != LPAR)
		Recover("Invalid substitution for \"...\"",NULL_ENTRY);
	n = dots->length-1; args = dots->value.tree+1;
	children = call->value.tree+(*which);
	if(n<1){
		i=call->length - *which;
		while(i--){*children = *(children+1); children++;}
		(call->length)--;
	}
	else *children = *args; /* replace ... with 1st arg */
	if(n>1)append_data(call,(*which)+1,n-1,(char *)(args+1));
	*which += n-1;
}

vector *
internal_symbol(Temp)
vector  *Temp;
{
	vfun_ptr f; fun_ptr get_entry(); char *name, *c_symbol();
if(check) {
	sanity(Temp,"Pointer to internal code in call");
}
	if(Temp->mode==MISSING && Temp->value.sys) return(Temp);
	if(Temp->name && *(Temp->name))name =Temp->name;
	else name = string_value(Temp);
	if(Temp->mode != MISSING) {
		Temp = New_vector();
		Temp->mode = MISSING;
		Temp->name = name;
	}
	f = (vfun_ptr) get_entry(c_symbol(name));
	if(!f)Warning(encs1("\"%s\" is not a symbol in the load table"
	  ,Temp->name),NULL_ENTRY);
	Temp->value.sys = f;
	return(Temp);
}

static void 
do_trace(expr)
vector *expr;
{
	if(!trace_call) {
		long prev = set_alloc(PERM_FRAME); vector *temp;
		trace_call = alcvec(FUN_CALL,3L);
		*(trace_call->value.tree) = alc_name(".Trace");
		trace_expr = *(trace_call->value.tree+1) = alcvec(PARSE,1L);
		temp = *(trace_call->value.tree+2) = alcvec(INT,1L);
		trace_Nframe = temp->value.Long;
		set_alloc(prev);
	}
	*(trace_expr->value.tree) = expr; /* the current expression */
	*trace_Nframe =Nframe;
}

static int 
el_fun(name)
char *name;
{
	switch(name[0]) {
	case '[':
		switch(name[1]) {
		case '\0':  return(SUBSET_FUN);
		case '[': if(!name[2]) return(ELEMENT_FUN);
		}
		return(0);
	case '$':
		return( name[1] ? 0 : DOLLAR_FUN );
	case 'a':
		return(!strcmp(name,"attr") || !strcmp(name,"attribute"))?
			ATTR_FUN:(!strcmp(name,"attributes")?ALL_ATTR_FUN:0);
	case 'm':
		return( (!strcmp(name,"mode"))?MODE_FUN:0);
	case 'l':
		return( (!strcmp(name,"length"))?LENGTH_FUN:
			((!strcmp(name,"levels"))?LEVELS_FUN:0));
	case 'n':
		return((!strcmp(name,"names"))?NAMES_FUN:0);
	case 'd':
		return((!strcmp(name,"dim"))?DIM_FUN:
			((!strcmp(name,"dimnames"))?DIMNAMES_FUN:0));
	case 't':
		return((!strcmp(name,"tsp"))?TSP_FUN:0);
	case 's':
		return(!strcmp(name,"storage.mode")?STORAGE_FUN:0);
	default:
		return(0);
	}
}

vector *
S_assign(ent,arglist)
vector *ent, *arglist;
{
	vector **args = arglist->value.tree; char *name; int explicit;
	vector *frame, *set_data(), *value; long n; extern long cur_frame;
	extern vector *S_data, *Local_data, *Frames;
	name = string_value(args[0]);
	if(IS_NULL_STRING(name)) Recover("Empty object name",ent);
	value = New_vector(); 
	n = (explicit=arglist->length>2) ? long_value(args[2],ent) : parent_frame[cur_frame];
	if(!explicit) {
		frame = (n == 1) ? S_data : Frames->value.tree[n-1];
		*value = *set_data(frame,args[1],name);
		if(n == 1)perm_assign(name,args[1]);
	}
	else if(n==0){ frame0_assign(name,args[1]); *value = *args[1];}
	else {
		if(n<1 || n>cur_frame)Recover(
		  enci1("Frame %ld for assignment doesn't exist",n),ent);
		frame = Frames->value.tree[n-1];
		*value = *set_data(frame,args[1],name);
	}
	return(S_void);	
}

char *
cur_fun_name(nframe)
long nframe;
{
	vector *temp; char *name;
	if(quick_name && *quick_name && quick_frame==Nframe)
		return(quick_name);
	if(nframe<1 || (temp = (*(call_stack->value.tree+nframe-1)))->mode!=FUN_CALL)return(NULL);
	temp = *(temp->value.tree);
	switch(temp->mode) {
	case NAME: name = temp->value.name; break;
	case CHAR: name = *(temp->value.Char); break;
	default: return(NULL);
	}
	if(name_eq(name,"stop"))name = cur_fun_name(parent_frame[nframe]);
	return(name);
}

vector *
parent_data(gen)
long gen;
{
	long n;
	for(n=Nframe;gen>0 && n>1;n=parent_frame[n],gen--);
	return(Frames->value.tree[n-1]);
}

static vector *
fix_mode(ent)
vector *ent;
{
	int mode = ent->mode; vector *value;
	switch(mode) {
	case LPAR: 
		switch((int) ent->length) {
		case 0: case 1: return(S_void);
		case 2: return(ent->value.tree[1]);
		}
		Warning("Old-fashioned parenthesized list, treated as c(...)",ent);
		value = copy_data(ent,NULL_ENTRY); value->mode = FUN_CALL;
		value->value.tree[0] = alc_name("c");
		return(value);
	case LBRACK:
	case DOUBLE_LBRACK:
	case DOLLAR:
		value = copy_data(ent,NULL_ENTRY); value->mode = FUN_CALL;
		return(value);
	default:
		Recover(encs1("Objects of mode \"%s\" should not be given to evaluator",token_name(mode)),NULL_ENTRY);
	}
#ifdef lint
	return(S_void);
#endif
}

static vector *
cons_value(p)
vector *p;
{
	char *name;
	if(!p)return(NULL);
	if(p->mode==NAME) {
		name = p->value.name;
		switch(*name) {
		case 'T': return((!name[1] || name_eq(name,"TRUE"))?blt_in_TRUE:NULL);
		case 'F': return((!name[1] || name_eq(name,"FALSE"))?blt_in_FALSE:NULL);
		case 'N': if(name_eq(name,"NA"))return(blt_in_NA);
			if(name_eq(name,"NULL"))return(blt_in_NULL);
		}
	}
	else if(!LANGUAGE_TYPE(p->mode))return(p);
	return(NULL);
}

vector *
S_bind(ent,arglist)
vector *ent,*arglist;
{
	vector *arg, *body, *new;
	if(ent->length<1)return(S_void);
	new = alcvec(COMPILED,2L);
	arg = arglist->value.tree[0];
	if(arg->mode == FUN_DEF) {
		vector *bb;
		bb = arg->value.tree[arg->length-1];
		body = do_bind(copy_data(bb,NULL_ENTRY),(char **)NULL,NULL_ENTRY);
		arg->value.tree[arg->length-1] = new;
		new->value.tree[0] = body; new->value.tree[1] = bb;
	} else {
		body = do_bind(copy_data(arg,NULL_ENTRY),(char **)NULL,NULL_ENTRY);
		new->value.tree[0] = body; new->value.tree[1] = arg;
	}
	return(arg);
}

static vector *
do_bind(expr,cname_in, frame)
vector *expr, *frame; char **cname_in;
{
	vector *internal_symbol(), **children; long n;
	int mode;
	mode = expr->mode;
	if(NOT_RECURSIVE(mode) || !LANGUAGE_TYPE(mode))
		return(expr);
	children = expr->value.tree;
	switch(mode){
	case FUN_CALL:
		expr = bind_call(expr,cname_in,frame);
		break;
	case INTERNAL:
		children[1] = internal_symbol(children[1]);
		break;
	case IF: case LBRACE: case FLEX_CALL:
		for(n = expr->length; n>0; n--, children++)
			*children = do_bind(*children,cname_in,frame);
		break;
	case FOR:
		children[1] = do_bind(children[1],cname_in,frame);
		children[2] = do_bind(children[2],cname_in,frame);
		break;
	case WHILE:
		children[0] = do_bind(children[0],cname_in,frame);
		children[1] = do_bind(children[1],cname_in,frame);
		break;
	case REPEAT:
		children[0] = do_bind(children[0],cname_in,frame);
		break;
	case LARROW: case DBLEARROW:
		children[1] = do_bind(children[1],cname_in,frame);
		break;
	case ARGUMENT:
		children[0] = do_bind(children[0],cname_in,frame);
		children[1] = do_bind(children[1],cname_in,frame);
		break;
	case COMMENT_EXPR:
		expr = do_bind(comment_out(expr),cname_in,frame);
		break;
	/* others, including FRAME, do nothing */
	}
	return(expr);
}

static char *bind_funs[] = { "missing", "nargs", NULL };

static vector *
bind_call(expr,cname_in,parent)
vector  *expr, *parent; char **cname_in;
{
	vector **children, *child, *val; long n;
	char *cnames[21], **cc; int nc;
	if(!cname_in) { nc = 0; }
	else for(cc = cname_in, nc = 0; nc<20 && *cc; nc++, cc++)
		cnames[nc] = *cc;
	child = expr->value.tree[0];
	if(child->mode == NAME) {
		char **nn, *name; int n;
		name = child->value.name;
		child = get_data(name,FUN_DEF);
		if(!child || child->mode!=FUN_DEF) return(expr);
		/* check for bind-time evalutation */
		for(nn = bind_funs; *nn && !name_eq(name,*nn); nn++){}
		if(*nn && parent) { /* evaluate, bind the result */
			new_frame(parent,S_void);
			expr = Eval(expr,Nframe);
			expr = pop_frame(expr);
			return(do_bind(expr,cnames,parent));
		}
		/* check for recursive call */
		for(nn = cnames, n = nc;n>0;nn++, n--)if(name_eq(*nn,name))
			return(expr);
		cnames[nc++] = name; cnames[nc] = NULL;
	}
	else { /* evaluation needed to determine function called */
		vector **to;
		val = alcvec(FUN_CALL,expr->length);
		for(n=expr->length-1,to = val->value.tree,children = expr->value.tree;
		  n>0;n--,children++,to++)
			*to = do_bind(*children,cnames,parent);
		return(val);
	}
	child = copy_data(child,NULL_ENTRY); /* copy of definition */
	val = alcvec(FRAME,3L);
	children = val->value.tree;
	children[0] = child->value.tree[child->length-1];
	children[1] = fun_args(child,expr,NULL_ENTRY); /* the new frame */
	children[2] = expr;
	if(nc<20) { /* bind recursively, args, body */
		vector **args;
		child = children[1]; args = child->value.tree;
		for(n = 0; n<child->length; n++)
			args[n] = do_bind(args[n],cnames,parent);
		children[0] = do_bind(children[0],cnames,child);
		if(expd_ok(children[0])) {
			child = substitute(children[0],children[1],(char **)NULL,S_void);
			if(expd_ok(child))val = simplify(child); /* still ok */
		}
	}
	return(val);
}

static int 
expd_ok(expr)
vector *expr;
{
	int mode, ok; long n; vector **children;
	mode = expr->mode;
	if(NOT_RECURSIVE(mode) || !LANGUAGE_TYPE(mode))
		return(TRUE);
	children = expr->value.tree;
	switch(mode){
	case FUN_CALL:
		return(FALSE);
	case INTERNAL:
		return(intern_in_l(children[1]->name)&1);
	case LARROW:
	case DBLEARROW:
	case FOR:
	case WHILE:
	case REPEAT:
		return(FALSE);
	case ARGUMENT:
		return(expd_ok(VOID(children[0]) ? children[1] : children[0]));
	case LBRACE:
		if(expr->length > 3)return(FALSE); /* a heuristic that says
			that long braced expressions are probably as fast
			or faster done in a frame */
		/* otherwise, it depends on the elements */
	default:
		for(ok = TRUE, n = expr->length; n>0; n--, children++)
			ok &= expd_ok(*children);
		return(ok);
	}
}

vector *
comment_out(ent)
vector *ent;
{
	long n; vector **children;
	for(n = ent->length, children = ent->value.tree;n>0; n--,children++)
		if((*children)->mode != COMMENT)return(*children);
	return(S_void);
}

static vector *
simplify(expr)
vector *expr;
{
	int mode; long n; vector *temp, **children;
	mode = expr->mode;
	if(NOT_RECURSIVE(mode) || !LANGUAGE_TYPE(mode))
		return(expr);
	children = expr->value.tree;
	switch(mode ){
	case INTERNAL: {
		vector **args; long amode;
		if(!intern_in_l(children[1]->name)&2)return(expr);
		temp = children[0];
		for(n = temp->length-1, args = temp->value.tree+1; n>0;
		  n--, args++) {
			amode = (*args)->mode;
			if(LANGUAGE_TYPE(amode))return(expr);
		}
		return(Eval(expr,1L));
		}
	case IF:
		temp = simplify(children[0]);
		if(LANGUAGE_TYPE(temp->mode))return(expr);
		if(e_logical_value(temp,NULL_ENTRY))return(simplify(children[1]));
		else if(expr->length>2) return(simplify(children[2]));
		else return(blt_in_NULL);
	case LBRACE:
		if(expr->length ==1)return(simplify(children[0]));
	default:
		return(expr);
	}
	
}

static long 
which_trace(name)
char *name;
{
	long i, n; vector **p; char *pname;
	for(n=Trace->length, i=1, p = Trace->value.tree; n>0; n--,i++,p++){
		pname = (*p)->name;
		if(!pname || !*pname || name_eq(name,pname))return(i);
	}
	return(0);
}

vector *
S_trace(ent,arglist)
vector *ent, *arglist;
{
	vector **args, *trace, *tracer, *call; long prev,n; int which;
	char *what, *trace_name;
/* must arrange for Trace to get refreshed when frame 0 is compacted */
	if(!Trace) Trace = set_data(frame0,alcvec(LIST,0L),".Trace");
	which = sys_index;
	args = arglist->value.tree;
	switch(which) {
	case 0: /* trace(fun,tracer) */
		what = string_value(args[0]);
		n = which_trace(what);
		if(n>0) {
			trace = Trace->value.tree[n-1];
			call = trace->value.tree[2];
		}
		else {
			trace = alcvec(FRAME,3L); trace->name = what;
			call = trace->value.tree[2] = alcvec(FUN_CALL,2L);
			call->value.tree[1] = alcvec(ARGUMENT,2L);
		}
		tracer = args[1];
		switch(tracer->mode) {
		case CHAR:
			trace_name = string_value(tracer);
			tracer = get_data(trace_name,FUN_DEF);
			if(!tracer) Recover(encs1(
			  "The tracer function \"%s\" must exist",trace_name),
			  NULL_ENTRY);
			call->value.tree[0] = alc_name(trace_name);
			break;
		case FUN_DEF:
			tracer = copy_data(tracer,cons_frame);
			call->value.tree[0] =
			 (ent->value.tree[2])->mode == NAME ?
				copy_data(ent->value.tree[2],cons_frame) :
				tracer ;
			break;
		default:
			Recover("tracer should be a function or the name of a function",NULL_ENTRY);
		}
		trace->value.tree[1] = fun_args(tracer,call,NULL_ENTRY);			trace->value.tree[0] = tracer->value.tree[tracer->length-1];
		prev = set_alloc(FRAME0);
		trace = copy_data(trace,cons_frame);
		if(n<1) {
			append_dir(Trace,NOARG,trace);
		}
		else Trace->value.tree[n-1] = trace;
		set_alloc(prev);
		Eval_Profile = TRUE;
		break;
	case 1: /* untrace(fun) */
		if(arglist->length ==0) { /* untrace all */
			Trace->length = 0;
			break;
		}
		what = string_value(args[0]);
		n = which_trace(what);
		if(n<1)Warning(encs1("No trace currently on for \"%s\"",what),NULL_ENTRY);
		del_comp(Trace,n);
		if(Trace->length == 0)Eval_Profile = FALSE;
		break;
	case 2: /* sys.trace() */
		return(Trace);
	}
	return(S_void);
}

static vector *
check_trace(call,frame,def)
vector *call, *frame, *def;
{
	vector *trace_call, *new, *val, **children; char *name; long n,prev;
	trace_call = call->value.tree[0];
	if(db_level)return(NULL); /* no tracing in error handling */
	if(trace_call->mode != NAME) return(NULL);
	name = trace_call->value.name;
	n = which_trace(name);
	if(!n)return(NULL);
	prev = set_alloc(parent_frame[Nframe]);
	new = alcvec(FRAME,3L);
	children = new->value.tree;
	children[0] = def->value.tree[def->length-1];
	children[1] = frame;
	children[2] = call;
	val = copy_data(Trace->value.tree[n-1],NULL_ENTRY);
if(check) {
	if(VOID(val) || val->mode != FRAME || val->length<3)
		Recover(encs1("Invalid tracer element for \"%s\"",name),NULL_ENTRY);
}
	frame = val->value.tree[1];
	call = frame->value.tree[0]; /* the argument to tracer */
	if(call->mode == ARGUMENT)
		call->value.tree[0] = new;
	else {
		new->name = call->name;
		frame->value.tree[0] = new;
	}
	set_alloc(prev);
	return(val);
}

/*
 * internal entries NOT on the no_quick list are asserted:
 *	1. to evaluate their arguments
 *	2. NOT to assume they have their own frame; and
 *	3. to have the same calling sequence in the .Internal as in the
 * 	   definition of the function.
 * IF ANY OF THESE ARE VIOLATED, THE quick_call MAY FAIL
 */
static vfun_ptr no_quick[] = {S_debug, S_dummy, NULL};
static vfun_ptr safe[] = {S_assign, As_vector, Is_vector, S_extract, do_op, do_math, do_summary, S_dtype, S_list, S_unlist, S_unprotect, NULL};
/* stucture for hash tables */
typedef struct s_intern_method {
	vfun_ptr what;
	char *group;
	int type;
} intern_method;

extern vector *S_menu(), *S_colon(), *S_match();
static intern_method in_methods[] = {
{S_extract,"Extract",1},
{S_replace,"Replace",1},
{do_math,"Math",1},
{do_summary,"Summary",1	},
{do_op,"Ops",2},
{As_vector,"As",1},
{Is_vector,"Is",1},
{S_deparse,NULL_STRING,1},
{S_menu,NULL_STRING,1},
{S_colon,NULL_STRING,2},
{S_match,NULL_STRING,2},
{(vfun_ptr)0L, NULL_STRING,0}
};


static vector *
quick_call(call, def, body, fname)
vector *call, *def, *body;
char *fname;
{
	long na, n, i, ia, len;
	int m, unsafe;
	vector **actuals, **formals, *arglist=blt_in_empty, *a, *f, **v, *t1, *t;
	vfun_ptr this_fun,*p;
	char *name;

	if(Eval_Profile && Trace->length && (!fname  || which_trace(fname)))
		return(NULL_ENTRY); /* no quick_call on traced functions */
	na = call->length-1; n = def->length-1;
	/*
	 * Internal code S_switch and S_method always use quick_call.
	 * Otherwise, a quick call is possible only if:
	 *	1. the .Internal evaluates its args
	 *	2. it is not one of a known list that make use of their frame
	 *	3. the call is simple, so amatch isn't needed.
	 */
	actuals = body->value.tree;
	this_fun = internal_symbol(actuals[1])->value.sys;
	if(!this_fun)
		return(NULL_ENTRY);
	else if(this_fun == S_switch || this_fun == S_method)goto do_it;
	for(p = no_quick; *p; p++)
		if(this_fun == *p)
			return(NULL_ENTRY);
	formals = def->value.tree;
	actuals = call->value.tree+1;
	if(n != 1)
		for(ia = 0; ia < na; ia++)
			if((name = (actuals[ia])->name) && *name)
				return(NULL_ENTRY);
	arglist = alcvec(LIST, na+n);
	v = arglist->value.tree;
	len = 0;
	unsafe = TRUE;
	for(p = safe; *p; p++)
		if(this_fun == *p) {
			unsafe = FALSE;
			break;
		}
	/* NOTE: all the copying of PRECIOUS below shouldn't be needed, if the
	/* .Internals all behaved properly & protected their arguments  */
	MEANINGFUL(t);
#define SAFE(p) (unsafe ? copy_data(p,NULL_ENTRY) : (t = New_vector(), *t = *p, t))
/*
#define SAFE(p) copy_data(p,NULL_ENTRY)
*/
	for(i = ia = 0; i < n ;i++) { /* arg. matching */
		f = formals[i];
		name = f->name;
		if(name && *name == '.' && name_eq(name, "...")) /* eat actuals */
			while(ia < na)
				v[len++] = actuals[ia++];
		else if(ia<na)
			v[len++] = actuals[ia++];
		else {
			if(a=cons_value(f))
		 		v[len++] = (PRECIOUS(a)) ? SAFE(a) : a;
		 	else
				return(NULL_ENTRY); /* no non-constant defaults */
		}
	}
	if(!fname) fname = string_value(call->value.tree[0]);
	for(ia=0;ia<na ;ia++) { /* arg. evaluation */
		a = v[ia]; m = a->mode;
		if(LANGUAGE_TYPE(m)){
			t1 = Eval(a,Nframe);
			if (PRECIOUS(t1)) t1= SAFE(t1);
			t1->name = a->name; a = t1;
		}
		else if(PRECIOUS(a)){ t1 = SAFE(a); t1->name = a->name; a=t1;}
		v[ia] = a;
	}
	arglist->length = len;
	if(len>0 && v[0]->mode == STRUCTURE ||( len > 1 && v[1]->mode == STRUCTURE))
	/* possibly an internal method */
		if((f=do_intern_method(call, arglist,this_fun, def,fname))!=NULL_ENTRY) return(f);
 do_it:	sys_index = body->length > 3 ? long_value(body->value.tree[3],call) : 0;
	quick_name = fname; quick_save = call; quick_frame = Nframe;
	quick_fun = def;
	f = (*this_fun) (call, arglist);
if(check){
	if((name=sanity(f,NULL_STRING))!=NULL_STRING)
		 Recover(encs1("Bad value returned by internal code: %s",name),call);
}
	quick_close();
	return(f);
}

static void 
quick_close()
{
	quick_name = NULL_STRING; quick_save = NULL; quick_frame = 0;
}

static vector *
get_perm(name)
char *name;
{
	vector *p; extern vector *read_data();
	if( (p = xact_comp(S_data,name)) != NULL_ENTRY)return(p);
	if( (p = read_data(name,ANY,TRUE,1)) != NULL_ENTRY)return(p);
	return(alcvec(NULL,0L));
}

static vector *
find_fun(name)
char *name;
{
	vector **p, *a; long i;
	for(i = 0, p = Local_data->value.tree; i<Local_data->length; i++, p++) {
		a = *p;
		if(!name_eq(name,a->name))continue;
		if(a->mode == FUN_DEF)return(a);
		if(a->mode == ARGUMENT &&
			  Local_data->length-i <= CURRENT_NARGS) {
			a = Eval(a,Nframe);
			return(a);
		}
		else if(a->mode == STRUCTURE && Data_mode(a)==FUN_DEF)
			return(a);
		else {
			Warning(encs1("looking for function \"%s\", ignored local non-function",name),NULL_ENTRY);
			break;
		}
	}
	/* look for the object, but not locally, since that already failed*/
	return( find_data(name, FUN_DEF, TRUE,NULL_ENTRY));
}

static vector *save_err_opt;
static void 
rest_err_opt()
{
	error_code = save_err_opt;
}

vector *
Default_pgm(ent, arglist)
vector *ent, *arglist;
{
/* this code simulates the following:
/*{
/*	assign(".Last.expr", parse(), frame = 1)
/*	assign(".Auto.print", T, frame = 1)
/*	switch(mode(.Last.expr[[1]]),
/*		"<-" = ,
/*		"<<-" = eval(.Last.expr, 0),
/*		{
/*			assign(".Last.value", eval(.Last.expr, 0), frame = 1)
/*			if(.Auto.print)
/*				print(.Last.value)
/*			.Last.value
/*		}
/*		)
/*}
/* with the exceptions that: 1) No new frames are created; 2)printing does 
/* NOT take place after `for', `repeat', `while' or QUIT
*/
	static vector *parse_args[5], *parse_call, *parse_arg, *print_call;
	static int init = FALSE;
	int prev, print; vector *p, *value; extern vector *S_parse();
	long mode;
	UNUSED(ent); UNUSED(arglist);

	if(!init) {
		prev = set_alloc(PERM_FRAME);
		parse_call = alcf("parse",NULL_ENTRY);
		parse_arg = alcvec(LIST,5L);
		parse_arg->value.tree = parse_args;
		parse_args[0] = alcvec(CHAR,0L);
		parse_args[1] = parse_args[2] = parse_args[3] = blt_in_NULL;
		parse_args[4] = blt_in_FALSE;
		print_call = alcf("print",alc_name(".Last.value"));
		set_precious(print_call,cons_frame);
		set_alloc((long)prev);
		init = TRUE;
	}
	p = S_parse(parse_call,parse_arg);
	p = set_data(Frames->value.tree[0],p,".Last.expr");
	set_data(Frames->value.tree[0],blt_in_TRUE,".Auto.print");
	if(p->length == 1) value = p->value.tree[0];
	else {
		value = New_vector();
		*value = *p;
		value->mode = LBRACE;
	}
	mode = value->mode;
	if(mode==COMMENT_EXPR) {
		long n = value->length; vector **p = value->value.tree;
		for(;n>0; n--, p++)if((*p)->mode!=COMMENT){value = *p; mode = value->mode; break;}
	}
	value = Eval(value,Nframe);
	switch((int)mode) {
	case LARROW: case DBLEARROW:
	case FOR: case REPEAT: case WHILE: case QUIT:
	case COMMENT_EXPR: case COMMENT: /* shouldn't happen, but... */
		break;
	default:
		set_data(S_data,value,".Last.value");
		if(value->mode==MISSING)break;
		p = get_data(".Auto.print",ANY);
		print = p ? logical_value(p,NULL_ENTRY): FALSE;
		if(print) {
			save_err_opt = error_code;
			add_exit((fun_ptr)rest_err_opt,Nframe);
			error_code = blt_in_FALSE;
			Eval(print_call,Nframe);
			error_code = save_err_opt;
		}
	}
	return(value);
}

vector *
S_method(ent, arglist)
vector *ent, *arglist;
{
	vector *obj, **args, *p, *method; extern vector *get_next_method();
	long which = sys_index, n; char *name;
	switch(which) {
	case 0: /* UseMethod() */
		if( Nargs(ent)>0){
			p = coevec(Eval(Arg1(ent),Nframe),CHAR,TRUE,CHECK_IT);
			set_data(Local_data,p,".Generic");
		}
		obj = Nargs(ent)>1 ? Eval(Arg2(ent),Nframe) : get_arg1();
		method = get_intern_method(obj);
		if(!method)return(blt_in_NULL);
		p = Eval(method, Nframe);
		if(RETURNED(Nframe))p = ret_vals[Nframe];
		else ret_vals[Nframe] = p;
		return(p);
	case 1: /* NextMethod() */
		obj = Nargs(ent)>1 ? Eval(Arg2(ent),Nframe) : NULL_ENTRY;
		quick_save = NULL_ENTRY; quick_fun = blt_in_NULL; /* signal to quick_args */
		method = get_next_method(obj,call_stack->value.tree[Nframe-1]);
	/* either a method  or the body of the generic function*/
		return(Eval(method, Nframe));
	case 2: /* Method() */
		return(method ? method : blt_in_NULL);
	}
}

vector *
S_switch(ent, arglist)
vector *ent, *arglist;
{
	vector *Temp, *deflt, **children, *val; char *name;
	int by_name,found; long n;
	UNUSED(arglist);

	Temp = coevec(Eval(Arg1(ent),Nframe),ANY,TRUE,CHECK_IT);
	if(Temp->length>1)Warning(enci1("switch value has %ld elements: only the first used",Temp->length),NULL_ENTRY);
	else if(Temp->length<1)Recover("Length of switch value is 0",NULL_ENTRY);
	MEANINGFUL(name);
	switch(Temp->mode) {
	case DOUBLE: case INT: case REAL: case LGL: case COMPLEX:
		n = long_value(Temp,ent); by_name = FALSE; break;
	default:
		MEANINGFUL(n);
		name = string_value(Temp); by_name = TRUE;
	}
	if(by_name)
		if(name==NULL_STRING || *name == '\0')return(S_void);
		else {
			n=ent->length-2; children=ent->value.tree+2;
			found=FALSE; deflt = NULL_ENTRY;
	/* if the name is matched, evaluate the first non-missing argument
	 * that follows: switch(a=,b=,c=foo(...),)
	 * if no match by name, the first unnamed argument, if any, is used
	 */
			while(n--){
				Temp = *children++;
				if(!found) {
					if( deflt==NULL_ENTRY &&
					  IS_NULL_STRING(Temp->name))
						deflt = Temp;
					found=name_eq(Temp->name,name);
				}
				if(found && Temp->mode!=MISSING){
					deflt = Temp; break;
				}
			}
			if(deflt==NULL_ENTRY)return(blt_in_NULL);
			else
				return(Eval(deflt,Nframe));
		}
	else if(n<0 || n>ent->length-2)return(blt_in_NULL);
	else if(n==0) {
		val = ent->value.tree[ent->length -1];
		if(val->name && *val->name == 'd') 
			return(Eval(val,Nframe));
		else return(blt_in_NULL);
	}
	else
		return(Eval((*(ent->value.tree+n+1)),Nframe));
}

vector *
quick_args(arglist, group)
vector *arglist; char *group;
/* create an evaluation frame, typically when quick_call did not */
/* called from class_call (thence from class_op and class_fun) to do methods */
/* for .Intenals's */
{
	vector *f,*fun, *new, **vals, **args, *p, **formals;
	long i,j,n,m,ndots; char *an;
/* This routine is called from a routine that has found a method in response        */
/* to a call, from quick_call, do_replace, put_data, or case INTERNAL  in Eval().   */
/* quick_args is responsible for returning a suitable frame in which                */
/* the body of the method can be evaluated.  It either makes one or uses cur. frame */	
	if(quick_save) { /* do the argument match */
		f = fun_args(quick_fun, quick_save, NULL_ENTRY);
		m = f->length; n = Nargs(quick_save);
		formals = quick_fun->value.tree;
	}
	else if(quick_fun == blt_in_empty) { /* do_intern_method set this up */
/* came from case INTERNAL in Eval(): use the current frame */
		f = Frames->value.tree[Nframe-1];
		if(p = xact_comp(f,"...")) fix_dotnum(f,p); /* set all the ..<n> objs */
		return(f);
	}
	else if(quick_fun == blt_in_NULL) { /* NextMethod set this up */
		f = xact_comp(Local_data,".Generic");
		if(!f) Recover("called from outside a method (no \".Generic\" in frame)",NULL_ENTRY);
		f = find_fun(string_value(f)); n = f->length-1;
		formals = (f)->value.tree;
		new = alcvec(LIST, n + 4); args = new->value.tree;
		new->length =  n = f->length-1; /* drop the body */
		for(i=0; i<n; i++, formals++, args++) {
			p = xact_comp(Local_data, (*formals)->name);
			if(!p) PROBLEM "can't find object \"%s\" for NextMethod",
				(*formals)->name RECOVER(NULL_ENTRY);
			if(p->mode == ARGUMENT && (p->value.tree[0])->mode!=MISSING) {
			/* an unevaluated arg. that isn't missing */
				an = (*formals)->name;
				p = alcvec(ARGUMENT,2); p->name = an;
				*(p->value.tree) = alc_name(an);
			}
			*args = p;
		}
	/* should check (?) that this frame will treat the current frame as
	/* non-local when being evaluated to avoid overwriting */
		return(new);
	}
	else { /* make up some names */
		f = generic_fun(); (f->length)--; /* drop the body */
		formals = (f)->value.tree;
		m=0; n = arglist->length;
		if(!f->length) n = 0;
	}		
	new = alcvec(LIST,n + m+4); /* allows room for .Class, etc. */
	vals = new->value.tree; args = arglist->value.tree;
	for(i =j = ndots = 0;  i<n; i++) {
/* make a frame, with the actual args, named */
		p = New_vector(); *p = *args[i];
		an = (*formals)->name;
		if(*an == '.' && name_eq(an,"...")) {
			an = DOT_NAME(j);
			j++; ndots++;
		}
		else formals++;
		p->name = an; vals[i] = p;
	}
	if(!quick_save && ndots && n) { /* formal arguments after the ...  */
		formals = f->value.tree;
		for(j = f->length - 1; j>=0; j--) {
			an = formals[j]->name;
			if(name_eq(an,"..."))break;
			vals[j]->name = an;
		}
	}
	formals = f->value.tree;
	for(i = 0; i < m; i++) {
/* add on any default args & non-simple arguments for substitution */
		p = formals[i];
		if(p->mode == ARGUMENT) vals[n++] = p;
	}
	new->length = n;
	return(new);
}

static vector *
generic_fun()
{
	vector *f; long n; char *an;
	f = coevec(frame_fun->value.tree[Nframe-1],ANY,FALSE,FALSE);
	if(f->length) return(f);
/* no frame_fun: better be inside a method */
	f = get_local(".Generic",1);
	if(f) {
		an = string_value(f);
		if(an && (f = find_fun(an))) f = coevec(f,ANY,FALSE,FALSE);
	}
	if(!f || !f->length)
		PROBLEM "Can't find generic function \"%s\"", an
		RECOVER(NULL_ENTRY);
	return(f);
}

static vector *
get_intern_method(object)
vector *object;
{
	vector *p, *class, *class_method(), *call; char *fname;
	class = xact_comp(Local_data,".Class");
	if(!class && (object->mode != STRUCTURE || 
		!( class = xact_comp(object,"class")))) return(NULL_ENTRY);
	p = xact_comp(Local_data,".Generic");
	if(!object) {
		if(!p)return(NULL_ENTRY);
		fname = string_value(p);
		call = find_fun(fname);
		if(!call)Recover("couldn't find generic function",call);
		fname = (call->value.tree[0])->name;
		object = xact_comp(Local_data,fname);
		if(!object)PROBLEM "Sucallosed to use object \"%s\" but it's not in the frame", fname
			RECOVER(NULL_ENTRY);
	}
	call = call_stack->value.tree[Nframe-1];
	if(!p) p = call->value.tree[0];
	fname = string_value(p);
	return( class_method(object, fname, class, call, Local_data,0L));
}

static vector *
get_arg1()
{
	vector *p; char *name;
	p = generic_fun();
	name = (p->value.tree[0])->name;
	p = xact_comp(Local_data,name);
	if(!p)PROBLEM "Can't find a local object (\"%s\")", name
		RECOVER(NULL_ENTRY);
	if(p->mode == ARGUMENT)p = Eval(p,Nframe);
	return(p);
}


static vector *
do_intern_method(call, arglist,this_fun,def,fname)
vector *call, *arglist, *def; vfun_ptr this_fun; char *fname;
{
	intern_method *p; vector *f, **args; long n;
/* are there any arg's with attributes ? */
	for(n = arglist->length, args = arglist->value.tree; n>0; n--, args++)
		if((*args)->mode == STRUCTURE)break;
	if(!n)return(NULL_ENTRY);
/* if this is a .Internal recognizing methods, get the method expr'n if any */
	for(p = in_methods;p && p->what; p++) {
		if(this_fun != p->what)continue;
		if(def) { quick_save = call; quick_fun = def;} /* signal quick_arg */
		else {quick_save = NULL_ENTRY; quick_fun = blt_in_empty;}
		if(!fname) fname = string_value(call->value.tree[0]);
		if(p->type== 2 && arglist->length > 1 &&
		  (f = class_op(p->group,fname,call,arglist)))
			return(Eval(f,Nframe));
		else if(p->type > 0 &&
		  (f = class_fun(p->group,fname,call,arglist)))
			return(Eval(f,Nframe));
		else break;
	}
	return(NULL_ENTRY);
}

static vector *
miss_dot(name, frame)
char *name; vector *frame;
{
/* TRUE if name is of the form ".." followed by number, and "..." is in the frame */
	int c; char *nm = name; vector *dots, **els; long n, ndots;
	if(*nm++ == '.' && *nm++ == '.') while(c = *nm++) {
		if(c<'0' || c>'9')return(NULL_ENTRY);
	}
	else return(NULL_ENTRY);
	if(!(dots=xact_comp(frame,"...")))return(NULL_ENTRY);
	if(data_mode(dots)==ARGUMENT) dots = coevec(dots->value.tree[0],ANY,FALSE,FALSE);
	els = dots->value.tree; ndots = dots->length;
	if(dots->mode == LPAR || dots->mode == FUN_CALL){ els++; ndots--;}
	n = -1; sscanf(name,"..%ld",&n);
	if(n<0)return(NULL_ENTRY);
	if(n<1 || n > ndots)return(blt_in_TRUE);
	dots = els[n-1];
	return( VOID(dots) ? blt_in_TRUE : blt_in_FALSE);
}

static void
fix_dotnum(frame, dots)
vector *frame, *dots;
{
	vector **args, *arg; long n, i;
	if(dots->mode==ARGUMENT)dots = dots->value.tree[0];
	args = dots->value.tree; n = dots->length;
	if(dots->mode == LPAR || dots->mode == FUN_CALL) /* the usual case */
		{args++; n--;}
	else if(NOT_RECURSIVE(dots->mode))return;
	for(i = 0; i < n; i++) {
		arg = args[i];
		if(VOID(arg) || xact_comp(frame,DOT_NAME(i)))continue;
		set_data(frame, arg, DOT_NAME(i));
	}
}

static vector *
make_frame_attrs(fun)
vector *fun;
{
	vector *p, *pp; long i;
	if(fun->mode != STRUCTURE)return(Frames->value.tree[Nframe-1]);
	p = alcvec(STRUCTURE,fun->length);
	MEMCPY(p->value.tree, fun->value.tree,fun->length);
	i = x_which_comp(".Data",p);
	if(i){
		pp = p->value.tree[i-1] = New_vector();
		*pp = *(Frames->value.tree[Nframe-1]);
		pp->name = ".Data";
	}
	set_precious(p,Local_data);
	return(p);
}
