#include <usercore.h>
#include <sunwindow/window_hs.h>
#include <sunwindow/cms.h>
#include <stdio.h>
#include <fcntl.h>
#include "S.h"
#include "device.h"

#define am(i)		F77_COM(bgrp)[(i)-1]
#define curam(i)	current_am[(i)-1]
#define FOREVER		2147483647
#define SET		0
#define GET		1

/* hook definitions */
#define SET_COLOR_TABLE 1
#define GET_COLOR_TABLE 2
#define PUT_RASTER 3
#define GET_RASTER 4
#define GET_RECT 5
#define SUNCOLOR -101
#define SUNBW -100

	/* The color map used by this driver.   We keep it as unsigned
	 * chars in case we have to mess with pixwin stuff
	 */

#define CMAPSIZE	32
unsigned char mapred[CMAPSIZE] = {
	255, 	0,	255, 	0, 	0, 	255, 	0, 	255,
	0, 	128,	128, 	0, 	0, 	128, 	0, 	128,
	175,	255,	255, 	128,	128,	255, 	128,	255,
	192,	64,	128,	255,	0,	0,	255,	0
	};
unsigned char mapgreen[CMAPSIZE] = {
	255, 	0,	0, 	255,	0, 	255,	255,	0, 
	0, 	128,	0, 	128,	0, 	128,	128,	0, 
	175,	255,	128,	255,	128,	255,	255,	128,
	64,	0,	0,	0,	255,	0,	255,	0
	};
unsigned char mapblue[CMAPSIZE] = {
	255, 	0,	0, 	0, 	255,	0, 	255,	255,
	0, 	128,	0, 	0, 	128,	0, 	128,	128,
	175,	255,	128,	128,	255,	128,	255,	255,
	0,	76,	178,	0,	0,	255,	255,	0
	};
static struct colormapseg default_cseg = { 32, 0, "S color map"};

static float aspect;
static float char_width = 0.02, char_height = 0.02;
static struct vwsurf vws, *surface = &vws;
static struct rect r;
static int ask = 1;
static int color = 0;
static int nseg = 1;

extern float F77_COM(bgrp)[];
vector *csun(), *F77_SUB(brdpnz)();
static vector *wrap(), *flush(), *signalled(), *points(), *lines(),
	*polygon(), *suntext(), *segments(), *clear(), *readpen(), *hook();
static void init_colormap();
static void set_adjacencies();
static void fill_am();
static void color_table();
static void check();

/* next four declarations are the state for this driver */
static device d_sun = {
	FALSE, 0, NULL, 0, NULL,
	{csun, wrap, flush, signalled, points, lines,
	 polygon, suntext, segments, clear, readpen, NULL,
	 hook, NULL, NULL, NULL, NULL, NULL}
};
static float current_am[200];

static vector *
flush()
{
	return(S_void);
}

static vector *
clear()
{
	check();
	if(ask) {
		fprintf(stderr, "GO? ");
		fflush(stderr);
		while(getchar() != '\n') ;	/* ignore reply */
	}
	delete_all_retained_segments();
	create_retained_segment(nseg = 1);
	return(S_void);
}

static vector *
wrap()
{
	delete_all_retained_segments();
	deselect_view_surface(surface);
	terminate_view_surface(surface);
	terminate_device(LOCATOR, 1);
	terminate_core();
	return(S_void);
}

static vector *
signalled()
{
	return(S_void);
}

static vector *
lines(x, y, n)
float x[], y[];
long *n;
{
	check();
	if(*n <= 0) return(S_void);
	move_abs_2(x[0], y[0]);
	polyline_abs_2(&x[1], &y[1], (int)*n - 1);
	return(S_void);
}

static vector *
segments(x1, y1, x2, y2, n)
float x1[], y1[], x2[], y2[];
long *n;
{
	int i;

	check();
	for(i = 0; i < *n; i++) {
		move_abs_2(*x1++, *y1++);
		line_abs_2(*x2++, *y2++);
	}
	return(S_void);
}

static vector *
polygon(x, y, n)
float x[], y[];
long *n;
{
	check();
	if(*n > 0) polygon_abs_2(x, y, (int)*n);
	return(S_void);
}

static vector *
points(x, y, n)
float x[], y[];
long *n;
{
	long pch = (long) am(15);

	check();
	if(*n <= 0) return(S_void);
	if(pch < 32)
		F77_SUB(dmarkz)(x, y, n, &pch);
	else
		polymarker_abs_2(x, y, (int)*n);
	return(S_void);
}
	
static vector *
suntext(x, y, string, nch, adj)
F_CHARTYPE string;
float *x, *y, *adj;
long *nch;
{
	float dx, dy, nx, ny;
	float vxmin, vxmax, vymin, vymax;
	float wxmin, wxmax, wymin, wymax;
	char *buf;

	check();
	buf = Malloc(*nch + 1);
	if(buf == (char *)0)
		PROBLEM "Cannot allocate memory for text",NULL_ENTRY);
	strncpy(buf, F_CHARP(string), (int) *nch);
	buf[*nch]='\0';

	/*
	 * To keep a constant aspect ratio for characters, we
	 * first find the desired string position in NDC space,
	 * then open a new segment with world coords which match
	 * NDC space.  This string is plotted, and the remembered
	 * previous viewport and window are restored in another
	 * retained segment.
	 */
	map_world_to_ndc_2(*x, *y, &nx, &ny);
	inquire_viewport_2(&vxmin, &vxmax, &vymin, &vymax);
	inquire_window(&wxmin, &wxmax, &wymin, &wymax);
	close_retained_segment(nseg);
	set_charsize(am(18)*char_width*0.5, am(18)*char_height*0.5);
	set_viewport_2(0.0, 1.0, 0.0, aspect);
	set_window(0.0, 1.0, 0.0, aspect);
	create_retained_segment(++nseg);
	inquire_text_extent_2(buf, &dx, &dy);
	move_abs_2(nx - *adj * dx, ny - *adj * dy);
	text(buf);
	close_retained_segment(nseg);
	set_viewport_2(vxmin, vxmax, vymin, vymax);
	set_window(wxmin, wxmax, wymin, wymax);
	create_retained_segment(++nseg);
	free(buf);
	return(S_void);
}

vector *
csun(a_ask, a_color, a_display)
long *a_ask, *a_color;
char **a_display;
{
	device *new_device();
	int i;
	char *getenv(), *gfx, *me;
	char *av[4];
	ask = *a_ask;
	color = *a_color;

	/* initialize device structure and graphical parameters */
	set_device(new_device(&d_sun, 0L)->which);
	/* find the surface on which to do the graphics */

	i = 0;
	av[i++] = "";
	if( *a_display != NULL && *a_display[0] != '\0' ) {
		av[i++] = "-d";
		av[i++] = *a_display;
	}
	av[i++] = NULL;
	if(get_view_surface(surface, av))
		PROBLEM "Cannot initialize sun device driver",NULL_ENTRY);

	/* don't blanket a tty subwindow */
	gfx = getenv("WINDOW_GFX");
	me = getenv("WINDOW_ME");
	if(gfx && me && strcmp(gfx, me) == 0)
		surface->flags = VWSURF_NEWFLG;

	/* prepare for output */
	if(initialize_core(BUFFERED, SYNCHRONOUS, TWOD))
		PROBLEM "Cannot initialize SunCore" RECOVER(NULL_ENTRY);
	surface->cmapsize = CMAPSIZE;
	strncpy(surface->cmapname, default_cseg.cms_name, DEVNAMESIZE);
	if(initialize_view_surface(surface, FALSE))
		PROBLEM "Cannot initialize view surface" RECOVER(NULL_ENTRY);
	if(select_view_surface(surface))
		PROBLEM "Cannot select view surface" RECOVER(NULL_ENTRY);
	win_getsize(surface->windowfd, &r);
	aspect = (float)r.r_height / (float)r.r_width;
	set_ndc_space_2(1.0, aspect);
	set_viewport_2(0.0, 1.0, 0.0, aspect);
	set_window(0.0, 1.0, 0.0, 1.0);

	/* prepare for input */
	initialize_device(LOCATOR, 1);
	set_echo_surface(LOCATOR, 1, surface);
	set_echo(LOCATOR, 1, 1);	/* pointing finger cursor */
	for(i = 1; i <= 3; i++) {
		initialize_device(BUTTON, i);
		set_echo_surface(BUTTON, i, surface);
	}

	/* fill the amodes array */
	fill_am();

	/* open segment and initialize character primitive static attributes */
	create_retained_segment(nseg = 1);
	set_charprecision(CHARACTER);
	set_charsize(char_width, char_height);
	set_font(STICK);
	init_colormap();

	/* establish the relative positions of multiple monitors
	 * if necessary.
	 */

	set_adjacencies(surface->windowfd);
}

/*
 *	Initialize the color map.  We keep the basic color map as unsigned
 *	chars in case we have to mess with pixwins and the like.  Likely we
 */
#define init_col(m,c,i) do{switch(m[i]){ \
	case 0:	c[i] = 0.0; break; \
	case 255: c[i] = 1.0; break; \
	case 128: c[i] = 0.5; break; \
	default: c[i] = (double)m[i]/255.; break;}}while(0)

static void
init_colormap()
{
	float initwhich[CMAPSIZE], initred[CMAPSIZE], initgreen[CMAPSIZE],
		initblue[CMAPSIZE];
	int i;

	for(i=0; i < CMAPSIZE; i++) {
		initwhich[i] = i;
		init_col(mapred,initred,i);
		init_col(mapgreen,initgreen,i);
		init_col(mapblue,initblue,i);
	}
	color_table(CMAPSIZE, initwhich, initred, initgreen, initblue, SET);
}

struct raster {
	int width, height, depth;
	short *bits;
};

static vector *
hook(type, x, n, y, m)
long *type, *n, *m;
float x[], y[];
{
	int ndef, nword, butnum;
	float ax, ay, bx, by, t;
	struct raster rast;

	check();
	switch(*type) {
	case SET_COLOR_TABLE:
		*m = 0;
		ndef = *n / 4;
		color_table(ndef, x, x+ndef, x+2*ndef, x+3*ndef, SET);
		break;
	case GET_COLOR_TABLE:
		ndef = *n;
		if(*m != 3*ndef) {
			fprintf(stderr, "hook(GET_COLOR_TABLE): 3*%d != %d",
				ndef, *m);
			*m = 0;
			return(S_void);
		}
		color_table(ndef, x, y, y+ndef, y+2*ndef, GET);
		break;
	case PUT_RASTER:
		*m = 0;
		move_abs_2(x[0], x[1]);
		x += 2;
		rast.width = *x++;
		rast.height = *x++;
		rast.depth = color ? 8 : 1;
		rast.bits = (short *)x;
		nword = color
			? ((rast.width + 1) / 2) * rast.height
			: ((rast.width + 15) / 16) * rast.height; 
		if((nword + 1) / 2 != *n - 4) {
			fprintf(stderr, "hook(PUT_RASTER): Bad data\n");
			return(S_void);
		}
		put_raster(&rast);
		break;
	case GET_RECT:
		if(*m != 4)
			return(S_void);
		*m = 0;
		await_any_button_get_locator_2(FOREVER, 1, &butnum, &ax, &ay);
		if(butnum != 1)
			return(S_void);
		map_ndc_to_world_2(ax, ay, &y[0], &y[2]);
		move_abs_2(y[0], y[2]);
		set_echo_position(LOCATOR, 1, ax, ay);
		set_echo(LOCATOR, 1, 6);	/* 6 = rubber band box */
		await_any_button_get_locator_2(FOREVER, 1, &butnum, &bx, &by);
		if(butnum != 1)
			return(S_void);
		map_ndc_to_world_2(bx, by, &y[1], &y[3]);
		set_echo(LOCATOR, 1, 1);	/* 1 = pointing finger cursor */
		if(y[0] > y[1]) {		/* make xmin < xmax */
			t = y[0];
			y[0] = y[1];
			y[1] = t;
		}
		if(y[2] > y[3]) {		/* make ymin < ymax */
			t = y[3];
			y[3] = y[2];
			y[2] = t;
		}
		*m = 4;
		break;
	default:
		*m = 0;
	}
	return(S_void);
}

static vector *
readpen(x, y, n, nmax)
float x[], y[];
long *n, *nmax;
{
	int but, i;
	float xin, yin;

	check();
	for(i = 0; i < *nmax; i++) {
		/* set_locator_2(1, xin, yin); */
		but = 0;
		while(but == 0)
			await_any_button_get_locator_2(FOREVER, 1, &but, &xin, &yin);
		if(but != 1) break;
		map_ndc_to_world_2(xin, yin, x++, y++);
		fprintf(stderr, "\007"); fflush(stderr);
	}
	*n = i;
	return(S_void);
}

static void
check() /* look for important parameter changes */
{
	static int styles[] = {SOLID, DOTTED, DASHED, DOTDASHED};
	static int nstyles = (sizeof(styles) / sizeof(*styles));
	int i, which, istyle;
	float value, fracx, fracy;
	double sin(), cos(), dvalue;
	int do_window = 0;

	for(i = 1; i <= 130; i++) {
		if(am(i)==curam(i)) continue;
		which = i;
		value = am(i);
		curam(which) = value;
		switch(which) {

		case 8:
			istyle = (int)(value - 1) % nstyles;
			set_linestyle(styles[istyle]);
			break;

		case 9:
			set_linewidth((value - 1)/3);
			break;

		case 10:
			set_line_index((int)value);
			set_fill_index((int)value);
			set_text_index((int)value);
			break;

		case 14:
			dvalue = value * DEG2RD;
			set_charpath_2(cos(dvalue), sin(dvalue));
			dvalue += PI/2;
			set_charup_2(cos(dvalue), sin(dvalue));
			break;

		case 15:
			set_marker_symbol((char)value);
			break;

		case 40: /* plot in figure */
		case 41:
		case 42:
		case 43:
		case 44: /* figure on device */
		case 45:
		case 46:
		case 47:
		case 61: /* user coords */
		case 62:
		case 63:
		case 64:
		case 65: /* flag for clipping */
			do_window = 1;
			break;
		}
	}

	if(!do_window)
		return;

	/* close current segment to change viewport and window */
	close_retained_segment(nseg);
	if(do_window && am(65) > 0) {
		set_viewport_2(am(44), am(45), aspect*am(46), aspect*am(47));
		fracx = (am(62)-am(61)) / (am(41)-am(40));
		fracy = (am(64)-am(63)) / (am(43)-am(42));
		set_window(
			am(61) - am(40)*fracx,
			am(62) + (1 - am(41))*fracx,
			am(63) - am(42)*fracy,
			am(64) + (1 - am(43))*fracy);
	}
	if(do_window && am(65) <= 0) {
		fracx = am(45) - am(44);
		fracy = am(47) - am(46);
		set_viewport_2(
			am(44) + am(40)*fracx,
			am(44) + am(41)*fracx,
			(am(46) + am(42)*fracy)*aspect,
			(am(46) + am(43)*fracy)*aspect);
		set_window(am(61), am(62), am(63), am(64));
	}
	create_retained_segment(++nseg);
}

static void
color_table(ndef, which, red, green, blue, setorget)
	int ndef, setorget;
	float which[], red[], green[], blue[];
{
	int i, j;

	for(i = 0; i < ndef; i++) {
		j = i + 1;
		while(j < ndef && which[j] == 1 + which[j-1])
			j++;
		j--;
		if(setorget == SET) {
			define_color_indices(surface,
				(int)which[i], (int)which[j],
				&red[i], &green[i], &blue[i]);
		} else {
			inquire_color_indices(surface,
				(int)which[i], (int)which[j],
				&red[i], &green[i], &blue[i]);
		}
		i = j;
	}
}

static void
fill_am()
{
	double drw, drh, px, py, c1em;
	int i;

	for(i = 1; i <= 130; i++)
		am(i) = 0;

	/* device specific paramaters */
	am(20) = char_width * r.r_width;	/* char width in rasters */
	am(21) = char_height * r.r_height;	/* char height in rasters */
	am(22) = 0;  am(23) = r.r_width - 1;	/* x limits in rasters */
	am(24) = 0;  am(25) = r.r_height - 1;	/* y limits in rasters */
	am(26) = 0;  am(27) = 0;		/* char addressing offset */
	am(28) = am(29) = color ? 0.016 : 0.0125;/* raster size in inches */
	am(30) = color ? SUNCOLOR : SUNBW;	/* device code number (< 0)) */
	am(31) = 1;				/* allow char rotation */
	am(1) = 1;				/* allow char size change */

	/* fixed parameters, mainly from defltz.r */
	am(8) = 1;	am(9) = 1;	am(10) = 1;	am(11) = 1;
	am(15) = 42;	am(17) = 3;	am(18) = 1;	am(45) = 1;
	am(47) = 1;	am(49) = 1;	am(54) = 1;	am(57) = 5;
	am(58) = 5;	am(59) = 7;	am(60) = 126;	am(62) = 1;
	am(64) = 1;	am(66) = 0.02;	am(79) = -1;	am(80) = 1;
	am(81) = 1;	am(82) = 1;	am(83) = 1;	am(85) = 0.2;
	am(89) = 1;	am(91) = 1;	am(93) = 1;	am(94) = 1;
	am(97) = 109;	am(100) = 0.5;	am(101) = -1;	am(102) = 115;
	am(103) = 32;	am(105) = 1;	am(106) = 5;	am(107) = 115;
	am(108) = 32;	am(110) = 1;	am(111) = 5;	am(112) = 3;
	am(113) = 1;	am(119) = 111;	am(122) = 109;	am(130) = 0.001;

	/* dependencies, mainly from zzpltz.r, zscalz.r and zcsizz.r */
	drw = am(23) - am(22);
	drh = am(25) - am(24);
	am(70) = am(28);
	am(71) = am(29);
	am(74) = am(20) * am(28);
	am(75) = am(21) * am(29);
	c1em = max(am(74), am(75));
	am(50) = am(51) = am(52) = am(53) = 7 * c1em;
	am(123) = am(98) = drw * am(28);
	am(124) = am(99) = drh * am(29);
	am(40) = 7 * c1em / am(98);
	am(41) = 1 - am(40);
	am(42) = 7 * c1em / am(99);
	am(43) = 1 - am(42);
	px = am(41) - am(40);
	py = am(43) - am(42);
	am(76) = am(55) = am(98) * px;
	am(77) = am(56) = am(99) * py;
	am(32) = am(22) + am(40) * drw;
	am(33) = am(22) + am(41) * drw;
	am(34) = am(24) + am(42) * drh;
	am(35) = am(24) + am(43) * drh;
	am(36) = am(32);
	am(37) = px * drw;
	am(38) = am(34);
	am(39) = py * drh;
	am(67) = am(74) / am(76);
	am(68) = am(75) / am(77);
	am(72) = c1em / am(76);
	am(73) = c1em / am(77);
	am(84) = c1em / min(am(98),am(99));
	for(i=1; i<=130; i++) curam(i) = am(i);
}

/*
 *	on_graphics_dev() returns 1 if the window accessed by file descriptor
 *	"fd" is on the same screen as the graphics window, (but is not the
 *	graphics window itself) and 0 otherwise.
 */

static struct screen graphics_screen;
static char graphics_name[WIN_NAMESIZE];

static int
on_graphics_dev(fd)
	int fd;
{
	struct screen screen;
	char s_name[WIN_NAMESIZE];

	win_screenget(fd, &screen);
	win_fdtoname(fd, s_name);
	if( strcmp(screen.scr_fbname, graphics_screen.scr_fbname) == 0 &&
	    strcmp(graphics_name, s_name) != 0)
		return 1;
	return 0;
}

/*
 *	This code tries to determine if the graphics window and the current
 *	window are on the same device.  If they are not, it tries to set
 *	adjacencies up so that the cursor can migrate between them.
 *	Some care is taken not to destroy existing adjacencies.
 */
static void
set_adjacencies(graphics_fd)
	int graphics_fd;
{
	char *wname;
	struct screen screen;
	int graphics_neighbors[SCR_POSITIONS], w_neighbors[SCR_POSITIONS];
	int w_num, graphics_num;
	int i;
	int wfd;

	win_screenget(graphics_fd, &graphics_screen);
	graphics_num = win_fdtonumber(graphics_fd);
	win_fdtoname(graphics_fd, graphics_name);

	/*
	 * If we are not running under sunwindows, go home.  It's not clear
	 * how to share the cursor and mouse under these circumstances.
	 *
	 * If we are running under sunwindows, and also on the graphics
	 * screen then we're all done.  (If user can't get cursor into this
	 * window how did they get S running in the first place?)
	 */
	wname = getenv("WINDOW_ME");
	if( wname == NULL ) {
		PROBLEM "S not running under Sunwindows" WARNING(NULL_ENTRY);
		return;
	}
	wfd = open(wname, O_RDONLY);
	if( wfd == -1 ) {
		PROBLEM "Could not open current window!" WARNING(NULL_ENTRY);
		return;
	}
	win_screenget(wfd, &screen);
	w_num = win_fdtonumber(wfd);
	if( strcmp(screen.scr_fbname, graphics_screen.scr_fbname) == 0 ) {
		close(wfd);
		return;
	}

	/* So we are running under sunwindows, and the graphics screen is not
	 * the same frame buffer.  Does either have neighbors?  If so,
	 * keep our paws off.
	 */

	win_getscreenpositions(graphics_fd, graphics_neighbors);
	win_getscreenpositions(wfd, w_neighbors);
	for(i=0; i<SCR_POSITIONS; i++) {
		if(graphics_neighbors[i] != -1 || w_neighbors[i] != -1 ) {
			close(wfd);
			return;
		}
	}

	/* The two screens have no neighbors.  Are there other windows on the
	 * graphics screen?  If so, complain.  (This shouldn't happen, and so
	 * warrants a comment.)
	 */

	if( win_enumall(on_graphics_dev) )
	{
		PROBLEM "Other windows on graphics screen -- made screens adjacent anyway" WARNING(NULL_ENTRY);
	}

	/* Whew!  Set graphics screen up so that we get to/from it by moving
	 * off either edge of the window screen.
	 */

	w_neighbors[SCR_EAST] = graphics_num;
	w_neighbors[SCR_WEST] = graphics_num;
	graphics_neighbors[SCR_EAST] = w_num;
	graphics_neighbors[SCR_WEST] = w_num;
	win_setscreenpositions(graphics_fd, graphics_neighbors);
	win_setscreenpositions(wfd, w_neighbors);
	close(wfd);
	return;
}
