#include "mysccs.h"
SCCSID("@(#)non_ansi.c   %E%   SAP   %I%")

static char * this_File GNU_UNUSED = __FILE__;

/************************************************************************/
/* $Id: non_ansi.c,v 1.1.1.1 1998/11/06 14:33:18 d019080 Exp $
 ************************************************************************/
/*
 *  (C) Copyright 1998  SAP AG Walldorf
 *
 * Author:  Martin Rex
 * 
 * SAP AG DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
 * INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO
 * EVENT SHALL SAP AG BE LIABLE FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL
 * DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR
 * PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS
 * ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE
 * OF THIS SOFTWARE.
 *
 * Providing a platform independent interface to load
 * "shared libraries" aka "shared objects" aka "DLLs"
 * dynamically at runtime.
 *
 * This code doesn't care whether you try to load a library
 * multiple times and it doesn't care about multi-threading ...
 *
 */

#include <stddef.h>
#include <stdlib.h>
#include <string.h>
#include <stdio.h>
#include <ctype.h>
#include "non_ansi.h"




/*
 * Strcaseicmp()
 *
 * Case independent string compare
 *
 */
int
Strcaseicmp( const char *s1, const char *s2 )
{
   const unsigned char  * a  = (const unsigned char *) s1;
   const unsigned char  * b  = (const unsigned char *) s2;
   int                    c1;
   int                    c2;

   if ( a==b )
      return(0);

   for ( ; *a!='\0'  &&  *b!='\0' ; a++, b++ ) {
      c1 = isupper(*a) ? tolower(*a) : *a ;
      c2 = isupper(*b) ? tolower(*b) : *b ;
      if ( c2!=c1 ) {
	 break;
      }
   }
   
   return( (int)*b - (int)*a);

} /* Strcaseicmp() */




/*
 * Strncaseicmp()
 *
 * Case independent string compare with a length limit
 *
 */
int
Strncaseicmp( const char *s1, const char *s2, size_t count )
{
   const unsigned char   * a = (const unsigned char *) s1;
   const unsigned char   * b = (const unsigned char *) s2;
   int                     c1;
   int                     c2;
   size_t		   i;

   if ( a==b )
      return(0);

   for( i=0 ; i<count  &&  *a!='\0'  &&  *b!='\0' ; a++, b++, i++ ) {
      c1 = isupper(*a) ? tolower(*a) : *a ;
      c2 = isupper(*b) ? tolower(*b) : *b ;
      if ( c2!=c1 ) {
	 break;
      }
   }
   
   return( (int)*b - (int)*a );

} /* Strncaseicmp() */




/*
 * Strnlen()
 *
 * strlen with a maximum limit
 *
 */
size_t
Strnlen( const char *s1, size_t count )
{
   const char * s;
   size_t       i;

   for( s=s1, i=0 ; i<count && *s!='\0' ; i++, s++ );

   return(i);

} /* Strnlen() */




/*
 * Strmaxcpy()
 *
 * copy a string into a limited buffer, possibly truncating it
 * function returns NULL when truncating source string
 *
 */
char *
Strmaxcpy( char *dest, const char *src, size_t count )
{
   char  * ptr = NULL;

   if ( count!=0 ) {
      if ( src==NULL || count<=1 ) {
	 *dest = '\0';
	 if ( src!=NULL && *src!='\0' ) {
	    ptr = dest;
	 }

      } else {

	 strncpy( dest, src, count );
	 if ( dest[count-1]=='\0' ) {
	    ptr = dest;
	 } else {
	    /* strcpy didn't put a NUL here => source was longer than count */
	    dest[count-1] = '\0';
	 }
      }
   }

   return(ptr);

} /* Strmaxcpy() */




/*
 * Strmaxdup()
 *
 * copy a string into dynamic memory when it's less than the max size
 *
 */
char *
Strmaxdup( char * src, size_t  max_len )
{
   char    * ptr = NULL;
   size_t    len;

   for ( len=0 ; src[len]!='\0'  &&  len<max_len ; len++ );
   if ( src[len]=='\0' ) {
      ptr = malloc( len+1 );
      if ( ptr!=NULL )
	 memcpy( ptr, src, len+1 );
   }

   return(ptr);

} /* Strmaxdup() */




/*
 * Xgetopt()
 *
 *
 */
int     optind = 1;
int     opterr = 0;
int     optopt = 0;

char  * optarg;

int
Xgetopt( int    p_argc, char   ** p_argv,  char  * p_options )
{
   char   * opos = 0;

   if ( p_options==NULL ) {
      fprintf(stderr, "getopt(): bad option string!\n");
      return(-1);
   }

   if ( p_argv[optind]==NULL ) {
      optopt = 0;
      return(-1);
   }

   if ( p_argv[optind][0]=='-' ) {

      optopt = p_argv[optind][1];
      if ( optopt == '\0' )
	 return(-1);

      if ( optopt=='-' ) {
	 optind++;
	 return(-1);
      }
      opos = strchr(p_options, optopt);
      optind++;
      if ( opos==NULL ) {
	 return('?');
      }

      if ( opos[1]==':' ) {
	 if ( optind<=p_argc && p_argv[optind]!=NULL ) {
	    optarg = p_argv[optind];
	    optind++;
	    return(optopt);
	 }
	 return ( p_options[0]==':' ? ':' : '?' );
      }
      optarg = NULL;

      return(optopt);

   } 

   optarg = NULL;
   optopt = '-';

   return(-1);

}/* Xgetopt() */
