/* SCCSID("@(#)platform.h  %E%   SAP   %I%") */

/************************************************************************/
/* $Id: platform.h,v 1.1.1.1 1998/11/06 14:33:18 d019080 Exp $
 ************************************************************************/
/*
 *  (C) Copyright 1998  SAP AG Walldorf
 *
 * Author:  Martin Rex
 * 
 * SAP AG DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
 * INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO
 * EVENT SHALL SAP AG BE LIABLE FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL
 * DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR
 * PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS
 * ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE
 * OF THIS SOFTWARE.
 */


#ifndef _XX_PLATFORM_H_
#  define _XX_PLATFORM_H_


#ifndef USHRT_MAX
#  include <limits.h>
#endif


#if USHRT_MAX >= 0x10000ul
#  define XX_SIZEOF_USHORT    4
#  error cannot handle   unsigned short > 2 bytes 
#else
#  define XX_SIZEOF_USHORT    2
#endif

#if UINT_MAX >= 0x10000ul
#  define XX_SIZEOF_UINT      4
#else
#  define XX_SIZEOF_UINT      2
#endif

#if ULONG_MAX > 0xFFFFFFFFul
#  define XX_SIZEOF_ULONG     8
#else
#  define XX_SIZEOF_ULONG     4
#endif


#if    (XX_SIZEOF_UINT   == 4)

  typedef unsigned int    Uint32;

#elif  (XX_SIZEOF_ULONG  == 4)

  typedef unsigned long   Uint32;

#elif  (XX_SIZEOF_USHORT == 4)

  typedef unsigned short  Uint32;

#endif



struct sys_platform_s {
   char    os_name[64];
   char    os_release[64];
   char    os_hardware[64];
   char    hostname[64];
   char    user[32];
   int     speed_indicator;
};


/* try to recognize platforms ... */

#if defined(_WINDOWS) || defined(_WIN32)

#  define LRTIMER_WIN_FTIME	 1
#  define HRTIMER_WIN32_QueryPerformanceCounter  1
#  define RTLINK_WINDOWS_LOADLIBRARY
#  define SHLIB_EXTENSION	 ".dll"
#  define SHLIB_TERM		 "DLL"
#  define HAVE_DOSWIN_SYSTEM	 1

#  define SYS_GET_OSNAME(x)	 win_osname(x)
#  define SYS_GET_OSRELEASE(x)	 win_osrelease(x)
#  define SYS_GET_OSHARDWARE(x)	 win_hardware(x)
#  define SYS_GET_USERNAME(x)	 win_username(x)
#  define SYS_GET_HOSTNAME(x)	 win_computername(x)


#elif defined(_AIX)

   /* AIX 3.2.x or 4.x.x */
#  define LRTIMER_GETTIMEOFDAY	 1
#  define HRTIMER_GETTIMEOFDAY	 1
#  define UNIX			 1

   /* we need _POSIX_SOURCE and _ALL_SOURCE on AIX 3.2.5 ... */
#  include <sys/types.h>

   /* would somebody please shoot them for making the return value */
   /* from load() different from the input to unload() !           */
#  include <sys/ldr.h>

   /* would you believe it, they have implemented dlopen() in AIX 4.2 */
#  ifdef L_LOADMEMBER
#    define RTLINK_UNIX_DLOPEN	 1
#    define DLOPEN_FLAGS	 (RTLD_NOW|RTLD_MEMBER)
#    define SHLIB_EXTENSION	 ".so"
#    define SHLIB_TERM		 "shared library"
#  else
#    define RTLINK_AIX_LOAD	 1
#    define SHLIB_EXTENSION	 ".o"
#    define SHLIB_TERM		 "shared object"
#  endif

#  define SYS_GET_OSRELEASE(x)   sys_popen( "/usr/bin/oslevel", (x)->os_release,  sizeof((x)->os_release)  )
#  define SYS_GET_OSHARDWARE(x)  sys_popen( "/usr/bin/model",   (x)->os_hardware, sizeof((x)->os_hardware) )


#elif defined(__osf__) && defined(__alpha)

   /* Digital UNIX (aka DEC OSF/1) on Alpha */
#  define LRTIMER_GETTIMEOFDAY	 1
#  define HRTIMER_OSFALPHA_PCC   1
#  define UNIX			 1
#  define RTLINK_UNIX_DLOPEN	 1
#  define DLOPEN_FLAGS		 (RTLD_NOW)
#  define SHLIB_EXTENSION	 ".so"
#  define SHLIB_TERM		 "shared library"

extern int alpha_cpu_speed;

#  define SYS_GET_OSHARDWARE(x)  sprintf( (x)->os_hardware, "Alpha (%d Mhz)", alpha_cpu_speed );


#elif defined(__sun) && defined(__unix) && defined(__SVR4)

   /* SUN Solaris 2.x */
#  define LRTIMER_GETTIMEOFDAY	 1
#  define HRTIMER_GETTIMEOFDAY	 1
#  define UNIX			 1
#  define RTLINK_UNIX_DLOPEN	 1
#  define DLOPEN_FLAGS		 (RTLD_NOW)
#  define SHLIB_EXTENSION	 ".so"
#  define SHLIB_TERM		 "shared library"


#elif defined(linux)

   /* Linux  any.any */
#  define LRTIMER_GETTIMEOFDAY	 1
#  define HRTIMER_GETTIMEOFDAY	 1
#  define UNIX			 1
#  define RTLINK_UNIX_DLOPEN	 1
#  define DLOPEN_FLAGS		 (RTLD_NOW)
#  define SHLIB_EXTENSION	 ".so"
#  define SHLIB_TERM		 "shared library"


#elif (defined(unix) || defined(__SNI_TARG_UNIX)) && defined(sinix)

   /* Siemens-Nixdorf SVR4  5.43 */
#  define LRTIMER_GETTIMEOFDAY	 1
#  define HRTIMER_GETTIMEOFDAY	 1
#  define UNIX			 1
#  define RTLINK_UNIX_DLOPEN	 1
#  define DLOPEN_FLAGS		 (RTLD_NOW)
#  define SHLIB_EXTENSION	 ".so"
#  define SHLIB_TERM		 "shared library"


#elif defined(__hpux) || defined(hpux)

  /* HP-UX 9.x and 10.x					        */
  /* should work for PA-Risc   9000/700 and 9000/800  machines  */
#  define LRTIMER_GETTIMEOFDAY	 1
#  define HRTIMER_GETTIMEOFDAY	 1
#  define UNIX			 1
#  define RTLINK_HPUX_SHLOAD	 1
#  define SHLIB_EXTENSION	 ".sl"
#  define SHLIB_TERM		 "shared library"

#  define SYS_GET_OSHARDWARE(x)  sys_popen( "/usr/bin/model", (x)->os_hardware, sizeof((x)->os_hardware) )


#elif defined(_MACINTOSH)

  /* Apple MacIntosh with CFM Shared Libraries */
#  define RTLINK_APPLE_MAC	 1
#  define SHLIB_EXTENSION	 ""
#  define SHLIB_TERM		 "CFM shared library"

#  error Incomplete configuration -- I still need to try MACs 


#elif defined(_OS400 ) /* MISSING: need correct prepocessor symbol here */

#  define RTLINK_OS400		 1
#  define SHLIB_EXTENSION	 ""
#  define SHLIB_TERM		 "shared object"

#  error Incomplete configuration -- I still need to try OS/400


#elif defined(__OS2__) /* MISSING: need correct preprocessor symbol here ! */

#  define RTLINK_OS2		 1
#  define SHLIB_EXTENSION	 ".DLL"
#  define SHLIB_TERM		 "DLL"

#  error Incomplete configuration -- I still need to try OS/2


#else

#  error This Platform is not recognized (yet).  Please insert your definitions into this tree

#endif



/* common Unix definitions ... */
#if defined(unix) || defined(UNIX)

#  define HAVE_UNISTD_H
#  define HAVE_PWD_H
#  define HAVE_UID_T
#  define HAVE_SYS_WAIT_H
#  define HAVE_POSIX_SYSTEM  1

#  ifndef SYS_GET_OSHARDWARE
#    define SYS_GET_OSHARDWARE(x)   sys_uts_oshardware(x)
#  endif

#  ifndef SYS_GET_OSRELEASE
#    define SYS_GET_OSRELEASE(x)    sys_uts_osrelease(x)
#  endif

#  ifndef SYS_GET_OSNAME
#    define SYS_GET_OSNAME(x)	    sys_uts_osname(x)
#  endif

#  ifndef SYS_GET_USERNAME
#    define SYS_GET_USERNAME(x)	    sys_getpwuid(x)
#  endif

#  ifndef SYS_GET_HOSTNAME
#    define SYS_GET_HOSTNAME(x)	    sys_gethostname(x)
#  endif

#endif /* !UNIX  &&  !unix */



/*
 * Define DLL_FUNC_DECO, DLL_DATA_DECO, FUNCPTR_DECO and FAR
 */

#if defined(_WIN32)
#  if !defined(WINAPI)
#    if !defined(_M_IX86)
#	include <windows.h>
#    else
#       /* shortcutting Microsoft Win32 on Intel x86i, because including */
#       /* <windows.h> is painfully timeconsuming during development ... */
#       define WINAPI		__stdcall
#    endif
#  endif
#  define FUNCPTR_DECO	        WINAPI
#  define EXPORT_FUNCTION	__declspec(dllexport) WINAPI
#  define EXPORT_DATA		__declspec(dllexport)
#  define IMPORT_FUNCTION       __declspec(dllimport) WINAPI
#  define IMPORT_DATA		__declspec(dllimport)
#elif defined(_WINDOWS)
#  if !defined(WINAPI)
#    define WINAPI		__far __pascal
#  endif
#  define FUNCPTR_DECO	        WINAPI
#  define EXPORT_FUNCTION	__export WINAPI
#  define EXPORT_DATA		__export
#  define IMPORT_FUNCTION	__export WINAPI
#  define IMPORT_DATA		__export
#  define FAR			__far
#else
#  define EXPORT_FUNCTION
#  define EXPORT_DATA
#  define IMPORT_FUNCTION
#  define IMPORT_DATA
#  define FUNCPTR_DECO
#endif

#ifdef BUILDING_DLL
#  define DLL_DATA_DECO	      EXPORT_DATA
#  define DLL_FUNC_DECO	      EXPORT_FUNCTION
#else
#  define DLL_DATA_DECO	      IMPORT_DATA
#  define DLL_FUNC_DECO	      IMPORT_FUNCTION
#endif

#ifndef FAR
#  define FAR
#endif



#endif /* _XX_PLATFORM_H_ */
