#include "mysccs.h"
SCCSID("@(#)debug.c   %E%   SAP   %I%")

static char * this_File GNU_UNUSED = __FILE__;

/************************************************************************/
/* $Id: debug.c,v 1.1.1.1 1998/11/06 14:33:16 d019080 Exp $
 ************************************************************************/
/*
 *  (C) Copyright 1998  SAP AG Walldorf
 *
 * Author:  Martin Rex
 * 
 * SAP AG DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
 * INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO
 * EVENT SHALL SAP AG BE LIABLE FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL
 * DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR
 * PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS
 * ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE
 * OF THIS SOFTWARE.
 */

#ifdef XDEBUG

#include "common.h"
#include "debug.h"

/* global variables */
int      debug_global_flag  = FALSE;

/* local variables */
static FILE  * dfp                     = stderr;
static int     debug_initialized       = FALSE;


void
debug_init( int p_enable, FILE * p_fp, char * p_filename )
{

   debug_initialized       = TRUE;
   debug_global_flag       = (p_enable==FALSE) ? FALSE : TRUE;

   if ( debug_global_flag==TRUE ) {

      fprintf(stderr, "Sending debug output to ");

      if ( p_fp==NULL || p_fp==stderr ) {

	 dfp = stderr;
	 fprintf(stderr, "STDERR\n");

      } else if ( p_fp==stdout ) {

	 dfp = stdout;
	 fprintf(stderr, "STDOUT\n");

      } else {

	 dfp = p_fp;
	 fprintf(stderr, "file \"%.200s\"\n", p_filename);

      }

   } /* debug_global_flag==TRUE */


   return;

} /* debug_init() */




void
debug_print( dbg_class_et p_class, ... )
{
   va_list    args;
   char     * label;
   char     * fmt1 = NULL;
   char	    * fmt2 = NULL;

   if ( dfp==NULL ) {
      fprintf(stderr, "WAAA! I don't have a valid FILE * for debugging!\n");
      abort();
   }

   if ( debug_global_flag==FALSE
	&&  p_class != DBG_CLASS_ERR ) {
      return;
   }

   switch( p_class ) {
      case DBG_CLASS_ERR:    fmt1 = "ERROR in %.60s(): ";	   break;
      case DBG_CLASS_ARG:    fmt1 = "->> %.60s(\n";		   break;
      case DBG_CLASS_RET:    fmt1 = "<<- %.60s() ";	    	   break;

      case DBG_CLASS_STRING: fmt2 = "\t%.50s =\"%.150s\"\n";	   break;

      case DBG_CLASS_ARGV:   break;
      case DBG_CLASS_INFO:   fprintf(dfp, "*INFO* ");		   break;
      default:		     break;
   
   }

   va_start(args, p_class);

   if ( fmt1!=NULL ) {
      label = va_arg( args, char * );
      fprintf( dfp, fmt1, label );
   }

   if ( fmt2==NULL ) {
      fmt2 = va_arg( args, char * );
   }

   vfprintf(dfp, fmt2, args);

   va_end(args);



   switch( p_class ) {
      case DBG_CLASS_RET:  fprintf(dfp, "----------\n");
			   break;

      default:		   break;

   }

   fflush(dfp);

   return;

} /* debug_print() */


#endif /* !XDEBUG */

