/* SCCSID("@(#)verbose.h   %E%   SAP   %I%") */

/************************************************************************/
/* $Id: verbose.h,v 1.1.1.1 1998/11/06 14:33:19 d019080 Exp $
 ************************************************************************/
/*
 *  (C) Copyright 1998  SAP AG Walldorf
 *
 * Author:  Martin Rex
 * 
 * SAP AG DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
 * INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO
 * EVENT SHALL SAP AG BE LIABLE FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL
 * DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR
 * PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS
 * ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE
 * OF THIS SOFTWARE.
 */


#ifndef _XX_VERBOSE_H_
#  define  _XX_VERBOSE_H_

#include <stdarg.h>

extern int    verbose_level;
extern int    there_was_output;
extern int    show_error_location;
extern int    duplicate_to_stdout;
extern int    sap_constraints_count;


typedef enum veb_class_e {
      VEB_CLASS_ERR	= (1<<0),
      VEB_CLASS_RESULT	= (1<<1),
      VEB_CLASS_OK	= (1<<2),
      VEB_CLASS_INFO	= (1<<3),
      VEB_CLASS_TEST	= (1<<4),
      VEB_CLASS_STRING	= (1<<5),
      VEB_CLASS_STATUS  = (1<<6),
      VEB_CLASS_BUG	= (1<<7),
      VEB_CLASS_TRIN    = (1<<8),
      VEB_CLASS_TROUT   = (1<<9),
      VEB_CLASS_TIMING  = (1<<10),
      VEB_CLASS_SECTION = (1<<11),
      VEB_CLASS_SAPERR  = (1<<12)
} veb_class_et;


extern void verbose_init( int enable, FILE * fp, char * filename, int quiet );
extern void set_verbose_level( int level );
extern void verbose_print( veb_class_et p_class, int p_min_level, ... );
extern void set_enter_leave_messages( char * enter_msg, char * leave_msg );
extern void checkin_message( void );
extern void checkout_message( void );


#define VERBOSE_INIT()	   verbose_init( 1, stdout, NULL, TRUE );

#define VERBOSE_BEGIN(x)	   char  * this_Call = # x ;


#undef XVEB
#define XVEB(x)  verbose_print x ;
#define V_ERR    VEB_CLASS_ERR,  2, this_File, (Uint) (__LI ## NE__)
#define V_TEST	 VEB_CLASS_TEST, 2
#define V_STATUS VEB_CLASS_STATUS, 2
#define V_RESULT VEB_CLASS_RESULT
#define V_INFO   VEB_CLASS_INFO
#define V_STRING VEB_CLASS_STRING
#define V_OK     VEB_CLASS_OK
#define V_SHOW	 VEB_CLASS_OK, 2
#define V_HIDE	 VEB_CLASS_OK, verbose_level
#define V_BUG	 VEB_CLASS_BUG, 2
#define V_TRIN   VEB_CLASS_TRIN, 2
#define V_TROUT  VEB_CLASS_TROUT, 2
#define V_TIME	 VEB_CLASS_TIMING, 2
#define V_SEC    VEB_CLASS_SECTION
#define V_SAP    VEB_CLASS_SAPERR, (int)(options.sap_constraints!=0)


#define VERBOSE_DUPMEM( srcptr, srclen, dstptr, dstlen ) \
	 dstptr = verbose_dupmem( __FI ## LE__, __LI ## NE__, (srcptr), (srclen), &(dstlen) );

void * verbose_dupmem( char * module_name, Uint line_of_code,
		       void * orig_ptr, size_t orig_len,  size_t * new_len );

void verbose_freemem( void ** ptr, size_t * len );

#endif /* _XX_VERBOSE_H_ */
