/*
 * fast.c
 *
 * Main routine for v3.0 testing "fast" processes
 *
 * Copyright 1995 BG Systems 
 *
 * Author       Date        Comments
 * John Green   14-Feb-97   Written
 *
 *
 */

static char SccsId[] = "%W% %G%";

#include <stdio.h>
#include <stdlib.h>
#include <time.h>
#include <signal.h>

#include <limits.h>
#include <sys/prctl.h>
#include <sys/schedctl.h>
#include <sys/types.h>
#include <sys/time.h>

#include "lv3.h"

void setup_lv(void );
void init_timer(void );
void rf_quit(void );
void catcher(void );
int ms_time(double *);

void print_bits(float);

extern int open_lv(bglv *, char *, int );
extern int init_lv(bglv *);
extern int close_lv(bglv *);

extern int w_lv(int, char *);
extern int r_lv(bglv *);

extern int check_rev(bglv *);
extern int check_setup(bglv *);

bglv bgdata;

double start, now;
struct itimerval itv;

/*
 * main()
 *
 * This is where everything happens
 *
 */

main()
{
   int      st;
   int      rst = 1;
   long     counter = 0;
   int      i;
   int      j;
   char     inputs = 1;


   setup_lv();
#ifndef DEBUG
   init_timer();
#endif

   st = ms_time(&start);

   i = 0;
   while(counter++ < 10000000)
   {
      st = w_lv(bgdata.sp_fd, "o");

      st = ms_time(&now);
#ifdef DEBUG
      sginap(4);
#else
      sigpause(SIGALRM);
#endif

      st = r_lv(&bgdata);

      if ( (counter % 200) == 0 )
         printf("%7ld  Update rate = %5.2f Hz\n",
                  counter, counter/(now-start) );
   }

   printf("%ld transfers in %f sec.\n", counter, (now-start) );
   printf("Update rate = %5.2f Hz\n", counter/(now-start) );

   exit(0);
}


void setup_lv()
{
   int st;
   int i;
   
/*
 * Defaults to 4 analog, and 8 discretes
 */
 
   bgdata.analog_in = AIC1 | AIC2 | AIC3 | AIC4 | AIC5;
   bgdata.analog_in = 0;
   bgdata.analog_in = AIC1 | AIC2 | AIC3 | AIC4 | AIC5;
   bgdata.analog_in = AIC1 | AIC2 | AIC3;
   bgdata.analog_in = AIC1;

   bgdata.dig_in = DIC1 | DIC2 | DIC3;
   bgdata.dig_in = DIC1 | DIC2;
   bgdata.dig_in = 0;

/*
 *  Set the baud rate
 */
   bgdata.baud    = BAUD576;
   bgdata.baud    = BAUD384;
   bgdata.baud    = BAUD12;
   bgdata.baud    = BAUD192;
 
/*
 *  Open the port & drivers
 */
   st = open_lv(&bgdata, "/dev/ttyd2", FB_NOBLOCK);
   if (st < 0)
   {
      printf("Unable to open port\n");
      exit(-1);
   }
/*
 *  Send the init string
 */
   st = init_lv(&bgdata);
   if ( st < 0 )
   {
      check_setup(&bgdata);
      printf("Invalid setup requested.  Bye\n");
      exit(-1);
   }
}

void catcher()
{
}

int ms_time(double *t)
{
   struct timeval tp;
   struct timezone tzp;
   int st;

   st = gettimeofday(&tp, &tzp);
   *t = tp.tv_sec +  ((float)tp.tv_usec / 1000000.0);

   return(0);
}

void rf_quit()
{
   int st;

   st = r_lv(&bgdata);
   st = close_lv(&bgdata);
   if (st != 0)
   
   printf("Bye\n");
   exit(0);
}

void init_timer()
{
   int st;
/*
 * Initialize the itimer
 * If we cannot set the npri to a low number, the minimum
 * value of tv_usec is 10000 (10 ms).
 * If we are root, and can set the priority to 30, then
 * we can really crank up the speed....
 */
 
/*
 * Set the non-degrading priority of this process
 */
   st = schedctl(NDPRI, 0, 32);
   if ( st == -1 )
   {
      printf("Unable to set NDPRI\n");
      printf("CerealBox will only sample at max 100 Hz\n");
   }

   itv.it_interval.tv_sec = 0;
   itv.it_interval.tv_usec =  5000;
   itv.it_interval.tv_usec = 20000; /* 50 Hz */
   itv.it_interval.tv_usec = 15000; 
   itv.it_interval.tv_usec =  6000;

   itv.it_value = itv.it_interval;
   setitimer(ITIMER_REAL, &itv, (struct itimerval *)0 );

/*
 * Set the signal parameters
 */
   sigset(SIGALRM,  catcher);
   sigset(SIGQUIT,  rf_quit);
   sigset(SIGKILL,  rf_quit);
   sigset(SIGINT,   rf_quit);
}
