/*
 * Copyright 1994   BG Systems, Inc.
 * pattern.c
 *
 * Send a pattern to the dig outs...
 *
 * Author         Date       Comments
 * John Green     15-Oct-94  Author
 * John Green     01-Feb-95  Rev 3.0 release
 */

static char SccsId[] = "@(#)pattern.c	1.2 01 Feb 1995";

#include <stdio.h>

#include "lv3.h"


void pattern(long *count, bglv *bgp)
{
   long i;
   static int direction = 1;

   i = *count;

   if ( i > 64 )
   {
      bgp->dout[0] = 0x0;
      bgp->dout[1] = 0x0;
      bgp->dout[2] = 0x0;
      direction = -1;
   }
   else if ( i > 40 )
   {
      bgp->dout[0] |= 0x1 << i-41;
      bgp->dout[1] |= 0x1 << (64-i-8);
      bgp->dout[2] |= 0x1 << (64-i);
   }
   else if ( i > 16 )
   {
      bgp->dout[0] = 0x1 << i-17;
      bgp->dout[1] = 0x1 << (40-i-8);
      bgp->dout[2] = 0x1 << (40-i);
   }
/*
 *  All 3 going clockwise, adding
 */
   else if ( i >= 8  )
   {
      bgp->dout[0] |= 0x1 << (i -8);
      bgp->dout[1] |= 0x1 << (16 - i);
      bgp->dout[2] |= 0x1 << (16 - i);
   }
/*
 *  All 3 going clockwise
 */
   else if ( i >= 0)
   {
      bgp->dout[0] = 0x1 << i;
      bgp->dout[1] = 0x1 << (8-i);
      bgp->dout[2] = 0x1 << (8-i);
   }
   else if ( i < 0 )
      direction = 1;

   if ( direction == 1 )
      i++;
   else if ( direction == -1 )
      i--;

   *count = i;
}
