/*
 * Copyright 1994   BG Systems, Inc.
 * check_rev.c
 *
 * routine that checks the EPROM revision
 *
 * Author         Date       Comments
 * John Green     21-Oct-94  Author
 * John Green     01-Feb-95  Final changes for revision 3.0 release
 */

static char SccsId[] = "%W% %G%";

#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <sys/types.h>

#include "lv3.h"

extern int open_lv(bglv *, char *, int);
extern int check_rev(bglv *);

bglv bgdata;
void check_rev7(bglv *);

static char Cpy[] = "Copyright (c), BG Systems";

int main(int argc, char **argv)
{
   int st;
/*
 * Open the serial port, and request a copyright string
 */
   printf("Attempting to open the serial port\n");
   st = open_lv(&bgdata, argv[1], FB_NOBLOCK);

   if (st < 0)
   {
      printf("\tUnable to open port\nbye\n");
      exit(1);
   }
   else
      printf("\tOK\n");

   if ( bgdata.Rev.bug >= 7 )
      check_rev7(&bgdata);

   exit(0);
}

void check_rev7(bglv *bgp)
{
   int st;
   char buf[64];

   st = write(bgp->sp_fd, "t", 2);
   sginap(100);
   st = read(bgp->sp_fd, buf, 44);
   buf[st] = '\0';
   if ( buf[0] != 'C' )
      printf("Error test 3.07 EPROM. Possible beta EPROM\n");
   else if ( buf[1] == 'e' )
   {
      if ( buf[2] == '4' )
         printf("4 encoders on LV824\n");
      else if ( buf[2] == '8' )
         printf("8 encoders on LV824\n");
   } 

}
