/*
 * Decompiled with CFR 0.152.
 */
package org.w3c.jigsaw.servlet;

import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import javax.servlet.http.HttpSession;
import javax.servlet.http.HttpSessionContext;
import org.w3c.jigsaw.http.httpd;
import org.w3c.jigsaw.servlet.JigsawHttpSession;
import org.w3c.jigsaw.servlet.ServletProps;
import org.w3c.util.PropertyMonitoring;

public class JigsawHttpSessionContext
implements HttpSessionContext,
PropertyMonitoring {
    private Hashtable sessions;
    private int sessionNb = 0;
    private int sessionCount = 0;
    private int maxsession;
    private long maxidle;
    private JigsawHttpSession oldestIdleSession = null;
    private SessionSweeper sweeper = null;
    private ServletProps props = null;

    public JigsawHttpSessionContext(httpd httpd2, ServletProps servletProps) {
        this.props = servletProps;
        this.sessions = new Hashtable(3);
        this.maxidle = servletProps.getSessionsMaxIdleTime();
        this.maxsession = servletProps.getMaxSessionsNumber();
        this.sweeper = new SessionSweeper(this, servletProps.getSessionsSweepDelay());
        httpd2.getProperties().registerObserver(this);
    }

    protected synchronized String addSession(JigsawHttpSession jigsawHttpSession) {
        if (this.sessionCount >= this.maxsession) {
            this.removeOldestIdleSession();
        }
        String string = this.getNewSessionId();
        this.sessions.put(string, jigsawHttpSession);
        ++this.sessionCount;
        return string;
    }

    public Enumeration getIds() {
        return this.sessions.keys();
    }

    private String getNewSessionId() {
        return "J" + String.valueOf(new Date().hashCode()) + "-" + this.sessionNb++;
    }

    public HttpSession getSession(String string) {
        return (HttpSession)this.sessions.get(string);
    }

    public boolean propertyChanged(String string) {
        if (string.equals(ServletProps.SERVLET_SESSION_IDLE)) {
            this.maxidle = this.props.getSessionsMaxIdleTime();
        } else if (string.equals(ServletProps.SERVLET_MAX_SESSION)) {
            this.maxsession = this.props.getMaxSessionsNumber();
        } else if (string.equals(ServletProps.SERVLET_SESSION_SWEEP)) {
            this.sweeper.setDelay(this.props.getSessionsSweepDelay());
        }
        return true;
    }

    protected synchronized void removeOldestIdleSession() {
        if (this.oldestIdleSession != null) {
            this.oldestIdleSession.invalidate();
            this.oldestIdleSession = null;
        }
    }

    protected void removeSession(String string) {
        this.sessions.remove(string);
        --this.sessionCount;
    }

    protected synchronized void sweepSession() {
        long l = System.currentTimeMillis();
        Enumeration enumeration = this.sessions.keys();
        this.oldestIdleSession = null;
        while (enumeration.hasMoreElements()) {
            long l2;
            JigsawHttpSession jigsawHttpSession = (JigsawHttpSession)this.sessions.get(enumeration.nextElement());
            long l3 = l - jigsawHttpSession.getLastAccessedTime();
            int n = jigsawHttpSession.getMaxInactiveInterval() * 1000;
            long l4 = l2 = n > 0 ? (long)n : this.maxidle;
            if (l3 > l2) {
                jigsawHttpSession.invalidate();
                continue;
            }
            if (this.oldestIdleSession != null) {
                if (this.oldestIdleSession.getLastAccessedTime() <= jigsawHttpSession.getLastAccessedTime()) continue;
                this.oldestIdleSession = jigsawHttpSession;
                continue;
            }
            this.oldestIdleSession = jigsawHttpSession;
        }
    }

    class SessionSweeper
    extends Thread {
        int delay;
        JigsawHttpSessionContext ctxt = null;

        SessionSweeper(JigsawHttpSessionContext jigsawHttpSessionContext2, int n) {
            super("SessionSweeper");
            this.delay = n;
            this.ctxt = jigsawHttpSessionContext2;
            this.setPriority(1);
            this.setDaemon(true);
            this.start();
        }

        public void run() {
            while (true) {
                try {
                    Thread.sleep(this.delay);
                }
                catch (InterruptedException interruptedException) {}
                this.ctxt.sweepSession();
            }
        }

        void setDelay(int n) {
            this.delay = n;
        }
    }
}

