/*
 * Decompiled with CFR 0.152.
 */
package org.w3c.tools.resources.store;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import org.w3c.tools.resources.AttributeHolder;
import org.w3c.tools.resources.InvalidResourceException;
import org.w3c.tools.resources.Resource;
import org.w3c.tools.resources.serialization.SerializationException;
import org.w3c.tools.resources.serialization.Serializer;
import org.w3c.tools.resources.store.ResourceStore;
import org.w3c.tools.resources.store.ResourceStoreManager;
import org.w3c.tools.resources.store.UnknownResourceException;

public class ResourceStoreImpl
implements ResourceStore {
    static final int writerSize = 65536;
    private static final int VERSION = 2;
    protected Serializer serializer = null;
    File repository = null;
    protected ResourceStoreManager manager = null;
    Object token = null;
    Hashtable resources = null;
    boolean modified = false;

    public synchronized boolean acceptUnload() {
        boolean bl;
        block11: {
            if (this.resources == null) {
                return true;
            }
            bl = true;
            if (this.manager != null && this.manager.getStoreSizeLimit() > 0 && this.resources.size() > this.manager.getStoreSizeLimit()) {
                bl = false;
            } else {
                Enumeration enumeration = this.resources.elements();
                while (enumeration.hasMoreElements()) {
                    ResourceIndex resourceIndex = (ResourceIndex)enumeration.nextElement();
                    Resource resource = resourceIndex.getResource();
                    ResourceIndex resourceIndex2 = resourceIndex;
                    synchronized (resourceIndex2) {
                        if (!resource.acceptUnload()) {
                            bl = false;
                        }
                    }
                }
            }
            if (bl) break block11;
            try {
                if (this.modified) {
                    this.internalSave(false);
                }
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
                this.warning("internalSave failed at acceptUnload");
            }
        }
        return bl;
    }

    public synchronized void addResource(Resource resource) {
        this.loadResources();
        ResourceIndex resourceIndex = new ResourceIndex(resource, true);
        resourceIndex.markModified();
        resource.setValue("store-entry", (Object)resourceIndex);
        this.resources.put(resourceIndex.getIdentifier(), resourceIndex);
        this.markModified();
        this.markUsed();
    }

    public Enumeration enumerateResourceIdentifiers() {
        this.markUsed();
        this.loadResources();
        return this.resources.keys();
    }

    public String getIdentifier() {
        return this.repository.getAbsolutePath();
    }

    public int getVersion() {
        return 2;
    }

    public boolean hasResource(String string) {
        this.markUsed();
        this.loadResources();
        return this.resources.get(string) != null;
    }

    public void initialize(ResourceStoreManager resourceStoreManager, Object object, File file, Serializer serializer) {
        this.manager = resourceStoreManager;
        this.token = object;
        this.repository = file;
        this.serializer = serializer;
        this.resources = null;
        this.markUsed();
    }

    protected synchronized void internalSave(boolean bl) throws IOException {
        Object[] objectArray;
        if (this.resources == null) {
            return;
        }
        Enumeration enumeration = this.resources.elements();
        Vector<Object[]> vector = new Vector<Object[]>(11);
        while (enumeration.hasMoreElements()) {
            objectArray = ((ResourceIndex)enumeration.nextElement()).getResource();
            vector.addElement(objectArray);
        }
        objectArray = new Resource[vector.size()];
        vector.copyInto(objectArray);
        File file = new File(this.repository.getParent(), String.valueOf(this.repository.getName()) + ".tmp");
        FileOutputStream fileOutputStream = new FileOutputStream(file);
        OutputStreamWriter outputStreamWriter = new OutputStreamWriter((OutputStream)fileOutputStream, "UTF-8");
        BufferedWriter bufferedWriter = new BufferedWriter(outputStreamWriter, 65536);
        this.serializer.writeResources((AttributeHolder[])objectArray, bufferedWriter);
        String string = this.repository.getName();
        String string2 = this.repository.getParent();
        File file2 = new File(string2, String.valueOf(string) + ".bak");
        File file3 = new File(string2, String.valueOf(string) + ".bak~");
        if (file3.exists()) {
            file3.delete();
        }
        if (file2.exists()) {
            file2.renameTo(file3);
            file2.delete();
        }
        if (this.repository.exists()) {
            if (!this.repository.renameTo(file2)) {
                this.warning("unable to rename " + this.repository + " to " + file2);
                file3.renameTo(file2);
            }
            this.repository.delete();
        }
        if (!file.renameTo(this.repository)) {
            file2.renameTo(this.repository);
            file3.renameTo(file2);
            this.warning("unable to rename " + file + " to " + this.repository);
        }
        file3.delete();
        this.modified = false;
        if (bl) {
            int n = 0;
            while (n < objectArray.length) {
                ((Resource)objectArray[n]).notifyUnload();
                ++n;
            }
            this.resources = null;
        }
    }

    public Resource loadResource(String string, Hashtable hashtable) throws InvalidResourceException {
        this.loadResources();
        this.markUsed();
        ResourceIndex resourceIndex = (ResourceIndex)this.resources.get(string);
        if (resourceIndex == null) {
            return null;
        }
        if (hashtable == null) {
            hashtable = new Hashtable<String, ResourceIndex>(3);
        }
        hashtable.put("store-entry", resourceIndex);
        return resourceIndex.loadResource(hashtable);
    }

    protected synchronized void loadResources() {
        block7: {
            int n = 0;
            if (this.resources != null) break block7;
            try {
                this.resources = new Hashtable(11);
                if (this.repository.exists()) {
                    BufferedReader bufferedReader = new BufferedReader(new FileReader(this.repository));
                    Resource[] resourceArray = this.serializer.readResources(bufferedReader);
                    n = 0;
                    while (n < resourceArray.length) {
                        ResourceIndex resourceIndex = new ResourceIndex(resourceArray[n], false);
                        if (resourceIndex != null && resourceIndex.getIdentifier() != null) {
                            this.resources.put(resourceIndex.getIdentifier(), resourceIndex);
                        }
                        ++n;
                    }
                }
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
                this.warning("Unable to load resources");
            }
            catch (SerializationException serializationException) {
                this.warning(serializationException.getMessage());
                serializationException.printStackTrace();
            }
            catch (Exception exception) {
                exception.printStackTrace();
                String string = "Error in " + this.repository.getName() + " in dir " + this.repository.getParent() + ": [" + n + "] " + exception.getMessage();
                this.warning(string);
            }
        }
    }

    public Resource lookupResource(String string) {
        this.loadResources();
        this.markUsed();
        ResourceIndex resourceIndex = (ResourceIndex)this.resources.get(string);
        return resourceIndex == null || !resourceIndex.initialized ? null : resourceIndex.getResource();
    }

    protected void markModified() {
        if (!this.modified) {
            ResourceStoreImpl resourceStoreImpl = this;
            synchronized (resourceStoreImpl) {
                this.modified = true;
            }
        }
    }

    public void markModified(Resource resource) {
        ResourceIndex resourceIndex = (ResourceIndex)resource.getStoreEntry();
        if (resourceIndex != null) {
            resourceIndex.markModified();
            this.markModified();
            this.markUsed();
        }
    }

    protected final void markUsed() {
        if (this.manager != null) {
            this.manager.markUsed(this.token);
        }
    }

    public synchronized void removeResource(String string) {
        ResourceIndex resourceIndex = (ResourceIndex)this.resources.get(string);
        if (resourceIndex != null) {
            resourceIndex.unloadResource();
            this.resources.remove(string);
            this.markModified();
            this.markUsed();
        }
    }

    public synchronized void renameResource(String string, String string2) {
        ResourceIndex resourceIndex = (ResourceIndex)this.resources.get(string);
        if (resourceIndex != null) {
            this.resources.remove(string);
            resourceIndex.setIdentifier(string2);
            this.resources.put(string2, resourceIndex);
            resourceIndex.markModified();
            this.markModified();
        }
    }

    public void save() {
        block3: {
            if (!this.modified) break block3;
            try {
                this.internalSave(false);
            }
            catch (IOException iOException) {
                this.warning("Save failed (IO) [" + iOException.getMessage() + "]");
            }
            catch (Exception exception) {
                this.warning("Save failed [" + exception.getMessage() + "]");
            }
        }
    }

    public void saveResource(Resource resource) {
        this.loadResources();
        ResourceIndex resourceIndex = (ResourceIndex)resource.getStoreEntry();
        if (resourceIndex == null) {
            throw new UnknownResourceException(resource);
        }
        if (resourceIndex.isModified()) {
            this.save();
        }
        this.markUsed();
    }

    public synchronized void shutdown() {
        if (this.modified) {
            try {
                this.internalSave(true);
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
                this.warning("internalSave failed at shutdown.");
            }
        } else if (this.resources != null) {
            Enumeration enumeration = this.resources.elements();
            while (enumeration.hasMoreElements()) {
                ResourceIndex resourceIndex = (ResourceIndex)enumeration.nextElement();
                resourceIndex.unloadResource();
            }
        }
        this.resources = null;
        this.manager = null;
    }

    protected void warning(String string) {
        System.out.println("[" + this.getClass().getName() + "@" + this.repository + "]: " + string);
    }

    class ResourceIndex {
        boolean modified = false;
        String identifier = null;
        Resource resource = null;
        boolean initialized = false;

        ResourceIndex(Resource resource, boolean bl) {
            this.resource = resource;
            this.identifier = resource.unsafeGetIdentifier();
            this.modified = false;
            this.initialized = bl;
        }

        synchronized String getIdentifier() {
            return this.identifier;
        }

        synchronized Resource getResource() {
            return this.resource;
        }

        synchronized boolean isModified() {
            return this.modified;
        }

        synchronized Resource loadResource(Hashtable hashtable) {
            if (this.initialized) {
                return this.resource;
            }
            this.resource.initialize(hashtable);
            this.initialized = true;
            return this.resource;
        }

        synchronized void markModified() {
            this.modified = true;
        }

        synchronized void setIdentifier(String string) {
            this.identifier = string;
        }

        void unloadResource() {
            this.resource.notifyUnload();
            this.resource = null;
        }
    }
}

