/*
 * Decompiled with CFR 0.152.
 */
package org.w3c.tools.widgets;

import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Panel;

public class BorderPanel
extends Panel {
    public static final int SOLID = 0;
    public static final int RAISED = 1;
    public static final int LOWERED = 2;
    public static final int IN = 3;
    public static final int OUT = 4;
    private static final int DEFAULT_THICKNESS = 2;
    private int type;
    private int thickness;
    protected Insets insets = null;

    public BorderPanel(int n) {
        this.type = n;
        this.thickness = 2;
        this.build();
    }

    public BorderPanel(int n, int n2) {
        this.type = n;
        this.thickness = n2;
        this.build();
    }

    private void build() {
        this.insets = new Insets(this.thickness, this.thickness, this.thickness, this.thickness);
    }

    public Insets getInsets() {
        return this.insets;
    }

    public void paint(Graphics graphics) {
        if (this.thickness > 0) {
            Dimension dimension = this.size();
            graphics.setColor(this.getBackground());
            switch (this.type) {
                case 0: {
                    graphics.setColor(this.getForeground());
                    int n = 0;
                    while (n < this.thickness) {
                        graphics.drawRect(n, n, dimension.width - n * 2 - 1, dimension.height - n * 2 - 1);
                        ++n;
                    }
                    break;
                }
                case 1: {
                    int n = 0;
                    while (n < this.thickness) {
                        graphics.draw3DRect(n, n, dimension.width - n * 2 - 1, dimension.height - n * 2 - 1, true);
                        ++n;
                    }
                    break;
                }
                case 2: {
                    int n = 0;
                    while (n < this.thickness) {
                        graphics.draw3DRect(n, n, dimension.width - n * 2 - 1, dimension.height - n * 2 - 1, false);
                        ++n;
                    }
                    break;
                }
                case 3: {
                    graphics.draw3DRect(0, 0, dimension.width - 1, dimension.height - 1, false);
                    graphics.draw3DRect(this.thickness - 1, this.thickness - 1, dimension.width - this.thickness * 2 + 1, dimension.height - this.thickness * 2 + 1, true);
                    break;
                }
                case 4: {
                    graphics.draw3DRect(0, 0, dimension.width - 1, dimension.height - 1, true);
                    graphics.draw3DRect(this.thickness - 1, this.thickness - 1, dimension.width - this.thickness * 2 + 1, dimension.height - this.thickness * 2 + 1, false);
                    break;
                }
            }
        }
        super.paint(graphics);
    }

    public void setInsets(Insets insets) {
        this.insets = insets;
    }
}

