/*
 * Decompiled with CFR 0.152.
 */
package org.w3c.css.parser;

import java.util.Enumeration;
import java.util.Vector;
import org.w3c.css.parser.AtRule;
import org.w3c.css.parser.MediaEnumeration;
import org.w3c.css.properties.css1.CssProperty;
import org.w3c.css.util.ApplContext;
import org.w3c.css.util.InvalidParamException;

public class AtRuleMedia
extends AtRule {
    static final String[] mediaCSS3 = new String[]{"all", "aural", "braille", "embossed", "handheld", "print", "projection", "screen", "tty", "tv", "presentation", "atsc-tv"};
    String restrictor = new String();
    String[] media = new String[mediaCSS3.length];
    String[] originalMedia = new String[mediaCSS3.length];
    Vector mediafeatures = new Vector();
    boolean empty = true;

    public AtRuleMedia addMedia(String medium, ApplContext ac) throws InvalidParamException {
        for (int i = 0; i < mediaCSS3.length; ++i) {
            if (!medium.toLowerCase().equals(mediaCSS3[i])) continue;
            this.media[i] = mediaCSS3[i];
            this.originalMedia[i] = medium;
            this.empty = false;
            return this;
        }
        throw new InvalidParamException("media", medium, ac);
    }

    public void addMediaRestrictor(String restrictor, ApplContext ac) {
        if (restrictor.toUpperCase().equals("ONLY") || restrictor.toUpperCase().equals("NOT")) {
            this.restrictor = restrictor;
        }
    }

    public void addMediaFeature(CssProperty prop) {
        if (prop != null) {
            String expression = prop.getPropertyName();
            if (prop.toString() != null) {
                expression = expression + " : " + prop.toString();
            }
            this.mediafeatures.addElement(expression);
        }
    }

    public String keyword() {
        return "media";
    }

    public boolean isEmpty() {
        return this.empty;
    }

    public boolean canApply(AtRule atRule) {
        if (atRule instanceof AtRuleMedia) {
            AtRuleMedia second = (AtRuleMedia)atRule;
            for (int i = 0; i < this.media.length; ++i) {
                if (this.media[i] == second.media[i]) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public boolean canMatched(AtRule atRule) {
        if (atRule instanceof AtRuleMedia) {
            AtRuleMedia second = (AtRuleMedia)atRule;
            for (int i = 0; i < this.media.length; ++i) {
                if (this.media[i] != second.media[i]) continue;
                return true;
            }
            return false;
        }
        return false;
    }

    public Enumeration elements() {
        return new MediaEnumeration(this);
    }

    public String toString() {
        int i;
        StringBuffer ret = new StringBuffer();
        ret.append('@');
        ret.append(this.keyword());
        ret.append(' ');
        if (!this.restrictor.equals("")) {
            ret.append(this.restrictor);
            ret.append(' ');
        }
        boolean f = true;
        for (i = 0; i < this.media.length; ++i) {
            if (this.originalMedia[i] == null) continue;
            if (!f) {
                ret.append(',');
                ret.append(' ');
            } else {
                f = false;
            }
            ret.append(this.originalMedia[i]);
        }
        for (i = 0; i < this.mediafeatures.size(); ++i) {
            ret.append(" and (");
            ret.append((String)this.mediafeatures.elementAt(i));
            ret.append(')');
        }
        return ret.toString();
    }
}

