<?php

require('password.php');

// config
$access_db_name = "db/log.db";
$access_table_name = "AccessLog";
$card_db_name = "db/cards.db";
$card_table_name = "Cards";

// from http://stackoverflow.com/questions/19271381/
// correctly-determine-if-date-string-is-a-valid-date-in-that-format
function validate_date($date) {
  $d = DateTime::createFromFormat('Y-m-d', $date);
  return $d && $d->format('Y-m-d') === $date;
}

// from php docs
class PiDB extends SQLite3 {
  function __construct($name) {
    $this->open($name);
  }
}

// handle the post request
if (isset($_POST["auth_key"])) {
  // bcrypt hash out in the open, but it's not easily accessible
  // and it's hard to reverse so it should be fine
  $correct_auth_key_hash = "\$2y\$10\$uHVcDHzRFtvY7v4sSyGvIeQt/PvZk82HbwbIW.2.U0ocHDB0bsR5u";

  // make sure the supplied auth key matches
  if (password_verify($_POST["auth_key"], $correct_auth_key_hash)) {
    // validate all the form fields
    $first_name = $_POST["first_name"];
    $last_name = $_POST["last_name"];
    $affiliation = $_POST["affiliation"];
    $exp_date = $_POST["exp_date"];

    if (strlen($first_name) < 1) {
      // bad first name
      echo "Please enter a first name."; 
    } elseif (strlen($last_name) < 1) {
      // bad last name
      echo "Please enter a last name."; 
    } elseif (strlen($affiliation) < 1) {
      // bad affiliation 
      echo "Please enter an affiliation."; 
    } elseif (!validate_date($exp_date)) {
      // bad expiration date
      echo "Please enter a valid date."; 
    } else {

			// get the most recently used card
      $access_db = new PiDB($access_db_name);
      $card = $access_db->query("SELECT Card FROM $access_table_name ORDER BY Date DESC LIMIT 1")->fetchArray()["Card"];

      // add the most recently used card to the cards database
      $card_db = new PiDB($card_db_name);
      $card_db->query("INSERT INTO $card_table_name (Name, Card, Affiliation, ExpireDate) VALUES (\"$first_name" . " " . $last_name . "\", $card, \"$affiliation\", \"$exp_date\")");

			// redirect to the main page
      header("Location: add.php");

    }
  } else {
    echo $_POST["auth_key"] . " is not a valid auth key.<br>";
  }
} else {
  echo "You must supply a valid auth key.";
}

?>

<br>
<br>
<a href="add.php">&larr; back</a>
