/*
 * Decompiled with CFR 0.152.
 */
package org.w3c.css.util;

import org.w3c.css.parser.CssSelectors;
import org.w3c.css.properties.css1.CssProperty;
import org.w3c.css.util.ApplContext;

public class Warning {
    String sourceFile;
    int hashSource;
    int line;
    CssSelectors selector;
    String warningMessage;

    public Warning(String sourceFile, int line, String warningMessage, int level, String message1, String message2, ApplContext ac) {
        this.sourceFile = sourceFile;
        this.hashSource = sourceFile.hashCode() % 100;
        this.line = line;
        this.warningMessage = this.warm(warningMessage, message1, message2, ac);
        this.line = this.getLevel(warningMessage, level, ac) + line * 10;
    }

    public Warning(String sourceFile, int line, String warningMessage, int level, ApplContext ac) {
        this(sourceFile, line, warningMessage, level, "", "", ac);
    }

    public Warning(CssProperty property, String warningMessage, int level, String message1, String message2, ApplContext ac) {
        this.sourceFile = property.getSourceFile();
        if (this.sourceFile != null) {
            this.hashSource = this.sourceFile.hashCode() % 100;
        }
        this.warningMessage = this.warm(warningMessage, message1, message2, ac);
        this.line = this.getLevel(warningMessage, level, ac) + property.getLine() * 10;
    }

    public Warning(CssProperty property, String warningMessage, int level, ApplContext ac) {
        this(property, warningMessage, level, property.getPropertyName(), "", ac);
        this.selector = property.getSelectors();
    }

    public Warning(CssProperty property, String warningMessage, int level, CssProperty property2, ApplContext ac) {
        this(property, warningMessage, level, property.getPropertyName(), property2.getPropertyName(), ac);
        this.selector = property.getSelectors();
    }

    public String getSourceFile() {
        return this.sourceFile;
    }

    public int getLine() {
        return this.line / 10;
    }

    public String getWarningMessage() {
        return this.warningMessage;
    }

    public int getLevel() {
        return this.line % 10;
    }

    public CssSelectors getContext() {
        return this.selector;
    }

    public int getInternalOrder() {
        return this.hashSource * 100000 + this.line;
    }

    public void dump() {
        System.err.println(this.getSourceFile());
        System.err.println(this.getLine());
        System.err.println(this.getWarningMessage());
        System.err.println(this.getLevel());
    }

    private String warm(String warning, String arg1, String arg2, ApplContext ac) {
        String str = ac.getMsg().getWarningString(warning);
        if (str == null) {
            return "can't find the warning message for " + warning;
        }
        int i = 0;
        while ((i = str.indexOf("%s", i)) >= 0) {
            StringBuffer stb = new StringBuffer(str.substring(0, i));
            str = stb.append(arg1).append(str.substring(i + 2)).toString();
            arg1 = arg2;
        }
        return str;
    }

    private int getLevel(String warning, int defaultLevel, ApplContext ac) {
        String str = ac.getMsg().getWarningLevelString(warning);
        if (str == null) {
            return defaultLevel;
        }
        try {
            int level = Integer.parseInt(str);
            if (level > 9 || level < 0) {
                return defaultLevel;
            }
            return level;
        }
        catch (Exception e) {
            return defaultLevel;
        }
    }
}

