/*
 * Decompiled with CFR 0.152.
 */
package org.w3c.css.values;

import org.w3c.css.util.ApplContext;
import org.w3c.css.util.InvalidParamException;
import org.w3c.css.util.Util;
import org.w3c.css.values.CssValue;
import org.w3c.css.values.CssValueFloat;

public class CssAngle
extends CssValue
implements CssValueFloat {
    Float value;
    int unit;
    static String[] units = new String[]{"deg", "grad", "rad"};
    static int[] hash_units;
    static Float defaultValue;

    public CssAngle() {
        this(defaultValue);
    }

    public CssAngle(float v) {
        this(new Float(v));
    }

    public CssAngle(Float angle) {
        this.value = angle;
    }

    public void set(String s, ApplContext ac) throws InvalidParamException {
        int i;
        String unit;
        s = s.toLowerCase();
        int length = s.length();
        if (s.indexOf("grad") == -1) {
            unit = s.substring(length - 3, length);
            this.value = new Float(s.substring(0, length - 3));
        } else {
            unit = "grad";
            this.value = new Float(s.substring(0, length - 4));
        }
        int hash = unit.hashCode();
        for (i = 0; i < units.length; ++i) {
            if (hash != hash_units[i]) continue;
            this.unit = i;
            break;
        }
        if (i > 2) {
            throw new InvalidParamException("unit", unit, ac);
        }
        this.unit = i;
    }

    public Object get() {
        return this.value;
    }

    public float getValue() {
        return this.value.floatValue();
    }

    public String getUnit() {
        return units[this.unit];
    }

    public String toString() {
        if (this.value.floatValue() != 0.0f) {
            return Util.displayFloat(this.value) + this.getUnit();
        }
        return Util.displayFloat(this.value);
    }

    public boolean equals(Object value) {
        return value instanceof CssAngle && this.value.equals(((CssAngle)value).value) && this.unit == ((CssAngle)value).unit;
    }

    private float normalize(float degree) {
        while (degree < 0.0f) {
            degree += 360.0f;
        }
        while (degree > 360.0f) {
            degree -= 360.0f;
        }
        return degree;
    }

    public float getDegree() {
        float angle = this.value.floatValue();
        switch (this.unit) {
            case 0: {
                return this.normalize(angle);
            }
            case 1: {
                return this.normalize(angle * 0.9f);
            }
            case 2: {
                return this.normalize(angle * 57.295776f);
            }
        }
        System.err.println("[ERROR] in org.w3c.css.values.CssAngle");
        System.err.println("[ERROR] Please report (" + this.unit + ")");
        return 0.0f;
    }

    public boolean isDegree() {
        return this.unit == 0;
    }

    public boolean isGradian() {
        return this.unit == 1;
    }

    public boolean isRadian() {
        return this.unit == 2;
    }

    static {
        defaultValue = new Float(0.0f);
        hash_units = new int[units.length];
        for (int i = 0; i < units.length; ++i) {
            CssAngle.hash_units[i] = units[i].hashCode();
        }
    }
}

