/*
 * Decompiled with CFR 0.152.
 */
package org.w3c.jigsaw.admin;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Hashtable;
import java.util.zip.GZIPInputStream;
import org.w3c.jigsaw.admin.AdminReader;
import org.w3c.jigsaw.admin.AdminWriter;
import org.w3c.jigsaw.admin.PlainRemoteResource;
import org.w3c.jigsaw.admin.RemoteAccessException;
import org.w3c.jigsaw.admin.RemoteResource;
import org.w3c.www.http.HttpCredential;
import org.w3c.www.mime.MimeType;
import org.w3c.www.protocol.http.HttpManager;
import org.w3c.www.protocol.http.Reply;
import org.w3c.www.protocol.http.Request;

public class AdminContext {
    public static final boolean debug = false;
    public static MimeType conftype = null;
    protected Hashtable cachedattrs = new Hashtable();
    protected URL server = null;
    protected RemoteResource root = null;
    protected HttpManager http = null;
    protected AdminReader reader = null;
    protected AdminWriter writer = null;
    protected HttpCredential credential = null;

    static {
        try {
            conftype = new MimeType("application/xml;type=jigsaw-config;charset=UTF-8");
        }
        catch (Exception exception) {
            exception.printStackTrace();
            System.exit(1);
        }
    }

    public AdminContext(URL uRL) throws RemoteAccessException {
        this.server = uRL;
        this.http = HttpManager.getManager();
        this.reader = new AdminReader(this);
        this.writer = new AdminWriter();
    }

    public synchronized RemoteResource getAdminResource() throws RemoteAccessException {
        if (this.root == null) {
            this.loadRoot();
        }
        return this.root;
    }

    protected String getContent(Reply reply) {
        try {
            InputStream inputStream = this.getInputStream(reply);
            if (inputStream == null) {
                return null;
            }
            BufferedInputStream bufferedInputStream = new BufferedInputStream(inputStream);
            byte[] byArray = new byte[256];
            StringBuffer stringBuffer = new StringBuffer();
            while (bufferedInputStream.read(byArray, 0, 256) != -1) {
                stringBuffer.append(new String(byArray));
            }
            bufferedInputStream.close();
            return new String(stringBuffer);
        }
        catch (IOException iOException) {
            return null;
        }
    }

    protected InputStream getInputStream(Reply reply) throws IOException {
        if (reply.hasTransferEncoding("gzip")) {
            return new GZIPInputStream(reply.getInputStream());
        }
        return reply.getInputStream();
    }

    public void initialize() throws RemoteAccessException {
        this.loadRoot();
    }

    protected synchronized void loadRoot() throws RemoteAccessException {
        try {
            Request request = this.http.createRequest();
            request.setMethod("LOAD-ROOT");
            request.setURL(this.server);
            request.setValue("TE", "gzip");
            Reply reply = this.runRequest(request);
            this.root = this.reader.readResource(this.server, null, this.getInputStream(reply));
        }
        catch (RemoteAccessException remoteAccessException) {
            throw remoteAccessException;
        }
        catch (Exception exception) {
            this.root = null;
            throw new RemoteAccessException(exception.getMessage());
        }
    }

    public static void main(String[] stringArray) {
        try {
            AdminContext adminContext = new AdminContext(new URL(stringArray[0]));
            adminContext.initialize();
            String string = stringArray[1];
            PlainRemoteResource plainRemoteResource = (PlainRemoteResource)adminContext.root;
            RemoteResource remoteResource = plainRemoteResource;
            int n = 2;
            while (n < stringArray.length) {
                remoteResource = remoteResource.loadResource(stringArray[n]);
                ++n;
            }
            if (string.equals("dump")) {
                ((PlainRemoteResource)remoteResource).dump(System.out);
            } else if (string.equals("list")) {
                if (!remoteResource.isContainer()) {
                    System.out.println("\tnot a container !");
                } else {
                    String[] stringArray2 = remoteResource.enumerateResourceIdentifiers();
                    int n2 = 0;
                    while (n2 < stringArray2.length) {
                        System.out.println("\t" + stringArray2[n2]);
                        ++n2;
                    }
                }
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    protected Reply runRequest(Request request) throws RemoteAccessException {
        if (this.credential != null) {
            request.setAuthorization(this.credential);
        }
        try {
            Reply reply = this.http.runRequest(request);
            MimeType mimeType = reply.getContentType();
            if (reply.getStatus() == 401) {
                this.getInputStream(reply).close();
                throw new RemoteAccessException("Unauthorized");
            }
            if (mimeType == null || mimeType.match(conftype) < 0) {
                String string = this.getContent(reply);
                if (string != null) {
                    throw new RemoteAccessException(string);
                }
                throw new RemoteAccessException("invalid content type");
            }
            return reply;
        }
        catch (RemoteAccessException remoteAccessException) {
            throw remoteAccessException;
        }
        catch (Exception exception) {
            throw new RemoteAccessException(exception.getMessage());
        }
    }

    public void setCredential(HttpCredential httpCredential) {
        this.credential = httpCredential;
    }
}

