/*
 * Decompiled with CFR 0.152.
 */
package org.w3c.jigsaw.filters;

import java.net.URL;
import java.util.Dictionary;
import java.util.Hashtable;
import org.w3c.jigsaw.filters.CacheEntry;
import org.w3c.jigsaw.filters.CacheException;
import org.w3c.jigsaw.http.Reply;
import org.w3c.jigsaw.http.Request;
import org.w3c.util.AsyncLRUList;
import org.w3c.util.LRUList;

class Cache {
    private static final String STATE_NORM_URL = "org.w3c.jigsaw.filters.Cache.normURL";
    private int maxSize;
    private int maxEntries;
    private int size;
    private int defaultMaxAge;
    Dictionary entries;
    LRUList lruList;

    public Cache(int n, int n2, int n3) {
        this.maxSize = n;
        this.maxEntries = n2;
        this.defaultMaxAge = n3;
        this.size = 0;
        this.lruList = new AsyncLRUList();
        this.entries = new Hashtable(20);
    }

    private final synchronized boolean flushLRU() {
        if (this.entries.size() == 0) {
            return false;
        }
        CacheEntry cacheEntry = (CacheEntry)this.lruList.removeTail();
        this.entries.remove(cacheEntry.getURL());
        this.size -= cacheEntry.getSize();
        return true;
    }

    static String getNormalizedURL(Request request) {
        String string = (String)request.getState(STATE_NORM_URL);
        if (string != null) {
            return string;
        }
        URL uRL = request.getURL();
        string = uRL.getFile();
        request.setState(STATE_NORM_URL, string);
        return string;
    }

    public synchronized void remove(Request request) {
        System.out.println("**** Removing from cache");
        CacheEntry cacheEntry = (CacheEntry)this.entries.remove(Cache.getNormalizedURL(request));
        if (cacheEntry == null) {
            return;
        }
        this.lruList.remove(cacheEntry);
    }

    public CacheEntry retrieve(Request request) {
        String string = Cache.getNormalizedURL(request);
        CacheEntry cacheEntry = (CacheEntry)this.entries.get(string);
        return cacheEntry == null ? null : cacheEntry;
    }

    public void store(Request request, Reply reply) throws CacheException {
        System.out.println("**** Storing reply in cache");
        if (this.maxEntries > 0 && this.entries.size() == this.maxEntries) {
            this.flushLRU();
        }
        if (this.maxSize > 0 && reply.hasContentLength()) {
            int n = this.maxSize - reply.getContentLength();
            while (this.entries.size() > n) {
                if (!this.flushLRU()) break;
            }
        }
        CacheEntry cacheEntry = new CacheEntry(request, reply, this.defaultMaxAge);
        Cache cache = this;
        synchronized (cache) {
            this.size += cacheEntry.getSize();
            CacheEntry cacheEntry2 = this.entries.put(cacheEntry.getURL(), cacheEntry);
            if (cacheEntry2 != null) {
                this.lruList.remove(cacheEntry2);
            }
            this.lruList.toHead(cacheEntry);
        }
    }
}

