/*
 * Decompiled with CFR 0.152.
 */
package org.w3c.jigsaw.status;

import java.util.Date;
import org.w3c.jigsaw.frames.HTTPFrame;
import org.w3c.jigsaw.html.HtmlGenerator;
import org.w3c.jigsaw.http.Reply;
import org.w3c.jigsaw.http.Request;
import org.w3c.jigsaw.http.httpd;
import org.w3c.jigsaw.http.httpdStatistics;
import org.w3c.tools.resources.AttributeRegistry;
import org.w3c.tools.resources.FramedResource;
import org.w3c.tools.resources.IntegerAttribute;

public class StatisticsFrame
extends HTTPFrame {
    private static int REFRESH_DEFAULT = 5;
    protected static int ATTR_REFRESH = -1;
    static String time_tbl;
    static String dyn_time_tbl;
    static String sta_time_tbl;

    static {
        IntegerAttribute integerAttribute = null;
        Class<?> clazz = null;
        try {
            clazz = Class.forName("org.w3c.jigsaw.status.StatisticsFrame");
        }
        catch (Exception exception) {
            exception.printStackTrace();
            System.exit(1);
        }
        integerAttribute = new IntegerAttribute("refresh", new Integer(5), 2);
        ATTR_REFRESH = AttributeRegistry.registerAttribute(clazz, integerAttribute);
        time_tbl = "<table border=\"1\" class=\"time\"><caption>Request processing times</caption><tr><th>min<th>avg<th>max</tr><tr>";
        dyn_time_tbl = "<table border=\"1\" class=\"time\"><caption>Dynamic request processing times</caption><tr><th>min<th>avg<th>max</tr><tr>";
        sta_time_tbl = "<table border=\"1\" class=\"time\"><caption>Static request processing times</caption><tr><th>min<th>avg<th>max</tr><tr>";
    }

    public Reply get(Request request) {
        HtmlGenerator htmlGenerator = new HtmlGenerator("Statistics");
        int n = this.getInt(ATTR_REFRESH, REFRESH_DEFAULT);
        if (n > 0) {
            htmlGenerator.addMeta("Refresh", Integer.toString(n));
        }
        this.addStyleSheet(htmlGenerator);
        httpdStatistics httpdStatistics2 = ((httpd)this.getServer()).getStatistics();
        htmlGenerator.append("<h1>Server statistics</h1>");
        long l = httpdStatistics2.getStartTime();
        long l2 = (System.currentTimeMillis() - l) / 1000L;
        htmlGenerator.append("<p>Your server was started on <span class=\"date\">");
        htmlGenerator.append(new Date(l).toString());
        long l3 = l2 / 86400L;
        long l4 = l2 % 86400L;
        long l5 = l4 / 3600L;
        long l6 = l4 % 3600L;
        long l7 = l6 / 60L;
        long l8 = l6 % 60L;
        htmlGenerator.append("</span>\n<p>It has now been running for <span class=\"uptime\">");
        htmlGenerator.append(Long.toString(l3));
        htmlGenerator.append(" days, ");
        htmlGenerator.append(Long.toString(l5));
        htmlGenerator.append(" hours, ");
        htmlGenerator.append(Long.toString(l7));
        htmlGenerator.append(" minutes and ");
        htmlGenerator.append(Long.toString(l8));
        htmlGenerator.append(" seconds.</span>\n");
        long l9 = httpdStatistics2.getHitCount();
        long l10 = httpdStatistics2.getDynamicHitCount();
        long l11 = httpdStatistics2.getStaticHitCount();
        float f = 0.0f;
        float f2 = 0.0f;
        if (l9 > 0L) {
            f = (float)l11 / (float)l9 * 100.0f;
            f2 = (float)l10 / (float)l9 * 100.0f;
        }
        htmlGenerator.append("<ul><li>hits: ", Long.toString(l9));
        htmlGenerator.append("  <ul>\n    <li>static: ", Long.toString(l11));
        htmlGenerator.append(" (", Float.toString(f));
        htmlGenerator.append("%)</li>\n    <li>dynamic: ", Long.toString(l10));
        htmlGenerator.append(" (", Float.toString(f2));
        htmlGenerator.append("%)</li>\n  </ul>\n");
        long l12 = httpdStatistics2.getEmittedBytes();
        long l13 = l12 / 1024L;
        long l14 = l13 / 1024L;
        long l15 = l14 / 1024L;
        long l16 = l15 / 1024L;
        if (l16 != 0L) {
            htmlGenerator.append("</li>\n<li>bytes: ", Long.toString(l16), "Tb, ");
            htmlGenerator.append(Long.toString(l15 % 1024L), "Gb, ");
            htmlGenerator.append(Long.toString(l14 % 1024L), "Mb, ");
            htmlGenerator.append(Long.toString(l13 % 1024L), "Kb, ");
            htmlGenerator.append(Long.toString(l12 % 1024L));
        } else if (l15 != 0L) {
            htmlGenerator.append("</li>\n<li>bytes: ", Long.toString(l15), "Gb, ");
            htmlGenerator.append(Long.toString(l14 % 1024L), "Mb, ");
            htmlGenerator.append(Long.toString(l13 % 1024L), "Kb, ");
            htmlGenerator.append(Long.toString(l12 % 1024L));
        } else if (l14 != 0L) {
            htmlGenerator.append("</li>\n<li>bytes: ", Long.toString(l14), "Mb, ");
            htmlGenerator.append(Long.toString(l13 % 1024L), "Kb, ");
            htmlGenerator.append(Long.toString(l12 % 1024L));
        } else if (l13 != 0L) {
            htmlGenerator.append("</li>\n<li>bytes: ", Long.toString(l13), "Kb, ");
            htmlGenerator.append(Long.toString(l12 % 1024L));
        } else {
            htmlGenerator.append("</li>\n<li>bytes: ", Long.toString(l12));
        }
        float f3 = 0.0f;
        float f4 = 0.0f;
        if (l2 > 0L) {
            f3 = (float)l9 / (float)l2;
            f4 = (float)l9 * 86400.0f / (float)l2;
        }
        htmlGenerator.append("</li>\n<li>Average hits per second: ", Float.toString(f3));
        htmlGenerator.append("</li>\n<li>Average hits per day: ", Float.toString(f4));
        long l17 = l9 > 0L ? l12 / l9 : 0L;
        l13 = l17 / 1024L;
        l14 = l13 / 1024L;
        l15 = l14 / 1024L;
        if (l15 != 0L) {
            htmlGenerator.append("</li>\n<li>Average bytes per hit: ");
            htmlGenerator.append(Long.toString(l15), "Gb, ");
            htmlGenerator.append(Long.toString(l14 % 1024L), "Mb, ");
            htmlGenerator.append(Long.toString(l13 % 1024L), "Kb, ");
            htmlGenerator.append(Long.toString(l17 % 1024L));
        } else if (l14 != 0L) {
            htmlGenerator.append("</li>\n<li>Average bytes per hit: ");
            htmlGenerator.append(Long.toString(l14), "Mb, ");
            htmlGenerator.append(Long.toString(l13 % 1024L), "Kb, ");
            htmlGenerator.append(Long.toString(l17 % 1024L));
        } else if (l13 != 0L) {
            htmlGenerator.append("</li>\n<li>Average bytes per hit: ");
            htmlGenerator.append(Long.toString(l13), "Kb, ");
            htmlGenerator.append(Long.toString(l17 % 1024L));
        } else {
            htmlGenerator.append("</li>\n<li>Average bytes per hit: ", Long.toString(l17));
        }
        long l18 = 0L;
        if (l2 > 0L) {
            l18 = l12 / l2;
        }
        if ((l15 = (l14 = (l13 = l18 / 1024L) / 1024L) / 1024L) != 0L) {
            htmlGenerator.append("</li>\n<li>Average bytes per second: ");
            htmlGenerator.append(Long.toString(l15), "Gb, ");
            htmlGenerator.append(Long.toString(l14 % 1024L), "Mb, ");
            htmlGenerator.append(Long.toString(l13 % 1024L), "Kb, ");
            htmlGenerator.append(Long.toString(l18 % 1024L));
        } else if (l14 != 0L) {
            htmlGenerator.append("</li>\n<li>Average bytes per second: ");
            htmlGenerator.append(Long.toString(l14), "Mb, ");
            htmlGenerator.append(Long.toString(l13 % 1024L), "Kb, ");
            htmlGenerator.append(Long.toString(l18 % 1024L));
        } else if (l13 != 0L) {
            htmlGenerator.append("</li>\n<li>Average bytes per second: ");
            htmlGenerator.append(Long.toString(l13), "Kb, ");
            htmlGenerator.append(Long.toString(l18 % 1024L));
        } else {
            htmlGenerator.append("</li>\n<li>Average bytes per second: ", Long.toString(l18));
        }
        htmlGenerator.append("</li>\n</ul>");
        htmlGenerator.append(time_tbl);
        htmlGenerator.append("<td>", Long.toString(httpdStatistics2.getMinRequestTime()), " <span class=\"unit\">ms</span>");
        htmlGenerator.append("</td>\n<td>", Long.toString(httpdStatistics2.getMeanRequestTime()), " <span class=\"unit\">ms</span>");
        htmlGenerator.append("</td>\n<td>", Long.toString(httpdStatistics2.getMaxRequestTime()), " <span class=\"unit\">ms</span>");
        htmlGenerator.append("</td>\n</table>\n");
        if (l11 > 0L) {
            htmlGenerator.append(sta_time_tbl);
            htmlGenerator.append("<td>", Long.toString(httpdStatistics2.getMinStaticRequestTime()), " <span class=\"unit\">ms</span>");
            htmlGenerator.append("</td>\n<td>", Long.toString(httpdStatistics2.getMeanStaticRequestTime()), " <span class=\"unit\">ms</span>");
            htmlGenerator.append("</td>\n<td>", Long.toString(httpdStatistics2.getMaxStaticRequestTime()), " <span class=\"unit\">ms</span>");
            htmlGenerator.append("</td>\n</table>\n");
        }
        if (l10 > 0L) {
            htmlGenerator.append(dyn_time_tbl);
            htmlGenerator.append("<td>", Long.toString(httpdStatistics2.getMinDynamicRequestTime()), " <span class=\"unit\">ms</span>");
            htmlGenerator.append("</td>\n<td>", Long.toString(httpdStatistics2.getMeanDynamicRequestTime()), " <span class=\"unit\">ms</span>");
            htmlGenerator.append("</td>\n<td>", Long.toString(httpdStatistics2.getMaxDynamicRequestTime()), " <span class=\"unit\">ms</span>");
            htmlGenerator.append("</td>\n</table>\n");
        }
        try {
            htmlGenerator.append(((httpd)this.getServer()).getHTMLStatus());
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        Reply reply = request.makeReply(200);
        reply.setNoCache();
        reply.setStream(htmlGenerator);
        reply.setDynamic(true);
        return reply;
    }

    public void registerResource(FramedResource framedResource) {
        super.registerOtherResource(framedResource);
    }
}

