/*
 * Decompiled with CFR 0.152.
 */
package org.w3c.www.http;

import org.w3c.www.http.HeaderValue;
import org.w3c.www.http.HttpContentRange;
import org.w3c.www.http.HttpDate;
import org.w3c.www.http.HttpEntityTag;
import org.w3c.www.http.HttpInteger;
import org.w3c.www.http.HttpMessage;
import org.w3c.www.http.HttpMimeType;
import org.w3c.www.http.HttpString;
import org.w3c.www.http.HttpTokenList;
import org.w3c.www.mime.MimeParser;
import org.w3c.www.mime.MimeType;

public class HttpEntityMessage
extends HttpMessage {
    public static int H_ALLOW = 19;
    public static int H_CONTENT_LENGTH = 20;
    public static int H_CONTENT_BASE = 21;
    public static int H_CONTENT_ENCODING = 22;
    public static int H_CONTENT_LANGUAGE = 23;
    public static int H_CONTENT_LOCATION = 24;
    public static int H_CONTENT_MD5 = 25;
    public static int H_CONTENT_RANGE = 26;
    public static int H_CONTENT_TYPE = 27;
    public static int H_ETAG = 28;
    public static int H_EXPIRES = 29;
    public static int H_LAST_MODIFIED = 30;

    static {
        HttpMessage.registerHeader("Allow", "org.w3c.www.http.HttpTokenList", H_ALLOW);
        HttpMessage.registerHeader("Content-Length", "org.w3c.www.http.HttpInteger", H_CONTENT_LENGTH);
        HttpMessage.registerHeader("Content-Base", "org.w3c.www.http.HttpString", H_CONTENT_BASE);
        HttpMessage.registerHeader("Content-Encoding", "org.w3c.www.http.HttpTokenList", H_CONTENT_ENCODING);
        HttpMessage.registerHeader("Content-Language", "org.w3c.www.http.HttpTokenList", H_CONTENT_LANGUAGE);
        HttpMessage.registerHeader("Content-Location", "org.w3c.www.http.HttpString", H_CONTENT_LOCATION);
        HttpMessage.registerHeader("Content-Md5", "org.w3c.www.http.HttpString", H_CONTENT_MD5);
        HttpMessage.registerHeader("Content-Range", "org.w3c.www.http.HttpContentRange", H_CONTENT_RANGE);
        HttpMessage.registerHeader("Content-Type", "org.w3c.www.http.HttpMimeType", H_CONTENT_TYPE);
        HttpMessage.registerHeader("Etag", "org.w3c.www.http.HttpEntityTag", H_ETAG);
        HttpMessage.registerHeader("Expires", "org.w3c.www.http.HttpDate", H_EXPIRES);
        HttpMessage.registerHeader("Last-Modified", "org.w3c.www.http.HttpDate", H_LAST_MODIFIED);
    }

    public HttpEntityMessage() {
    }

    public HttpEntityMessage(MimeParser mimeParser) {
        super(mimeParser);
    }

    public void addContentEncoding(String string) {
        HttpTokenList httpTokenList = (HttpTokenList)this.getHeaderValue(H_CONTENT_ENCODING);
        if (httpTokenList == null) {
            String[] stringArray = new String[]{string.toLowerCase()};
            this.setHeaderValue(H_CONTENT_ENCODING, (HeaderValue)new HttpTokenList(stringArray));
        } else {
            httpTokenList.addToken(string, false);
        }
    }

    public String[] getAllow() {
        HeaderValue headerValue = this.getHeaderValue(H_ALLOW);
        return headerValue != null ? (String[])headerValue.getValue() : null;
    }

    public String getContentBase() {
        HeaderValue headerValue = this.getHeaderValue(H_CONTENT_BASE);
        return headerValue != null ? (String)headerValue.getValue() : null;
    }

    public String[] getContentEncoding() {
        HeaderValue headerValue = this.getHeaderValue(H_CONTENT_ENCODING);
        return headerValue != null ? (String[])headerValue.getValue() : null;
    }

    public String[] getContentLanguage() {
        HeaderValue headerValue = this.getHeaderValue(H_CONTENT_LANGUAGE);
        return headerValue != null ? (String[])headerValue.getValue() : null;
    }

    public int getContentLength() {
        HeaderValue headerValue = this.getHeaderValue(H_CONTENT_LENGTH);
        return headerValue != null ? (Integer)headerValue.getValue() : -1;
    }

    public String getContentLocation() {
        HeaderValue headerValue = this.getHeaderValue(H_CONTENT_LOCATION);
        return headerValue != null ? (String)headerValue.getValue() : null;
    }

    public String getContentMD5() {
        HeaderValue headerValue = this.getHeaderValue(H_CONTENT_MD5);
        return headerValue != null ? (String)headerValue.getValue() : null;
    }

    public HttpContentRange getContentRange() {
        HeaderValue headerValue = this.getHeaderValue(H_CONTENT_RANGE);
        return headerValue != null ? (HttpContentRange)headerValue.getValue() : null;
    }

    public MimeType getContentType() {
        HeaderValue headerValue = this.getHeaderValue(H_CONTENT_TYPE);
        return headerValue != null ? (MimeType)headerValue.getValue() : null;
    }

    public HttpEntityTag getETag() {
        HeaderValue headerValue = this.getHeaderValue(H_ETAG);
        return headerValue != null ? (HttpEntityTag)headerValue.getValue() : null;
    }

    public long getExpires() {
        HeaderValue headerValue = this.getHeaderValue(H_EXPIRES);
        return headerValue != null ? (Long)headerValue.getValue() : -1L;
    }

    public long getLastModified() {
        HeaderValue headerValue = this.getHeaderValue(H_LAST_MODIFIED);
        return headerValue != null ? (Long)headerValue.getValue() : -1L;
    }

    public boolean hasContentRange() {
        return this.hasHeader(H_CONTENT_RANGE);
    }

    public void setAllow(String[] stringArray) {
        this.setHeaderValue(H_ALLOW, (HeaderValue)(stringArray == null ? null : new HttpTokenList(stringArray)));
    }

    public void setContentBase(String string) {
        this.setHeaderValue(H_CONTENT_BASE, (HeaderValue)(string == null ? null : new HttpString(true, string)));
    }

    public void setContentEncoding(String[] stringArray) {
        this.setHeaderValue(H_CONTENT_ENCODING, (HeaderValue)(stringArray == null ? null : new HttpTokenList(stringArray)));
    }

    public void setContentLanguage(String[] stringArray) {
        this.setHeaderValue(H_CONTENT_LANGUAGE, (HeaderValue)(stringArray == null ? null : new HttpTokenList(stringArray)));
    }

    public void setContentLength(int n) {
        if (n < 0) {
            this.setHeaderValue(H_CONTENT_LENGTH, null);
        } else {
            this.setHeaderValue(H_CONTENT_LENGTH, (HeaderValue)new HttpInteger(true, n));
        }
    }

    public void setContentLocation(String string) {
        this.setHeaderValue(H_CONTENT_LOCATION, (HeaderValue)(string == null ? null : new HttpString(true, string)));
    }

    public void setContentMD5(String string) {
        this.setHeaderValue(H_CONTENT_MD5, (HeaderValue)(string == null ? null : new HttpString(true, string)));
    }

    public void setContentType(MimeType mimeType) {
        this.setHeaderValue(H_CONTENT_TYPE, (HeaderValue)(mimeType == null ? null : new HttpMimeType(true, mimeType)));
    }

    public void setETag(HttpEntityTag httpEntityTag) {
        this.setHeaderValue(H_ETAG, (HeaderValue)httpEntityTag);
    }

    public void setExpires(long l) {
        this.setHeaderValue(H_EXPIRES, (HeaderValue)(l == -1L ? null : new HttpDate(true, l)));
    }

    public void setLastModified(long l) {
        this.setHeaderValue(H_LAST_MODIFIED, (HeaderValue)(l == -1L ? null : new HttpDate(true, l)));
    }
}

