/*
 * Decompiled with CFR 0.152.
 */
package org.w3c.www.http;

import org.w3c.www.http.BasicValue;
import org.w3c.www.http.HttpBuffer;
import org.w3c.www.http.HttpParser;
import org.w3c.www.http.HttpParserException;
import org.w3c.www.http.HttpRangeList;
import org.w3c.www.http.ParseState;

public class HttpRange
extends BasicValue {
    protected int firstpos = -1;
    protected int lastpos = -1;
    protected String unit = null;
    protected HttpRangeList list = null;

    public HttpRange() {
        this.isValid = false;
    }

    HttpRange(HttpRangeList httpRangeList, byte[] byArray, int n, int n2) {
        this.list = httpRangeList;
        this.raw = byArray;
        this.roff = n;
        this.rlen = n2;
        this.isValid = false;
    }

    HttpRange(boolean bl, String string, int n, int n2) {
        this.isValid = bl;
        this.setUnit(string);
        this.setFirstPosition(n);
        this.setLastPosition(n2);
    }

    public int getFirstPosition() {
        this.validate();
        return this.firstpos;
    }

    public int getLastPosition() {
        this.validate();
        return this.lastpos;
    }

    public String getUnit() {
        this.validate();
        return this.unit;
    }

    public Object getValue() {
        this.validate();
        return this;
    }

    protected void invalidateByteValue() {
        super.invalidateByteValue();
        if (this.list != null) {
            this.list.invalidateByteValue();
        }
    }

    protected void parse() throws HttpParserException {
        ParseState parseState = new ParseState(this.roff, this.rlen);
        ParseState parseState2 = new ParseState();
        parseState.separator = (byte)61;
        if (HttpParser.nextItem(this.raw, parseState) < 0) {
            this.error("No byte range unit.");
        }
        this.unit = parseState.toString(this.raw, true);
        parseState.prepare();
        int n = HttpParser.skipSpaces(this.raw, parseState);
        if (this.raw[n] == 45) {
            parseState.ioff = ++n;
            this.firstpos = -1;
            this.lastpos = HttpParser.parseInt(this.raw, parseState);
        } else {
            parseState.separator = (byte)45;
            if (HttpParser.nextItem(this.raw, parseState) < 0) {
                this.error("Invalid range spec: no first pos.");
            }
            parseState2.prepare(parseState);
            this.firstpos = HttpParser.parseInt(this.raw, parseState2);
            parseState.prepare();
            if (HttpParser.nextItem(this.raw, parseState) >= 0) {
                parseState2.prepare(parseState);
                this.lastpos = HttpParser.parseInt(this.raw, parseState2);
            }
        }
    }

    public void setFirstPosition(int n) {
        if (this.firstpos != n) {
            this.invalidateByteValue();
        }
        this.firstpos = n;
    }

    public void setLastPosition(int n) {
        if (this.lastpos != n) {
            this.invalidateByteValue();
        }
        this.lastpos = n;
    }

    public void setUnit(String string) {
        this.invalidateByteValue();
        this.unit = string;
    }

    protected void updateByteValue() {
        HttpBuffer httpBuffer = new HttpBuffer();
        httpBuffer.append(this.unit);
        httpBuffer.append((byte)61);
        if (this.firstpos >= 0) {
            httpBuffer.appendInt(this.firstpos);
        } else if (this.lastpos < 0) {
            httpBuffer.append((byte)48);
        }
        httpBuffer.append('-');
        if (this.lastpos >= 0) {
            httpBuffer.appendInt(this.lastpos);
        }
        this.raw = httpBuffer.getByteCopy();
        this.roff = 0;
        this.rlen = this.raw.length;
    }
}

