/*
 * Decompiled with CFR 0.152.
 */
package org.w3c.www.mux.tests;

import java.io.BufferedOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import org.w3c.www.mux.MuxSession;
import org.w3c.www.mux.MuxStream;

class MuxFetcher
extends Thread {
    MuxSession ses = null;
    DataOutputStream out = null;
    InputStream in = null;
    URL u = null;
    OutputStream dst = null;

    MuxFetcher(MuxStream muxStream, URL uRL) throws IOException {
        this(muxStream, uRL, null);
    }

    MuxFetcher(MuxStream muxStream, URL uRL, OutputStream outputStream) throws IOException {
        this.ses = muxStream.connect(80);
        this.dst = outputStream;
        this.u = uRL;
        this.start();
    }

    public void copy(URL uRL, OutputStream outputStream) throws IOException {
        this.request(uRL);
        byte[] byArray = new byte[1024];
        int n = -1;
        while ((n = this.in.read(byArray, 0, byArray.length)) > 0) {
            outputStream.write(byArray, 0, n);
        }
    }

    public void dump(URL uRL) throws IOException {
        this.request(uRL);
        byte[] byArray = new byte[1024];
        int n = -1;
        while ((n = this.in.read(byArray, 0, byArray.length)) > 0) {
            System.out.print(new String(byArray, 0, 0, n));
        }
        System.out.println("Dumped all available data !");
    }

    public void request(URL uRL) throws IOException {
        this.out.writeBytes("GET " + uRL + " HTTP/1.1\r\n");
        this.out.writeBytes("Connection: close\r\n\r\n");
        this.out.flush();
    }

    public void run() {
        try {
            this.out = new DataOutputStream(new BufferedOutputStream(this.ses.getOutputStream()));
            this.in = this.ses.getInputStream();
            if (this.dst != null) {
                this.copy(this.u, this.dst);
            } else {
                this.dump(this.u);
            }
            this.ses.shutdown();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }
}

