/*
 * Decompiled with CFR 0.152.
 */
package org.w3c.www.webdav;

import org.w3c.www.http.HttpInvalidValueException;
import org.w3c.www.webdav.ParseState;

public class DAVParser {
    private static final boolean debug = false;

    public static final String decodeETag(String string) throws HttpInvalidValueException {
        int n = string.indexOf(91);
        int n2 = string.indexOf(93);
        if (n == -1 || n2 == -1) {
            throw new HttpInvalidValueException(string);
        }
        return string.substring(n + 1, n2);
    }

    public static final String decodeURL(String string) throws HttpInvalidValueException {
        int n = string.indexOf(60);
        int n2 = string.indexOf(62);
        if (n == -1 || n2 == -1) {
            throw new HttpInvalidValueException(string);
        }
        return string.substring(n + 1, n2);
    }

    protected static void error(String string, String string2) throws HttpInvalidValueException {
        throw new HttpInvalidValueException(String.valueOf(string) + ": " + string2);
    }

    public static final int nextItem(byte[] byArray, ParseState parseState) {
        int n = -1;
        int n2 = -1;
        parseState.start = parseState.isSkipable ? (n = DAVParser.skipSpaces(byArray, parseState)) : (n = parseState.ioff);
        int n3 = n2 = parseState.bufend > 0 ? parseState.bufend : byArray.length;
        if (n >= n2) {
            return -1;
        }
        parseState.start = n;
        block0: while (n < n2) {
            if (byArray[n] == 34) {
                ++n;
                while (n < n2) {
                    if (byArray[n] == 92) {
                        n += 2;
                        continue;
                    }
                    if (byArray[n] == 34) {
                        ++n;
                        continue block0;
                    }
                    ++n;
                }
                if (n == n2) {
                    DAVParser.error("nextItem", "Un-terminated quoted item.");
                }
            } else if (byArray[n] == parseState.separator || parseState.spaceIsSep && (byArray[n] == 32 || byArray[n] == 9)) break;
            ++n;
        }
        parseState.end = n;
        if (parseState.isSkipable) {
            parseState.ioff = n;
            parseState.ooff = DAVParser.skipSpaces(byArray, parseState);
        }
        if (parseState.ooff < parseState.bufend && byArray[parseState.ooff] == parseState.separator) {
            ++parseState.ooff;
        }
        return parseState.end > parseState.start ? parseState.start : -1;
    }

    public static final int skipSpaces(byte[] byArray, ParseState parseState) {
        int n = parseState.bufend > 0 ? parseState.bufend : byArray.length;
        int n2 = parseState.ioff;
        while (n2 < n) {
            if (byArray[n2] != 32 && byArray[n2] != 9 && byArray[n2] != parseState.separator) {
                parseState.ioff = n2;
                return n2;
            }
            ++n2;
        }
        return n2;
    }

    public static final boolean startsWith(byte[] byArray, ParseState parseState, char c) {
        return byArray[parseState.start] == (byte)c;
    }
}

