/*
 * Decompiled with CFR 0.152.
 */
package org.w3c.jigsaw.auth;

import java.net.InetAddress;
import java.util.Enumeration;
import org.w3c.jigsaw.auth.AuthFilter;
import org.w3c.jigsaw.auth.AuthRealm;
import org.w3c.jigsaw.auth.AuthUser;
import org.w3c.jigsaw.auth.BasicAuthContext;
import org.w3c.jigsaw.auth.BasicAuthContextException;
import org.w3c.jigsaw.auth.IPMatcher;
import org.w3c.jigsaw.auth.RealmsCatalog;
import org.w3c.jigsaw.html.HtmlGenerator;
import org.w3c.jigsaw.http.Client;
import org.w3c.jigsaw.http.HTTPException;
import org.w3c.jigsaw.http.Reply;
import org.w3c.jigsaw.http.Request;
import org.w3c.jigsaw.http.httpd;
import org.w3c.tools.resources.AttributeRegistry;
import org.w3c.tools.resources.FramedResource;
import org.w3c.tools.resources.InvalidResourceException;
import org.w3c.tools.resources.ProtocolException;
import org.w3c.tools.resources.ResourceReference;
import org.w3c.tools.resources.StringArrayAttribute;
import org.w3c.www.http.HttpChallenge;
import org.w3c.www.http.HttpFactory;
import org.w3c.www.http.HttpReplyMessage;

public class GenericAuthFilter
extends AuthFilter {
    protected static int ATTR_ALLOWED_USERS = -1;
    protected static int ATTR_ALLOWED_GROUPS = -1;
    protected IPMatcher ipmatcher = null;
    protected RealmsCatalog catalog = null;
    protected ResourceReference rr_realm = null;
    protected String loaded_realm = null;
    protected HttpChallenge challenge = null;

    static {
        StringArrayAttribute stringArrayAttribute = null;
        Class<?> clazz = null;
        try {
            clazz = Class.forName("org.w3c.jigsaw.auth.GenericAuthFilter");
        }
        catch (Exception exception) {
            exception.printStackTrace();
            System.exit(1);
        }
        stringArrayAttribute = new StringArrayAttribute("users", null, 2);
        ATTR_ALLOWED_USERS = AttributeRegistry.registerAttribute(clazz, stringArrayAttribute);
        stringArrayAttribute = new StringArrayAttribute("groups", null, 2);
        ATTR_ALLOWED_GROUPS = AttributeRegistry.registerAttribute(clazz, stringArrayAttribute);
    }

    protected synchronized void acquireRealm() {
        Object object;
        if (this.catalog == null) {
            object = (httpd)((FramedResource)this.getTargetResource()).getServer();
            this.catalog = ((httpd)object).getRealmsCatalog();
        }
        if ((object = this.getRealm()) == null) {
            return;
        }
        if (this.rr_realm != null && ((String)object).equals(this.loaded_realm)) {
            return;
        }
        this.rr_realm = this.catalog.loadRealm((String)object);
        if (this.rr_realm != null) {
            try {
                try {
                    AuthRealm authRealm = (AuthRealm)this.rr_realm.lock();
                    Enumeration enumeration = authRealm.enumerateUserNames();
                    if (enumeration.hasMoreElements()) {
                        this.ipmatcher = new IPMatcher();
                    }
                    while (enumeration.hasMoreElements()) {
                        Object var9_6;
                        String string = (String)enumeration.nextElement();
                        ResourceReference resourceReference = authRealm.loadUser(string);
                        try {
                            try {
                                AuthUser authUser = (AuthUser)resourceReference.lock();
                                short[][] sArray = authUser.getIPTemplates();
                                if (sArray != null) {
                                    int n = 0;
                                    while (n < sArray.length) {
                                        this.ipmatcher.add(sArray[n], resourceReference);
                                        ++n;
                                    }
                                }
                            }
                            catch (InvalidResourceException invalidResourceException) {
                                System.out.println("Invalid user reference : " + string);
                            }
                            var9_6 = null;
                            resourceReference.unlock();
                        }
                        catch (Throwable throwable) {
                            var9_6 = null;
                            resourceReference.unlock();
                            throw throwable;
                        }
                    }
                }
                catch (InvalidResourceException invalidResourceException) {
                }
                Object var3_11 = null;
                this.rr_realm.unlock();
            }
            catch (Throwable throwable) {
                Object var3_12 = null;
                this.rr_realm.unlock();
                throw throwable;
            }
        }
    }

    public void authenticate(Request request) throws ProtocolException {
        Object object;
        HtmlGenerator htmlGenerator;
        AuthUser authUser;
        if (!this.checkRealm()) {
            return;
        }
        Client client = request.getClient();
        if (client == null) {
            return;
        }
        boolean bl = false;
        ResourceReference resourceReference = this.lookupUser(client.getInetAddress());
        if (resourceReference != null) {
            try {
                try {
                    authUser = (AuthUser)resourceReference.lock();
                    if (authUser != null) {
                        bl = true;
                        if (!authUser.definesAttribute("password") && this.checkUser(authUser)) {
                            request.setState("org.w3c.jigsaw.auth.AuthFilter.user", authUser.getName());
                            request.setState("org.w3c.jigsaw.auth.AuthFilter.type", "ip");
                            Object var6_6 = null;
                            resourceReference.unlock();
                            return;
                        }
                    }
                }
                catch (InvalidResourceException invalidResourceException) {
                }
            }
            catch (Throwable throwable) {
                Object var6_8 = null;
                resourceReference.unlock();
                throw throwable;
            }
            htmlGenerator = null;
            resourceReference.unlock();
        }
        if (request.hasAuthorization() && !request.isProxy() || request.isProxy() && request.hasProxyAuthorization()) {
            object = null;
            try {
                object = new BasicAuthContext(request);
            }
            catch (BasicAuthContextException basicAuthContextException) {
                object = null;
            }
            if (object != null && (resourceReference = this.checkBasicAuth((BasicAuthContext)object)) != null) {
                try {
                    try {
                        boolean bl2;
                        AuthUser authUser2 = (AuthUser)resourceReference.lock();
                        if (authUser2 != null && this.checkUser(authUser2) && (!(bl2 = authUser2.definesAttribute("ipaddress")) || bl)) {
                            request.setState("org.w3c.jigsaw.auth.AuthFilter.user", ((BasicAuthContext)object).user);
                            request.setState("org.w3c.jigsaw.auth.AuthFilter.type", "Basic");
                            authUser = null;
                            resourceReference.unlock();
                            return;
                        }
                    }
                    catch (InvalidResourceException invalidResourceException) {
                    }
                }
                catch (Throwable throwable) {
                    authUser = null;
                    resourceReference.unlock();
                    throw throwable;
                }
                authUser = null;
                resourceReference.unlock();
            }
        }
        object = null;
        if (request.isProxy()) {
            object = request.makeReply(407);
            ((HttpReplyMessage)object).setProxyAuthenticate(this.challenge);
        } else {
            object = request.makeReply(401);
            ((HttpReplyMessage)object).setWWWAuthenticate(this.challenge);
        }
        htmlGenerator = new HtmlGenerator("Unauthorized");
        htmlGenerator.append("<h1>Unauthorized access</h1><p>You are denied access to this resource.");
        ((Reply)object).setStream(htmlGenerator);
        throw new HTTPException((Reply)object);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected ResourceReference checkBasicAuth(BasicAuthContext basicAuthContext) {
        ResourceReference resourceReference;
        ResourceReference resourceReference2;
        block8: {
            ResourceReference resourceReference3;
            block7: {
                resourceReference2 = this.lookupUser(basicAuthContext.user);
                if (resourceReference2 == null) {
                    return null;
                }
                try {
                    try {
                        AuthUser authUser = (AuthUser)resourceReference2.lock();
                        if (authUser == null) {
                            ResourceReference resourceReference4 = null;
                            Object var5_8 = null;
                            resourceReference2.unlock();
                            return resourceReference4;
                        }
                        if (!authUser.definesAttribute("password")) {
                            resourceReference3 = resourceReference2;
                            break block7;
                        }
                        resourceReference = authUser.getPassword().equals(basicAuthContext.password) ? resourceReference2 : null;
                        break block8;
                    }
                    catch (InvalidResourceException invalidResourceException) {
                        ResourceReference resourceReference5 = null;
                        Object var5_11 = null;
                        resourceReference2.unlock();
                        return resourceReference5;
                    }
                }
                catch (Throwable throwable) {
                    Object var5_12 = null;
                    resourceReference2.unlock();
                    throw throwable;
                }
            }
            Object var5_9 = null;
            resourceReference2.unlock();
            return resourceReference3;
        }
        Object var5_10 = null;
        resourceReference2.unlock();
        return resourceReference;
    }

    protected synchronized boolean checkRealm() {
        this.acquireRealm();
        return this.ipmatcher != null;
    }

    protected boolean checkUser(AuthUser authUser) {
        String[] stringArray;
        String[] stringArray2;
        String[] stringArray3 = this.getAllowedUsers();
        if (stringArray3 != null) {
            int n = 0;
            while (n < stringArray3.length) {
                if (stringArray3[n].equals(authUser.getName())) {
                    return true;
                }
                ++n;
            }
        }
        if ((stringArray2 = this.getAllowedGroups()) != null && (stringArray = authUser.getGroups()) != null) {
            int n = 0;
            while (n < stringArray.length) {
                int n2 = 0;
                while (n2 < stringArray2.length) {
                    if (stringArray2[n2].equals(stringArray[n])) {
                        return true;
                    }
                    ++n2;
                }
                ++n;
            }
        }
        return stringArray3 == null && stringArray2 == null;
    }

    public String[] getAllowedGroups() {
        return (String[])this.getValue(ATTR_ALLOWED_GROUPS, null);
    }

    public String[] getAllowedUsers() {
        return (String[])this.getValue(ATTR_ALLOWED_USERS, null);
    }

    public void initialize(Object[] objectArray) {
        super.initialize(objectArray);
        if (this.getRealm() != null) {
            this.challenge = HttpFactory.makeChallenge("Basic");
            this.challenge.setAuthParameter("realm", this.getRealm());
        }
    }

    public synchronized ResourceReference lookupUser(String string) {
        if (this.rr_realm == null) {
            this.acquireRealm();
        }
        try {
            try {
                AuthRealm authRealm = (AuthRealm)this.rr_realm.lock();
                ResourceReference resourceReference = authRealm.loadUser(string);
                Object var4_5 = null;
                this.rr_realm.unlock();
                return resourceReference;
            }
            catch (InvalidResourceException invalidResourceException) {
                ResourceReference resourceReference = null;
                Object var4_6 = null;
                this.rr_realm.unlock();
                return resourceReference;
            }
        }
        catch (Throwable throwable) {
            Object var4_7 = null;
            this.rr_realm.unlock();
            throw throwable;
        }
    }

    public synchronized ResourceReference lookupUser(InetAddress inetAddress) {
        if (this.ipmatcher == null) {
            this.acquireRealm();
        }
        return (ResourceReference)this.ipmatcher.lookup(inetAddress.getAddress());
    }

    public void setValue(int n, Object object) {
        super.setValue(n, object);
        if (n == AuthFilter.ATTR_REALM) {
            this.challenge = HttpFactory.makeChallenge("Basic");
            this.challenge.setAuthParameter("realm", this.getRealm());
        }
    }
}

