/*
 * Decompiled with CFR 0.152.
 */
package org.w3c.jigsaw.http;

public class httpdSecurityManager
extends SecurityManager {
    public static final String SM_AGENT_ACCEPT_P = "org.w3c.jigsaw.security.agent.accept";
    public static final String SM_AGENT_WRITE_P = "org.w3c.jigsaw.security.write";
    public static final String SM_DEBUG_P = "org.w3c.jigsaw.debug";
    private static boolean debug = false;
    private static boolean agent_accept = false;
    private static boolean agent_write = false;

    static {
        agent_accept = Boolean.getBoolean(SM_AGENT_ACCEPT_P);
        agent_write = Boolean.getBoolean(SM_AGENT_WRITE_P);
        debug = Boolean.getBoolean(SM_DEBUG_P);
    }

    public void checkAccept(String string, int n) {
        if (debug) {
            this.trace("checkAccept: " + string + "@" + n);
        }
        if (this.inAgent() && !agent_accept) {
            throw new SecurityException();
        }
    }

    public void checkAccess(Thread thread) {
        if (debug) {
            this.trace("checkAccess: " + thread.getName());
        }
        if (this.inAgent()) {
            throw new SecurityException("Access denied to agents.");
        }
    }

    public void checkCreateClassLoader() {
        if (debug) {
            this.trace("checkCreateClassLoader.");
        }
        if (this.inAgent()) {
            throw new SecurityException("createClassLoader denied to agents.");
        }
    }

    public void checkListen(int n) {
        if (debug) {
            this.trace("checkListen: " + n);
        }
        if (this.inAgent()) {
            throw new SecurityException("Listen denied to agents.");
        }
    }

    public void checkPropertiesAccess() {
        if (debug) {
            this.trace("checkPropertiesAccess.");
        }
        if (this.inAgent()) {
            throw new SecurityException("Properties denied to agents");
        }
    }

    public void checkRead(int n) {
        if (debug) {
            this.trace("checkRead: " + n);
        }
        if (this.inAgent()) {
            throw new SecurityException("Read(fd) denied to agents.");
        }
    }

    public void checkRead(String string) {
        if (debug) {
            this.trace("checkRead: " + string);
        }
        if (this.inAgent()) {
            throw new SecurityException("Read(file) denied to agents.");
        }
    }

    public void checkWrite(int n) {
        if (debug) {
            this.trace("checkWrite: " + n);
        }
        if (this.inAgent()) {
            throw new SecurityException("Write(fd) denied to agents.");
        }
    }

    public void checkWrite(String string) {
        if (debug) {
            this.trace("checkWrite: " + string);
        }
        if (this.inAgent() && !agent_write) {
            throw new SecurityException("write(file) denied to agents.");
        }
    }

    protected final boolean inAgent() {
        return false;
    }

    protected void trace(String string) {
        if (this.inAgent()) {
            System.out.println("[agent-security] " + string);
        } else {
            System.out.println("[httpd-security] " + string);
        }
    }
}

