/*
 * Decompiled with CFR 0.152.
 */
package org.w3c.jigsaw.servlet;

import java.io.DataOutputStream;
import java.io.IOException;
import javax.servlet.ServletOutputStream;
import org.w3c.jigsaw.http.Reply;
import org.w3c.jigsaw.servlet.JigsawHttpServletResponse;

class JigsawServletOutputStream
extends ServletOutputStream {
    DataOutputStream out = null;
    JigsawHttpServletResponse resp = null;
    Reply reply = null;
    byte[] buffer = null;
    int count = 0;
    boolean committed = false;
    boolean writerUsed = false;
    byte[] ln = new byte[]{13, 10};

    JigsawServletOutputStream(JigsawHttpServletResponse jigsawHttpServletResponse, DataOutputStream dataOutputStream, int n, boolean bl) {
        this.out = dataOutputStream;
        this.resp = jigsawHttpServletResponse;
        this.writerUsed = bl;
        if (n <= 0) {
            throw new IllegalArgumentException("Buffer size <= 0");
        }
        this.buffer = new byte[n];
        this.count = 0;
        this.committed = false;
    }

    JigsawServletOutputStream(JigsawHttpServletResponse jigsawHttpServletResponse, Reply reply, int n, boolean bl) {
        this.resp = jigsawHttpServletResponse;
        this.reply = reply;
        this.writerUsed = bl;
        if (n <= 0) {
            throw new IllegalArgumentException("Buffer size <= 0");
        }
        this.buffer = new byte[n];
        this.count = 0;
        this.committed = false;
    }

    public void close() throws IOException {
        this.flushBuffer();
        this.out.close();
    }

    public void flush() throws IOException {
        if (!this.writerUsed) {
            this.flushBuffer();
            this.out.flush();
        }
    }

    private void flushBuffer() throws IOException {
        if (!this.committed) {
            this.resp.notifyClient();
        }
        this.committed = true;
        if (this.out == null && this.reply != null) {
            this.out = new DataOutputStream(this.reply.getOutputStream());
        }
        if (this.count > 0) {
            this.out.write(this.buffer, 0, this.count);
            this.count = 0;
        }
    }

    public boolean isCommitted() {
        return this.committed;
    }

    public void print(double d) throws IOException {
        this.print(Double.toString(d));
    }

    public void print(int n) throws IOException {
        this.write(n);
    }

    public void print(long l) throws IOException {
        this.print(Long.toString(l));
    }

    public void print(String string) throws IOException {
        this.write(string.getBytes());
    }

    public void println() throws IOException {
        this.write(this.ln);
    }

    public void println(double d) throws IOException {
        this.print(d);
        this.println();
    }

    public void println(int n) throws IOException {
        this.print(n);
        this.println();
    }

    public void println(long l) throws IOException {
        this.print(l);
        this.println();
    }

    public void println(String string) throws IOException {
        this.print(string);
        this.println();
    }

    public void realFlush() throws IOException {
        this.flushBuffer();
        this.out.flush();
    }

    public void reset() throws IllegalStateException {
        if (this.committed) {
            throw new IllegalStateException("Response already committed");
        }
        this.count = 0;
    }

    protected void write(byte by) throws IOException {
        if (this.count >= this.buffer.length) {
            this.flushBuffer();
        }
        this.buffer[this.count++] = by;
    }

    public void write(int n) throws IOException {
        this.write((byte)n);
    }

    public void write(byte[] byArray) throws IOException {
        this.write(byArray, 0, byArray.length);
    }

    public void write(byte[] byArray, int n, int n2) throws IOException {
        if (n2 >= this.buffer.length) {
            this.flushBuffer();
            this.out.write(byArray, n, n2);
            return;
        }
        if (n2 > this.buffer.length - this.count) {
            this.flushBuffer();
        }
        System.arraycopy(byArray, n, this.buffer, this.count, n2);
        this.count += n2;
    }
}

