/*
 * Decompiled with CFR 0.152.
 */
package org.w3c.tools.jdbc;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import org.w3c.tools.jdbc.JdbcServer;
import org.w3c.util.LRUAble;

public class JdbcConnection
implements LRUAble {
    public static final boolean debug = false;
    public static final int QUERY_TIMEOUT = 300;
    protected long querystamp = -1L;
    Connection conn = null;
    protected LRUAble lru_next = null;
    protected LRUAble lru_prev = null;
    protected JdbcServer server = null;

    JdbcConnection(JdbcServer jdbcServer) {
        this.server = jdbcServer;
    }

    public void close() {
        if (this.conn != null) {
            try {
                this.conn.close();
            }
            catch (SQLException sQLException) {}
            this.conn = null;
        }
    }

    public void delete() {
        this.close();
        this.server.unregisterConnection(this);
        this.server.deleteConnection(this);
    }

    public DatabaseMetaData getMetaData() throws SQLException {
        if (this.conn != null) {
            return this.conn.getMetaData();
        }
        throw new SQLException("no connection");
    }

    public LRUAble getNext() {
        return this.lru_next;
    }

    public LRUAble getPrev() {
        return this.lru_prev;
    }

    public long getQueryStamp() {
        return this.querystamp;
    }

    protected final JdbcServer getServer() {
        return this.server;
    }

    public boolean isClosed() {
        if (this.conn != null) {
            try {
                return this.conn.isClosed();
            }
            catch (SQLException sQLException) {
                return true;
            }
        }
        return true;
    }

    public synchronized boolean markUsed() {
        block9: {
            try {
                if (this.conn == null || !this.conn.isClosed()) break block9;
                try {
                    this.conn.close();
                }
                catch (Exception exception) {}
                this.conn = null;
            }
            catch (SQLException sQLException) {
                try {
                    this.conn.close();
                }
                catch (Exception exception) {}
                this.conn = null;
            }
        }
        if (this.conn == null) {
            try {
                DriverManager.setLoginTimeout(60);
                this.conn = DriverManager.getConnection(this.server.uri, this.server.user, this.server.password);
            }
            catch (SQLException sQLException) {
                this.server.unregisterConnection(this);
                this.server.deleteConnection(this);
                return false;
            }
        }
        this.server.unregisterConnection(this);
        return true;
    }

    public ResultSet performQuery(String string) throws SQLException {
        if (this.conn != null) {
            try {
                ResultSet resultSet;
                this.querystamp = System.currentTimeMillis();
                Statement statement = this.conn.createStatement();
                statement.setQueryTimeout(300);
                ResultSet resultSet2 = resultSet = statement.executeQuery(string);
                Object var4_5 = null;
                this.querystamp = -1L;
                return resultSet2;
            }
            catch (Throwable throwable) {
                Object var4_6 = null;
                this.querystamp = -1L;
                throw throwable;
            }
        }
        throw new SQLException("no connection");
    }

    public int performUpdate(String string) throws SQLException {
        if (this.conn != null) {
            try {
                this.querystamp = System.currentTimeMillis();
                Statement statement = this.conn.createStatement();
                statement.setQueryTimeout(300);
                int n = statement.executeUpdate(string);
                Object var4_4 = null;
                this.querystamp = -1L;
                return n;
            }
            catch (Throwable throwable) {
                Object var4_5 = null;
                this.querystamp = -1L;
                throw throwable;
            }
        }
        throw new SQLException("no connection");
    }

    public void setNext(LRUAble lRUAble) {
        this.lru_next = lRUAble;
    }

    public void setPrev(LRUAble lRUAble) {
        this.lru_prev = lRUAble;
    }
}

