/*
 * Decompiled with CFR 0.152.
 */
package org.w3c.tools.jpeg;

import java.util.Hashtable;
import org.w3c.tools.jpeg.ExifData;
import org.w3c.tools.jpeg.TagDecoder;

public class Exif {
    private static final int TAG_EXIF_OFFSET = 34665;
    private static final int TAG_INTEROP_OFFSET = 40965;
    private Hashtable tags = new Hashtable();
    private Hashtable exif = new Hashtable();
    private Hashtable decoder = new Hashtable();
    private ExifData data = null;
    private boolean intelOrder = false;
    private String tagHeight = null;
    private String tagWidth = null;
    private String tagComp = null;
    private String tagBPP = null;
    private String tagNumCC = null;

    public void addBitsPerPixel(String string) {
        this.tagBPP = string;
    }

    public void addCompression(String string) {
        this.tagComp = string;
    }

    public void addDecoder(String string, String string2) {
        this.decoder.put(string, string2);
    }

    public void addHeight(String string) {
        this.tagHeight = string;
    }

    public void addNumberOfColorComponents(String string) {
        this.tagNumCC = string;
    }

    public void addTag(int n, String string) {
        this.tags.put(new Integer(n), string);
    }

    public void addWidth(String string) {
        this.tagWidth = string;
    }

    protected void assignByte(String string, int n) {
        int n2 = (int)this.data.convertAnyValue(1, n);
        this.exif.put(string, String.valueOf(n2));
    }

    protected void assignRational(String string, int n) {
        int n2 = this.data.get32s(n);
        int n3 = this.data.get32s(n + 4);
        String string2 = "";
        if (n2 % 10 == 0 && n3 % 10 == 0) {
            n2 /= 10;
            n3 /= 10;
        }
        if (n2 % 5 == 0 && n3 % 5 == 0) {
            n2 /= 5;
            n3 /= 5;
        }
        if (n2 % 3 == 0 && n3 % 3 == 0) {
            n2 /= 3;
            n3 /= 3;
        }
        if (n2 % 2 == 0 && n3 % 2 == 0) {
            n2 /= 2;
            n3 /= 2;
        }
        string2 = n3 == 0 ? "0" : (n3 == 1 ? String.valueOf(n2) : n2 + "/" + n3);
        this.exif.put(string, String.valueOf(string2));
    }

    protected void assignSByte(String string, int n) {
        int n2 = (int)this.data.convertAnyValue(6, n);
        this.exif.put(string, String.valueOf(n2));
    }

    protected void assignSLong(String string, int n) {
        int n2 = (int)this.data.convertAnyValue(9, n);
        this.exif.put(string, String.valueOf(n2));
    }

    protected void assignSShort(String string, int n) {
        int n2 = (int)this.data.convertAnyValue(8, n);
        this.exif.put(string, String.valueOf(n2));
    }

    protected void assignString(String string, int n, int n2) {
        String string2 = this.data.getString(n, n2);
        if (!"".equals(string2)) {
            this.exif.put(string, string2);
        }
    }

    protected void assignULong(String string, int n) {
        int n2 = (int)this.data.convertAnyValue(4, n);
        this.exif.put(string, String.valueOf(n2));
    }

    protected void assignUShort(String string, int n) {
        int n2 = (int)this.data.convertAnyValue(3, n);
        this.exif.put(string, String.valueOf(n2));
    }

    protected void assignUndefined(String string, int n, int n2) {
        String string2 = this.data.getUndefined(n, n2);
        if (!"".equals(string2)) {
            this.exif.put(string, string2);
        }
    }

    public Hashtable getTags() {
        return this.exif;
    }

    public void parseExif(byte[] byArray) {
        this.data = new ExifData(byArray);
        if (!this.data.isExifData()) {
            return;
        }
        int n = this.data.get32u(10);
        this.processExifDir(6 + n, 6);
    }

    protected void processExifDir(int n, int n2) {
        int n3 = this.data.get16u(n);
        int n4 = 0;
        while (n4 < n3) {
            int n5 = n + 2 + 12 * n4;
            int n6 = this.data.get16u(n5);
            int n7 = this.data.get16u(n5 + 2);
            int n8 = this.data.get32u(n5 + 4);
            if (n7 < 0 || n7 > 12) {
                System.err.println("Bad number of formats in EXIF dir: " + n7);
                return;
            }
            int n9 = n8 * ExifData.bytesPerFormat[n7];
            int n10 = n5 + 8;
            if (n9 > 4) {
                int n11 = this.data.get32u(n5 + 8);
                n10 = n2 + n11;
            }
            Integer n12 = new Integer(n6);
            if (n6 == 34665 || n6 == 40965) {
                int n13 = this.data.get32u(n10);
                this.processExifDir(n2 + n13, n2);
            } else {
                String string = "BugBugBug";
                boolean bl = false;
                if (this.tags.containsKey(n12)) {
                    string = (String)this.tags.get(n12);
                    bl = true;
                } else {
                    string = ":unknown0x" + Integer.toHexString(n12);
                }
                if (this.decoder.containsKey(string)) {
                    String string2 = (String)this.decoder.get(string);
                    TagDecoder tagDecoder = null;
                    try {
                        tagDecoder = (TagDecoder)Class.forName(string2).newInstance();
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        System.err.println("Class not found: " + string2);
                    }
                    catch (InstantiationException instantiationException) {
                        System.err.println("Failed to instantiate " + string2);
                    }
                    catch (IllegalAccessException illegalAccessException) {
                        System.err.println("Illegal access instantiating " + string2);
                    }
                    catch (ClassCastException classCastException) {
                        System.err.println("Class " + string2 + " is not a TagDecoder");
                    }
                    if (tagDecoder != null) {
                        tagDecoder.decode(this.exif, this.data, n7, n10, n9);
                    }
                } else {
                    switch (n7) {
                        case 7: {
                            this.assignUndefined(string, n10, n9);
                            break;
                        }
                        case 2: {
                            this.assignString(string, n10, n9);
                            break;
                        }
                        case 6: {
                            this.assignSByte(string, n10);
                            break;
                        }
                        case 1: {
                            this.assignByte(string, n10);
                            break;
                        }
                        case 3: {
                            this.assignUShort(string, n10);
                            break;
                        }
                        case 8: {
                            this.assignSShort(string, n10);
                            break;
                        }
                        case 4: {
                            this.assignULong(string, n10);
                            break;
                        }
                        case 9: {
                            this.assignSLong(string, n10);
                            break;
                        }
                        case 5: 
                        case 10: {
                            this.assignRational(string, n10);
                            break;
                        }
                    }
                }
            }
            ++n4;
        }
    }

    public void setBPP(int n) {
        if (this.tagBPP != null) {
            this.exif.put(this.tagBPP, String.valueOf(n));
        }
    }

    public void setCompression(String string) {
        if (this.tagComp != null) {
            this.exif.put(this.tagComp, string);
        }
    }

    public void setHeight(int n) {
        if (this.tagHeight != null) {
            this.exif.put(this.tagHeight, String.valueOf(n));
        }
    }

    public void setNumCC(int n) {
        if (this.tagNumCC != null) {
            this.exif.put(this.tagNumCC, String.valueOf(n));
        }
    }

    public void setWidth(int n) {
        if (this.tagWidth != null) {
            this.exif.put(this.tagWidth, String.valueOf(n));
        }
    }
}

