/*
 * Decompiled with CFR 0.152.
 */
package org.w3c.tools.resources.serialization;

import java.util.Vector;
import org.w3c.tools.resources.Attribute;
import org.w3c.tools.resources.Resource;
import org.w3c.tools.resources.ResourceFrame;
import org.w3c.tools.resources.serialization.AttributeDescription;

public class ResourceDescription {
    String classname = null;
    String[] classes = null;
    String[] interfaces = null;
    String identifier = null;
    AttributeDescription[] attributes = null;
    String[] children = null;

    public ResourceDescription(String string) {
        this.classname = string;
        this.interfaces = new String[0];
        this.classes = new String[0];
    }

    public ResourceDescription(Resource resource) {
        this.classname = resource.getClass().getName();
        Vector<String> vector = new Vector<String>(8);
        Vector vector2 = new Vector(8);
        Class<?>[] classArray = resource.getClass().getInterfaces();
        if (classArray != null) {
            int n = 0;
            while (n < classArray.length) {
                vector2.addElement(classArray[n]);
                ++n;
            }
        }
        Class<?> clazz = resource.getClass().getSuperclass();
        while (clazz != null) {
            vector.addElement(clazz.getName());
            classArray = clazz.getInterfaces();
            if (classArray != null) {
                int n = 0;
                while (n < classArray.length) {
                    vector2.addElement(classArray[n]);
                    ++n;
                }
            }
            clazz = clazz.getSuperclass();
        }
        this.classes = new String[vector.size()];
        vector.copyInto(this.classes);
        this.interfaces = new String[vector2.size()];
        vector2.copyInto(this.interfaces);
        Attribute[] attributeArray = resource.getAttributes();
        Vector<AttributeDescription> vector3 = new Vector<AttributeDescription>(10);
        int n = 0;
        while (n < attributeArray.length) {
            Object object = resource.getValue(n, null);
            if (object instanceof ResourceFrame[]) {
                ResourceFrame[] resourceFrameArray = (ResourceFrame[])object;
                int n2 = resourceFrameArray.length;
                ResourceDescription[] resourceDescriptionArray = new ResourceDescription[n2];
                int n3 = 0;
                while (n3 < n2) {
                    resourceDescriptionArray[n3] = new ResourceDescription(resourceFrameArray[n3]);
                    ++n3;
                }
                vector3.addElement(new AttributeDescription(attributeArray[n], resourceDescriptionArray));
            } else {
                vector3.addElement(new AttributeDescription(attributeArray[n], object));
            }
            ++n;
        }
        this.attributes = new AttributeDescription[vector3.size()];
        vector3.copyInto(this.attributes);
    }

    public AttributeDescription[] getAttributeDescriptions() {
        return this.attributes;
    }

    public String[] getChildren() {
        return this.children;
    }

    public String[] getClassHierarchy() {
        return this.classes;
    }

    public String getClassName() {
        return this.classname;
    }

    public String[] getClassesAndInterfaces() {
        String[] stringArray = new String[this.interfaces.length + this.classes.length];
        System.arraycopy(this.classes, 0, stringArray, 0, this.classes.length);
        System.arraycopy(this.interfaces, 0, stringArray, this.classes.length, this.interfaces.length);
        return stringArray;
    }

    public ResourceDescription getClone(AttributeDescription[] attributeDescriptionArray) {
        ResourceDescription resourceDescription = new ResourceDescription(this.classname);
        resourceDescription.identifier = this.identifier;
        resourceDescription.children = this.children;
        resourceDescription.attributes = attributeDescriptionArray;
        resourceDescription.classes = this.classes;
        resourceDescription.interfaces = this.interfaces;
        return resourceDescription;
    }

    public ResourceDescription[] getFrameDescriptions() {
        int n = 0;
        while (n < this.attributes.length) {
            Object object = this.attributes[n].getValue();
            if (object instanceof ResourceDescription[]) {
                return (ResourceDescription[])object;
            }
            ++n;
        }
        return new ResourceDescription[0];
    }

    public String getIdentifier() {
        if (this.identifier == null && this.attributes != null) {
            int n = 0;
            while (n < this.attributes.length) {
                if (this.attributes[n].getName().equals("identifier")) {
                    this.identifier = (String)this.attributes[n].getValue();
                }
                ++n;
            }
        }
        return this.identifier;
    }

    public String[] getInterfaces() {
        return this.interfaces;
    }

    public void setAttributeDescriptions(Vector vector) {
        this.attributes = new AttributeDescription[vector.size()];
        vector.copyInto(this.attributes);
    }

    public void setChildren(String[] stringArray) {
        this.children = stringArray;
    }

    public void setClassHierarchy(Vector vector) {
        this.classes = new String[vector.size()];
        vector.copyInto(this.classes);
    }

    public void setClassHierarchy(String[] stringArray) {
        this.classes = stringArray;
    }

    public void setInterfaces(Vector vector) {
        this.interfaces = new String[vector.size()];
        vector.copyInto(this.interfaces);
    }

    public void setInterfaces(String[] stringArray) {
        this.interfaces = stringArray;
    }
}

