/*
 * Decompiled with CFR 0.152.
 */
package org.w3c.tools.resources.serialization.xml;

import java.io.IOException;
import java.io.Writer;
import java.util.Enumeration;
import java.util.Vector;
import org.w3c.tools.resources.ArrayAttribute;
import org.w3c.tools.resources.Attribute;
import org.w3c.tools.resources.AttributeHolder;
import org.w3c.tools.resources.ContainerInterface;
import org.w3c.tools.resources.FrameArrayAttribute;
import org.w3c.tools.resources.ResourceFrame;
import org.w3c.tools.resources.SimpleAttribute;
import org.w3c.tools.resources.serialization.xml.JigXML;
import org.w3c.tools.resources.serialization.xml.XMLWriter;

public class XMLResourceWriter
extends XMLWriter
implements JigXML {
    public XMLResourceWriter(Writer writer) {
        super(writer);
    }

    protected void startResource(AttributeHolder attributeHolder) throws IOException {
        String string = attributeHolder.getClass().getName();
        this.writer.write(60);
        this.writer.write("resource");
        this.writer.write(32);
        this.writer.write("class");
        this.writer.write("='");
        this.writer.write(string);
        this.writer.write("'>\n");
    }

    protected void startResourceDescr(AttributeHolder attributeHolder) throws IOException {
        int n;
        String string = attributeHolder.getClass().getName();
        this.writer.write(60);
        this.writer.write("resource");
        this.writer.write(32);
        this.writer.write("class");
        this.writer.write("='");
        this.writer.write(string);
        this.writer.write("'>\n");
        Vector<String> vector = new Vector<String>(10);
        Class<?> clazz = attributeHolder.getClass();
        Class<?>[] classArray = clazz.getInterfaces();
        if (classArray != null) {
            n = 0;
            while (n < classArray.length) {
                vector.addElement(classArray[n].getName());
                ++n;
            }
        }
        this.writeInherit(clazz.getSuperclass(), vector);
        ++this.level;
        n = 0;
        while (n < vector.size()) {
            String string2 = (String)vector.elementAt(n);
            this.indent();
            this.writer.write(60);
            this.writer.write("implements");
            this.writer.write(32);
            this.writer.write("class");
            this.writer.write("='");
            this.writer.write(string2);
            this.writer.write("'/>\n");
            ++n;
        }
        --this.level;
        this.writeChildren(attributeHolder);
    }

    protected void writeAttribute(Attribute attribute, Object object, boolean bl) throws IOException {
        ++this.level;
        if (attribute instanceof SimpleAttribute) {
            this.indent();
            this.writer.write(60);
            this.writer.write("attribute");
            this.writer.write(32);
            this.writer.write("name");
            this.writer.write("='");
            this.writer.write(attribute.getName());
            this.writer.write("' ");
            this.writer.write("flag");
            this.writer.write("='");
            this.writer.write(attribute.getFlag());
            this.writer.write("' ");
            this.writer.write("class");
            this.writer.write("='");
            this.writer.write(attribute.getClass().getName());
            this.writer.write("'>");
            if (object == null) {
                this.writer.write("@@NULL@@");
            } else {
                String string = ((SimpleAttribute)attribute).pickle(object);
                this.writer.write(XMLWriter.encode(string));
            }
            this.writer.write("</");
            this.writer.write("attribute");
            this.writer.write(">\n");
        } else if (attribute instanceof ArrayAttribute) {
            this.indent();
            this.writer.write(60);
            this.writer.write("array");
            this.writer.write(32);
            this.writer.write("name");
            this.writer.write("='");
            this.writer.write(attribute.getName());
            this.writer.write("' ");
            this.writer.write("flag");
            this.writer.write("='");
            this.writer.write(attribute.getFlag());
            this.writer.write("' ");
            this.writer.write("class");
            this.writer.write("='");
            this.writer.write(attribute.getClass().getName());
            this.writer.write("' ");
            String[] stringArray = null;
            stringArray = object == null ? new String[]{} : ((ArrayAttribute)attribute).pickle(object);
            int n = stringArray.length;
            this.writer.write("length");
            this.writer.write("='");
            this.writer.write(String.valueOf(n));
            this.writer.write("'>\n");
            ++this.level;
            int n2 = 0;
            while (n2 < n) {
                this.indent();
                this.writer.write(60);
                this.writer.write("value");
                this.writer.write(62);
                String string = stringArray[n2];
                if (string == null) {
                    this.writer.write("@@NULL@@");
                } else {
                    this.writer.write(XMLWriter.encode(string));
                }
                this.writer.write("</");
                this.writer.write("value");
                this.writer.write(">\n");
                ++n2;
            }
            --this.level;
            this.indent();
            this.writer.write("</");
            this.writer.write("array");
            this.writer.write(">\n");
        } else if (attribute instanceof FrameArrayAttribute) {
            this.indent();
            this.writer.write(60);
            this.writer.write("resourcearray");
            this.writer.write(32);
            this.writer.write("name");
            this.writer.write("='");
            this.writer.write(attribute.getName());
            this.writer.write("' ");
            this.writer.write("class");
            this.writer.write("='");
            this.writer.write(attribute.getClass().getName());
            this.writer.write("' ");
            ResourceFrame[] resourceFrameArray = null;
            resourceFrameArray = object == null ? new ResourceFrame[]{} : (ResourceFrame[])object;
            int n = resourceFrameArray.length;
            this.writer.write("length");
            this.writer.write("='");
            this.writer.write(String.valueOf(n));
            this.writer.write("'>\n");
            if (bl) {
                int n3 = 0;
                while (n3 < n) {
                    this.writeResourceDescription(resourceFrameArray[n3]);
                    ++n3;
                }
            } else {
                int n4 = 0;
                while (n4 < n) {
                    this.writeResource(resourceFrameArray[n4]);
                    ++n4;
                }
            }
            this.indent();
            this.writer.write("</");
            this.writer.write("resourcearray");
            this.writer.write(">\n");
        }
        --this.level;
    }

    protected void writeChildren(AttributeHolder attributeHolder) throws IOException {
        if (attributeHolder instanceof ContainerInterface) {
            Vector<String> vector = new Vector<String>();
            Enumeration enumeration = ((ContainerInterface)((Object)attributeHolder)).enumerateResourceIdentifiers(true);
            while (enumeration.hasMoreElements()) {
                vector.addElement((String)enumeration.nextElement());
            }
            int n = vector.size();
            ++this.level;
            this.indent();
            this.writer.write(60);
            this.writer.write("children");
            this.writer.write(32);
            this.writer.write("length");
            this.writer.write("='");
            this.writer.write(String.valueOf(n));
            this.writer.write("'>\n");
            ++this.level;
            int n2 = 0;
            while (n2 < n) {
                this.indent();
                this.writer.write(60);
                this.writer.write("child");
                this.writer.write(62);
                this.writer.write(XMLWriter.encode((String)vector.elementAt(n2)));
                this.writer.write("</");
                this.writer.write("child");
                this.writer.write(">\n");
                ++n2;
            }
            --this.level;
            this.indent();
            this.writer.write("</");
            this.writer.write("children");
            this.writer.write(">\n");
            --this.level;
        }
    }

    protected void writeInherit(Class clazz, Vector vector) throws IOException {
        if (clazz != null) {
            ++this.level;
            this.indent();
            this.writer.write(60);
            this.writer.write("inherit");
            this.writer.write(32);
            this.writer.write("class");
            this.writer.write("='");
            this.writer.write(clazz.getName());
            this.writer.write("'>\n");
            Class<?>[] classArray = clazz.getInterfaces();
            if (classArray != null) {
                int n = 0;
                while (n < classArray.length) {
                    vector.addElement(classArray[n].getName());
                    ++n;
                }
            }
            this.writeInherit(clazz.getSuperclass(), vector);
            this.indent();
            this.writer.write("</");
            this.writer.write("inherit");
            this.writer.write(">\n");
            --this.level;
        }
    }

    public void writeResource(AttributeHolder attributeHolder) throws IOException {
        ++this.level;
        this.indent();
        this.startResource(attributeHolder);
        Attribute[] attributeArray = attributeHolder.getAttributes();
        int n = 0;
        while (n < attributeArray.length) {
            Object object = attributeHolder.unsafeGetValue(n, null);
            if (!attributeArray[n].checkFlag(8)) {
                this.writeAttribute(attributeArray[n], object, false);
            }
            ++n;
        }
        this.indent();
        this.closeResource();
        --this.level;
    }

    public void writeResourceDescription(AttributeHolder attributeHolder) throws IOException {
        ++this.level;
        this.indent();
        this.startResourceDescr(attributeHolder);
        Attribute[] attributeArray = attributeHolder.getAttributes();
        int n = 0;
        while (n < attributeArray.length) {
            Object object = attributeHolder.unsafeGetValue(n, null);
            if (!attributeArray[n].checkFlag(8)) {
                this.writeAttribute(attributeArray[n], object, true);
            }
            ++n;
        }
        this.indent();
        this.closeResource();
        --this.level;
    }
}

