/*
 * Decompiled with CFR 0.152.
 */
package org.w3c.www.http;

import java.util.Enumeration;
import java.util.Vector;
import org.w3c.www.http.BasicValue;
import org.w3c.www.http.HttpBuffer;
import org.w3c.www.http.HttpExt;
import org.w3c.www.http.HttpParser;
import org.w3c.www.http.HttpParserException;
import org.w3c.www.http.ParseState;

public class HttpExtList
extends BasicValue {
    public static final int MAN = 0;
    public static final int CMAN = 1;
    public static final int OPT = 2;
    public static final int COPT = 3;
    Vector httpexts = null;
    int manopt = 0;

    protected HttpExtList() {
        this.isValid = false;
        this.httpexts = new Vector(2);
    }

    public HttpExtList(HttpExtList httpExtList) {
        this.isValid = true;
        httpExtList.validate();
        int n = httpExtList.httpexts.size();
        this.httpexts = new Vector(n);
        int n2 = 0;
        while (n2 < n) {
            HttpExt httpExt = new HttpExt((HttpExt)httpExtList.httpexts.elementAt(n2));
            this.httpexts.addElement(httpExt);
            ++n2;
        }
        this.manopt = httpExtList.manopt;
    }

    public HttpExtList(HttpExt[] httpExtArray) {
        this.isValid = true;
        int n = httpExtArray.length;
        this.httpexts = new Vector(n);
        if (httpExtArray != null) {
            int n2 = 0;
            while (n2 < n) {
                this.httpexts.addElement(httpExtArray[n2]);
                ++n2;
            }
        }
    }

    public void addHttpExt(HttpExt httpExt) {
        this.validate();
        this.httpexts.addElement(httpExt);
    }

    public HttpExt getHttpExt(String string) {
        this.validate();
        int n = 0;
        while (n < this.httpexts.size()) {
            HttpExt httpExt = (HttpExt)this.httpexts.elementAt(n);
            if (httpExt.getName().equals(string)) {
                return httpExt;
            }
            ++n;
        }
        return null;
    }

    public HttpExt[] getHttpExts() {
        this.validate();
        Object[] objectArray = new HttpExt[this.httpexts.size()];
        this.httpexts.copyInto(objectArray);
        return objectArray;
    }

    public int getLength() {
        this.validate();
        return this.httpexts.size();
    }

    public int getManOptFlag() {
        return this.manopt;
    }

    public Object getValue() {
        return this;
    }

    protected void parse() throws HttpParserException {
        ParseState parseState = new ParseState(this.roff, this.rlen);
        ParseState parseState2 = new ParseState(0, 0);
        ParseState parseState3 = new ParseState(0, 0);
        parseState.separator = (byte)44;
        parseState.spaceIsSep = false;
        parseState2.separator = (byte)59;
        parseState2.spaceIsSep = false;
        parseState3.separator = (byte)61;
        parseState3.spaceIsSep = false;
        while (HttpParser.nextItem(this.raw, parseState) >= 0) {
            parseState2.ioff = parseState.start;
            parseState2.bufend = parseState.end;
            HttpExt httpExt = new HttpExt();
            while (HttpParser.nextItem(this.raw, parseState2) >= 0) {
                parseState3.ioff = parseState2.start;
                parseState3.bufend = parseState2.end;
                boolean bl = HttpParser.unquote(this.raw, parseState3);
                if (HttpParser.nextItem(this.raw, parseState3) < 0) {
                    this.error("Invalid extension item [" + parseState2.toString(this.raw) + "]");
                }
                String string = parseState3.toString(this.raw);
                String string2 = parseState3.toString(this.raw, true);
                if (bl) {
                    httpExt.setName(string);
                } else {
                    parseState3.prepare();
                    HttpParser.unquote(this.raw, parseState3);
                    if (HttpParser.nextItem(this.raw, parseState3) < 0) {
                        this.error("No value for attribute [" + string2 + "]");
                    }
                    if (string2.equals("ns")) {
                        httpExt.setNamespace(parseState3.toString(this.raw));
                    } else {
                        httpExt.addDeclExt(string, parseState3.toString(this.raw));
                    }
                }
                parseState2.prepare();
            }
            parseState.prepare();
            this.httpexts.addElement(httpExt);
        }
    }

    protected void setManOptFlag(int n) {
        this.manopt = n;
    }

    protected void updateByteValue() {
        HttpBuffer httpBuffer = new HttpBuffer();
        int n = this.httpexts.size();
        int n2 = 0;
        while (n2 < n) {
            HttpExt httpExt = (HttpExt)this.httpexts.elementAt(n2);
            if (n2 != 0) {
                httpBuffer.append(", ");
            }
            httpBuffer.appendQuoted(httpExt.getName());
            if (httpExt.needsHeaders()) {
                httpBuffer.append(";");
                httpBuffer.append("ns", (byte)61, httpExt.getNamespace());
            }
            Enumeration enumeration = httpExt.getDeclExtNames();
            while (enumeration.hasMoreElements()) {
                String string = (String)enumeration.nextElement();
                httpBuffer.append("; ");
                httpBuffer.append(string, (byte)61, httpExt.getDeclExt(string));
            }
            ++n2;
        }
        this.raw = httpBuffer.getByteCopy();
        this.roff = 0;
        this.rlen = this.raw.length;
    }
}

