/*
 * Decompiled with CFR 0.152.
 */
package org.w3c.www.protocol.http.cache;

import java.io.File;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import org.w3c.util.LRUAble;
import org.w3c.util.LRUList;
import org.w3c.util.LookupTable;
import org.w3c.util.SyncLRUList;
import org.w3c.www.protocol.http.cache.CacheStore;
import org.w3c.www.protocol.http.cache.CacheValidator;
import org.w3c.www.protocol.http.cache.CachedResource;
import org.w3c.www.protocol.http.cache.InvalidCacheException;
import org.w3c.www.protocol.http.cache.NoSuchResourceException;
import org.w3c.www.protocol.http.cache.UnloadedGenerationException;

public class CacheGeneration
implements LRUAble {
    private static final boolean debug = true;
    private Hashtable lookupTable = null;
    private SyncLRUList lruList = null;
    private long bytecount = 0L;
    private long bytelimit = 0L;
    private long bytestored = 0L;
    private boolean saved = false;
    private boolean loaded = false;
    private int cr_count = 0;
    private int id = 0;
    private Vector toDel = null;
    private CacheStore store = null;
    protected File generationFile = null;
    protected LRUAble prev = null;
    protected LRUAble next = null;

    public CacheGeneration(CacheStore cacheStore, long l) {
        this.store = cacheStore;
        this.toDel = new Vector();
        this.lookupTable = new Hashtable();
        this.bytelimit = l;
        this.lruList = new SyncLRUList();
    }

    private CachedResource _removeResource(String string) throws NoSuchResourceException {
        System.err.println("*** removing from generation " + this.id + ": " + string);
        CachedResource cachedResource = (CachedResource)this.lookupTable.get(string);
        if (cachedResource == null) {
            String string2 = String.valueOf(string) + " not found in generation " + this.id;
            throw new NoSuchResourceException(string2);
        }
        this.lookupTable.remove(string);
        this.lruList.remove(cachedResource);
        long l = cachedResource.getCurrentLength();
        System.err.println("*** removed... saved " + l + " bytes");
        this.bytecount -= l;
        this.bytestored -= l;
        this.saved = false;
        --this.cr_count;
        return cachedResource;
    }

    public synchronized boolean addResource(CachedResource cachedResource, long l, long l2) {
        if (!this.loaded) {
            throw new UnloadedGenerationException("generation " + this.id);
        }
        if (this.canStore(cachedResource, l)) {
            CachedResource cachedResource2 = null;
            cachedResource2 = (CachedResource)this.lookupTable.get(cachedResource.getIdentifier());
            if (cachedResource2 != null) {
                l2 = cachedResource2.getCurrentLength();
                long l3 = l - l2;
                if (this.bytecount + l3 > this.bytelimit) {
                    return false;
                }
                this.lookupTable.remove(cachedResource.getIdentifier());
                this.lruList.remove(cachedResource);
                this.bytecount -= l2;
                this.toDel.addElement(cachedResource2);
                this.store.getState().notifyResourceReplaced(cachedResource, l2);
            } else {
                this.store.getState().notifyResourceAdded(cachedResource, l2);
            }
            this.lookupTable.put(cachedResource.getIdentifier(), cachedResource);
            cachedResource.generation = this;
            this.lruList.toHead(cachedResource);
            this.bytestored += l;
            this.bytecount += l;
            this.saved = false;
            ++this.cr_count;
            return true;
        }
        return false;
    }

    private boolean canStore(CachedResource cachedResource, long l) {
        long l2;
        if (!this.loaded) {
            throw new UnloadedGenerationException("generation " + this.id);
        }
        CachedResource cachedResource2 = null;
        cachedResource2 = (CachedResource)this.lookupTable.get(cachedResource.getIdentifier());
        if (cachedResource2 != null && this.bytecount + (l2 = l - (long)cachedResource2.getCurrentLength()) > this.bytelimit) {
            return false;
        }
        return l + this.bytecount <= this.bytelimit;
    }

    public void clean() {
        this.lookupTable = new Hashtable();
        this.lruList = new SyncLRUList();
        this.loaded = false;
    }

    public long collectSpace(long l, boolean bl) {
        CacheGeneration cacheGeneration;
        if (!this.loaded) {
            try {
                this.store.loadGeneration(this);
            }
            catch (InvalidCacheException invalidCacheException) {
                System.err.println("*** Collecting Unable to load generation [" + this.getId() + "]");
                System.err.println(invalidCacheException.getMessage());
                return 0L;
            }
        }
        Vector vector = new Vector();
        long l2 = 0L;
        System.err.println("*** Collecting " + l + " bytes " + (bl ? "with" : "without") + " checking");
        if (l <= 0L) {
            return 0L;
        }
        if (l > this.bytecount && !bl) {
            return this.emptyGeneration();
        }
        CacheValidator cacheValidator = this.store.getValidator();
        CachedResource cachedResource = (CachedResource)this.lruList.getTail();
        while (cachedResource != null) {
            if (bl && cacheValidator.checkStaleness(cachedResource)) {
                cachedResource = (CachedResource)this.lruList.getPrev(cachedResource);
                continue;
            }
            CachedResource cachedResource2 = (CachedResource)this.lruList.getPrev(cachedResource);
            cacheGeneration = this;
            synchronized (cacheGeneration) {
                this.lookupTable.remove(cachedResource.getIdentifier());
                this.lruList.remove(cachedResource);
                this.saved = false;
                --this.cr_count;
                this.store.getState().notifyResourceToBeDeleted(cachedResource);
            }
            this.toDel.addElement(cachedResource);
            if ((l2 += (long)cachedResource.getCurrentLength()) >= l) break;
            cachedResource = cachedResource2;
        }
        cacheGeneration = this;
        synchronized (cacheGeneration) {
            this.bytecount -= l2;
        }
        System.err.println("*** Collected " + l2 + " bytes from generation " + this.id);
        return l2;
    }

    public synchronized boolean containsResource(String string) {
        return this.lookupTable.get(string) != null;
    }

    protected synchronized void copyInto(CacheGeneration cacheGeneration) {
        Object object;
        SyncLRUList syncLRUList = cacheGeneration.lruList;
        Object object2 = (CachedResource)((LRUList)syncLRUList).getHead();
        while (object2 != null) {
            object = (CachedResource)((LRUList)syncLRUList).getNext((LRUAble)object2);
            ((CachedResource)object2).generation = this;
            this.lruList.toTail((LRUAble)object2);
            this.lookupTable.put(((CachedResource)object2).getIdentifier(), object2);
            object2 = object;
        }
        cacheGeneration.setSaved(false);
        object = cacheGeneration.toDel.elements();
        while (object.hasMoreElements()) {
            this.toDel.add(object.nextElement());
        }
        this.cr_count += cacheGeneration.cr_count;
        this.bytecount += cacheGeneration.bytecount;
        this.bytestored += cacheGeneration.bytestored;
        this.saved = false;
    }

    protected void deleteGenerationFile() {
        this.generationFile.delete();
    }

    public long deleteStored(CachedResource cachedResource) {
        if (!this.loaded) {
            throw new UnloadedGenerationException("generation " + this.id);
        }
        System.out.println("Deleting " + cachedResource.getIdentifier() + "from generation: " + this.id);
        this.toDel.removeElement(cachedResource);
        long l = cachedResource.delete();
        CacheGeneration cacheGeneration = this;
        synchronized (cacheGeneration) {
            this.bytestored -= l;
        }
        this.store.getState().notifyResourceDeleted(cachedResource);
        return l;
    }

    protected long emptyGeneration() {
        Hashtable hashtable;
        long l;
        if (!this.loaded) {
            throw new UnloadedGenerationException("generation " + this.id);
        }
        System.err.println("*** Deleting Generation " + this.id + " (" + this.bytecount + ")");
        Object object = this;
        synchronized (object) {
            l = this.bytecount;
            hashtable = this.lookupTable;
            this.lookupTable = new Hashtable();
            this.lruList = new SyncLRUList();
            this.bytecount = 0L;
            this.cr_count = 0;
        }
        object = hashtable.elements();
        while (object.hasMoreElements()) {
            CachedResource cachedResource = (CachedResource)object.nextElement();
            this.toDel.addElement(cachedResource);
            this.store.getState().notifyResourceToBeDeleted(cachedResource);
        }
        this.generationFile.delete();
        this.saved = false;
        return l;
    }

    public long getByteLimit() {
        return this.bytelimit;
    }

    public int getCRCount() {
        return this.cr_count;
    }

    public long getCachedByteCount() {
        return this.bytecount;
    }

    public Enumeration getCachedResources() {
        if (!this.loaded) {
            throw new UnloadedGenerationException("generation " + this.id);
        }
        return this.lookupTable.elements();
    }

    public Enumeration getDeletedResources() {
        return this.toDel.elements();
    }

    public synchronized Enumeration getFiles() {
        Vector<File> vector = new Vector<File>();
        if (this.loaded) {
            Enumeration enumeration = this.lookupTable.elements();
            while (enumeration.hasMoreElements()) {
                CachedResource cachedResource = (CachedResource)enumeration.nextElement();
                File file = cachedResource.getFile();
                if (file == null) continue;
                vector.addElement(file);
            }
        } else {
            Enumeration enumeration = this.lookupTable.elements();
            while (enumeration.hasMoreElements()) {
                String string = (String)enumeration.nextElement();
                if (string.equals("")) continue;
                vector.addElement(new File(string));
            }
        }
        return vector.elements();
    }

    public float getFillRatio() {
        return (float)this.bytecount / (float)this.bytelimit;
    }

    public File getGenerationFile() {
        return this.generationFile;
    }

    public int getId() {
        return this.id;
    }

    public LRUAble getNext() {
        return this.next;
    }

    public LRUAble getPrev() {
        return this.prev;
    }

    public long getStoredByteCount() {
        return this.bytestored;
    }

    public boolean isLoaded() {
        return this.loaded;
    }

    public boolean isSaved() {
        return this.saved;
    }

    protected void loadCachedResource(CachedResource cachedResource) {
        File file = cachedResource.getFile();
        if (!(file == null || file.exists() && file.length() == (long)cachedResource.getCurrentLength())) {
            return;
        }
        this.lookupTable.put(cachedResource.getIdentifier(), cachedResource);
        cachedResource.generation = this;
        this.lruList.toHead(cachedResource);
        long l = cachedResource.getCurrentLength();
        this.bytestored += l;
        this.bytecount += l;
        ++this.cr_count;
    }

    public synchronized CachedResource lookupResource(String string) {
        if (!this.loaded) {
            throw new UnloadedGenerationException("generation " + this.id);
        }
        return (CachedResource)this.lookupTable.get(string);
    }

    public synchronized long removeResource(String string) throws NoSuchResourceException {
        if (!this.loaded) {
            throw new UnloadedGenerationException("generation " + this.id);
        }
        CachedResource cachedResource = this._removeResource(string);
        return cachedResource.getCurrentLength();
    }

    public synchronized long removeResource(CachedResource cachedResource) throws NoSuchResourceException {
        if (!this.loaded) {
            throw new UnloadedGenerationException("generation " + this.id);
        }
        return this.removeResource(cachedResource.getIdentifier());
    }

    public synchronized void setByteLimit(long l) {
        this.bytelimit = l;
        if (l >= this.bytecount) {
            return;
        }
        long l2 = l - this.bytecount;
        l2 -= this.collectSpace(l - this.bytecount, true);
        l2 -= this.collectSpace(l2, false);
    }

    protected void setDescription(LookupTable[] lookupTableArray) {
        this.clean();
        this.saved = true;
        this.bytestored = 0L;
        this.bytecount = 0L;
        this.cr_count = 0;
        int n = 0;
        while (n < lookupTableArray.length) {
            LookupTable lookupTable = lookupTableArray[n];
            try {
                String string = (String)lookupTable.get("current-length");
                String string2 = (String)lookupTable.get("id");
                String string3 = (String)lookupTable.get("file");
                string3 = string3 == null ? "" : string3;
                this.bytestored += (long)Integer.parseInt(string);
                this.lookupTable.put(string2, string3);
            }
            catch (Exception exception) {
                System.err.println("Unable to load description in [" + this.getId() + "] " + exception.getMessage());
            }
            ++n;
        }
    }

    public void setGenerationFile(File file) {
        this.generationFile = file;
    }

    public synchronized void setId(int n) {
        this.id = n;
    }

    protected void setLoaded(boolean bl) {
        this.loaded = bl;
    }

    public synchronized void setNext(LRUAble lRUAble) {
        this.next = lRUAble;
    }

    public synchronized void setPrev(LRUAble lRUAble) {
        this.prev = lRUAble;
    }

    protected void setSaved(boolean bl) {
        this.saved = bl;
    }

    public void unload() {
        this.clean();
        this.saved = true;
        this.bytecount = 0L;
        this.cr_count = 0;
        Enumeration enumeration = this.lookupTable.keys();
        while (enumeration.hasMoreElements()) {
            this.lookupTable.put(enumeration.nextElement(), Boolean.TRUE);
        }
    }
}

