/*
 * Decompiled with CFR 0.152.
 */
package org.w3c.www.protocol.http.cache;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.FilenameFilter;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import org.w3c.tools.sorter.Sorter;
import org.w3c.util.LRUAble;
import org.w3c.util.ObservableProperties;
import org.w3c.util.PropertyMonitoring;
import org.w3c.util.SyncLRUList;
import org.w3c.www.protocol.http.cache.CacheFilter;
import org.w3c.www.protocol.http.cache.CacheGeneration;
import org.w3c.www.protocol.http.cache.CacheSerializer;
import org.w3c.www.protocol.http.cache.CacheSweeper;
import org.w3c.www.protocol.http.cache.CacheValidator;
import org.w3c.www.protocol.http.cache.CachedResource;
import org.w3c.www.protocol.http.cache.InvalidCacheException;
import org.w3c.www.protocol.http.cache.NoSuchResourceException;
import org.w3c.www.protocol.http.cache.StoreState;

public class CacheStore
implements PropertyMonitoring {
    public static final String CACHE_DIRECTORY_P = "org.w3c.www.protocol.http.cache.directory";
    public static final String STORE_SIZE_P = "org.w3c.www.protocol.http.cache.storesize";
    public static final String GARBAGE_COLLECTION_THRESHOLD_P = "org.w3c.www.protocol.http.cache.gc_threshold";
    public static final String FILE_SIZE_RATIO_P = "org.w3c.www.protocol.http.cache.fileSizeRatio";
    public static final String GARBAGE_COLLECTION_ENABLED_P = "org.w3c.www.protocol.http.cache.garbageCollectionEnabled";
    public static final String SYNCHRONIZATION_DELAY_P = "org.w3c.www.protocol.http.cache.SynchronizationDelay";
    public static final String GENERATION_COMPACT_DELAY_P = "org.w3c.www.protocol.http.cache.GenerationCompactDelay";
    public static final String MAX_CACHED_RESOURCES_P = "org.w3c.www.protocol.http.cache.MaxCachedResources";
    public static final String MAX_GENERATIONS_P = "org.w3c.www.protocol.http.cache.MaxGenerations";
    public static final String GENERATION_FILENAME = "gen-";
    private StoreState state = null;
    private File statefile = null;
    private SyncLRUList generations = null;
    private long bytelimit = 0L;
    private long storelimit = 0L;
    private long generationlimit = 0L;
    private int cr_limit = 0;
    private double threshold = 0.1;
    private double gc_kept_ratio = 0.8;
    private int nb_dir = 128;
    private File cache_dir = null;
    private File[] dirs = null;
    private boolean garbageCollectionEnabled = true;
    private CacheFilter filter = null;
    private boolean debug = false;
    private int max_generation = 10;
    private long sync_delay = 60000L;
    private long gencomp_delay = 60000L;
    protected ObservableProperties props = null;

    private CacheGeneration _loadGeneration(CacheGeneration cacheGeneration) throws InvalidCacheException {
        try {
            BufferedReader bufferedReader = new BufferedReader(new FileReader(cacheGeneration.getGenerationFile()));
            cacheGeneration = this.getSerializer().readGeneration(cacheGeneration, bufferedReader);
            this.state.notifyGenerationLoaded(cacheGeneration);
            return cacheGeneration;
        }
        catch (FileNotFoundException fileNotFoundException) {
            String string = "Generation file does not exists: " + cacheGeneration.getGenerationFile().getAbsolutePath();
            throw new InvalidCacheException(string);
        }
        catch (IOException iOException) {
            String string = "IOError reading " + cacheGeneration.getGenerationFile().getAbsolutePath();
            throw new InvalidCacheException(string);
        }
    }

    protected CacheGeneration addNewGeneration() throws InvalidCacheException {
        long l = this.bytelimit - this.state.getByteCount();
        if (this.state.getNbGeneration() < this.max_generation && l > this.generationlimit) {
            CacheGeneration cacheGeneration = new CacheGeneration(this, this.generationlimit);
            this.setGenerationFile(cacheGeneration);
            this.state.notifyGenerationCreated(cacheGeneration);
            this.generations.toHead(cacheGeneration);
            return cacheGeneration;
        }
        return null;
    }

    protected void checkDirs() {
        this.dirs = new File[this.nb_dir];
        int n = 0;
        while (n < this.nb_dir) {
            this.dirs[n] = new File(this.cache_dir, this.getFileNumber(n, 3));
            if (!this.dirs[n].exists()) {
                this.dirs[n].mkdirs();
            }
            ++n;
        }
    }

    protected synchronized void checkState() {
        long l = this.state.getByteCount();
        long l2 = this.state.getStoreCount();
        long l3 = this.state.getCrCount();
        int n = this.state.getEntryNum();
        int n2 = this.state.getNbGeneration();
        int n3 = this.state.getCurrentGeneration();
        double d = (double)l / (double)this.bytelimit * 100.0;
        String string = String.valueOf(d);
        if (string.length() > 5) {
            string = string.substring(0, 5);
        }
        System.out.println("  Ratio (BC/BL)*100    : " + string + " %");
        System.out.println(">>> Generations <<<");
        CacheGeneration cacheGeneration = this.getMRUGeneration();
        System.out.println("  Id  | Loaded  | CR cnt   | BT lim   | BT cnt   | ST cnt   | ratio");
        System.out.println(" ------------------------------------------------------------------------");
        long l4 = 0L;
        long l5 = 0L;
        while (cacheGeneration != null) {
            long l6 = cacheGeneration.getCachedByteCount();
            long l7 = cacheGeneration.getStoredByteCount();
            long l8 = cacheGeneration.getByteLimit();
            l4 += l6;
            l5 += l7;
            double d2 = (double)l6 / (double)l8 * 100.0;
            String string2 = String.valueOf(d2);
            if (string2.length() > 5) {
                string2 = string2.substring(0, 5);
            }
            System.out.print("  " + this.getFileNumber(cacheGeneration.getId(), 2));
            System.out.print("  |  " + cacheGeneration.isLoaded() + " ");
            System.out.print("  | " + this.getFileNumber(cacheGeneration.getCRCount(), 7));
            System.out.print("  | " + this.getFileNumber((int)l8, 7));
            System.out.print("  | " + this.getFileNumber((int)l6, 7));
            System.out.print("  | " + this.getFileNumber((int)l7, 7));
            System.out.println("  | " + string2 + " %");
            cacheGeneration = this.getNextGeneration(cacheGeneration);
        }
        System.out.println(">>> Check State <<<");
        System.out.println("  Byte Count  <= Byte Limit    : " + (l <= this.bytelimit));
        System.out.println("  Store Count <= Store Limit   : " + (l2 <= this.storelimit));
        System.out.println("  CR Count    <= CR Limit      : " + (l3 <= (long)this.cr_limit));
        System.out.println("  Byte Count  <= Store Count   : " + (l <= l2));
        System.out.println("  CR Count    <= Entry Num     : " + (l3 <= (long)n));
        System.out.println("  Current gen >= Number of gen : " + (n3 >= n2));
        System.out.println("  Generations SC == Store SC   : " + (l5 == l2));
        System.out.println("  Generations BC == Store BC   : " + (l4 == l));
    }

    protected int cleanCacheDir() {
        Hashtable hashtable = new Hashtable();
        CacheGeneration cacheGeneration = (CacheGeneration)this.generations.getHead();
        while (cacheGeneration != null) {
            Enumeration enumeration = cacheGeneration.getFiles();
            while (enumeration.hasMoreElements()) {
                hashtable.put(enumeration.nextElement(), Boolean.TRUE);
            }
            cacheGeneration = this.getNextGeneration(cacheGeneration);
        }
        int n = 0;
        int n2 = 0;
        while (n2 < this.dirs.length) {
            File[] fileArray = this.dirs[n2].listFiles();
            if (fileArray != null) {
                int n3 = 0;
                while (n3 < fileArray.length) {
                    if (hashtable.get(fileArray[n3]) == null && fileArray[n3].delete()) {
                        ++n;
                        if (this.debug) {
                            System.out.println(String.valueOf(String.valueOf(fileArray[n3])) + " not used, removed");
                        }
                    }
                    ++n3;
                }
            }
            ++n2;
        }
        return n;
    }

    protected void compactGenerations() {
        if (this.debug) {
            System.out.println("*** trying to compact generations");
        }
        if (this.state.getNbGeneration() < this.max_generation) {
            return;
        }
        if (this.debug) {
            System.out.println("*** compact: Max reached, compacting...");
        }
        CacheGeneration cacheGeneration = this.getMRUGeneration();
        cacheGeneration = this.getNextGeneration(cacheGeneration);
        while (cacheGeneration != null) {
            CacheGeneration cacheGeneration2;
            if (this.debug) {
                System.out.println("*** compact: working on generation " + cacheGeneration.getId());
            }
            if ((cacheGeneration2 = this.getNextGeneration(cacheGeneration)) == null) break;
            if (cacheGeneration.getCachedByteCount() + cacheGeneration2.getCachedByteCount() < cacheGeneration.getByteLimit()) {
                SyncLRUList syncLRUList = this.generations;
                synchronized (syncLRUList) {
                    if (this.debug) {
                        System.out.println("*** compact: merging (" + cacheGeneration.getId() + ") and (" + cacheGeneration2.getId() + ")");
                    }
                    this.generations.remove(cacheGeneration2);
                    cacheGeneration.copyInto(cacheGeneration2);
                    cacheGeneration2.deleteGenerationFile();
                    this.state.decrGenerationNum();
                }
            }
            cacheGeneration = this.getNextGeneration(cacheGeneration);
        }
    }

    public synchronized long getCachedByteCount() {
        return this.state.getByteCount();
    }

    public synchronized long getCachedByteFree() {
        return this.bytelimit - this.state.getByteCount();
    }

    public CachedResource getCachedResource(String string) throws InvalidCacheException {
        CacheGeneration cacheGeneration = (CacheGeneration)this.generations.getHead();
        if (cacheGeneration == null) {
            return null;
        }
        do {
            CachedResource cachedResource = null;
            if (cacheGeneration.isLoaded()) {
                cachedResource = cacheGeneration.lookupResource(string);
            } else if (cacheGeneration.containsResource(string)) {
                this.loadGeneration(cacheGeneration);
                cachedResource = cacheGeneration.lookupResource(string);
            }
            if (cachedResource == null) continue;
            try {
                CacheStore cacheStore = this;
                synchronized (cacheStore) {
                    this.removeResource(cacheGeneration, cachedResource);
                }
            }
            catch (NoSuchResourceException noSuchResourceException) {}
            return cachedResource;
        } while ((cacheGeneration = this.getNextGeneration(cacheGeneration)) != null);
        return null;
    }

    public CachedResource getCachedResource(CachedResource cachedResource) throws InvalidCacheException {
        CacheGeneration cacheGeneration = cachedResource.generation;
        if (cacheGeneration != null) {
            try {
                CacheStore cacheStore = this;
                synchronized (cacheStore) {
                    this.removeResource(cacheGeneration, cachedResource);
                }
            }
            catch (NoSuchResourceException noSuchResourceException) {}
            return cachedResource;
        }
        return cachedResource;
    }

    public CachedResource getCachedResourceReference(String string) throws InvalidCacheException {
        CacheGeneration cacheGeneration = (CacheGeneration)this.generations.getHead();
        if (cacheGeneration == null) {
            return null;
        }
        do {
            CachedResource cachedResource = null;
            if (cacheGeneration.isLoaded()) {
                cachedResource = cacheGeneration.lookupResource(string);
            } else if (cacheGeneration.containsResource(string)) {
                this.loadGeneration(cacheGeneration);
                cachedResource = cacheGeneration.lookupResource(string);
            }
            if (cachedResource == null) continue;
            return cachedResource;
        } while ((cacheGeneration = this.getNextGeneration(cacheGeneration)) != null);
        return null;
    }

    public long getCompactGenerationDelay() {
        return this.gencomp_delay;
    }

    /*
     * Unable to fully structure code
     */
    private String getFileNumber(int var1_1, int var2_2) {
        block2: {
            var3_3 = 0;
            var4_4 = var1_1;
            if (var4_4 != 0) ** GOTO lbl8
            var3_3 = 1;
            break block2;
lbl-1000:
            // 1 sources

            {
                var4_4 /= 10;
                ++var3_3;
lbl8:
                // 2 sources

                ** while (var4_4 > 0)
            }
        }
        var5_5 = var2_2 - var3_3;
        var6_6 = new StringBuffer();
        var7_7 = 0;
        while (var7_7 < var5_5) {
            var6_6.append("0");
            ++var7_7;
        }
        var6_6.append(Integer.toString(var1_1));
        return var6_6.toString();
    }

    private File[] getGenerationFiles() throws InvalidCacheException {
        FilenameFilter filenameFilter = new FilenameFilter(){

            public boolean accept(File file, String string) {
                return string.startsWith(CacheStore.GENERATION_FILENAME);
            }
        };
        if (this.cache_dir == null) {
            throw new InvalidCacheException("No Cache Directory!!");
        }
        if (!this.cache_dir.exists()) {
            this.cache_dir.mkdirs();
        }
        return this.cache_dir.listFiles(filenameFilter);
    }

    private int getGenerationId(File file) {
        String string = file.getName();
        int n = string.indexOf(45) + 1;
        String string2 = string.substring(n);
        try {
            return Integer.parseInt(string2);
        }
        catch (NumberFormatException numberFormatException) {
            return -1;
        }
    }

    public CacheGeneration getLRUGeneration() {
        return (CacheGeneration)this.generations.getTail();
    }

    public CacheGeneration getLRULoadedGeneration() {
        CacheGeneration cacheGeneration = (CacheGeneration)this.generations.getTail();
        while (cacheGeneration != null && !cacheGeneration.isLoaded()) {
            cacheGeneration = (CacheGeneration)this.generations.getPrev(cacheGeneration);
        }
        return cacheGeneration;
    }

    public CacheGeneration getMRUGeneration() {
        return (CacheGeneration)this.generations.getHead();
    }

    public float getMRUGenerationRatio() {
        CacheGeneration cacheGeneration = (CacheGeneration)this.generations.getHead();
        return cacheGeneration == null ? 0.0f : cacheGeneration.getFillRatio();
    }

    protected File getNewEntryFile() {
        int n;
        CacheStore cacheStore = this;
        synchronized (cacheStore) {
            n = this.state.incrEntryNum();
        }
        int n2 = n / this.nb_dir;
        int n3 = n % this.nb_dir;
        File file = this.dirs[n3];
        return new File(file, this.getFileNumber(n2, 4));
    }

    public CacheGeneration getNextGeneration(CacheGeneration cacheGeneration) {
        if (this.generations != null) {
            return (CacheGeneration)this.generations.getNext(cacheGeneration);
        }
        return null;
    }

    public CacheGeneration getPrevGeneration(CacheGeneration cacheGeneration) {
        if (this.generations != null) {
            return (CacheGeneration)this.generations.getPrev(cacheGeneration);
        }
        return null;
    }

    public long getRequiredByteNumber() {
        return (long)((double)this.state.getByteCount() - (double)this.bytelimit * this.gc_kept_ratio);
    }

    public CacheSerializer getSerializer() {
        return this.filter.serializer;
    }

    public StoreState getState() {
        return this.state;
    }

    public synchronized long getStoredByteCount() {
        return this.state.getStoreCount();
    }

    public CacheSweeper getSweeper() {
        return this.filter.sweeper;
    }

    public long getSyncDelay() {
        return this.sync_delay;
    }

    public CacheValidator getValidator() {
        return this.filter.validator;
    }

    public void initialize(CacheFilter cacheFilter) throws InvalidCacheException {
        this.filter = cacheFilter;
        this.props = cacheFilter.props;
        this.cache_dir = this.props.getFile(CACHE_DIRECTORY_P, null);
        if (this.cache_dir == null) {
            this.cache_dir = new File(System.getProperty("user.dir"));
            this.cache_dir = new File(this.cache_dir, ".web-cache");
        }
        this.bytelimit = this.props.getLong("org.w3c.www.protocol.http.cache.size", 0x1400000L);
        this.storelimit = this.props.getLong(STORE_SIZE_P, 0x1600000L);
        this.sync_delay = this.props.getLong(SYNCHRONIZATION_DELAY_P, 60000L);
        this.gencomp_delay = this.props.getLong(GENERATION_COMPACT_DELAY_P, 60000L);
        this.garbageCollectionEnabled = this.props.getBoolean(GARBAGE_COLLECTION_ENABLED_P, true);
        this.threshold = this.props.getDouble(FILE_SIZE_RATIO_P, 0.1);
        this.gc_kept_ratio = this.props.getDouble(GARBAGE_COLLECTION_THRESHOLD_P, 0.8);
        this.max_generation = this.props.getInteger(MAX_GENERATIONS_P, 10);
        this.generationlimit = this.bytelimit / (long)this.max_generation;
        this.debug = this.props.getBoolean("org.w3c.www.protocol.http.cache.debug", false);
        this.cr_limit = this.props.getInteger(MAX_CACHED_RESOURCES_P, 50000);
        this.statefile = new File(this.cache_dir, "state");
        this.loadState();
        this.checkDirs();
        System.out.println("Loading generations...");
        this.loadGenerations();
        System.out.println("Cleaning cache directories...");
        int n = this.cleanCacheDir();
        if (n > 0) {
            System.out.println(String.valueOf(n) + " unused files deleted.");
        }
    }

    protected CacheGeneration loadGeneration(CacheGeneration cacheGeneration) throws InvalidCacheException {
        CacheGeneration cacheGeneration2 = this.getLRULoadedGeneration();
        CacheStore cacheStore = this;
        synchronized (cacheStore) {
            if (this.getCachedByteFree() < this.generationlimit && cacheGeneration2 != null) {
                this.unloadGeneration(cacheGeneration2);
            }
            CacheGeneration cacheGeneration3 = this._loadGeneration(cacheGeneration);
            Object var5_5 = null;
            return cacheGeneration3;
        }
    }

    protected synchronized void loadGenerations() throws InvalidCacheException {
        this.generations = new SyncLRUList();
        Object[] objectArray = this.getGenerationFiles();
        if (objectArray == null) {
            throw new InvalidCacheException("No generation files!");
        }
        int n = objectArray.length;
        Vector vector = new Vector(n);
        int n2 = 0;
        while (n2 < n) {
            Sorter.orderedFileInsert((File)objectArray[n2], vector);
            ++n2;
        }
        vector.copyInto(objectArray);
        int n3 = 0;
        while (n3 < n) {
            block12: {
                Object object;
                int n4 = -1;
                try {
                    Object object2 = objectArray[n3];
                    n4 = this.getGenerationId((File)object2);
                    if (n4 != -1) {
                        object = new CacheGeneration(this, this.generationlimit);
                        BufferedReader bufferedReader = new BufferedReader(new FileReader((File)object2));
                        if (this.state.getCrCount() < this.cr_limit) {
                            this.getSerializer().readGeneration((CacheGeneration)object, bufferedReader);
                        } else {
                            this.getSerializer().readDescription((CacheGeneration)object, bufferedReader);
                        }
                        ((CacheGeneration)object).setId(n4);
                        ((CacheGeneration)object).setGenerationFile((File)object2);
                        this.generations.toHead((LRUAble)object);
                    } else if (this.debug) {
                        System.err.println("Invalid generation filename : " + ((File)objectArray[n3]).getName());
                    }
                }
                catch (FileNotFoundException fileNotFoundException) {
                    if (this.debug) {
                        object = "File not found generation[" + n4 + "]";
                        System.err.println(String.valueOf(object) + " " + fileNotFoundException.getMessage());
                    }
                }
                catch (IOException iOException) {
                    if (!this.debug) break block12;
                    object = "Error loading generation [" + n4 + "]";
                    System.err.println(String.valueOf(object) + " " + iOException.getMessage());
                }
            }
            ++n3;
        }
    }

    protected void loadState() {
        try {
            BufferedReader bufferedReader = new BufferedReader(new FileReader(this.statefile));
            this.state = (StoreState)this.getSerializer().read(bufferedReader);
        }
        catch (IOException iOException) {
            if (this.debug) {
                System.err.println("Can't load StoreState : " + iOException.getMessage());
            }
            this.state = new StoreState();
        }
    }

    public boolean propertyChanged(String string) {
        if (string.equals("org.w3c.www.protocol.http.cache.size")) {
            this.bytelimit = this.props.getLong(string, this.bytelimit);
            return true;
        }
        if (string.equals(STORE_SIZE_P)) {
            this.storelimit = this.props.getLong(string, this.storelimit);
            return true;
        }
        if (string.equals("org.w3c.www.protocol.http.cache.debug")) {
            this.debug = this.props.getBoolean(string, this.debug);
            return true;
        }
        if (string.equals(GARBAGE_COLLECTION_ENABLED_P)) {
            this.garbageCollectionEnabled = this.props.getBoolean(string, true);
            return true;
        }
        if (string.equals(FILE_SIZE_RATIO_P)) {
            double d = this.props.getDouble(string, this.threshold);
            if (d <= 1.0E-5 || d >= 1.0) {
                return false;
            }
            this.threshold = d;
            return true;
        }
        if (string.equals(GARBAGE_COLLECTION_THRESHOLD_P)) {
            double d = this.props.getDouble(string, this.gc_kept_ratio);
            if (d <= 1.0E-5 || d >= 1.0) {
                return false;
            }
            this.gc_kept_ratio = d;
            return true;
        }
        if (string.equals(MAX_GENERATIONS_P)) {
            int n = this.props.getInteger(string, this.max_generation);
            if (n <= 0) {
                return false;
            }
            this.max_generation = n;
            return true;
        }
        if (string.equals(MAX_CACHED_RESOURCES_P)) {
            int n = this.props.getInteger(string, this.cr_limit);
            if (n <= 0) {
                return false;
            }
            this.cr_limit = n;
            return true;
        }
        if (string.equals(SYNCHRONIZATION_DELAY_P)) {
            long l = this.props.getLong(string, this.sync_delay);
            if (l <= 0L) {
                return false;
            }
            this.sync_delay = l;
            return true;
        }
        if (string.equals(GENERATION_COMPACT_DELAY_P)) {
            long l = this.props.getLong(string, this.gencomp_delay);
            if (l <= 0L) {
                return false;
            }
            this.gencomp_delay = l;
            return true;
        }
        return true;
    }

    protected void removeResource(CacheGeneration cacheGeneration, CachedResource cachedResource) throws NoSuchResourceException {
        cacheGeneration.removeResource(cachedResource);
        this.state.notifyResourceRemoved(cachedResource);
    }

    protected synchronized void resizeGeneration(CacheGeneration cacheGeneration, CachedResource cachedResource) {
        long l;
        if (this.debug) {
            System.out.println("Resizing generation " + cacheGeneration.getId());
        }
        if ((l = (long)Math.max(cachedResource.getContentLength(), cachedResource.getCurrentLength())) > this.generationlimit) {
            cacheGeneration.setByteLimit(l);
            this.generationlimit = (this.bytelimit - l) / (long)(this.max_generation - 1);
        } else if (this.debug) {
            System.out.println("Asked for a not necessary resize!");
        }
    }

    protected void saveGeneration(CacheGeneration cacheGeneration) throws InvalidCacheException {
        if (cacheGeneration.isLoaded() && !cacheGeneration.isSaved()) {
            try {
                BufferedWriter bufferedWriter = new BufferedWriter(new FileWriter(cacheGeneration.getGenerationFile()));
                this.getSerializer().writeGeneration(cacheGeneration, bufferedWriter);
                cacheGeneration.setSaved(true);
            }
            catch (FileNotFoundException fileNotFoundException) {
                String string = "Generation file does not exists: " + cacheGeneration.getGenerationFile().getAbsolutePath();
                throw new InvalidCacheException(string);
            }
            catch (IOException iOException) {
                String string = "IOError writing on " + cacheGeneration.getGenerationFile().getAbsolutePath();
                throw new InvalidCacheException(string);
            }
        }
    }

    protected void saveState() {
        block2: {
            this.state.sync();
            try {
                BufferedWriter bufferedWriter = new BufferedWriter(new FileWriter(this.statefile));
                this.getSerializer().write(this.state, bufferedWriter);
            }
            catch (IOException iOException) {
                if (!this.debug) break block2;
                System.err.println("Can't load StoreState : " + iOException.getMessage());
            }
        }
    }

    private synchronized void setGenerationFile(CacheGeneration cacheGeneration) throws InvalidCacheException {
        int n = this.state.incrCurrentGeneration();
        File file = new File(this.cache_dir, GENERATION_FILENAME + this.getFileNumber(n, 4));
        if (this.debug) {
            System.err.println(file);
        }
        cacheGeneration.setGenerationFile(file);
        cacheGeneration.setId(n);
    }

    public boolean storeCachedResource(CachedResource cachedResource) throws InvalidCacheException {
        return this.storeCachedResource(cachedResource, 0L);
    }

    public boolean storeCachedResource(CachedResource cachedResource, long l) throws InvalidCacheException {
        long l2;
        CacheGeneration cacheGeneration = (CacheGeneration)this.generations.getHead();
        long l3 = cachedResource.getCurrentLength();
        if (l3 > (l2 = (long)((double)this.bytelimit * this.threshold))) {
            return false;
        }
        if (cacheGeneration != null) {
            if (cacheGeneration.addResource(cachedResource, l3, l)) {
                return true;
            }
            Object object = this.addNewGeneration();
            if (object != null) {
                if (!((CacheGeneration)object).addResource(cachedResource, l3, l)) {
                    this.resizeGeneration((CacheGeneration)object, cachedResource);
                    if (!((CacheGeneration)object).addResource(cachedResource, l3, l)) {
                        String string = "Unable to add a cachedResource in a resized generation!!";
                        throw new InvalidCacheException(string);
                    }
                }
            } else {
                Object object2;
                if (this.state.getStoreCount() < this.storelimit - this.generationlimit && this.state.getNbGeneration() < this.max_generation) {
                    while (object == null) {
                        Object object3;
                        object2 = this.getLRULoadedGeneration();
                        if (object2 == null) {
                            object3 = "No Generation Loaded but store limit reached";
                            throw new InvalidCacheException((String)object3);
                        }
                        object3 = this;
                        synchronized (object3) {
                            this.unloadGeneration((CacheGeneration)object2);
                            object = this.addNewGeneration();
                        }
                    }
                } else {
                    object2 = null;
                    CacheStore cacheStore = this;
                    synchronized (cacheStore) {
                        object2 = this.getLRUGeneration();
                        if (object2 == null) {
                            String string = "No Generation Loaded but store limit reached";
                            throw new InvalidCacheException(string);
                        }
                        ((CacheGeneration)object2).emptyGeneration();
                        long l4 = ((CacheGeneration)object2).getByteLimit();
                        this.generationlimit = (this.generationlimit * (long)(this.max_generation - 1) + l4) / (long)this.max_generation;
                        this.generations.toHead((LRUAble)object2);
                        this.setGenerationFile((CacheGeneration)object2);
                    }
                    this.getSweeper().collectStored((CacheGeneration)object2);
                    object = object2;
                }
                if (!((CacheGeneration)object).addResource(cachedResource, l3, l)) {
                    this.resizeGeneration((CacheGeneration)object, cachedResource);
                    if (!((CacheGeneration)object).addResource(cachedResource, l3, l)) {
                        object2 = "Unable to add a cachedResource in a resized generation!!";
                        throw new InvalidCacheException((String)object2);
                    }
                    return true;
                }
            }
        } else {
            CacheGeneration cacheGeneration2 = null;
            Object object = this;
            synchronized (object) {
                cacheGeneration2 = this.addNewGeneration();
            }
            if (cacheGeneration2 == null) {
                object = "Unable create the first generation!!";
                throw new InvalidCacheException((String)object);
            }
            if (!cacheGeneration2.addResource(cachedResource, l3, l)) {
                this.resizeGeneration(cacheGeneration2, cachedResource);
                if (!cacheGeneration2.addResource(cachedResource, l3, l)) {
                    object = "Unable to add a cachedResource in a resized generation!!";
                    throw new InvalidCacheException((String)object);
                }
                return true;
            }
        }
        return false;
    }

    public synchronized void sync() {
        CacheGeneration cacheGeneration = (CacheGeneration)this.generations.getHead();
        if (cacheGeneration == null) {
            return;
        }
        do {
            try {
                this.saveGeneration(cacheGeneration);
            }
            catch (InvalidCacheException invalidCacheException) {
                if (!this.debug) continue;
                System.err.println("Unable to save generation [" + cacheGeneration.getId() + "] " + invalidCacheException.getMessage());
            }
        } while ((cacheGeneration = this.getNextGeneration(cacheGeneration)) != null);
        this.saveState();
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(">>> CacheStore [").append(this.cache_dir.getAbsolutePath()).append("] <<<");
        stringBuffer.append("\n  Store limit          : ").append(this.storelimit);
        stringBuffer.append("\n  Byte limit           : ").append(this.bytelimit);
        stringBuffer.append("\n  CR limit             : ").append(this.cr_limit);
        stringBuffer.append(this.state);
        return stringBuffer.toString();
    }

    protected void unloadGeneration(CacheGeneration cacheGeneration) throws InvalidCacheException {
        try {
            BufferedWriter bufferedWriter = new BufferedWriter(new FileWriter(cacheGeneration.getGenerationFile()));
            this.getSerializer().writeGeneration(cacheGeneration, bufferedWriter);
            this.state.notifyGenerationUnloaded(cacheGeneration);
        }
        catch (FileNotFoundException fileNotFoundException) {
            String string = "Generation file does not exists: " + cacheGeneration.getGenerationFile().getAbsolutePath();
            throw new InvalidCacheException(string);
        }
        catch (IOException iOException) {
            String string = "IOError writing on " + cacheGeneration.getGenerationFile().getAbsolutePath();
            throw new InvalidCacheException(string);
        }
    }

    public CachedResource updateResourceGeneration(CachedResource cachedResource) throws InvalidCacheException {
        CacheGeneration cacheGeneration = (CacheGeneration)this.generations.getHead();
        if (cacheGeneration != cachedResource.generation) {
            try {
                CacheStore cacheStore = this;
                synchronized (cacheStore) {
                    this.removeResource(cachedResource.generation, cachedResource);
                }
            }
            catch (NoSuchResourceException noSuchResourceException) {}
            this.storeCachedResource(cachedResource, cachedResource.getCurrentLength());
        }
        return cachedResource;
    }

    protected void updateSweeperPriority() {
        long l = this.state.getByteCount();
        long l2 = this.state.getStoreCount();
        long l3 = this.state.getCrCount();
        CacheSweeper cacheSweeper = this.getSweeper();
        if (l > this.bytelimit) {
            cacheSweeper.setState(4);
        } else if (l > (long)((double)this.bytelimit * this.gc_kept_ratio)) {
            cacheSweeper.setState(3);
        } else if (l2 > this.storelimit) {
            cacheSweeper.setState(2);
        } else {
            cacheSweeper.setState(1);
        }
    }
}

