/*
 * Decompiled with CFR 0.152.
 */
package org.w3c.jigadm.editors;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Label;
import java.awt.Panel;
import java.awt.ScrollPane;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Properties;
import org.w3c.jigadm.PropertyManager;
import org.w3c.jigadm.RemoteResourceWrapper;
import org.w3c.jigadm.editors.ResourceHelper;
import org.w3c.jigsaw.admin.RemoteAccessException;
import org.w3c.tools.widgets.BorderPanel;
import org.w3c.tools.widgets.ImageButton;

public class ControlHelper
extends ResourceHelper {
    protected static final String CHECKPOINT_L = "Checkpoint";
    protected static final String SAVE_L = "Save";
    protected static final String STOP_L = "Stop";
    protected static final String RESTART_L = "Restart";
    private RemoteResourceWrapper rrw = null;
    private boolean initialized = false;
    protected Panel widget = new BorderPanel(2, 2);
    protected Label controlLabel = null;

    public ControlHelper() {
        this.widget.setLayout(new BorderLayout());
    }

    public void clearChanged() {
    }

    public void commitChanges() {
    }

    protected void executeAction(String string) {
        try {
            this.setMessage(String.valueOf(string) + " ...");
            this.rrw.getResource().loadResource(string);
            this.setMessage(String.valueOf(string) + " done.");
        }
        catch (Exception exception) {
            exception.printStackTrace();
            this.errorPopup("Error", exception);
        }
    }

    public Component getComponent() {
        return this.widget;
    }

    protected Image getIcon(PropertyManager propertyManager, String string) {
        return Toolkit.getDefaultToolkit().getImage(propertyManager.getIconLocation(string));
    }

    public final String getTitle() {
        return "Control";
    }

    public boolean hasChanged() {
        return false;
    }

    public void initControlPanel() {
        MouseButtonListener mouseButtonListener = new MouseButtonListener();
        ControlListener controlListener = new ControlListener();
        Panel panel = new Panel(new BorderLayout());
        PropertyManager propertyManager = PropertyManager.getPropertyManager();
        ScrollPane scrollPane = new ScrollPane();
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        Panel panel2 = new Panel(gridBagLayout);
        gridBagConstraints.insets = new Insets(5, 0, 0, 0);
        scrollPane.add(panel2);
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        Image image = this.getIcon(propertyManager, "checkpoint");
        Image image2 = this.getIcon(propertyManager, "save");
        Image image3 = this.getIcon(propertyManager, "stop");
        Image image4 = this.getIcon(propertyManager, "restart");
        ImageButton imageButton = new ImageButton(image, CHECKPOINT_L);
        imageButton.addActionListener(controlListener);
        imageButton.addMouseListener(mouseButtonListener);
        gridBagConstraints.gridwidth = 1;
        gridBagLayout.setConstraints(imageButton, gridBagConstraints);
        panel2.add(imageButton);
        Label label = new Label(CHECKPOINT_L);
        gridBagConstraints.gridwidth = 0;
        gridBagLayout.setConstraints(label, gridBagConstraints);
        panel2.add(label);
        imageButton = new ImageButton(image2, SAVE_L);
        imageButton.addActionListener(controlListener);
        imageButton.addMouseListener(mouseButtonListener);
        gridBagConstraints.gridwidth = 1;
        gridBagLayout.setConstraints(imageButton, gridBagConstraints);
        panel2.add(imageButton);
        label = new Label(SAVE_L);
        gridBagConstraints.gridwidth = 0;
        gridBagLayout.setConstraints(label, gridBagConstraints);
        panel2.add(label);
        imageButton = new ImageButton(image3, STOP_L);
        imageButton.addActionListener(controlListener);
        imageButton.addMouseListener(mouseButtonListener);
        gridBagConstraints.gridwidth = 1;
        gridBagLayout.setConstraints(imageButton, gridBagConstraints);
        panel2.add(imageButton);
        label = new Label(STOP_L);
        gridBagConstraints.gridwidth = 0;
        gridBagLayout.setConstraints(label, gridBagConstraints);
        panel2.add(label);
        imageButton = new ImageButton(image4, RESTART_L);
        imageButton.addActionListener(controlListener);
        imageButton.addMouseListener(mouseButtonListener);
        gridBagConstraints.gridwidth = 1;
        gridBagLayout.setConstraints(imageButton, gridBagConstraints);
        panel2.add(imageButton);
        label = new Label(RESTART_L);
        gridBagConstraints.gridwidth = 0;
        gridBagLayout.setConstraints(label, gridBagConstraints);
        panel2.add(label);
        panel.add("Center", panel2);
        this.widget.add("Center", panel);
        this.controlLabel = new Label("", 1);
        this.controlLabel.setBackground(Color.gray);
        this.controlLabel.setForeground(Color.white);
        BorderPanel borderPanel = new BorderPanel(3, 2);
        borderPanel.setLayout(new BorderLayout());
        borderPanel.add((Component)this.controlLabel, "Center");
        this.widget.add("South", borderPanel);
        this.widget.validate();
        this.widget.setVisible(true);
    }

    public void initialize(RemoteResourceWrapper remoteResourceWrapper, Properties properties) throws RemoteAccessException {
        this.rrw = remoteResourceWrapper;
        if (this.initialized) {
            return;
        }
        this.initialized = true;
        this.initControlPanel();
    }

    public void resetChanges() {
    }

    public void setMessage(String string) {
        this.controlLabel.setText(string);
    }

    class ControlListener
    implements ActionListener {
        ControlListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (actionEvent.getSource() instanceof ImageButton) {
                ControlHelper.this.executeAction(actionEvent.getActionCommand());
            }
        }
    }

    class MouseButtonListener
    extends MouseAdapter {
        MouseButtonListener() {
        }

        public void mouseEntered(MouseEvent mouseEvent) {
            Component component = mouseEvent.getComponent();
            if (component instanceof ImageButton) {
                String string = ((ImageButton)component).getActionCommand();
                if (string.equals(ControlHelper.CHECKPOINT_L)) {
                    ControlHelper.this.setMessage("Start the Checkpoint resource.");
                } else if (string.equals(ControlHelper.SAVE_L)) {
                    ControlHelper.this.setMessage("Save the current configuration.");
                } else if (string.equals(ControlHelper.STOP_L)) {
                    ControlHelper.this.setMessage("Stop the server.");
                } else if (string.equals(ControlHelper.RESTART_L)) {
                    ControlHelper.this.setMessage("Restart the server (doesn't work yet).");
                }
            }
        }

        public void mouseExited(MouseEvent mouseEvent) {
            ControlHelper.this.setMessage("");
        }
    }
}

