/*
 * Decompiled with CFR 0.152.
 */
package org.w3c.jigsaw.acl;

import java.net.InetAddress;
import java.util.Hashtable;
import org.w3c.jigsaw.acl.AclPrincipal;
import org.w3c.jigsaw.auth.AuthUser;
import org.w3c.jigsaw.auth.IPMatcher;

public class AuthUserPrincipal
implements AclPrincipal {
    protected String name = null;
    protected String password = null;
    protected String realm = null;
    protected Hashtable values = null;
    protected IPMatcher ipmatcher = null;

    public AuthUserPrincipal(AuthUser authUser, String string) {
        this.name = authUser.getName();
        this.password = authUser.getPassword();
        this.realm = string;
        this.ipmatcher = new IPMatcher();
        this.values = new Hashtable();
        short[][] sArray = authUser.getIPTemplates();
        if (sArray != null) {
            int n = 0;
            while (n < sArray.length) {
                this.ipmatcher.add(sArray[n], Boolean.TRUE);
                ++n;
            }
        }
    }

    public boolean equals(Object object) {
        if (object instanceof AuthUserPrincipal) {
            return this.toString().equals(object.toString());
        }
        return object.equals(this);
    }

    public String getName() {
        return this.name;
    }

    public String getPassword() {
        return this.password;
    }

    public String getRealm() {
        return this.realm;
    }

    public Object getValue(String string) {
        return this.values.get(string);
    }

    public int hashCode() {
        return this.toString().hashCode();
    }

    public boolean matchIP(InetAddress inetAddress) {
        return this.ipmatcher.lookup(inetAddress) == Boolean.TRUE;
    }

    public void setValue(String string, Object object) {
        this.values.put(string, object);
    }

    public String toString() {
        if (this.password == null) {
            return this.name;
        }
        return String.valueOf(this.name) + ":" + this.password;
    }
}

