/*
 * Decompiled with CFR 0.152.
 */
package org.w3c.jigsaw.http;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.PrintStream;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.URL;
import java.net.UnknownHostException;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import org.w3c.jigsaw.auth.RealmsCatalog;
import org.w3c.jigsaw.config.PropertySet;
import org.w3c.jigsaw.daemon.ServerHandler;
import org.w3c.jigsaw.daemon.ServerHandlerInitException;
import org.w3c.jigsaw.daemon.ServerHandlerManager;
import org.w3c.jigsaw.http.Client;
import org.w3c.jigsaw.http.ClientFactory;
import org.w3c.jigsaw.http.ConfigResource;
import org.w3c.jigsaw.http.ConnectionProp;
import org.w3c.jigsaw.http.GeneralProp;
import org.w3c.jigsaw.http.Logger;
import org.w3c.jigsaw.http.LoggingProp;
import org.w3c.jigsaw.http.MimeClientFactory;
import org.w3c.jigsaw.http.Reply;
import org.w3c.jigsaw.http.Request;
import org.w3c.jigsaw.http.Shuffler;
import org.w3c.jigsaw.http.httpdPreloadInterface;
import org.w3c.jigsaw.http.httpdSecurityManager;
import org.w3c.jigsaw.http.httpdStatistics;
import org.w3c.jigsaw.resources.CheckpointResource;
import org.w3c.tools.resources.AbstractContainer;
import org.w3c.tools.resources.DummyResourceReference;
import org.w3c.tools.resources.FilterInterface;
import org.w3c.tools.resources.FramedResource;
import org.w3c.tools.resources.InvalidResourceException;
import org.w3c.tools.resources.LookupResult;
import org.w3c.tools.resources.LookupState;
import org.w3c.tools.resources.ProtocolException;
import org.w3c.tools.resources.ReplyInterface;
import org.w3c.tools.resources.RequestInterface;
import org.w3c.tools.resources.Resource;
import org.w3c.tools.resources.ResourceContext;
import org.w3c.tools.resources.ResourceException;
import org.w3c.tools.resources.ResourceFilter;
import org.w3c.tools.resources.ResourceReference;
import org.w3c.tools.resources.ResourceSpace;
import org.w3c.tools.resources.ServerInterface;
import org.w3c.tools.resources.indexer.IndexerModule;
import org.w3c.tools.resources.indexer.IndexersCatalog;
import org.w3c.tools.resources.indexer.ResourceIndexer;
import org.w3c.tools.resources.serialization.xml.XMLSerializer;
import org.w3c.tools.resources.store.ResourceStoreManager;
import org.w3c.tools.resources.upgrade.Upgrader;
import org.w3c.tools.timers.EventManager;
import org.w3c.util.IO;
import org.w3c.util.ObservableProperties;
import org.w3c.util.PropertyMonitoring;
import org.w3c.util.Status;
import org.w3c.www.http.HttpEntityMessage;
import org.w3c.www.http.HttpFactory;
import org.w3c.www.http.HttpMessage;
import org.w3c.www.http.HttpReplyMessage;
import org.w3c.www.http.HttpTokenList;
import org.w3c.www.mime.MimeParserFactory;
import org.w3c.www.mime.MimeType;

public class httpd
implements ServerInterface,
Runnable,
PropertyMonitoring,
Cloneable,
Status {
    public static final String version = "2.2.5";
    public static final int verscount = 4;
    public static final boolean debug = true;
    public static final String VERSCOUNT_P = "org.w3c.jigsaw.version.counter";
    public static final String SERVER_SOFTWARE_P = "org.w3c.jigsaw.server";
    public static final String DEFHOSTIP_P = "org.w3c.jigsaw.defhostip";
    public static final String HOST_P = "org.w3c.jigsaw.host";
    public static final String ROOT_P = "org.w3c.jigsaw.root";
    public static final String CONFIG_P = "org.w3c.jigsaw.config";
    public static final String SPACE_P = "org.w3c.jigsaw.space";
    public static final String PORT_P = "org.w3c.jigsaw.port";
    public static final String TRACE_P = "org.w3c.jigsaw.trace";
    public static final String KEEP_ALIVE_P = "org.w3c.jigsaw.keepAlive";
    public static final String KEEP_TIMEOUT_P = "org.w3c.jigsaw.keep_alive.timeout";
    public static final String REQUEST_TIMEOUT_P = "org.w3c.jigsaw.request.timeout";
    public static final String CLIENT_PRIORITY_P = "org.w3c.jigsaw.client.priority";
    public static final String CLIENT_BUFSIZE_P = "org.w3c.jigsaw.client.bufsize";
    public static final String CLIENT_DEBUG_P = "org.w3c.jigsaw.client.debug";
    public static final String USE_SM_P = "org.w3c.http.useSecurityManager";
    public static final String LOGGER_P = "org.w3c.jigsaw.logger";
    public static final String LENIENT_P = "org.w3c.jigsaw.http.lenient";
    public static final String CLIENT_FACTORY_P = "org.w3c.jigsaw.http.ClientFactory";
    public static final String SHUFFLER_PATH_P = "org.w3c.jigsaw.shuffler.path";
    public static final String ROOT_NAME_P = "org.w3c.jigsaw.root.name";
    public static final String ROOT_CLASS_P = "org.w3c.jigsaw.root.class";
    public static final String MAX_LOADED_STORE_P = "org.w3c.jigsaw.loadedstore";
    public static final int MAX_LOADED_STORE = 128;
    int max_loaded_store = -1;
    public static final String STORE_SIZE_LIMIT_P = "org.w3c.jigsaw.storesize";
    public static final int STORE_SIZE_LIMIT = -1;
    int store_size_limit = -1;
    public static final String PROPS_P = "org.w3c.jigsaw.propfile";
    public static final String FS_SENSITIVITY = "org.w3c.jigsaw.checkSensitivity";
    public static String DOCURL_P = "org.w3c.jigsaw.docurl";
    public static String STARTUP_P = "org.w3c.jigsaw.startup";
    public static String TRASHDIR_P = "org.w3c.jigsaw.trashdir";
    public static String CHECKURL_P = "org.w3c.jigsaw.checkpointer";
    public static String PUBLIC_P = "org.w3c.jigsaw.publicMethods";
    public static String EDIT_ROOT_P = "org.w3c.jigsaw.edit.root";
    public static String SERIALIZER_CLASS_P = "org.w3c.jigsaw.serializer";
    public static String SERVER_USER_P = "org.w3c.jigsaw.unix.user";
    public static String SERVER_GROUP_P = "org.w3c.jigsaw.unix.group";
    public static String DISPLAY_URL_ON_ERROR_P = "org.w3c.jigsaw.error.url";
    private static Hashtable servers = new Hashtable();
    public Thread thread = null;
    private String software = "Jigsaw/2.2.5";
    private ServerSocket socket = null;
    private Logger logger = null;
    private Shuffler shuffler = null;
    public EventManager timer = null;
    ClientFactory factory = null;
    protected int[] instances = new int[]{1};
    private ServerHandlerManager shm = null;
    private String identifier = null;
    private httpdStatistics statistics = null;
    protected ObservableProperties props = null;
    private boolean tracep = false;
    private boolean keep = true;
    private String logger_class = null;
    private boolean uri_error = false;
    private boolean lenient = true;
    private String factory_class = "org.w3c.jigsaw.http.socket.SocketClientFactory";
    private String shuffler_path = null;
    private File root_dir = null;
    private File space_dir = null;
    protected String host = null;
    protected int port = 8001;
    private boolean client_debug = false;
    private int request_time_out = 1200000;
    private int connection_time_out = 1200000;
    private int client_priority = 5;
    private int client_bufsize = 4096;
    private boolean sensitivity = true;
    public FramedResource root = null;
    private ResourceReference root_reference = null;
    protected URL url = null;
    private boolean finishing = false;
    private boolean restarting = false;
    private ResourceIndexer indexer = null;
    private RealmsCatalog realms = null;
    private ResourceStoreManager manager = null;
    private String root_name = null;
    private String root_class = null;
    private String docurl = null;
    private String trashdir = null;
    private String checkurl = null;
    private String[] publicMethods = new String[]{"GET", "HEAD", "PUT", "POST", "LINK", "UNLINK", "DELETE", "OPTIONS", "TRACE"};
    private HttpTokenList publicHeader = null;
    private ResourceReference editroot = null;
    private Vector propSet = new Vector(8);
    private IndexersCatalog indexers = null;
    private ResourceContext context = null;
    private AbstractContainer configResource = null;
    private ResourceReference rr_configResource = null;
    private boolean isAClone = false;
    private String masterID = null;

    private synchronized FramedResource changeRoot(String string) {
        ResourceReference resourceReference = this.loadRoot(string);
        FramedResource framedResource = this.root;
        String string2 = this.root_name;
        if (resourceReference != null) {
            try {
                this.root = (FramedResource)resourceReference.lock();
                this.root_name = string;
                if (this.root_reference != null) {
                    this.root_reference.unlock();
                }
                this.root_reference = resourceReference;
                return this.root;
            }
            catch (InvalidResourceException invalidResourceException) {
                this.root = framedResource;
                this.root_name = string2;
                return null;
            }
        }
        return null;
    }

    public boolean checkFileSystemSensitivity() {
        return this.sensitivity;
    }

    protected boolean checkUpgrade(String string, ObservableProperties observableProperties) {
        int n = observableProperties.getInteger(VERSCOUNT_P, 1);
        if (n < 4) {
            System.err.println("*** Jigsaw needs upgrade from internal version " + n + " to " + 4);
            XMLSerializer xMLSerializer = new XMLSerializer();
            ((Hashtable)observableProperties).put(SERIALIZER_CLASS_P, "org.w3c.tools.resources.serialization.xml.XMLSerializer");
            File file = observableProperties.getFile(PROPS_P, null);
            Upgrader upgrader = new Upgrader(string, this.getConfigDirectory(), file, xMLSerializer);
            ((Hashtable)observableProperties).put(VERSCOUNT_P, String.valueOf(4));
            ((Hashtable)observableProperties).put(SERVER_SOFTWARE_P, "Jigsaw/2.2.5");
            try {
                upgrader.upgrade(4);
                return true;
            }
            catch (Exception exception) {
                System.err.println(exception.getMessage());
                return false;
            }
        }
        return true;
    }

    public void checkpoint() {
        this.manager.checkpoint();
    }

    protected void cleanTempDirectory() {
        IO.clean(this.getTempDirectory());
    }

    protected synchronized void cleanup(boolean bl) {
        try {
            this.socket.close();
            this.socket = null;
        }
        catch (IOException iOException) {
            this.errlog("[cleanup]: IOException while closing server socket.");
        }
        int[] nArray = this.instances;
        synchronized (nArray) {
            this.instances[0] = this.instances[0] - 1;
            if (this.factory != null) {
                this.factory.shutdown(true);
            }
            this.factory = null;
            if (this.manager != null && this.instances[0] == 0) {
                this.manager.shutdown();
            }
            this.manager = null;
            if (this.shuffler != null) {
                this.shuffler.shutdown();
            }
            this.shuffler = null;
            this.props.unregisterObserver(this);
            this.errlog("shutdown completed at: " + new Date() + ".");
            if (this.logger != null && this.instances[0] == 0) {
                this.logger.shutdown();
            }
            this.logger = null;
            this.timer.stopEventManager();
            System.out.println(String.valueOf(this.getIdentifier()) + ": " + this.getURL() + " done.");
            System.out.flush();
            File file = this.props.getFile(PROPS_P, null);
            ObservableProperties observableProperties = this.props;
            String string = this.identifier;
            this.identifier = null;
            this.manager = null;
            this.factory = null;
            this.shuffler = null;
            this.indexer = null;
            this.root = null;
            this.realms = null;
            this.logger = null;
            this.socket = null;
            this.timer = null;
            this.thread = null;
            this.url = null;
            this.restarting = false;
            this.finishing = false;
            if (bl) {
                try {
                    this.instances[0] = this.instances[0] + 1;
                    this.initialize(this.shm, string, observableProperties);
                    this.start();
                }
                catch (Exception exception) {
                    System.out.println("*** server restart failed.");
                    exception.printStackTrace();
                }
            }
        }
    }

    public ServerHandler clone(ServerHandlerManager serverHandlerManager, String string, ObservableProperties observableProperties) throws ServerHandlerInitException {
        httpd httpd2 = null;
        try {
            httpd2 = (httpd)this.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new ServerHandlerInitException(String.valueOf(this.getClass().getName()) + ": clone not supported !");
        }
        httpd2.shm = serverHandlerManager;
        httpd2.url = null;
        httpd2.masterID = httpd2.identifier;
        httpd2.identifier = string;
        httpd2.props = observableProperties;
        httpd2.props.registerObserver(httpd2);
        httpd2.initializeProperties();
        httpd2.initializeServerSocket();
        httpd2.isAClone = true;
        return httpd2;
    }

    public void debug(boolean bl) {
        this.tracep = bl;
    }

    public Enumeration enumeratePropertySet() {
        return this.propSet.elements();
    }

    public void errlog(Object object, String string) {
        if (this.logger != null) {
            this.logger.errlog("[" + object.getClass().getName() + "]: " + string);
        }
    }

    public void errlog(String string) {
        if (this.logger != null) {
            this.logger.errlog("[" + this.identifier + "] " + string);
        }
    }

    public void errlog(Client client, String string) {
        if (this.logger != null) {
            this.logger.errlog(client, string);
        }
    }

    public void errlog(Resource resource, String string) {
        if (this.logger != null) {
            this.logger.errlog(String.valueOf(resource.getClass().getName()) + "@" + resource.getURLPath() + ": " + string);
        }
    }

    public void fatal(Exception exception, String string) {
        System.out.println("*** Fatal Error, aborting");
        System.out.println(String.valueOf(this.getClass().getName()) + ": " + string);
        exception.printStackTrace();
        throw new RuntimeException(string);
    }

    public void fatal(String string) {
        System.out.println("*** Fatal error, aborting");
        System.out.println(String.valueOf(this.getClass().getName()) + ": " + string);
        throw new RuntimeException(string);
    }

    public File getAuthDirectory() {
        return new File(this.getConfigDirectory(), "auth");
    }

    protected String getBanner() {
        return "Jigsaw[2.2.5]";
    }

    public final int getClientBufferSize() {
        return this.client_bufsize;
    }

    public final boolean getClientDebug() {
        return this.client_debug;
    }

    public final boolean getClientKeepConnection() {
        return this.keep;
    }

    public final int getClientThreadPriority() {
        return this.client_priority;
    }

    public File getConfigDirectory() {
        File file = this.props.getFile(CONFIG_P, null);
        return file == null ? new File(this.getRootDirectory(), "config") : file;
    }

    public ResourceReference getConfigResource() {
        if (this.rr_configResource == null) {
            this.configResource = new ConfigResource(this);
            this.rr_configResource = new DummyResourceReference(this.configResource);
        }
        return this.rr_configResource;
    }

    public final int getConnectionTimeOut() {
        return this.connection_time_out;
    }

    public ResourceContext getDefaultContext() {
        return this.context;
    }

    public String getDocumentationURL() {
        return this.docurl;
    }

    public synchronized ResourceReference getEditRoot() {
        if (this.editroot == null) {
            String string = this.props.getString(EDIT_ROOT_P, null);
            if (string != null) {
                this.editroot = this.loadRoot(string);
            }
            if (this.editroot == null) {
                this.editroot = this.getRootReference();
            }
        }
        return this.editroot;
    }

    public String getHTMLStatus() {
        StringBuffer stringBuffer = new StringBuffer();
        if (this.factory instanceof Status) {
            stringBuffer.append(((Status)((Object)this.factory)).getHTMLStatus());
        }
        stringBuffer.append(this.manager.getHTMLStatus());
        return stringBuffer.toString();
    }

    public String getHost() {
        return this.host;
    }

    public String getIdentifier() {
        return this.identifier;
    }

    public File getIndexerDirectory() {
        return new File(this.getConfigDirectory(), "indexers");
    }

    public IndexersCatalog getIndexersCatalog() {
        if (this.indexers == null) {
            this.indexers = new IndexersCatalog(new ResourceContext(this.getDefaultContext()));
        }
        return this.indexers;
    }

    public InetAddress getInetAddress() {
        return this.socket.getInetAddress();
    }

    public int getLocalPort() {
        return this.socket.getLocalPort();
    }

    public Logger getLogger() {
        return this.logger;
    }

    protected MimeParserFactory getMimeClientFactory(Client client) {
        return new MimeClientFactory(client);
    }

    public int getPort() {
        return this.port;
    }

    public ObservableProperties getProperties() {
        return this.props;
    }

    public Resource getPropertySet(String string) {
        int n = 0;
        while (n < this.propSet.size()) {
            PropertySet propertySet = (PropertySet)this.propSet.elementAt(n);
            if (propertySet.getIdentifier().equals(string)) {
                return propertySet;
            }
            ++n;
        }
        return null;
    }

    public RealmsCatalog getRealmsCatalog() {
        return this.realms;
    }

    public final int getRequestTimeOut() {
        return this.request_time_out;
    }

    public ResourceSpace getResourceSpace() {
        return this.manager;
    }

    public ResourceStoreManager getResourceStoreManager() {
        return this.manager;
    }

    public FramedResource getRoot() {
        return this.root;
    }

    public File getRootDirectory() {
        return this.root_dir;
    }

    public ResourceReference getRootReference() {
        return this.root_reference;
    }

    public synchronized Shuffler getShuffler(Client client) {
        return this.shuffler;
    }

    public String getSoftware() {
        return this.software;
    }

    public File getSpaceDir() {
        return this.space_dir;
    }

    public httpdStatistics getStatistics() {
        return this.statistics;
    }

    public File getStoreDirectory() {
        return new File(this.getConfigDirectory(), "stores");
    }

    public File getTempDirectory() {
        return new File(this.getRootDirectory(), "tmp");
    }

    public String getTrashDirectory() {
        return this.trashdir;
    }

    public URL getURL() {
        if (this.url == null) {
            try {
                this.url = this.port != 80 ? new URL("http", this.host, this.port, "/") : new URL("http", this.host, "/");
            }
            catch (MalformedURLException malformedURLException) {
                throw new RuntimeException("unable to build server's URL");
            }
        }
        return this.url;
    }

    public void initialize(ServerHandlerManager serverHandlerManager, String string, ObservableProperties observableProperties) throws ServerHandlerInitException {
        this.shm = serverHandlerManager;
        this.identifier = string;
        this.props = observableProperties;
        this.props.registerObserver(this);
        this.initializeProperties();
        if (!this.checkUpgrade(string, observableProperties)) {
            throw new ServerHandlerInitException("Upgrade failed.");
        }
        this.initializeServerSocket();
    }

    private void initializeEventManager() {
        this.timer = new EventManager();
        this.timer.setDaemon(true);
        this.timer.start();
    }

    private void initializeIndexer() {
        ResourceContext resourceContext = this.getDefaultContext();
        IndexersCatalog indexersCatalog = this.getIndexersCatalog();
        IndexerModule indexerModule = new IndexerModule(indexersCatalog);
        indexerModule.registerIndexer(resourceContext, "default");
        resourceContext.registerModule(IndexerModule.NAME, indexerModule);
    }

    private void initializeLogger() throws ServerHandlerInitException {
        if (this.logger_class != null) {
            try {
                this.logger = (Logger)Class.forName(this.logger_class).newInstance();
                this.logger.initialize(this);
            }
            catch (Exception exception) {
                String string = "Unable to create logger of class [" + this.logger_class + "]" + "\r\ndetails: \r\n" + exception.getMessage();
                throw new ServerHandlerInitException(string);
            }
        } else {
            this.warning(String.valueOf(this.getBanner()) + ": no logger specified, not logging.");
        }
        this.statistics = new httpdStatistics(this);
    }

    protected void initializeProperties() throws ServerHandlerInitException {
        String string = null;
        String string2 = null;
        String string3 = null;
        boolean bl = this.props.getBoolean(DEFHOSTIP_P, false);
        try {
            string = bl ? InetAddress.getLocalHost().getHostAddress() : InetAddress.getLocalHost().getHostName();
        }
        catch (UnknownHostException unknownHostException) {
            string = null;
        }
        this.software = this.props.getString(SERVER_SOFTWARE_P, this.software);
        this.tracep = this.props.getBoolean(TRACE_P, this.tracep);
        this.uri_error = this.props.getBoolean(DISPLAY_URL_ON_ERROR_P, false);
        this.lenient = this.props.getBoolean(LENIENT_P, true);
        this.keep = this.props.getBoolean(KEEP_ALIVE_P, this.keep);
        this.logger_class = this.props.getString(LOGGER_P, null);
        this.factory_class = this.props.getString(CLIENT_FACTORY_P, this.factory_class);
        this.shuffler_path = this.props.getString(SHUFFLER_PATH_P, null);
        string2 = this.props.getString(ROOT_P, null);
        string3 = this.props.getString(SPACE_P, null);
        this.host = this.props.getString(HOST_P, string);
        this.port = this.props.getInteger(PORT_P, this.port);
        this.root_name = this.props.getString(ROOT_NAME_P, "root");
        this.root_class = this.props.getString(ROOT_CLASS_P, null);
        this.max_loaded_store = this.props.getInteger(MAX_LOADED_STORE_P, 128);
        this.store_size_limit = this.props.getInteger(STORE_SIZE_LIMIT_P, -1);
        this.sensitivity = this.props.getBoolean(FS_SENSITIVITY, true);
        this.publicMethods = this.props.getStringArray(PUBLIC_P, this.publicMethods);
        this.client_debug = this.props.getBoolean(CLIENT_DEBUG_P, this.client_debug);
        this.request_time_out = this.props.getInteger(REQUEST_TIMEOUT_P, this.request_time_out);
        this.connection_time_out = this.props.getInteger(KEEP_TIMEOUT_P, this.connection_time_out);
        this.client_priority = this.props.getInteger(CLIENT_PRIORITY_P, this.client_priority);
        this.client_bufsize = this.props.getInteger(CLIENT_BUFSIZE_P, this.client_bufsize);
        if (this.host == null) {
            throw new ServerHandlerInitException(String.valueOf(this.getClass().getName()) + "[initializeProperties]: " + "[host] undefined.");
        }
        if (string2 == null && (string2 = System.getProperties().getProperty("user.dir", null)) == null) {
            throw new ServerHandlerInitException(String.valueOf(this.getClass().getName()) + "[initializeProperties]:" + "[root] undefined.");
        }
        this.root_dir = new File(string2);
        this.space_dir = string3 == null ? new File(this.root_dir, "WWW") : new File(string3);
        String string4 = this.props.getString(DOCURL_P, null);
        if (string4 != null) {
            try {
                URL uRL = new URL(this.getURL(), string4);
                this.docurl = uRL.toExternalForm();
            }
            catch (Exception exception) {}
        }
        this.trashdir = this.props.getString(TRASHDIR_P, this.trashdir);
        this.checkurl = this.props.getString(CHECKURL_P, this.checkurl);
    }

    protected void initializePropertySets() {
        this.registerPropertySet(new GeneralProp("general", this));
        this.registerPropertySet(new ConnectionProp("connection", this));
        this.registerPropertySet(new LoggingProp("logging", this));
    }

    private void initializeRealmsCatalog() {
        this.realms = new RealmsCatalog(new ResourceContext(this.getDefaultContext()));
    }

    private void initializeResourceSpace(String string, String string2, String string3, String string4, int n) {
        Hashtable<String, Object> hashtable = new Hashtable<String, Object>(11);
        hashtable.put("url", "/");
        hashtable.put("directory", this.space_dir);
        hashtable.put("context", this.getDefaultContext());
        this.manager = new ResourceStoreManager(string, this.getStoreDirectory(), string2, string3, string4, n, this.store_size_limit, hashtable);
    }

    private void initializeRootResource() throws ServerHandlerInitException {
        if (this.changeRoot(this.root_name) == null) {
            String string = "Unable to restore root resource [" + this.root_name + "]" + " from store (not found).";
            throw new ServerHandlerInitException(string);
        }
    }

    private void initializeServerSocket() throws ServerHandlerInitException {
        try {
            Class<?> clazz = Class.forName(this.factory_class);
            this.factory = (ClientFactory)clazz.newInstance();
            this.factory.initialize(this);
        }
        catch (Exception exception) {
            String string = "Unable to create a client factory of class \"" + this.factory_class + "\"" + " details: \r\n" + exception.getMessage();
            throw new ServerHandlerInitException(string);
        }
        try {
            this.socket = this.factory.createServerSocket();
        }
        catch (IOException iOException) {
            String string = "Unable to create server socket on port " + this.port + ": " + iOException.getMessage() + ".";
            throw new ServerHandlerInitException(string);
        }
        this.thread = new Thread(this);
        this.thread.setName(this.identifier);
        this.thread.setPriority(10);
    }

    public boolean isLenient() {
        return this.lenient;
    }

    public ResourceReference loadResource(String string) {
        Hashtable<String, Object> hashtable = new Hashtable<String, Object>(11);
        hashtable.put("url", "/" + string);
        hashtable.put("directory", this.space_dir);
        ResourceContext resourceContext = new ResourceContext(this.getDefaultContext());
        hashtable.put("context", resourceContext);
        ResourceReference resourceReference = this.manager.loadRootResource(string, hashtable);
        if (resourceReference != null) {
            resourceContext.setResourceReference(resourceReference);
        }
        return resourceReference;
    }

    public synchronized ResourceReference loadRoot(String string) {
        Object object;
        Object var2_2 = null;
        String string2 = this.props.getString(EDIT_ROOT_P, null);
        Hashtable<String, Object> hashtable = new Hashtable<String, Object>(11);
        hashtable.put("url", "/");
        hashtable.put("directory", this.space_dir);
        ResourceContext resourceContext = null;
        if (string2 != null && !string.equals(string2)) {
            if (this.editroot == null) {
                object = new Hashtable<String, String>(11);
                ((Hashtable)object).put("url", "/");
                ((Hashtable)object).put("directory", this.space_dir);
                ResourceContext resourceContext2 = new ResourceContext(this.getDefaultContext());
                ((Hashtable)object).put("context", resourceContext2);
                this.editroot = this.manager.loadRootResource(string2, (Hashtable)object);
                if (this.editroot != null) {
                    resourceContext2.setResourceReference(this.editroot);
                }
            }
            resourceContext = new ResourceContext(this.editroot);
        } else {
            resourceContext = new ResourceContext(this.getDefaultContext());
        }
        hashtable.put("context", resourceContext);
        object = this.manager.loadRootResource(string, hashtable);
        if (object != null) {
            resourceContext.setResourceReference((ResourceReference)object);
        }
        return object;
    }

    protected void loadStartupClasses() {
        String[] stringArray = this.props.getStringArray(STARTUP_P, null);
        if (stringArray != null) {
            int n = 0;
            while (n < stringArray.length) {
                try {
                    Class<?> clazz = Class.forName(stringArray[n]);
                    httpdPreloadInterface httpdPreloadInterface2 = (httpdPreloadInterface)clazz.newInstance();
                    httpdPreloadInterface2.preload(this);
                }
                catch (ClassNotFoundException classNotFoundException) {
                    this.errlog("Startup class not found : " + classNotFoundException.getMessage());
                }
                catch (InstantiationException instantiationException) {
                    this.errlog("Unable to instanciate : " + instantiationException.getMessage());
                }
                catch (ClassCastException classCastException) {
                    this.errlog("Startup classes must be instance of httpdPreloadInterface: " + classCastException.getMessage());
                }
                catch (IllegalAccessException illegalAccessException) {
                    this.errlog("IllegalAccess " + illegalAccessException.getMessage());
                }
                ++n;
            }
        }
    }

    public void log(String string) {
        this.logger.log(string);
    }

    public void log(Client client, Request request, Reply reply, int n, long l) {
        if (this.logger != null) {
            this.logger.log(request, reply, n, l);
        }
        this.statistics.updateStatistics(client, request, reply, n, l);
    }

    public static void main(String[] stringArray) {
        Object object;
        int n;
        File file;
        Integer n2 = null;
        String string = null;
        String string2 = null;
        String string3 = null;
        String string4 = null;
        String string5 = "http-server";
        String string6 = "config";
        Boolean bl = null;
        boolean bl2 = false;
        String string7 = null;
        int n3 = 0;
        while (n3 < stringArray.length) {
            if (stringArray[n3].equals("-port")) {
                try {
                    n2 = new Integer(stringArray[++n3]);
                }
                catch (NumberFormatException numberFormatException) {
                    System.out.println("invalid port number [" + stringArray[n3] + "]");
                    System.exit(1);
                }
            } else if (stringArray[n3].equals("-id") && n3 + 1 < stringArray.length) {
                string5 = stringArray[++n3];
            } else if (stringArray[n3].equals("-maxstores") && n3 + 1 < stringArray.length) {
                string7 = stringArray[++n3];
            } else if (stringArray[n3].equals("-host") && n3 + 1 < stringArray.length) {
                string = stringArray[++n3];
            } else if (stringArray[n3].equals("-root") && n3 + 1 < stringArray.length) {
                string2 = stringArray[++n3];
            } else if (stringArray[n3].equals("-space") && n3 + 1 < stringArray.length) {
                string3 = stringArray[++n3];
            } else if (stringArray[n3].equals("-p") && n3 + 1 < stringArray.length) {
                string4 = stringArray[++n3];
            } else if (stringArray[n3].equals("-trace")) {
                bl = Boolean.TRUE;
            } else if (stringArray[n3].equals("?") || stringArray[n3].equals("-help")) {
                httpd.usage();
            } else if (stringArray[n3].equals("-config") && n3 + 1 < stringArray.length) {
                string6 = stringArray[++n3];
            } else if (stringArray[n3].equals("-noupgrade")) {
                bl2 = true;
            }
            ++n3;
        }
        ObservableProperties observableProperties = null;
        observableProperties = new ObservableProperties(System.getProperties());
        File file2 = string2 == null ? new File(observableProperties.getProperty("user.dir", null)) : new File(string2);
        File file3 = new File(file2, string6);
        if (string4 == null) {
            file = new File(file3, String.valueOf(string5) + ".props");
            if (!file.exists()) {
                file = new File(file3, "httpd.props");
            }
            string4 = file.getAbsolutePath();
        }
        if (string4 != null) {
            System.out.println("loading properties from: " + string4);
            try {
                file = new File(string4);
                observableProperties.load(new FileInputStream(file));
                ((Hashtable)observableProperties).put(PROPS_P, file.getAbsolutePath());
            }
            catch (FileNotFoundException fileNotFoundException) {
                System.out.println("Unable to load properties: " + string4);
                System.out.println("\t" + fileNotFoundException.getMessage());
                System.exit(1);
            }
            catch (IOException iOException) {
                System.out.println("Unable to load properties: " + string4);
                System.out.println("\t" + iOException.getMessage());
                System.exit(1);
            }
            System.setProperties(observableProperties);
        }
        if ((n = observableProperties.getInteger(VERSCOUNT_P, 1)) < 4) {
            System.err.println("+ Jigsaw needs upgrade from internal version " + n + " to " + 4);
            if (bl2) {
                System.err.println("+ Jigsaw cannot run in that version.");
                System.exit(1);
            }
            return;
        }
        if (n2 != null) {
            ((Hashtable)observableProperties).put(PORT_P, n2.toString());
        }
        if (string != null) {
            ((Hashtable)observableProperties).put(HOST_P, string);
        }
        if (string2 != null) {
            ((Hashtable)observableProperties).put(ROOT_P, file2.getAbsolutePath());
        }
        if (string6 != null) {
            ((Hashtable)observableProperties).put(CONFIG_P, file3.getAbsolutePath());
        }
        if (string3 != null) {
            ((Hashtable)observableProperties).put(SPACE_P, string3);
        }
        if (bl != null) {
            ((Hashtable)observableProperties).put(TRACE_P, "true");
            ((Hashtable)observableProperties).put(CLIENT_DEBUG_P, "true");
        }
        if (string7 != null) {
            ((Hashtable)observableProperties).put(MAX_LOADED_STORE_P, string7);
        }
        if (Boolean.getBoolean(USE_SM_P)) {
            object = new httpdSecurityManager();
            System.setSecurityManager((SecurityManager)object);
        }
        try {
            object = new httpd();
            ((httpd)object).initialize(null, string5, observableProperties);
        }
        catch (Exception exception) {
            System.out.println("*** [httpd]: fatal error, exiting !");
            exception.printStackTrace();
        }
    }

    public ReplyInterface perform(RequestInterface requestInterface) throws ProtocolException, ResourceException {
        Reply reply;
        FilterInterface[] filterInterfaceArray;
        Object object;
        LookupResult lookupResult;
        LookupState lookupState;
        Request request = (Request)requestInterface;
        if (request.getURL() == Request.THE_SERVER && request.getMethod().equals("OPTIONS")) {
            HttpTokenList httpTokenList = null;
            Cloneable cloneable = this;
            synchronized (cloneable) {
                if (this.publicHeader == null) {
                    httpTokenList = HttpFactory.makeStringList(this.publicMethods);
                }
                this.publicHeader = httpTokenList;
            }
            cloneable = request.makeReply(200);
            if (httpTokenList != null) {
                ((HttpMessage)cloneable).setHeaderValue(HttpReplyMessage.H_PUBLIC, httpTokenList);
            }
            ((HttpEntityMessage)cloneable).setContentLength(0);
            return cloneable;
        }
        if (request.getMethod().equals("TRACE")) {
            boolean bl;
            block47: {
                bl = true;
                lookupState = new LookupState(request);
                lookupResult = new LookupResult(this.root.getResourceReference());
                try {
                    if (!this.root.lookup(lookupState, lookupResult) || (object = lookupResult.getTarget()) == null) break block47;
                    try {
                        try {
                            FramedResource framedResource = (FramedResource)object.lock();
                            Class<?> clazz = Class.forName("org.w3c.jigsaw.proxy.ForwardFrame");
                            bl = framedResource.getFrameReference(clazz) == null;
                        }
                        catch (Exception exception) {
                        }
                        filterInterfaceArray = null;
                        object.unlock();
                    }
                    catch (Throwable throwable) {
                        Object var8_19 = null;
                        object.unlock();
                        throw throwable;
                    }
                }
                catch (Exception exception) {}
            }
            if (bl) {
                object = request.makeReply(200);
                ((HttpMessage)object).setNoCache();
                ((HttpMessage)object).setMaxAge(-1);
                ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                try {
                    ((HttpEntityMessage)object).setContentType(new MimeType("message/http"));
                    request.dump(byteArrayOutputStream);
                    ((HttpEntityMessage)object).setContentLength(byteArrayOutputStream.size());
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
                ((Reply)object).setStream(new ByteArrayInputStream(byteArrayOutputStream.toByteArray()));
                return object;
            }
        }
        ProtocolException protocolException = null;
        lookupState = null;
        lookupResult = null;
        try {
            lookupResult = new LookupResult(this.root.getResourceReference());
            lookupState = new LookupState(request);
            if (this.root.lookup(lookupState, lookupResult) && lookupResult.hasReply()) {
                return lookupResult.getReply();
            }
        }
        catch (ProtocolException protocolException2) {
            protocolException = protocolException2;
        }
        catch (Exception exception) {
            object = request.makeReply(400);
            ((Reply)object).setContent("<html><head><title>Bad Request</title></head>\n<body><p>The server was not able to understand this request</p></body></html>");
            protocolException = new ProtocolException((ReplyInterface)object);
        }
        object = lookupResult.getTarget();
        HttpReplyMessage httpReplyMessage = null;
        filterInterfaceArray = lookupResult.getFilters();
        int n = 0;
        if (protocolException == null) {
            try {
                request.setTargetResource((ResourceReference)object);
                if (filterInterfaceArray != null) {
                    while (n < filterInterfaceArray.length) {
                        if (filterInterfaceArray[n] != null && (httpReplyMessage = (Reply)filterInterfaceArray[n].ingoingFilter(request, filterInterfaceArray, n)) != null) {
                            return httpReplyMessage;
                        }
                        ++n;
                    }
                }
            }
            catch (ProtocolException protocolException3) {
                protocolException = protocolException3;
            }
            if (protocolException == null && object != null) {
                request.setFilters((ResourceFilter[])filterInterfaceArray, n);
                request.setTargetResource((ResourceReference)object);
                try {
                    try {
                        FramedResource framedResource = (FramedResource)object.lock();
                        httpReplyMessage = (Reply)framedResource.perform(request);
                        if (httpReplyMessage == null) {
                            httpReplyMessage = request.makeReply(404);
                            if (this.uri_error) {
                                ((Reply)httpReplyMessage).setContent("<html><head><title>Not Found</title></head>\n<body><h1>Invalid URL</h1><p>The URL <b>" + request.getURL() + "</b> that you requested is not" + " available " + " for this protocol.</body>\n" + "</html>");
                            } else {
                                ((Reply)httpReplyMessage).setContent("<html><head><title>Not Found</title></head>\n<body><h1>Invalid URL</h1><p>The URL</b> that you requested is not available  for this protocol.</body>\n</html>");
                            }
                            httpReplyMessage.setContentType(MimeType.TEXT_HTML);
                        }
                    }
                    catch (InvalidResourceException invalidResourceException) {
                        httpReplyMessage = request.makeReply(404);
                        if (this.uri_error) {
                            ((Reply)httpReplyMessage).setContent("<html><head><title>Not Found</title></head><body><b>The URL <b>" + request.getURL() + "</b> that you requested is not " + "available, " + " probably deleted.</body></html>");
                        } else {
                            ((Reply)httpReplyMessage).setContent("<html><head><title>Not Found</title></head><body><b>The URL that you requested is not available,  probably deleted.</body></html>");
                        }
                        httpReplyMessage.setContentType(MimeType.TEXT_HTML);
                    }
                    reply = null;
                    object.unlock();
                }
                catch (Throwable throwable) {
                    Object var11_26 = null;
                    object.unlock();
                    throw throwable;
                }
            }
            httpReplyMessage = request.makeReply(404);
            if (this.uri_error) {
                ((Reply)httpReplyMessage).setContent("<html><head>\n<title>Not Found</title></head><body><h1>Invalid URL</h1><p>The URL <b>" + request.getURL() + "</b> that you requested is not" + " available " + " on that server.</body></html>");
            } else {
                ((Reply)httpReplyMessage).setContent("<html><head>\n<title>Not Found</title></head><body><h1>Invalid URL</h1><p>The URL that you requested is not available  on that server.</body></html>");
            }
            httpReplyMessage.setContentType(MimeType.TEXT_HTML);
        }
        if (httpReplyMessage == null || httpReplyMessage.getStatus() != 1001) {
            if (protocolException == null) {
                int n2 = n;
                while (--n2 >= 0) {
                    if (filterInterfaceArray[n2] == null || (reply = (Reply)filterInterfaceArray[n2].outgoingFilter(request, (ReplyInterface)((Object)httpReplyMessage), filterInterfaceArray, n2)) == null) continue;
                    return reply;
                }
            } else {
                if (filterInterfaceArray != null) {
                    int n3 = filterInterfaceArray.length;
                    while (--n3 >= 0) {
                        if (filterInterfaceArray[n3] == null || (reply = (Reply)filterInterfaceArray[n3].exceptionFilter(request, protocolException, filterInterfaceArray, n3)) == null) continue;
                        return reply;
                    }
                }
                if ((httpReplyMessage = (Reply)protocolException.getReply()) == null) {
                    httpReplyMessage = request.makeReply(500);
                    if (this.uri_error) {
                        ((Reply)httpReplyMessage).setContent("<html><head>\n<title>Server Error</title></head><body><h1>Invalid URL</h1><p>The URL <b>" + request.getURL() + "</b>: isn't available " + " on that server.</body></html>");
                    } else {
                        ((Reply)httpReplyMessage).setContent("<html><head>\n<title>Server Error</title></head><body><h1>Invalid URL</h1><p>The URL isn't available  on that server.</body></html>");
                    }
                    httpReplyMessage.setContentType(MimeType.TEXT_HTML);
                }
            }
        }
        return httpReplyMessage;
    }

    public boolean propertyChanged(String string) {
        if (string.equals(SERVER_SOFTWARE_P)) {
            this.software = this.props.getString(string, this.software);
            return true;
        }
        if (string.equals(TRACE_P)) {
            this.tracep = this.props.getBoolean(string, this.tracep);
            this.errlog(String.valueOf(string) + " changed to " + this.tracep);
            return true;
        }
        if (string.equals(LENIENT_P)) {
            this.lenient = this.props.getBoolean(string, this.lenient);
            this.errlog(String.valueOf(string) + " changed to " + this.lenient);
            return true;
        }
        if (string.equals(DISPLAY_URL_ON_ERROR_P)) {
            this.uri_error = this.props.getBoolean(string, this.uri_error);
            this.errlog(String.valueOf(string) + " changed to " + this.uri_error);
            return true;
        }
        if (string.equals(KEEP_ALIVE_P)) {
            this.keep = this.props.getBoolean(string, this.keep);
            this.errlog(String.valueOf(string) + " changed to " + this.keep);
            return true;
        }
        if (string.equals(LOGGER_P)) {
            String string2 = this.props.getString(string, this.logger_class);
            if (!string2.equals(this.logger_class)) {
                Logger logger;
                try {
                    logger = (Logger)Class.forName(string2).newInstance();
                }
                catch (Exception exception) {
                    this.errlog(String.valueOf(string) + " change failed (bad logger class)");
                    return false;
                }
                httpd httpd2 = this;
                synchronized (httpd2) {
                    if (this.logger != null) {
                        this.logger.shutdown();
                    }
                    logger.initialize(this);
                    this.logger = logger;
                    this.logger_class = string2;
                }
            }
            return true;
        }
        if (string.equals(ROOT_NAME_P)) {
            String string3 = this.props.getString(string, null);
            if (this.changeRoot(string3) != null) {
                this.errlog("new root resource [" + string3 + "]");
                return true;
            }
            this.errlog("failed to change root to [" + string3 + "].");
            return false;
        }
        if (string.equals(SPACE_P)) {
            this.errlog(String.valueOf(string) + " change failed (server running)");
            return false;
        }
        if (string.equals(HOST_P)) {
            this.errlog(String.valueOf(string) + " change failed (server running)");
            return false;
        }
        if (string.equals(PORT_P)) {
            this.errlog(String.valueOf(string) + " switching port : " + this.props.getInteger(string, 80));
            int n = this.props.getInteger(string, 80);
            if (this.port != n) {
                int n2 = this.port;
                this.port = n;
                this.checkpoint();
                ServerSocket serverSocket = null;
                try {
                    serverSocket = this.factory.createServerSocket();
                    this.socket.close();
                    this.socket = serverSocket;
                }
                catch (Exception exception) {
                    try {
                        serverSocket.close();
                    }
                    catch (Exception exception2) {}
                    this.port = n2;
                    return false;
                }
            }
            return true;
        }
        if (string.equals(CLIENT_DEBUG_P)) {
            this.client_debug = this.props.getBoolean(string, this.client_debug);
            this.errlog(String.valueOf(string) + " changed to " + this.client_debug);
            return true;
        }
        if (string.equals(REQUEST_TIMEOUT_P)) {
            this.request_time_out = this.props.getInteger(string, this.request_time_out);
            this.errlog(String.valueOf(string) + " changed to " + this.request_time_out);
            return true;
        }
        if (string.equals(KEEP_TIMEOUT_P)) {
            this.connection_time_out = this.props.getInteger(string, this.connection_time_out);
            this.errlog(String.valueOf(string) + " changed to " + this.connection_time_out);
            return true;
        }
        if (string.equals(CLIENT_PRIORITY_P)) {
            this.client_priority = this.props.getInteger(string, this.client_priority);
            this.errlog(String.valueOf(string) + " changed to " + this.client_priority);
            return true;
        }
        if (string.equals(CLIENT_BUFSIZE_P)) {
            this.client_bufsize = this.props.getInteger(string, this.client_bufsize);
            this.errlog(String.valueOf(string) + " changed to " + this.client_bufsize);
            return true;
        }
        if (string.equals(DOCURL_P)) {
            String string4 = this.props.getString(string, this.docurl);
            try {
                URL uRL = new URL(this.getURL(), string4);
                this.docurl = uRL.toExternalForm();
            }
            catch (Exception exception) {
                return false;
            }
            return true;
        }
        if (string.equals(TRASHDIR_P)) {
            this.trashdir = this.props.getString(string, this.trashdir);
            File file = new File(this.trashdir);
            if (!file.exists()) {
                file.mkdirs();
            }
            this.errlog(String.valueOf(string) + " changed to " + this.trashdir);
            return true;
        }
        if (string.equals(CHECKURL_P)) {
            this.checkurl = this.props.getString(string, this.checkurl);
            this.errlog(String.valueOf(string) + " changed to " + this.checkurl);
            return true;
        }
        if (string.equals(PUBLIC_P)) {
            this.publicMethods = this.props.getStringArray(string, this.publicMethods);
            this.publicHeader = null;
            return true;
        }
        if (string.equals(SERVER_USER_P)) {
            String string5 = this.props.getString(SERVER_USER_P, null);
            this.errlog("new user: " + string5);
            return false;
        }
        if (string.equals(SERVER_GROUP_P)) {
            String string6 = this.props.getString(SERVER_GROUP_P, null);
            this.errlog("new group: " + string6);
            return false;
        }
        return true;
    }

    public synchronized void registerPropertySet(PropertySet propertySet) {
        this.propSet.addElement(propertySet);
    }

    public synchronized void restart() {
        this.errlog("[restart]: inited !");
        this.finishing = true;
        this.restarting = true;
        try {
            Socket socket = new Socket(this.host, this.port);
            socket.close();
        }
        catch (IOException iOException) {
            this.errlog("[restart]: IOException while unblocking server thread.");
        }
    }

    public void run() {
        System.out.println(String.valueOf(this.getBanner()) + ": serving at " + this.getURL());
        System.out.flush();
        this.errlog("started at: " + new Date() + ".");
        while (!this.finishing && this.socket != null) {
            Socket socket = null;
            try {
                socket = this.socket.accept();
                socket.setTcpNoDelay(true);
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
                this.errlog("failed to accept incoming connection on " + this.socket);
                try {
                    socket.close();
                }
                catch (Exception exception) {}
                socket = null;
            }
            if (this.socket == null || socket == null || this.factory == null) continue;
            this.factory.handleConnection(socket);
        }
        this.cleanup(this.restarting);
    }

    public synchronized void shutdown() {
        this.checkpoint();
        this.errlog("shutdown inited...(save done)");
        this.finishing = true;
        try {
            Socket socket = new Socket(this.host, this.port);
            socket.close();
        }
        catch (IOException iOException) {
            this.errlog("[shutdown]: IOException while unblocking server thread.");
        }
        this.shm.removeServerHandler(this);
        this.cleanTempDirectory();
    }

    public void start() throws ServerHandlerInitException {
        if (!this.isAClone) {
            this.context = new ResourceContext(this);
            this.initializeResourceSpace(this.identifier, this.root_class, this.props.getString(EDIT_ROOT_P, this.root_name), this.props.getString(SERIALIZER_CLASS_P, null), this.max_loaded_store);
            this.context.setSpace(this.getResourceSpace());
            this.initializeIndexer();
            this.initializeRootResource();
            this.initializeRealmsCatalog();
            this.initializePropertySets();
            this.initializeEventManager();
            this.initializeLogger();
            if (this.shuffler_path != null) {
                try {
                    this.shuffler = new Shuffler(this.shuffler_path);
                }
                catch (Error error) {
                    this.warning("unable to launch shuffler to " + this.shuffler_path + ": " + error.getMessage());
                    this.shuffler = null;
                }
                catch (RuntimeException runtimeException) {
                    this.warning(runtimeException, "unable to launch shuffler to " + this.shuffler_path + ": " + runtimeException.getMessage());
                    this.shuffler = null;
                }
            }
            if (this.shuffler != null) {
                this.trace("using shuffler at: " + this.shuffler_path);
            }
            this.loadStartupClasses();
            this.thread.start();
        } else {
            httpd httpd2 = (httpd)this.shm.lookupServerHandler(this.masterID);
            this.context = httpd2.getDefaultContext();
            this.realms = httpd2.realms;
            this.manager = httpd2.manager;
            this.initializeLogger();
            this.initializeRootResource();
            this.initializeEventManager();
            this.thread.start();
        }
    }

    public void startCheckpoint() {
        block11: {
            if (this.checkurl == null) {
                this.errlog("checkpointer URL unknown.");
                this.checkpoint();
                return;
            }
            try {
                LookupState lookupState = new LookupState(this.checkurl);
                LookupResult lookupResult = new LookupResult(this.root.getResourceReference());
                if (this.root.lookup(lookupState, lookupResult)) {
                    ResourceReference resourceReference = lookupResult.getTarget();
                    if (resourceReference != null) {
                        try {
                            try {
                                Resource resource = resourceReference.lock();
                                if (resource instanceof CheckpointResource) {
                                    ((CheckpointResource)resource).activate();
                                    this.errlog("Chekpointer started at: " + new Date() + ".");
                                } else {
                                    this.errlog("The chekpointer url (" + this.checkurl + ") doesn't point to a CheckpointResource");
                                    this.checkpoint();
                                }
                            }
                            catch (InvalidResourceException invalidResourceException) {
                                this.errlog("Invalid Checkpointer : " + invalidResourceException.getMessage());
                                this.checkpoint();
                            }
                            Object var5_7 = null;
                            resourceReference.unlock();
                            break block11;
                        }
                        catch (Throwable throwable) {
                            Object var5_8 = null;
                            resourceReference.unlock();
                            throw throwable;
                        }
                    }
                    this.errlog("can't find Checkpointer");
                    this.checkpoint();
                    break block11;
                }
                this.errlog("Checkpointer: lookup fail");
                this.checkpoint();
            }
            catch (ProtocolException protocolException) {
                this.errlog("Checkpointer : " + protocolException.getMessage());
                this.checkpoint();
            }
        }
    }

    public void trace(String string) {
        if (this.tracep && this.logger != null) {
            this.logger.trace(string);
        }
    }

    public void trace(Client client, String string) {
        if (this.tracep && this.logger != null) {
            this.logger.trace(client, string);
        }
    }

    public static void usage() {
        PrintStream printStream = System.out;
        printStream.println("usage: httpd [OPTIONS]");
        printStream.println("-id <id>          : server identifier.");
        printStream.println("-port <number>    : listen on the given port number.");
        printStream.println("-host <host>      : full name of host running the server.");
        printStream.println("-root <directory> : root directory of server.");
        printStream.println("-space <directory>: space directory exported by server");
        printStream.println("-p     <propfile> : property file to read.");
        printStream.println("-trace            : turns debugging on.");
        printStream.println("-config           : config directory to use.");
        printStream.println("-maxstores <int>  : Max number of stores in memory.");
        System.exit(1);
    }

    public void warning(Exception exception, String string) {
        System.out.println("*** Warning: " + string);
        exception.printStackTrace();
    }

    public void warning(String string) {
        System.out.println("*** Warning : " + string);
    }
}

