/*
 * Decompiled with CFR 0.152.
 */
package org.w3c.jigsaw.pagecompile;

import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringBufferInputStream;
import org.w3c.jigsaw.forms.URLDecoder;
import org.w3c.jigsaw.forms.URLDecoderException;
import org.w3c.jigsaw.frames.PostableFrame;
import org.w3c.jigsaw.http.HTTPException;
import org.w3c.jigsaw.http.Reply;
import org.w3c.jigsaw.http.Request;
import org.w3c.jigsaw.pagecompile.PageCompileOutputStream;
import org.w3c.tools.resources.ProtocolException;
import org.w3c.tools.resources.ReplyInterface;
import org.w3c.tools.resources.RequestInterface;
import org.w3c.tools.resources.ResourceException;
import org.w3c.www.http.HeaderValue;
import org.w3c.www.http.HttpEntityMessage;
import org.w3c.www.mime.MimeType;

public abstract class GeneratedFrame
extends PostableFrame {
    public Reply get(Request request) throws ProtocolException, ResourceException {
        if (this.getConvertGetFlag() && request.hasState("query")) {
            String string = request.getQueryString();
            StringBufferInputStream stringBufferInputStream = new StringBufferInputStream(string);
            URLDecoder uRLDecoder = new URLDecoder(stringBufferInputStream, this.getOverrideFlag());
            try {
                uRLDecoder.parse();
            }
            catch (URLDecoderException uRLDecoderException) {
                Reply reply = request.makeReply(400);
                reply.setContent("Invalid request: unable to decode form data.");
                throw new HTTPException(reply);
            }
            catch (IOException iOException) {
                Reply reply = request.makeReply(400);
                reply.setContent("Invalid request: unable to read form data.");
                throw new HTTPException(reply);
            }
            return this.handle(request, uRLDecoder);
        }
        Reply reply = this.createDefaultReply(request, 200);
        PageCompileOutputStream pageCompileOutputStream = new PageCompileOutputStream();
        try {
            this.get(request, reply, pageCompileOutputStream);
        }
        catch (IOException iOException) {
            Reply reply2 = request.makeReply(500);
            PageCompileOutputStream pageCompileOutputStream2 = new PageCompileOutputStream();
            PrintWriter printWriter = new PrintWriter(pageCompileOutputStream2);
            printWriter.print("The generated frame at\n\n" + request.getURL() + "\n\n" + "reported this exception : \n\n" + iOException.getMessage() + "\n\nStack trace : \n\n");
            iOException.printStackTrace(printWriter);
            printWriter.flush();
            printWriter.close();
            reply2.setStream(pageCompileOutputStream2.getInputStream());
            reply2.setContentLength(pageCompileOutputStream2.size());
            reply2.setContentType(MimeType.TEXT_PLAIN);
            return reply2;
        }
        reply.setStream(pageCompileOutputStream.getInputStream());
        reply.setContentLength(pageCompileOutputStream.size());
        return reply;
    }

    protected abstract void get(Request var1, Reply var2, PageCompileOutputStream var3) throws IOException;

    public boolean getConvertGetFlag() {
        return false;
    }

    public Reply handle(Request request, URLDecoder uRLDecoder) throws ProtocolException {
        PageCompileOutputStream pageCompileOutputStream = new PageCompileOutputStream();
        Reply reply = this.createDefaultReply(request, 200);
        try {
            this.post(request, reply, uRLDecoder, pageCompileOutputStream);
        }
        catch (IOException iOException) {
            Reply reply2 = request.makeReply(500);
            PageCompileOutputStream pageCompileOutputStream2 = new PageCompileOutputStream();
            PrintWriter printWriter = new PrintWriter(pageCompileOutputStream2);
            printWriter.print("The generated frame at\n\n" + request.getURL() + "\n\n" + "reported this exception : \n\n" + iOException.getMessage() + "\n\nStack trace : \n\n");
            iOException.printStackTrace(printWriter);
            printWriter.flush();
            printWriter.close();
            reply2.setStream(pageCompileOutputStream2.getInputStream());
            reply2.setContentLength(pageCompileOutputStream2.size());
            reply2.setContentType(MimeType.TEXT_PLAIN);
            return reply2;
        }
        reply.setStream(pageCompileOutputStream.getInputStream());
        reply.setContentLength(pageCompileOutputStream.size());
        return reply;
    }

    public ReplyInterface perform(RequestInterface requestInterface) throws ProtocolException, ResourceException {
        try {
            return super.perform(requestInterface);
        }
        catch (ProtocolException protocolException) {
            throw protocolException;
        }
        catch (ResourceException resourceException) {
            throw resourceException;
        }
        catch (Exception exception) {
            Request request = (Request)requestInterface;
            Reply reply = request.makeReply(500);
            PageCompileOutputStream pageCompileOutputStream = new PageCompileOutputStream();
            PrintWriter printWriter = new PrintWriter(pageCompileOutputStream);
            printWriter.print("The generated frame at\n\n" + request.getURL() + "\n\n" + "reported this exception : \n\n" + exception.getMessage() + "\n\nStack trace : \n\n");
            exception.printStackTrace(printWriter);
            printWriter.flush();
            printWriter.close();
            reply.setStream(pageCompileOutputStream.getInputStream());
            reply.setContentLength(pageCompileOutputStream.size());
            reply.setContentType(MimeType.TEXT_PLAIN);
            return reply;
        }
    }

    protected void post(Request request, Reply reply, URLDecoder uRLDecoder, PageCompileOutputStream pageCompileOutputStream) throws ProtocolException, IOException {
        Reply reply2 = request.makeReply(405);
        if (this.allowed != null) {
            reply2.setHeaderValue(HttpEntityMessage.H_ALLOW, (HeaderValue)this.allowed);
        }
        reply2.setContent("Method POST not allowed on this resource.");
        throw new HTTPException(reply2);
    }
}

