/*
 * Decompiled with CFR 0.152.
 */
package org.w3c.tools.jdbc;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.Serializable;
import java.util.Hashtable;
import java.util.Vector;

public class JdbcPropertyChangeSupport
extends PropertyChangeSupport {
    private Vector listeners = null;
    private Hashtable children = null;
    private Object source = null;

    public JdbcPropertyChangeSupport(Object object) {
        super(object);
        this.source = object;
    }

    public synchronized void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        if (this.listeners == null) {
            this.listeners = new Vector();
        }
        this.listeners.addElement(propertyChangeListener);
    }

    public synchronized void addPropertyChangeListener(String string, PropertyChangeListener propertyChangeListener) {
        JdbcPropertyChangeSupport jdbcPropertyChangeSupport;
        if (this.children == null) {
            this.children = new Hashtable();
        }
        if ((jdbcPropertyChangeSupport = (JdbcPropertyChangeSupport)this.children.get(string)) == null) {
            jdbcPropertyChangeSupport = new JdbcPropertyChangeSupport(this.source);
            this.children.put(string, jdbcPropertyChangeSupport);
        }
        jdbcPropertyChangeSupport.addPropertyChangeListener(propertyChangeListener);
    }

    public void firePropertyChange(PropertyChangeEvent propertyChangeEvent) {
        String string = propertyChangeEvent.getPropertyName();
        Vector vector = null;
        JdbcPropertyChangeSupport jdbcPropertyChangeSupport = null;
        JdbcPropertyChangeSupport jdbcPropertyChangeSupport2 = this;
        synchronized (jdbcPropertyChangeSupport2) {
            if (this.listeners != null) {
                vector = (Vector)this.listeners.clone();
            }
            if (this.children != null && string != null) {
                jdbcPropertyChangeSupport = (JdbcPropertyChangeSupport)this.children.get(string);
            }
        }
        if (vector != null) {
            int n = 0;
            while (n < vector.size()) {
                PropertyChangeListener propertyChangeListener = (PropertyChangeListener)vector.elementAt(n);
                propertyChangeListener.propertyChange(propertyChangeEvent);
                ++n;
            }
        }
        if (jdbcPropertyChangeSupport != null) {
            jdbcPropertyChangeSupport.firePropertyChange(propertyChangeEvent);
        }
    }

    public void firePropertyChange(String string, int n, int n2) {
        this.firePropertyChange(string, new Integer(n), new Integer(n2));
    }

    public void firePropertyChange(String string, Object object, Object object2) {
        Vector vector = null;
        JdbcPropertyChangeSupport jdbcPropertyChangeSupport = null;
        Serializable serializable = this;
        synchronized (serializable) {
            if (this.listeners != null) {
                vector = (Vector)this.listeners.clone();
            }
            if (this.children != null && string != null) {
                jdbcPropertyChangeSupport = (JdbcPropertyChangeSupport)this.children.get(string);
            }
        }
        serializable = new PropertyChangeEvent(this.source, string, object, object2);
        if (vector != null) {
            int n = 0;
            while (n < vector.size()) {
                PropertyChangeListener propertyChangeListener = (PropertyChangeListener)vector.elementAt(n);
                propertyChangeListener.propertyChange((PropertyChangeEvent)serializable);
                ++n;
            }
        }
        if (jdbcPropertyChangeSupport != null) {
            jdbcPropertyChangeSupport.firePropertyChange((PropertyChangeEvent)serializable);
        }
    }

    public void firePropertyChange(String string, boolean bl, boolean bl2) {
        this.firePropertyChange(string, new Boolean(bl), new Boolean(bl2));
    }

    public synchronized boolean hasListeners(String string) {
        JdbcPropertyChangeSupport jdbcPropertyChangeSupport;
        if (this.listeners != null && !this.listeners.isEmpty()) {
            return true;
        }
        if (this.children != null && (jdbcPropertyChangeSupport = (JdbcPropertyChangeSupport)this.children.get(string)) != null && jdbcPropertyChangeSupport.listeners != null) {
            return jdbcPropertyChangeSupport.listeners.isEmpty() ^ true;
        }
        return false;
    }

    public synchronized void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        if (this.listeners == null) {
            return;
        }
        this.listeners.removeElement(propertyChangeListener);
    }

    public synchronized void removePropertyChangeListener(String string, PropertyChangeListener propertyChangeListener) {
        if (this.children == null) {
            return;
        }
        JdbcPropertyChangeSupport jdbcPropertyChangeSupport = (JdbcPropertyChangeSupport)this.children.get(string);
        if (jdbcPropertyChangeSupport == null) {
            return;
        }
        jdbcPropertyChangeSupport.removePropertyChangeListener(propertyChangeListener);
    }
}

