/*
 * Decompiled with CFR 0.152.
 */
package org.w3c.tools.resources.upgrade;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import org.w3c.tools.resources.upgrade.Attribute;

public class IntegerArrayAttribute
extends Attribute {
    public IntegerArrayAttribute(String string, String[] stringArray, Integer n) {
        super(string, stringArray, n);
        this.type = "int[]";
    }

    public boolean checkValue(Object object) {
        return object instanceof int[];
    }

    public final int getPickleLength(Object object) {
        return ((int[])object).length * 4 + 4;
    }

    public void pickle(DataOutputStream dataOutputStream, Object object) throws IOException {
        int[] nArray = (int[])object;
        dataOutputStream.writeInt(nArray.length);
        int n = 0;
        while (n < nArray.length) {
            dataOutputStream.writeInt(nArray[n]);
            ++n;
        }
    }

    public String stringify(Object object) {
        if (object == null || !(object instanceof int[])) {
            return null;
        }
        int[] nArray = (int[])object;
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        while (n < nArray.length) {
            if (n > 0) {
                stringBuffer.append('|');
            }
            stringBuffer.append(nArray[n]);
            ++n;
        }
        return stringBuffer.toString();
    }

    public Object unpickle(DataInputStream dataInputStream) throws IOException {
        int n = dataInputStream.readInt();
        int[] nArray = new int[n];
        int n2 = 0;
        while (n2 < n) {
            nArray[n2] = dataInputStream.readInt();
            ++n2;
        }
        return nArray;
    }
}

