/*
 * Decompiled with CFR 0.152.
 */
package org.w3c.www.mime;

import java.io.BufferedInputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.w3c.www.http.HttpAccept;
import org.w3c.www.http.HttpAcceptCharset;
import org.w3c.www.http.HttpAcceptLanguage;
import org.w3c.www.http.HttpRequestMessage;
import org.w3c.www.mime.MimeHeaderHolder;
import org.w3c.www.mime.MimeParserException;
import org.w3c.www.mime.MimeParserFactory;

public class MimeParser {
    protected int ch = -1;
    protected InputStream input = null;
    protected byte[] buffer = new byte[128];
    protected int bsize = 0;
    protected MimeParserFactory factory = null;
    boolean cached = false;

    public MimeParser(InputStream inputStream, MimeParserFactory mimeParserFactory) {
        this.input = inputStream;
        this.factory = mimeParserFactory;
    }

    protected final void append(int n) {
        if (this.bsize + 1 >= this.buffer.length) {
            byte[] byArray = new byte[this.buffer.length * 2];
            System.arraycopy(this.buffer, 0, byArray, 0, this.buffer.length);
            this.buffer = byArray;
        }
        this.buffer[this.bsize++] = (byte)n;
    }

    protected void expect(int n) throws MimeParserException, IOException {
        if (n != this.ch) {
            String string = new Character((char)n).toString();
            String string2 = new Character((char)this.ch).toString();
            throw new MimeParserException("expecting " + string + "(" + n + ")" + " got " + string2 + "(" + this.ch + ")\n" + "context: " + new String(this.buffer, 0, 0, this.bsize) + "\n");
        }
        this.ch = this.input.read();
    }

    public InputStream getInputStream() {
        return this.input;
    }

    public static void main(String[] stringArray) {
        try {
            String string = stringArray[0];
            String string2 = stringArray[1];
            MimeParserFactory mimeParserFactory = null;
            mimeParserFactory = (MimeParserFactory)Class.forName(string).newInstance();
            BufferedInputStream bufferedInputStream = new BufferedInputStream(new FileInputStream(string2));
            MimeParser mimeParser = new MimeParser(bufferedInputStream, mimeParserFactory);
            HttpRequestMessage httpRequestMessage = (HttpRequestMessage)mimeParser.parse();
            HttpAccept[] httpAcceptArray = httpRequestMessage.getAccept();
            int n = 0;
            while (n < httpAcceptArray.length) {
                System.out.println("accept: " + httpAcceptArray[n].getMimeType());
                ++n;
            }
            HttpAcceptLanguage[] httpAcceptLanguageArray = httpRequestMessage.getAcceptLanguage();
            int n2 = 0;
            while (n2 < httpAcceptLanguageArray.length) {
                System.out.println("accept-lang: " + httpAcceptLanguageArray[n2].getLanguage());
                ++n2;
            }
            HttpAcceptCharset[] httpAcceptCharsetArray = httpRequestMessage.getAcceptCharset();
            int n3 = 0;
            while (n3 < httpAcceptCharsetArray.length) {
                System.out.println("accept-charset: " + httpAcceptCharsetArray[n3].getCharset());
                ++n3;
            }
            httpRequestMessage.emit(System.out);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            System.out.println("MimeParser <factory> <file>");
        }
    }

    public MimeHeaderHolder parse() throws MimeParserException, IOException {
        return this.parse(true);
    }

    public MimeHeaderHolder parse(boolean bl) throws MimeParserException, IOException {
        MimeHeaderHolder mimeHeaderHolder = this.factory.createHeaderHolder(this);
        this.ch = this.input.read();
        this.cached = true;
        if (!mimeHeaderHolder.notifyBeginParsing(this)) {
            if (!this.cached) {
                this.ch = this.input.read();
            }
            if (bl) {
                try {
                    this.parse822Headers(mimeHeaderHolder, bl);
                }
                catch (MimeParserException mimeParserException) {}
            } else {
                this.parse822Headers(mimeHeaderHolder, bl);
            }
        }
        mimeHeaderHolder.notifyEndParsing(this);
        return mimeHeaderHolder;
    }

    protected void parse822HeaderBody() throws MimeParserException, IOException {
        this.parse822HeaderBody(true);
    }

    protected void parse822HeaderBody(boolean bl) throws MimeParserException, IOException {
        if (bl) {
            this.parse822HeaderBodyLenient();
        } else {
            this.parse822HeaderBodyStrict();
        }
    }

    /*
     * Unable to fully structure code
     */
    protected void parse822HeaderBodyLenient() throws MimeParserException, IOException {
        this.bsize = 0;
        this.skipSpaces();
        var1_1 = false;
        block10: while (true) {
            switch (this.ch) {
                case 13: {
                    this.ch = this.input.read();
                    if (this.ch != 10) {
                        this.append(13);
                        continue block10;
                    }
                }
                case 10: {
                    this.ch = this.input.read();
                    switch (this.ch) {
                        case 9: 
                        case 32: {
                            do {
                                this.ch = this.input.read();
                            } while (this.ch == 32 || this.ch == 9);
                            if (this.ch == 13 || this.ch == 10) continue block10;
                            this.append(32);
                            this.append(this.ch);
                            ** GOTO lbl34
                        }
                        default: {
                            return;
                        }
                    }
                }
                case 92: {
                    this.append((char)this.ch);
                    if (var1_1) {
                        this.ch = this.input.read();
                        this.append((char)this.ch);
                    }
                    ** GOTO lbl34
                }
                case 34: {
                    var1_1 ^= true;
                }
                default: {
                    this.append((char)this.ch);
lbl34:
                    // 3 sources

                    this.ch = this.input.read();
                    continue block10;
                }
                case -1: 
            }
            break;
        }
    }

    /*
     * Unable to fully structure code
     */
    protected void parse822HeaderBodyStrict() throws MimeParserException, IOException {
        this.bsize = 0;
        this.skipSpaces();
        var1_1 = false;
        var2_2 = false;
        block10: while (true) {
            switch (this.ch) {
                case 13: {
                    this.ch = this.input.read();
                    if (this.ch != 10) {
                        this.append(13);
                        continue block10;
                    }
                    var2_2 = true;
                    continue block10;
                }
                case 10: {
                    if (!var1_1) ** GOTO lbl21
                    if (!var2_2) ** GOTO lbl20
                    this.append(13);
                    this.append(10);
                    ** GOTO lbl52
lbl20:
                    // 1 sources

                    throw new MimeParserException("MimeParser: \\n not allowed in quoted string");
lbl21:
                    // 1 sources

                    if (!var2_2) ** GOTO lbl35
                    this.ch = this.input.read();
                    switch (this.ch) {
                        case 9: 
                        case 32: {
                            do {
                                this.ch = this.input.read();
                            } while (this.ch == 32 || this.ch == 9);
                            if (this.ch == 13) continue block10;
                            this.append(32);
                            this.append(this.ch);
                            var2_2 = false;
                            ** GOTO lbl52
                        }
                        default: {
                            return;
                        }
                    }
lbl35:
                    // 1 sources

                    this.append(10);
                    ** GOTO lbl52
                }
                case 92: {
                    var2_2 = false;
                    this.append((char)this.ch);
                    if (var1_1) {
                        this.ch = this.input.read();
                        this.append((char)this.ch);
                    }
                    ** GOTO lbl52
                }
                case 34: {
                    var2_2 = false;
                    var1_1 ^= true;
                }
                default: {
                    if (var1_1 && this.ch < 32 && this.ch != 9) {
                        throw new MimeParserException("MimeParser: CTRL not allowed in quoted string");
                    }
                    var2_2 = false;
                    this.append((char)this.ch);
lbl52:
                    // 5 sources

                    this.ch = this.input.read();
                    continue block10;
                }
                case -1: 
            }
            break;
        }
    }

    protected String parse822HeaderName() throws MimeParserException, IOException {
        this.bsize = 0;
        while (this.ch >= 32 && this.ch != 58) {
            this.append((char)this.ch);
            this.ch = this.input.read();
        }
        this.skipSpaces();
        this.expect(58);
        if (this.bsize <= 0) {
            throw new MimeParserException("expected a header name.");
        }
        return new String(this.buffer, 0, 0, this.bsize);
    }

    protected void parse822Headers(MimeHeaderHolder mimeHeaderHolder) throws MimeParserException, IOException {
        this.parse822Headers(mimeHeaderHolder, true);
    }

    protected void parse822Headers(MimeHeaderHolder mimeHeaderHolder, boolean bl) throws MimeParserException, IOException {
        while (!(this.ch == 13 ? (this.ch = this.input.read()) == 10 : bl && this.ch == 10)) {
            String string = this.parse822HeaderName();
            this.skipSpaces();
            this.parse822HeaderBody(bl);
            mimeHeaderHolder.notifyHeader(string, this.buffer, 0, this.bsize);
        }
        return;
    }

    protected String parseToken(boolean bl) throws MimeParserException, IOException {
        this.bsize = 0;
        while (true) {
            switch (this.ch) {
                case -1: 
                case 0: 
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 9: 
                case 10: 
                case 11: 
                case 12: 
                case 13: 
                case 14: 
                case 15: 
                case 16: 
                case 17: 
                case 18: 
                case 19: 
                case 20: 
                case 21: 
                case 22: 
                case 23: 
                case 24: 
                case 25: 
                case 26: 
                case 27: 
                case 28: 
                case 29: 
                case 30: 
                case 31: 
                case 32: 
                case 34: 
                case 40: 
                case 41: 
                case 44: 
                case 47: 
                case 58: 
                case 59: 
                case 60: 
                case 61: 
                case 62: 
                case 63: 
                case 64: 
                case 91: 
                case 92: 
                case 93: 
                case 123: 
                case 125: {
                    return new String(this.buffer, 0, 0, this.bsize);
                }
            }
            this.append((char)(bl ? (int)Character.toLowerCase((char)this.ch) : this.ch));
            this.ch = this.input.read();
        }
    }

    public int read() throws IOException {
        if (this.cached) {
            this.cached = false;
        } else {
            this.ch = this.input.read();
        }
        return this.ch;
    }

    protected void skipSpaces() throws MimeParserException, IOException {
        while (this.ch == 32 || this.ch == 9) {
            this.ch = this.input.read();
        }
    }

    public void unread(int n) {
        if (this.cached) {
            throw new RuntimeException("cannot unread more then once !");
        }
        this.ch = n;
        this.cached = true;
    }
}

