/*
 * Decompiled with CFR 0.152.
 */
package org.w3c.www.protocol.http;

import java.util.Enumeration;
import java.util.Vector;
import org.w3c.www.protocol.http.HttpConnection;
import org.w3c.www.protocol.http.HttpException;
import org.w3c.www.protocol.http.HttpServer;

class HttpServerState {
    HttpServer server = null;
    Vector conns = null;
    protected int state = 0;
    protected HttpException ex = null;
    protected int num_conn = 0;
    protected static final int PREINIT = 0;
    protected static final int ERROR = 1;
    protected static final int OK = 2;
    private static final boolean debug = false;

    HttpServerState(HttpServer httpServer) {
        this.server = httpServer;
    }

    synchronized void decrConnectionCount() {
        --this.num_conn;
    }

    synchronized void deleteConnection(HttpConnection httpConnection) {
        if (this.conns != null) {
            this.conns.removeElement(httpConnection);
        }
    }

    synchronized HttpConnection getConnection() {
        if (this.conns != null && this.conns.size() > 0) {
            Enumeration enumeration = this.conns.elements();
            HttpConnection httpConnection = null;
            while (enumeration.hasMoreElements()) {
                HttpConnection httpConnection2 = (HttpConnection)enumeration.nextElement();
                if (!httpConnection2.mayReuse()) continue;
                httpConnection = httpConnection2;
                this.conns.removeElement(httpConnection);
                break;
            }
            if (httpConnection == null) {
                httpConnection = (HttpConnection)this.conns.elementAt(0);
                this.conns.removeElementAt(0);
            }
            httpConnection.cached = true;
            return httpConnection;
        }
        return null;
    }

    synchronized int getConnectionCount() {
        return this.num_conn;
    }

    final HttpServer getServer() {
        return this.server;
    }

    synchronized boolean hasConnection() {
        return this.conns != null && this.conns.size() > 0;
    }

    synchronized void incrConnectionCount() {
        ++this.num_conn;
    }

    synchronized boolean notEnoughConnections() {
        return this.conns == null || this.conns.size() == 0;
    }

    synchronized void registerConnection(HttpConnection httpConnection) {
        if (this.conns == null) {
            this.conns = new Vector(4);
        }
        this.conns.addElement(httpConnection);
    }

    public String toString() {
        String string = "";
        if (this.conns == null) {
            string = "null";
        } else if (this.conns.size() == 0) {
            string = "empty";
        } else {
            int n = 0;
            while (n < this.conns.size()) {
                string = String.valueOf(string) + "[" + ((HttpConnection)this.conns.elementAt(n)).toString() + "]";
                ++n;
            }
        }
        return this.num_conn + string;
    }

    synchronized void unregisterConnection(HttpConnection httpConnection) {
        if (this.conns != null) {
            this.conns.removeElement(httpConnection);
        }
    }
}

