/*
 * Decompiled with CFR 0.152.
 */
package org.w3c.www.protocol.http.cookies;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.net.URL;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import org.w3c.www.http.HttpCookie;
import org.w3c.www.http.HttpCookieList;
import org.w3c.www.http.HttpFactory;
import org.w3c.www.http.HttpSetCookie;
import org.w3c.www.protocol.http.cookies.DomainNode;

class DomainTree {
    Hashtable nodes = new Hashtable(10);

    DomainTree() {
    }

    protected void addMatchingPathCookiesInVector(HttpSetCookie[] httpSetCookieArray, String string, Vector vector) {
        int n = 0;
        while (n < httpSetCookieArray.length) {
            if (string.equals("/")) {
                vector.addElement(this.setCookie2Cookie(httpSetCookieArray[n]));
            } else if (httpSetCookieArray[n].getPath() != null && string.startsWith(httpSetCookieArray[n].getPath())) {
                vector.addElement(this.setCookie2Cookie(httpSetCookieArray[n]));
            }
            ++n;
        }
    }

    protected static String cookie2String(HttpSetCookie httpSetCookie) {
        Date date = new Date();
        return String.valueOf(httpSetCookie.getDomain()) + "\t" + String.valueOf(httpSetCookie.getSecurity()).toUpperCase() + "\t" + httpSetCookie.getPath() + "\t" + ((long)(httpSetCookie.getMaxAge() * 1000) + date.getTime()) + "\t" + httpSetCookie.getVersion() + "\t" + httpSetCookie.getName() + "\t" + httpSetCookie.getValue() + "\n";
    }

    protected String[] domainParts(String string) {
        if (string == null) {
            return null;
        }
        String string2 = new String(string);
        Vector<String> vector = new Vector<String>(5);
        int n = 0;
        int n2 = 0;
        int n3 = string2.length();
        while (n < n3) {
            n2 = string2.indexOf(46, n);
            if (n2 == -1) {
                n2 = n3;
            }
            vector.addElement(string2.substring(n, n2));
            n = n2 + 1;
        }
        if (vector.size() == 0) {
            return null;
        }
        Object[] objectArray = new String[vector.size()];
        vector.copyInto(objectArray);
        return objectArray;
    }

    public HttpCookieList getCookies(URL uRL) {
        String string = uRL.getHost();
        String string2 = uRL.getFile();
        String[] stringArray = this.domainParts(string);
        if (stringArray == null) {
            return null;
        }
        Vector vector = new Vector(5);
        int n = 0;
        DomainNode domainNode = null;
        Hashtable hashtable = this.nodes;
        if (this.isIp(string)) {
            domainNode = (DomainNode)hashtable.get(stringArray[n]);
            while (n < stringArray.length) {
                if (domainNode == null) {
                    return null;
                }
                if (domainNode.nbcookies > 0) {
                    this.addMatchingPathCookiesInVector(domainNode.cookies, string2, vector);
                }
                if ((domainNode = n + 1 < stringArray.length ? (DomainNode)hashtable.get(stringArray[++n]) : null) != null) {
                    hashtable = domainNode.nodes;
                    continue;
                }
                break;
            }
        } else {
            n = stringArray.length - 1;
            domainNode = (DomainNode)hashtable.get(stringArray[n]);
            while (n >= 0) {
                if (domainNode == null) {
                    return null;
                }
                if (domainNode.nbcookies > 0) {
                    this.addMatchingPathCookiesInVector(domainNode.cookies, string2, vector);
                }
                if ((domainNode = n > 0 ? (DomainNode)hashtable.get(stringArray[--n]) : null) != null) {
                    hashtable = domainNode.nodes;
                    continue;
                }
                break;
            }
        }
        if (vector.size() == 0) {
            return null;
        }
        Object[] objectArray = new HttpCookie[vector.size()];
        vector.copyInto(objectArray);
        return HttpFactory.makeCookieList((HttpCookie[])objectArray);
    }

    public void insertCookie(HttpSetCookie httpSetCookie) {
        String string = httpSetCookie.getDomain();
        String[] stringArray = this.domainParts(string);
        if (stringArray == null) {
            return;
        }
        int n = 0;
        DomainNode domainNode = null;
        Hashtable hashtable = this.nodes;
        if (this.isIp(string)) {
            domainNode = (DomainNode)hashtable.get(stringArray[n]);
            while (true) {
                if (domainNode == null) {
                    domainNode = new DomainNode();
                    hashtable.put(stringArray[n], domainNode);
                }
                if (n == stringArray.length - 1) {
                    domainNode.addCookie(httpSetCookie);
                    return;
                }
                if ((domainNode = (DomainNode)hashtable.get(stringArray[++n])) == null) {
                    domainNode = new DomainNode();
                    hashtable.put(stringArray[n], domainNode);
                }
                hashtable = domainNode.nodes;
            }
        }
        n = stringArray.length - 1;
        domainNode = (DomainNode)hashtable.get(stringArray[n]);
        while (true) {
            if (domainNode == null) {
                domainNode = new DomainNode();
                hashtable.put(stringArray[n], domainNode);
            }
            if (n == 0) {
                domainNode.addCookie(httpSetCookie);
                return;
            }
            if ((domainNode = (DomainNode)hashtable.get(stringArray[--n])) == null) {
                domainNode = new DomainNode();
                hashtable.put(stringArray[n], domainNode);
            }
            hashtable = domainNode.nodes;
        }
    }

    protected boolean isIp(String string) {
        int n = string.length() - 1;
        return string.charAt(n) >= '0' && string.charAt(n) <= '9';
    }

    /*
     * Unable to fully structure code
     */
    protected synchronized void loadCookies(File var1_1) throws FileNotFoundException {
        try {
            var2_2 = new FileReader(var1_1);
            var3_4 = new String[8];
            var4_5 = 0;
            var6_6 = new StringBuffer(30);
            ** GOTO lbl31
            while (true) {
                if (var5_7 != -1) ** GOTO lbl-1000
                return;
            }
lbl-1000:
            // 1 sources

            {
                switch (var5_7) lbl-1000:
                // 2 sources

                {
                    case 35: {
                        if ((var5_7 = var2_2.read()) != 10) ** continue;
                        break;
                    }
                    case 10: {
                        if (var4_5 <= 0) continue block8;
                        var3_4[var4_5++] = var6_6.toString();
                        var7_8 = this.string2Cookie(var3_4);
                        if (var7_8.getMaxAge() > 0) {
                            this.insertCookie(var7_8);
                        }
                        var6_6 = new StringBuffer(30);
                        var3_4 = new String[8];
                        var4_5 = 0;
                        break;
                    }
                    case 9: 
                    case 32: {
                        var3_4[var4_5++] = var6_6.toString();
                        var6_6 = new StringBuffer(30);
                        break;
                    }
                    default: {
                        var6_6.append((char)var5_7);
                    }
                }
lbl31:
                // 6 sources

                ** while ((var5_7 = var2_2.read()) != -1)
            }
lbl32:
            // 1 sources

        }
        catch (IOException var2_3) {
            System.out.println(var2_3.getMessage());
            var2_3.printStackTrace();
        }
    }

    protected HttpCookie setCookie2Cookie(HttpSetCookie httpSetCookie) {
        HttpCookie httpCookie = new HttpCookie();
        if (httpSetCookie != null) {
            httpCookie.setName(httpSetCookie.getName());
            httpCookie.setValue(httpSetCookie.getValue());
            httpCookie.setDomain(httpSetCookie.getDomain());
            httpCookie.setPath(httpSetCookie.getPath());
            httpCookie.setVersion(httpSetCookie.getVersion());
            return httpCookie;
        }
        return null;
    }

    protected HttpSetCookie string2Cookie(String[] stringArray) {
        HttpSetCookie httpSetCookie = new HttpSetCookie();
        httpSetCookie.setDomain(stringArray[0]);
        httpSetCookie.setSecurity(Boolean.getBoolean(stringArray[1].toLowerCase()));
        httpSetCookie.setPath(stringArray[2]);
        long l = Long.parseLong(stringArray[3]);
        long l2 = new Date().getTime();
        httpSetCookie.setMaxAge((int)((l - l2) / 1000L));
        httpSetCookie.setVersion(Integer.parseInt(stringArray[4]));
        httpSetCookie.setName(stringArray[5]);
        httpSetCookie.setValue(stringArray[6]);
        return httpSetCookie;
    }

    protected synchronized void sync(File file) {
        Enumeration enumeration = this.nodes.elements();
        DomainNode domainNode = null;
        FileWriter fileWriter = null;
        try {
            try {
                fileWriter = new FileWriter(file);
                fileWriter.write("# Jigsaw client HTTP Cookie File\n");
                fileWriter.write("# This is a generated file!  Do not edit.\n\n");
                while (enumeration.hasMoreElements()) {
                    domainNode = (DomainNode)enumeration.nextElement();
                    domainNode.sync(fileWriter);
                }
                fileWriter.close();
            }
            catch (IOException iOException) {
                System.out.println(iOException.getMessage());
                iOException.printStackTrace();
            }
            Object var6_6 = null;
        }
        catch (Throwable throwable) {
            Object var6_7 = null;
            try {
                if (fileWriter != null) {
                    fileWriter.close();
                }
            }
            catch (Exception exception) {}
            throw throwable;
        }
        try {
            if (fileWriter != null) {
                fileWriter.close();
            }
        }
        catch (Exception exception) {}
    }
}

