/*
 * Decompiled with CFR 0.152.
 */
package html.parser;

import html.parser.AttributeList;
import html.parser.ContentModel;
import html.parser.DTDConstants;
import html.parser.DTDParser;
import html.parser.Element;
import html.parser.Entity;
import html.parser.PublicMapping;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.BitSet;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import java.util.Vector;

public class DTD
implements DTDConstants {
    String name;
    Vector elements = new Vector();
    Hashtable elementHash = new Hashtable();
    Hashtable entityHash = new Hashtable();
    Element pcdata = this.getElement("#pcdata");
    Element app = this.getElement("app");
    Element html = this.getElement("html");
    Element head = this.getElement("head");
    Element body = this.getElement("body");
    static Properties props;
    static Hashtable dtdHash;
    static PublicMapping mapping;

    public DTD(String name) {
        this.name = name;
        this.defineEntity("#RE", 65536, 13);
        this.defineEntity("#RS", 65536, 10);
        this.defineEntity("#SPACE", 65536, 32);
    }

    public String getName() {
        return this.name;
    }

    public Entity getEntity(String name) {
        return (Entity)this.entityHash.get(name);
    }

    public Entity getEntity(int ch) {
        return (Entity)this.entityHash.get(new Integer(ch));
    }

    public Element getElement(String name) {
        Element e = (Element)this.elementHash.get(name);
        if (e == null) {
            e = new Element(name, this.elements.size());
            this.elements.addElement(e);
            this.elementHash.put(name, e);
        }
        return e;
    }

    public Element findElement(String name) {
        return (Element)this.elementHash.get(name);
    }

    public Element getElement(int index) {
        return (Element)this.elements.elementAt(index);
    }

    void defineEntity(String name, int type, byte[] data) {
        if (this.entityHash.get(name) == null) {
            Entity ent = new Entity(name, type, data);
            this.entityHash.put(name, ent);
            if ((type & 0x10000) != 0 && data.length == 1) {
                switch (type & 0xFFFEFFFF) {
                    case 1: 
                    case 11: {
                        this.entityHash.put(new Integer(data[0] & 0xFF), ent);
                    }
                }
            }
        }
    }

    void defineEntity(String name, int type, int ch) {
        byte[] data = new byte[]{(byte)(ch & 0xFF)};
        this.defineEntity(name, type, data);
    }

    void defineElement(String name, int type, boolean omitStart, boolean omitEnd, ContentModel content, BitSet exclusions, BitSet inclusions) {
        Element e = this.getElement(name);
        e.type = type;
        e.oStart = omitStart;
        e.oEnd = omitEnd;
        e.content = content;
        e.exclusions = exclusions;
        e.inclusions = inclusions;
    }

    void defineAttributes(String name, AttributeList atts) {
        Element e = this.getElement(name);
        e.atts = atts;
    }

    public String toString() {
        return this.name;
    }

    public void print() {
        System.out.println("<!DOCTYPE " + this.name + " [");
        System.out.println();
        Enumeration<Object> e = this.entityHash.elements();
        while (e.hasMoreElements()) {
            ((Entity)e.nextElement()).print();
        }
        System.out.println();
        e = this.elements.elements();
        while (e.hasMoreElements()) {
            ((Element)e.nextElement()).print();
        }
        System.out.println("]>");
    }

    public static DTD getDTD(String name) throws FileNotFoundException, IOException {
        DTD dtd = (DTD)dtdHash.get(name = name.toLowerCase());
        if (dtd == null) {
            if (mapping == null) {
                mapping = new PublicMapping(props.getProperty("dtds"));
            }
            InputStream in = mapping.get(name);
            dtd = new DTD(name);
            new DTDParser().parse(in, dtd);
            dtd.app.atts = new AttributeList("class");
            dtd.app.atts.modifier = 2;
            dtd.app.atts.type = 1;
            if (dtd.body.inclusions == null) {
                dtd.body.inclusions = new BitSet();
            }
            dtd.body.inclusions.set(dtd.app.getIndex());
            dtdHash.put(name, dtd);
        }
        return dtd;
    }

    static {
        dtdHash = new Hashtable();
    }
}

