/*
 * Decompiled with CFR 0.152.
 */
package html.parser;

import html.parser.DTDConstants;
import html.parser.Element;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public final class AttributeList
implements DTDConstants {
    String name;
    int type;
    Vector values;
    int modifier;
    String value;
    AttributeList next;
    static Hashtable attributeTypes = new Hashtable();

    AttributeList(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public int getType() {
        return this.type;
    }

    public Enumeration getValues() {
        return this.values.elements();
    }

    public String getValue() {
        return this.value;
    }

    public AttributeList getNext() {
        return this.next;
    }

    public String toString() {
        return this.name;
    }

    public void print(Element elem) {
        System.out.println("<ATTLIST " + elem.getName() + " ");
        AttributeList att = this;
        while (att != null) {
            System.out.print("\t" + att.getName() + " ");
            if (att.values != null) {
                System.out.print("(");
                Enumeration e = att.values.elements();
                while (e.hasMoreElements()) {
                    System.out.print(e.nextElement());
                    if (!e.hasMoreElements()) continue;
                    System.out.print("|");
                }
                System.out.print(") ");
            } else {
                System.out.print(AttributeList.type2name(att.getType()) + " ");
            }
            switch (att.modifier) {
                case 2: {
                    System.out.println("#REQUIRED");
                    break;
                }
                case 3: {
                    System.out.println("#CURRENT");
                    break;
                }
                case 4: {
                    System.out.println("#CONREF");
                    break;
                }
                case 5: {
                    System.out.println("#IMPLIED");
                    break;
                }
                case 1: {
                    System.out.print("#FIXED ");
                }
                default: {
                    System.out.println("\"" + att.value + "\"");
                }
            }
            att = att.next;
        }
        System.out.println(">");
    }

    static void defineAttributeType(String nm, int val) {
        Integer num = new Integer(val);
        attributeTypes.put(nm, num);
        attributeTypes.put(num, nm);
    }

    static int name2type(String nm) {
        Integer i = (Integer)attributeTypes.get(nm);
        return i == null ? 1 : i;
    }

    static String type2name(int tp) {
        return (String)attributeTypes.get(new Integer(tp));
    }

    static {
        AttributeList.defineAttributeType("CDATA", 1);
        AttributeList.defineAttributeType("ENTITY", 2);
        AttributeList.defineAttributeType("ENTITIES", 3);
        AttributeList.defineAttributeType("ID", 4);
        AttributeList.defineAttributeType("IDREF", 5);
        AttributeList.defineAttributeType("IDREFS", 6);
        AttributeList.defineAttributeType("NAME", 7);
        AttributeList.defineAttributeType("NAMES", 8);
        AttributeList.defineAttributeType("NMTOKEN", 9);
        AttributeList.defineAttributeType("NMTOKENS", 10);
        AttributeList.defineAttributeType("NOTATION", 11);
        AttributeList.defineAttributeType("NUMBER", 12);
        AttributeList.defineAttributeType("NUMBERS", 13);
        AttributeList.defineAttributeType("NUTOKEN", 14);
        AttributeList.defineAttributeType("NUTOKENS", 15);
        attributeTypes.put("fixed", new Integer(1));
        attributeTypes.put("required", new Integer(2));
        attributeTypes.put("current", new Integer(3));
        attributeTypes.put("conref", new Integer(4));
        attributeTypes.put("implied", new Integer(5));
    }
}

