/*
 * Decompiled with CFR 0.152.
 */
package html.tags;

import html.parser.Attributes;
import html.parser.Element;
import html.tags.Flow;
import html.tags.ParserFrame;
import java.net.MalformedURLException;
import java.net.URL;

public class LinkTag
extends Flow {
    public static boolean debug = false;

    public LinkTag() {
        debug = Boolean.getBoolean("html.tags.debug");
        if (debug) {
            System.out.println("creating LinkTag   this=" + this);
        }
    }

    public void initialize(Element elem, Attributes atts, ParserFrame parserFrame) {
        super.initialize(elem, atts, parserFrame);
        if (debug) {
            System.out.println("LinkTag::initialize()   node=" + this + "  (" + this.getElement().toString() + ")");
        }
        if (atts == null) {
            return;
        }
        String rel = atts.get("rel");
        String type = atts.get("type");
        String href = atts.get("href");
        if (debug) {
            System.out.println("LINK rel=\"" + rel + "\"" + "   href=\"" + href + "\"");
        }
        if (!(rel == null && type == null || rel != null && rel.toLowerCase().indexOf("stylesheet") == -1 || type != null && !type.equalsIgnoreCase("text/css"))) {
            String media;
            URL url;
            try {
                url = parserFrame.baseURL != null ? new URL(parserFrame.baseURL, href) : new URL(parserFrame.url, href);
            }
            catch (MalformedURLException e) {
                return;
            }
            if (debug) {
                System.out.println("[LinkTag::initialize(): should parse CSS url: " + url.toString() + "]");
            }
            if ((media = atts.get("media")) == null) {
                media = "all";
            }
            parserFrame.styleSheetParser.parseURL(parserFrame.ac, url, atts.get("title"), rel, media, 3);
            if (debug) {
                System.out.println("[parsed!]");
            }
        }
    }
}

