/*
 * Decompiled with CFR 0.152.
 */
package org.w3c.css.css;

import java.io.PrintWriter;
import java.util.Vector;
import org.w3c.css.properties.css1.CssProperty;
import org.w3c.css.util.Util;

public class CssStyleRule {
    private String indent;
    private String selectors;
    private Vector properties;
    private boolean important;

    public CssStyleRule(String indent, String selectors, Vector properties, boolean important) {
        this.selectors = selectors;
        this.properties = properties;
        this.important = important;
        this.indent = indent;
    }

    public String toString() {
        StringBuffer ret = new StringBuffer();
        if (this.selectors != null) {
            ret.append(this.selectors);
            ret.append(' ');
            ret.append('{');
            ret.append('\n');
        }
        for (int i = 0; i < this.properties.size(); ++i) {
            CssProperty property = (CssProperty)this.properties.elementAt(i);
            ret.append(this.indent);
            ret.append("   ");
            ret.append(property.getPropertyName());
            ret.append(" : ");
            ret.append(property.toString());
            if (property.getImportant()) {
                ret.append(" important");
            }
            ret.append(';');
            ret.append('\n');
        }
        if (this.selectors != null) {
            ret.append(this.indent);
            ret.append('}');
            ret.append('\n');
            ret.append('\n');
        }
        return ret.toString();
    }

    public void toHTML(PrintWriter out) {
        if (this.properties != null) {
            out.print("<li><span class='selector'>");
            if (this.selectors != null) {
                out.print(this.selectors);
                out.print("</span> {<ul class='vRule'>\n");
            }
            for (int i = 0; i < this.properties.size(); ++i) {
                CssProperty property = (CssProperty)this.properties.elementAt(i);
                out.print("<li>");
                out.print(Util.escapeHTML(property.getPropertyName()));
                out.print(" : <span class='vPropertyValue'>");
                out.print(Util.escapeHTML(property.toString()));
                out.print("</span>");
                if (property.getImportant()) {
                    out.print(" !important");
                }
                out.print(";</li>\n");
            }
            out.print("</ul>}</li>\n\n");
        }
    }
}

