/*
 * Decompiled with CFR 0.152.
 */
package org.w3c.css.css;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.net.URL;
import java.text.DateFormat;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Locale;
import java.util.StringTokenizer;
import java.util.Vector;
import org.w3c.css.css.CssRuleList;
import org.w3c.css.css.StyleReport;
import org.w3c.css.css.StyleSheet;
import org.w3c.css.css.StyleSheetGenerator;
import org.w3c.css.parser.CssError;
import org.w3c.css.parser.CssErrorToken;
import org.w3c.css.parser.CssParseException;
import org.w3c.css.parser.CssPrinterStyle;
import org.w3c.css.parser.CssSelectors;
import org.w3c.css.parser.Errors;
import org.w3c.css.properties.css1.CssProperty;
import org.w3c.css.util.ApplContext;
import org.w3c.css.util.InvalidParamException;
import org.w3c.css.util.Utf8Properties;
import org.w3c.css.util.Util;
import org.w3c.css.util.Warning;
import org.w3c.css.util.Warnings;

public final class StyleSheetGeneratorHTML2
extends StyleReport
implements CssPrinterStyle {
    StyleSheet style;
    Vector items;
    Warnings warnings;
    Errors errors;
    ApplContext ac;
    private CssSelectors selector;
    private PrintWriter out;
    private int warningLevel;
    private Utf8Properties general;
    private static Utf8Properties availableFormat;
    private static Utf8Properties availablePropertiesURL;
    private static Hashtable formats;
    int counter = 0;

    public StyleSheetGeneratorHTML2(ApplContext ac, String title, StyleSheet style, String document, int warningLevel) {
        if (document == null) {
            document = "html.en";
        }
        if (Util.onDebug) {
            System.err.println("document format is " + document);
        }
        this.ac = ac;
        this.style = style;
        this.general = new Utf8Properties(this.setDocumentBase(StyleSheetGeneratorHTML2.getDocumentName(ac, document)));
        this.general.put("file-title", title);
        this.warnings = style.getWarnings();
        this.errors = style.getErrors();
        this.items = style.newGetRules();
        this.warningLevel = warningLevel;
        this.general.put("errors-count", Integer.toString(this.errors.getErrorCount()));
        this.general.put("warnings-count", Integer.toString(this.warnings.getWarningCount()));
        this.general.put("rules-count", Integer.toString(this.items.size()));
        if (this.errors.getErrorCount() == 0) {
            this.desactivateError();
        }
        if (this.errors.getErrorCount() != 0 || !title.startsWith("http://")) {
            this.general.put("no-errors", "");
        }
        if (style.charset == null) {
            this.general.put("charset-rule", "");
        }
        if (this.warnings.getWarningCount() == 0 || warningLevel == -1) {
            this.general.put("go-warnings", "");
            this.general.put("warnings", "");
        }
        if (this.items.size() == 0) {
            this.general.put("go-rules", "");
            this.general.put("rules", "");
            this.general.put("no-errors", "");
        } else {
            this.general.put("no-rules", "");
        }
        if (this.errors.getErrorCount() != 0 || this.warnings.getWarningCount() != 0) {
            this.general.put("no-error-or-warning", "");
        }
        if (Util.onDebug) {
            this.general.list(System.err);
        }
        DateFormat df = null;
        if (ac.getLang() != null) {
            try {
                df = DateFormat.getDateTimeInstance(0, 0, new Locale(ac.getLang().substring(0, 2), "US"));
            }
            catch (Exception e) {
                df = DateFormat.getDateTimeInstance(0, 0, Locale.US);
            }
        }
        if (df != null) {
            this.general.put("today", df.format(new Date()));
        } else {
            this.general.put("today", new Date().toString());
        }
    }

    public void desactivateError() {
        this.general.put("go-errors", "");
        this.general.put("errors", "");
    }

    public void print(PrintWriter out) {
        this.out = out;
        String output = this.processSimple("document");
        if (output != null) {
            out.println(output);
        } else {
            out.println(this.ac.getMsg().getGeneratorString("request"));
        }
        out.flush();
    }

    public void produceStyleSheet() {
        Vector atRules = this.style.newGetRules();
        for (int idx = 0; idx < atRules.size(); ++idx) {
            ((CssRuleList)atRules.elementAt(idx)).toHTML(this.out);
            this.out.print("\n");
        }
    }

    public void print(CssProperty property) {
        Utf8Properties prop = new Utf8Properties(this.general);
        prop.put("property-name", property.getPropertyName().toString());
        prop.put("property-value", property.toString());
        if (!property.getImportant()) {
            prop.put("important-style", "");
        }
        this.out.print(this.processStyle(prop.getProperty("declaration"), prop));
    }

    public void produceParseException(CssParseException error, StringBuffer ret) {
        ret.append(' ');
        if (error.getContexts() != null && error.getContexts().size() != 0) {
            StringBuffer buf = new StringBuffer();
            Enumeration e = error.getContexts().elements();
            while (e.hasMoreElements()) {
                Object t = e.nextElement();
                if (t == null) continue;
                buf.append(t);
                if (!e.hasMoreElements()) continue;
                buf.append(", ");
            }
            if (buf.length() != 0) {
                ret.append(this.ac.getMsg().getGeneratorString("context"));
                ret.append(" : <span class='error'>").append(buf);
                ret.append("</span> ");
            }
        }
        ret.append("\n<p>");
        String name = error.getProperty();
        if (name != null && StyleSheetGeneratorHTML2.getURLProperty(name) != null) {
            ret.append(this.ac.getMsg().getGeneratorString("property"));
            ret.append(" : <a href=\"");
            ret.append(StyleSheetGeneratorHTML2.getURLProperty("@url-base"));
            ret.append(StyleSheetGeneratorHTML2.getURLProperty(name)).append("\">");
            ret.append(name).append("</a> ");
        }
        if (error.getException() != null && error.getMessage() != null) {
            if (error.isParseException()) {
                ret.append(this.queryReplace(error.getMessage())).append('\n');
            } else {
                Exception ex = error.getException();
                if (ex instanceof NumberFormatException) {
                    ret.append(this.ac.getMsg().getGeneratorString("invalid-number"));
                } else {
                    ret.append(this.queryReplace(ex.getMessage()));
                }
            }
            if (error.getSkippedString() != null) {
                ret.append(" : <span>");
                ret.append(this.queryReplace(error.getSkippedString()));
                ret.append("</span>\n");
            } else if (error.getExp() != null) {
                ret.append(" : ");
                ret.append(this.queryReplace(error.getExp().toStringFromStart()));
                ret.append("<span>");
                ret.append(this.queryReplace(error.getExp().toString()));
                ret.append("</span>\n");
            }
        } else {
            ret.append(this.ac.getMsg().getGeneratorString("unrecognize"));
            ret.append(" - <span class='error'>");
            ret.append(this.queryReplace(error.getSkippedString()));
            ret.append("</span>\n");
        }
    }

    public void produceError() {
        StringBuffer ret = new StringBuffer(1024);
        String oldSourceFile = null;
        boolean open = false;
        try {
            if (this.errors.getErrorCount() != 0) {
                CssError[] error = this.errors.getErrors();
                for (int i = 0; i < error.length; ++i) {
                    Exception ex = error[i].getException();
                    String file = error[i].getSourceFile();
                    if (!file.equals(oldSourceFile)) {
                        oldSourceFile = file;
                        if (open) {
                            ret.append("</ul>\n</div>");
                        }
                        ret.append("\n<div><h3>URI : <a href=\"");
                        ret.append(file).append("\">");
                        ret.append(file).append("</a></h3><ul>");
                        open = true;
                    }
                    ret.append("\n<li>");
                    ret.append(this.ac.getMsg().getGeneratorString("line"));
                    ret.append(": ").append(error[i].getLine());
                    if (ex instanceof FileNotFoundException) {
                        ret.append("\n<p>");
                        ret.append(this.ac.getMsg().getGeneratorString("not-found"));
                        ret.append("<span class='error'> ");
                        ret.append(ex.getMessage());
                        ret.append("</span>\n");
                    } else if (ex instanceof CssParseException) {
                        this.produceParseException((CssParseException)ex, ret);
                    } else if (ex instanceof InvalidParamException) {
                        ret.append("\n<p>");
                        ret.append(this.queryReplace(ex.getMessage())).append('\n');
                    } else if (ex instanceof IOException) {
                        ret.append("\n<p>");
                        String stringError = ex.toString();
                        int index = stringError.indexOf(58);
                        ret.append(stringError.substring(0, index));
                        ret.append(" : <span class='error'>");
                        ret.append(ex.getMessage()).append("</strong>\n");
                    } else if (error[i] instanceof CssErrorToken) {
                        ret.append("\n<p>");
                        CssErrorToken terror = (CssErrorToken)error[i];
                        ret.append(terror.getErrorDescription()).append(" : ");
                        ret.append(terror.getSkippedString()).append('\n');
                    } else {
                        ret.append("\n<p><span class='error'>Uncaught error</span> ");
                        ret.append(ex).append('\n');
                        if (ex instanceof NullPointerException) {
                            ex.printStackTrace();
                        }
                    }
                    ret.append("</p></li>");
                }
                if (open) {
                    ret.append("\n</ul>");
                }
                ret.append("</div>");
            }
            this.out.println(ret.toString());
        }
        catch (Exception e) {
            this.out.println(this.ac.getMsg().getGeneratorString("request"));
            e.printStackTrace();
        }
    }

    public void produceWarning() {
        boolean open = false;
        StringBuffer ret = new StringBuffer(1024);
        String oldSourceFile = "";
        int oldLine = -1;
        String oldMessage = "";
        try {
            if (this.warnings.getWarningCount() != 0) {
                this.warnings.sort();
                Warning[] warning = this.warnings.getWarnings();
                for (int i = 0; i < warning.length; ++i) {
                    Warning warn = warning[i];
                    if (warn.getLevel() > this.warningLevel) continue;
                    if (!warn.getSourceFile().equals(oldSourceFile)) {
                        if (open) {
                            ret.append("\n</ul></div>");
                        }
                        oldSourceFile = warn.getSourceFile();
                        ret.append("\n<div><h3>URI : <a href=\"");
                        ret.append(oldSourceFile).append("\">");
                        ret.append(oldSourceFile).append("</a></h3><ul>");
                        open = true;
                    }
                    oldLine = warn.getLine();
                    oldMessage = warn.getWarningMessage();
                    ret.append("\n<li><span class='warning'>");
                    ret.append(this.ac.getMsg().getGeneratorString("line"));
                    ret.append(" : ");
                    ret.append(oldLine);
                    if (warn.getLevel() != 0) {
                        ret.append(" (Level : ");
                        ret.append(warn.getLevel());
                        ret.append(")");
                    }
                    ret.append("</span> ");
                    ret.append(Util.escapeHTML(oldMessage));
                    if (warn.getContext() != null) {
                        ret.append(" : ").append(warn.getContext());
                    }
                    ret.append("</li>");
                }
                if (open) {
                    ret.append("\n</ul>");
                }
                ret.append("</div>");
            }
            this.out.println(ret.toString());
        }
        catch (Exception e) {
            this.out.println(this.ac.getMsg().getGeneratorString("request"));
            e.printStackTrace();
        }
    }

    private String queryReplace(String s) {
        if (s != null) {
            int len = s.length();
            StringBuffer ret = new StringBuffer(len);
            for (int i = 0; i < len; ++i) {
                char c = s.charAt(i);
                if (c == '<') {
                    ret.append("&lt;");
                    continue;
                }
                if (c == '>') {
                    ret.append("&gt;");
                    continue;
                }
                ret.append(c);
            }
            return ret.toString();
        }
        return "[empty string]";
    }

    private final String processSimple(String s) {
        return this.processStyle(this.general.getProperty(s), this.general);
    }

    private String processStyle(String str, Utf8Properties prop) {
        try {
            int i = 0;
            while ((i = str.indexOf("<!-- #", i)) >= 0) {
                String value;
                int lastIndexOfEntity = str.indexOf("-->", i);
                String entity = str.substring(i + 6, lastIndexOfEntity - 1).toLowerCase();
                if (entity.equals("rule")) {
                    this.out.print(str.substring(0, i));
                    str = str.substring(lastIndexOfEntity + 3);
                    i = 0;
                    this.produceStyleSheet();
                    continue;
                }
                if (entity.equals("selectors")) {
                    if (this.selector.getNext() != null) {
                        value = prop.getProperty(entity);
                        if (value != null) {
                            str = str.substring(0, i) + value + str.substring(lastIndexOfEntity + 3);
                            continue;
                        }
                        i += 6;
                        continue;
                    }
                    str = str.substring(lastIndexOfEntity + 3);
                    i = 0;
                    continue;
                }
                if (entity.equals("selector")) {
                    str = str.substring(lastIndexOfEntity + 3);
                    i = 0;
                    continue;
                }
                if (entity.equals("charset")) {
                    this.out.print(str.substring(0, i));
                    str = str.substring(lastIndexOfEntity + 3);
                    i = 0;
                    this.out.print(this.style.charset);
                    continue;
                }
                if (entity.equals("declaration")) {
                    str = str.substring(lastIndexOfEntity + 3);
                    i = 0;
                    continue;
                }
                if (entity.equals("warning")) {
                    this.out.print(str.substring(0, i));
                    str = str.substring(lastIndexOfEntity + 3);
                    i = 0;
                    this.produceWarning();
                    continue;
                }
                if (entity.equals("error")) {
                    this.out.print(str.substring(0, i));
                    str = str.substring(lastIndexOfEntity + 3);
                    i = 0;
                    this.produceError();
                    continue;
                }
                if (entity.equals("hook-html-validator")) {
                    this.out.print(str.substring(0, i));
                    str = str.substring(lastIndexOfEntity + 3);
                    i = 0;
                    if (this.style.getType().equals("text/html")) {
                        this.out.println(this.ac.getMsg().getGeneratorString("doc-html", this.general.get("file-title").toString()));
                        continue;
                    }
                    this.out.println(this.ac.getMsg().getGeneratorString("doc"));
                    continue;
                }
                value = prop.getProperty(entity);
                if (value != null) {
                    str = str.substring(0, i) + value + str.substring(lastIndexOfEntity + 3);
                    continue;
                }
                i += 6;
            }
            return str;
        }
        catch (Exception e) {
            e.printStackTrace();
            return str;
        }
    }

    public static final void printAvailableFormat(PrintWriter out) {
        Enumeration<?> e = availableFormat.propertyNames();
        out.println(" -- listing available output format --");
        while (e.hasMoreElements()) {
            String key = ((String)e.nextElement()).toLowerCase();
            out.print("Format : ");
            out.println(key);
            out.print("   File : ");
            out.println(StyleSheetGeneratorHTML2.getDocumentName(null, key));
        }
        out.flush();
    }

    private Utf8Properties setDocumentBase(String document) {
        Utf8Properties properties = (Utf8Properties)formats.get(document);
        if (properties == null) {
            properties = new Utf8Properties();
            try {
                URL url = StyleSheetGenerator.class.getResource(document);
                InputStream f = url.openStream();
                properties.load(f);
                f.close();
                properties.put("author", "www-validator-css");
                properties.put("author-email", "Email.html");
            }
            catch (Exception e) {
                System.err.println("org.w3c.css.css.StyleSheetGenerator: couldn't load properties " + document);
                System.err.println("  " + e.toString());
                StyleSheetGeneratorHTML2.printAvailableFormat(new PrintWriter(System.err));
            }
            formats.put(document, properties);
        }
        return new Utf8Properties(properties);
    }

    private static final String getDocumentName(ApplContext ac, String documentName) {
        documentName = documentName.toLowerCase();
        String document = null;
        if (ac != null && ac.getLang() != null) {
            StringTokenizer tokens = new StringTokenizer(ac.getLang(), ",");
            while (tokens.hasMoreTokens()) {
                String l = tokens.nextToken().trim().toLowerCase();
                document = availableFormat.getProperty(documentName + "." + l);
                if (document != null) break;
                int minusIndex = l.indexOf(45);
                if (minusIndex != -1) {
                    l = l.substring(0, minusIndex);
                    document = availableFormat.getProperty(documentName + "." + l);
                }
                if (document == null) continue;
                break;
            }
        }
        if (document == null) {
            document = availableFormat.getProperty(documentName);
        }
        if (document == null) {
            System.err.println("Unable to find " + documentName + " output format");
            return documentName;
        }
        return document;
    }

    private static final String getURLProperty(String name) {
        return availablePropertiesURL.getProperty(name);
    }

    static {
        InputStream f;
        URL url;
        formats = new Hashtable();
        availableFormat = new Utf8Properties();
        try {
            url = StyleSheetGenerator.class.getResource("format.properties");
            f = url.openStream();
            availableFormat.load(f);
            f.close();
        }
        catch (Exception e) {
            System.err.println("org.w3c.css.css.StyleSheetGenerator: couldn't load format properties ");
            System.err.println("  " + e.toString());
        }
        availablePropertiesURL = new Utf8Properties();
        try {
            url = StyleSheetGenerator.class.getResource("urls.properties");
            f = url.openStream();
            availablePropertiesURL.load(f);
            f.close();
        }
        catch (Exception e) {
            System.err.println("org.w3c.css.css.StyleSheetGenerator: couldn't load URLs properties ");
            System.err.println("  " + e.toString());
        }
    }
}

